/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.GenericChart;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class Renderer
implements Serializable {
    public static Cursor RESIZE_CURSOR;
    public static Cursor RESIZE_HOR_CURSOR;
    public static Cursor GRID_CURSOR_HORZ;
    public static Cursor GRID_CURSOR_VERT;
    public static Cursor HAND_CURSOR;
    public static Cursor DEFAULT_CURSOR;
    protected static final int DOUBLE_CLICK_TIME = 350;
    private Image rotateImage;
    private Image pixel_grabber_image;
    static Hashtable angledLabelCache;
    private static Object[] fifo_queue;
    private static int fifo_count;
    private static int fifo_head;
    private static int fifo_tail;
    boolean is_java2;
    protected GenericChart chart;

    public Renderer() {
    }

    public Renderer(GenericChart chart) {
        this.chart = chart;
        RESIZE_CURSOR = new Cursor(8);
        RESIZE_HOR_CURSOR = new Cursor(11);
        HAND_CURSOR = new Cursor(12);
        DEFAULT_CURSOR = new Cursor(0);
        GRID_CURSOR_VERT = new Cursor(8);
        GRID_CURSOR_HORZ = new Cursor(11);
        this.is_java2 = !System.getProperty("java.version").startsWith("1.1");
    }

    protected int getSeriesCount() {
        return this.chart.getSeriesCount();
    }

    protected int getSampleCount() {
        return this.chart.getSampleCount();
    }

    protected String getLabel(String name) {
        return this.chart.getLabel(name);
    }

    protected int getLabelAngle(String name) {
        return this.chart.getLabelAngle(name);
    }

    protected Font getFont(String label) {
        return this.chart.getFont(label);
    }

    protected FontMetrics getFontMetrics(Font font) {
        return this.chart.getFontMetrics(font);
    }

    protected Dimension getImageSize(String name) {
        Image img;
        Dimension imageSize = new Dimension(0, 0);
        if (name != null && (img = this.chart.getImage(name)) != null) {
            imageSize.width = img.getWidth(this.chart);
            imageSize.height = img.getHeight(this.chart);
        }
        return imageSize;
    }

    protected static Color getDarker(Color color) {
        if (color == null) {
            return null;
        }
        return new Color((int)((double)color.getRed() * 0.7), (int)((double)color.getGreen() * 0.7), (int)((double)color.getBlue() * 0.7), color.getAlpha());
    }

    protected static Color getBrighter(Color color) {
        if (color == null) {
            return null;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        r = r == 0 ? 64 : Math.min((int)((double)r / 0.7), 255);
        g = g == 0 ? 64 : Math.min((int)((double)g / 0.7), 255);
        b = b == 0 ? 64 : Math.min((int)((double)b / 0.7), 255);
        return new Color(r, g, b, a);
    }

    protected void clearBackground(Graphics g, Dimension size) {
        if (this.is_java2) {
            Rectangle rect = new Rectangle(0, 0, size.width, size.height);
            try {
                Class<?> g2DClass = Class.forName("java.awt.Graphics2D");
                Method getCompositeMethod = g2DClass.getMethod("getComposite", null);
                Object oldcomp = getCompositeMethod.invoke((Object)g, null);
                Object clearObj = Class.forName("java.awt.AlphaComposite").getField("Clear").get(null);
                Class[] parameters = new Class[]{Class.forName("java.awt.Composite")};
                Method setCompositeMethod = g2DClass.getMethod("setComposite", parameters);
                setCompositeMethod.invoke((Object)g, clearObj);
                parameters = new Class[]{Class.forName("java.awt.Shape")};
                Method fillMethod = g2DClass.getMethod("fill", parameters);
                fillMethod.invoke((Object)g, rect);
                setCompositeMethod.invoke((Object)g, oldcomp);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    protected void paintLabel(Graphics g, String label, int label_x, int label_y, Dimension size, int style, int angle, boolean underlined) {
        FontMetrics fm = g.getFontMetrics();
        if (label != null && angle == 0) {
            String[] lines = Chart.getStringValues(label, "\n");
            for (int i = 0; lines != null && i < lines.length; ++i) {
                if (lines[i] != null && !lines[i].equals("") && !lines[i].equals("\n")) {
                    int x = label_x;
                    int y = label_y;
                    if (style != -1) {
                        if (style == 1) {
                            x = label_x + size.width - fm.stringWidth(lines[i]);
                        } else if (style == 0) {
                            x = label_x + size.width / 2 - fm.stringWidth(lines[i]) / 2;
                        }
                    }
                    g.drawString(lines[i], x, y);
                    if (underlined) {
                        g.drawLine(x, y + 1, x + fm.stringWidth(lines[i]) - 2, y + 1);
                    }
                }
                label_y += fm.getMaxAscent() + 1;
            }
        } else if (label != null && size.width != 0 && size.height != 0) {
            this.paintAngledLabel(g, label, label_x, label_y, size, style, angle, underlined);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void paintAngledLabel(Graphics g, String label, int label_x, int label_y, Dimension size, int style, int angle, boolean underlined) {
        if (fifo_count != angledLabelCache.size()) {
            Renderer.fifo_clear();
        }
        FontMetrics fm = g.getFontMetrics();
        Image angled_label = null;
        Long key = null;
        if (fifo_queue != null && !this.chart.isServletModeOn()) {
            key = new Long(Renderer.hashCode(label) + angle + g.getFont().hashCode() + g.getColor().hashCode());
            angled_label = (Image)angledLabelCache.get(key);
        }
        if (angled_label == null) {
            boolean is_java2;
            boolean bl = is_java2 = !System.getProperty("java.version").startsWith("1.1");
            if (!is_java2) {
                if (this.rotateImage == null || size.width > this.rotateImage.getWidth(this.chart) || size.height > this.rotateImage.getHeight(this.chart)) {
                    if (this.rotateImage != null) {
                        this.rotateImage.flush();
                        this.rotateImage = null;
                        System.gc();
                    }
                    try {
                        this.rotateImage = this.chart.createImage(size.width, size.height);
                    }
                    catch (Throwable e) {
                        Renderer.fifo_clear();
                        try {
                            this.rotateImage = this.chart.createImage(size.width, size.height);
                        }
                        catch (Throwable ex) {
                            try {
                                this.rotateImage = this.chart.createImage_oldstyle(size.width, size.height);
                            }
                            catch (Throwable exc) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.rotateImage != null) {
                    Color[] colors = new Color[2];
                    colors[1] = g.getColor();
                    int[] color_pixels = new int[2];
                    this.getColorPixels(colors, color_pixels);
                    Graphics g_label = this.rotateImage.getGraphics();
                    g_label.setColor(colors[0]);
                    g_label.fillRect(0, 0, size.width, size.height);
                    g_label.setColor(colors[1]);
                    g_label.setFont(g.getFont());
                    this.paintLabel(g_label, label, 0, fm.getMaxAscent() - fm.getDescent() + 2, size, this.chart.getMultilineLabelAlignment(), 0, underlined);
                    g_label.dispose();
                    int[] pixels = new int[size.width * size.height];
                    PixelGrabber grabber = new PixelGrabber(this.rotateImage, 0, 0, size.width, size.height, pixels, 0, size.width);
                    grabber.startGrabbing();
                    grabber.getPixels();
                    for (int i = 0; i < pixels.length; ++i) {
                        if (pixels[i] != color_pixels[0]) continue;
                        pixels[i] = color_pixels[0] & 0xFFFFFF;
                    }
                    Dimension newSize = new Dimension(size.width, size.height);
                    int[] new_pixels = this.rotateImage(pixels, angle, newSize, color_pixels[0]);
                    try {
                        angled_label = this.chart.createImage(new MemoryImageSource(newSize.width, newSize.height, new_pixels, 0, newSize.width));
                    }
                    catch (Throwable e) {}
                }
            } else {
                if (angle == 90) {
                    size.width += 2;
                }
                Dimension angled_size = this.getAngledLabelSize(size, angle);
                double radian = (double)angle / 180.0 * Math.PI;
                double f_width = (double)angled_size.width / 2.0;
                double f_height = (double)angled_size.height / 2.0;
                int delta_y = (angled_size.height - size.height) / 2;
                int delta_x = (angled_size.width - size.width) / 2;
                angled_label = new BufferedImage(angled_size.width, angled_size.height, 2);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToRotation(radian, f_width, f_height);
                Graphics2D g2D = (Graphics2D)angled_label.getGraphics();
                g2D.setTransform(affineTransform);
                if (this.chart.isAntialiasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g2D.setColor(g.getColor());
                g2D.setFont(g.getFont());
                this.paintLabel(g2D, label, delta_x, delta_y + fm.getAscent() - fm.getDescent() + 2, size, -1, 0, underlined);
            }
            if (fifo_queue != null && !this.chart.isServletModeOn() && key != null && angled_label != null) {
                Object[] image_and_key;
                Object[] objectArray = fifo_queue;
                // MONITORENTER : fifo_queue
                if (fifo_count >= fifo_queue.length && (image_and_key = Renderer.fifo_remove()) != null) {
                    angledLabelCache.remove(image_and_key[0]);
                    ((Image)image_and_key[1]).flush();
                }
                angledLabelCache.put(key, angled_label);
                Renderer.fifo_add(new Object[]{key, angled_label});
                // MONITOREXIT : objectArray
            }
        }
        if (angle == 180) {
            label_y -= fm.getAscent() - 2;
        }
        if (angled_label == null) return;
        g.drawImage(angled_label, label_x, label_y, null);
    }

    private void getColorPixels(Color[] colors, int[] color_pixels) {
        colors[0] = Color.white;
        if (colors[0].equals(colors[1])) {
            colors[0] = Color.black;
        }
        if (this.pixel_grabber_image == null) {
            try {
                this.pixel_grabber_image = this.chart.createImage(2, 1);
            }
            catch (Throwable e) {
                this.pixel_grabber_image = this.chart.createImage_oldstyle(2, 1);
            }
        }
        if (this.pixel_grabber_image != null) {
            Graphics g = this.pixel_grabber_image.getGraphics();
            g.setColor(colors[0]);
            g.drawLine(0, 0, 0, 0);
            g.setColor(colors[1]);
            g.drawLine(1, 0, 1, 0);
            PixelGrabber grabber = new PixelGrabber(this.pixel_grabber_image, 0, 0, 2, 1, color_pixels, 0, 2);
            grabber.startGrabbing();
            grabber.getPixels();
            if (color_pixels[0] == color_pixels[1]) {
                colors[0] = new Color(0x7FFFFF);
            }
            g.dispose();
        }
    }

    private int[] rotateImage(int[] pixels, int angle, Dimension size, int background) {
        if (angle % 360 == 0) {
            return pixels;
        }
        if (angle % 360 == 90) {
            int[] new_pixels = new int[pixels.length];
            for (int col = 0; col < size.height; ++col) {
                for (int row = 0; row < size.width; ++row) {
                    new_pixels[row * size.height + col] = pixels[size.width * size.height - size.width - col * size.width + row];
                }
            }
            int width = size.width;
            size.width = size.height;
            size.height = width;
            return new_pixels;
        }
        if (angle % 360 == 180) {
            int[] new_pixels = new int[pixels.length];
            for (int col = 0; col < size.width; ++col) {
                for (int row = 0; row < size.height; ++row) {
                    new_pixels[row * size.width + col] = pixels[size.width * size.height - 1 - row * size.width - col];
                }
            }
            return new_pixels;
        }
        if (angle % 360 == 270) {
            int[] new_pixels = new int[pixels.length];
            for (int col = 0; col < size.height; ++col) {
                for (int row = 0; row < size.width; ++row) {
                    new_pixels[row * size.height + col] = pixels[col * size.width + size.width - row - 1];
                }
            }
            int width = size.width;
            size.width = size.height;
            size.height = width;
            return new_pixels;
        }
        angle = -angle;
        double sin = Math.sin((double)angle * (Math.PI / 180));
        double cos = Math.cos((double)angle * (Math.PI / 180));
        double[] coord = new double[2];
        Rectangle bounds = new Rectangle(size);
        this.getAngledBounds(cos, sin, bounds, coord);
        int xoffset = -bounds.x;
        int yoffset = -bounds.y;
        int[] new_pixels = new int[bounds.width * bounds.height];
        int[] line_pixels = new int[bounds.width];
        for (int dy = 0; dy < bounds.height; ++dy) {
            this.itransform(cos, sin, 0 - xoffset, dy - yoffset, coord);
            double x1 = coord[0];
            double y1 = coord[1];
            if (dy == dy) {
                // empty if block
            }
            this.itransform(cos, sin, bounds.width - xoffset, dy - yoffset, coord);
            double x2 = coord[0];
            double y2 = coord[1];
            double xinc = (x2 - x1) / (double)bounds.width;
            double yinc = (y2 - y1) / (double)bounds.width;
            for (int dx = 0; dx < bounds.width; ++dx) {
                int sx = (int)Math.round(x1);
                int sy = (int)Math.round(y1);
                line_pixels[dx] = sx < 0 || sy < 0 || sx >= size.width || sy >= size.height ? background & 0xFFFFFF : pixels[sy * size.width + sx];
                x1 += xinc;
                y1 += yinc;
            }
            System.arraycopy(line_pixels, 0, new_pixels, dy * bounds.width, line_pixels.length);
        }
        size.width = bounds.width;
        size.height = bounds.height;
        return new_pixels;
    }

    private void transform(double cos, double sin, double x, double y, double[] coord) {
        coord[0] = cos * x + sin * y;
        coord[1] = cos * y - sin * x;
    }

    private void itransform(double cos, double sin, double x, double y, double[] coord) {
        coord[0] = cos * x - sin * y;
        coord[1] = cos * y + sin * x;
    }

    private void getAngledBounds(double cos, double sin, Rectangle rect, double[] coord) {
        double minx = Double.POSITIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                this.transform(cos, sin, rect.x + x * rect.width, rect.y + y * rect.height, coord);
                minx = Math.min(minx, coord[0]);
                miny = Math.min(miny, coord[1]);
                maxx = Math.max(maxx, coord[0]);
                maxy = Math.max(maxy, coord[1]);
            }
        }
        rect.x = (int)Math.floor(minx);
        rect.y = (int)Math.floor(miny);
        rect.width = (int)Math.ceil(maxx) - rect.x + 1;
        rect.height = (int)Math.ceil(maxy) - rect.y + 1;
    }

    protected void paintBox(Graphics g, Color c, int x, int y, int w, int h, boolean pushed) {
        g.setColor(c);
        g.fillRect(x, y, w, h);
        g.setColor(pushed ? c.darker() : Color.white);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y + 1, x, y + h);
        g.setColor(pushed ? Color.white : c.darker());
        g.drawLine(x + 1, y + h, x + w, y + h);
        g.drawLine(x + w, y + 1, x + w, y + h);
    }

    protected Dimension getLabelSize(String label, FontMetrics fm) {
        if (label == null || label.equals("") || fm == null) {
            return new Dimension(0, 0);
        }
        Long key = new Long(label.hashCode() + fm.getFont().hashCode());
        Dimension size = (Dimension)this.chart.labelSizeCache.get(key);
        if (size == null) {
            size = new Dimension(0, 0);
            if (label.indexOf("\n") == -1) {
                size.width = fm.stringWidth(label) + 2;
                size.height = fm.getMaxAscent() + 2;
            } else {
                String[] lines = Chart.getStringValues(label, "\n");
                for (int i = 0; lines != null && i < lines.length; ++i) {
                    size.height += fm.getMaxAscent() + 1;
                    if (lines[i] == null || lines[i].equals("")) continue;
                    size.width = Math.max(size.width, fm.stringWidth(lines[i]) + 2);
                }
                ++size.height;
            }
            size.height = Math.max(size.height, fm.getMaxAscent());
            if (!this.chart.isServletModeOn()) {
                this.chart.labelSizeCache.put(key, size);
            }
        }
        if (size != null) {
            return size;
        }
        return new Dimension(0, 0);
    }

    protected Dimension getAngledLabelSize(Dimension size, int angle) {
        if (angle == 90 || angle == 270) {
            return new Dimension(size.height, size.width);
        }
        if (angle > 0 && angle < 360) {
            double sin_angle = Math.sin((double)angle * (Math.PI / 180));
            double cos_angle = Math.cos((double)angle * (Math.PI / 180));
            int width = (int)(Math.abs((double)size.width * cos_angle) + Math.abs((double)size.height * sin_angle) + 0.5);
            int height = (int)(Math.abs((double)size.width * sin_angle) + Math.abs((double)size.height * cos_angle) + 0.5);
            return new Dimension(width, height);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLabelAngleCacheSize(int count) {
        if (fifo_queue != null) {
            Object[] objectArray = fifo_queue;
            synchronized (fifo_queue) {
                if (count > 0) {
                    fifo_queue = new Object[count];
                    fifo_count = 0;
                    fifo_head = 0;
                    fifo_tail = 0;
                    angledLabelCache.clear();
                } else {
                    fifo_queue = null;
                    angledLabelCache.clear();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (count > 0) {
            fifo_queue = new Object[count];
            fifo_count = 0;
            fifo_head = 0;
            fifo_tail = 0;
            angledLabelCache.clear();
        } else {
            angledLabelCache.clear();
        }
    }

    public static Hashtable getAngledLabelCache() {
        return angledLabelCache;
    }

    public static void fifo_add(Object[] image_and_key) {
        if (image_and_key == null || image_and_key.length != 2 || fifo_head == fifo_tail && fifo_queue[fifo_tail] != null) {
            return;
        }
        if (++fifo_tail >= fifo_queue.length) {
            fifo_tail = 0;
        }
        Renderer.fifo_queue[Renderer.fifo_tail] = image_and_key;
        ++fifo_count;
    }

    public static Object[] fifo_remove() {
        if (fifo_head == fifo_tail && fifo_queue[fifo_tail] == null) {
            return null;
        }
        if (++fifo_head >= fifo_queue.length) {
            fifo_head = 0;
        }
        Object[] image_and_key = (Object[])fifo_queue[fifo_head];
        Renderer.fifo_queue[Renderer.fifo_head] = null;
        --fifo_count;
        return image_and_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fifo_clear() {
        Object[] objectArray = fifo_queue;
        synchronized (fifo_queue) {
            for (int i = 0; fifo_queue != null && i < fifo_queue.length; ++i) {
                Object[] image_and_key = (Object[])fifo_queue[i];
                if (image_and_key != null && image_and_key[1] != null) {
                    ((Image)image_and_key[1]).flush();
                }
                Renderer.fifo_queue[i] = null;
            }
            fifo_count = 0;
            fifo_head = 0;
            fifo_tail = 0;
            angledLabelCache.clear();
            System.gc();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Object[] getfifo_queue() {
        return fifo_queue;
    }

    public static int getfifo_count() {
        return fifo_count;
    }

    public static int hashCode(String s) {
        int h = 0;
        int off = 0;
        int len = s.length();
        char[] val = new char[len];
        s.getChars(0, len, val, 0);
        for (int i = len; i > 0; --i) {
            h = h * 37 + val[off++];
        }
        return h;
    }

    static {
        fifo_queue = new Object[900];
        angledLabelCache = new Hashtable();
    }
}

