/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.Legend;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import com.objectplanet.chart.Renderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class LegendRenderer
extends Renderer {
    Rectangle[] legendBounds;
    Rectangle actualLegend;
    Rectangle visibleLegend;
    Rectangle verticalLegendScroller;
    Rectangle horizontalLegendScroller;
    double verticalLegendFactor;
    double horizontalLegendFactor;
    private boolean slidingVerticalLegend;
    private boolean slidingHorizontalLegend;
    boolean verticalLegendScrollerOn;
    boolean horizontalLegendScrollerOn;
    private boolean topLegendPushed;
    private boolean bottomLegendPushed;
    private boolean leftLegendPushed;
    private boolean rightLegendPushed;
    int[] legendRowHeight;
    int[] legendColumnWidth;
    int lastScrollerClick;

    public LegendRenderer(GenericChart chart) {
        super(chart);
        this.chart = chart;
        this.actualLegend = new Rectangle();
        this.visibleLegend = new Rectangle();
        this.verticalLegendScroller = new Rectangle();
        this.horizontalLegendScroller = new Rectangle();
    }

    public void calculateGraphBounds(Legend legend, Rectangle gridBounds) {
        if (legend.isLegendOn()) {
            int rows;
            int seriesCount = this.getSeriesCount();
            boolean multiSeriesOn = this.chart.isMultiSeriesOn();
            int legendPosition = legend.getLegendPosition();
            String[] labels = this.chart.getLegendLabels();
            int entry_count = 0;
            for (int i = 0; i < labels.length; ++i) {
                if (seriesCount > 1 || multiSeriesOn) {
                    entry_count += this.chart.isSeriesEmpty(i) && (i >= labels.length || labels[i] == null || labels[i].equals("")) ? 0 : 1;
                    continue;
                }
                entry_count += labels[i] == null || labels[i].equals("") ? 0 : 1;
            }
            int columns = legend.getLegendColumns();
            int rest = 0;
            if (columns == 0) {
                if (legendPosition == 1 || legendPosition == 0) {
                    columns = 1;
                    rows = Math.max(entry_count, 1);
                } else {
                    columns = Math.max(entry_count, 1);
                    rows = 1;
                }
            } else {
                rows = entry_count / columns;
                rest = entry_count % columns;
                if (rest > 0) {
                    ++rows;
                }
            }
            Font legendFont = this.getFont("legendFont");
            FontMetrics fm = this.getFontMetrics(legendFont);
            this.actualLegend.width = 0;
            this.actualLegend.height = 0;
            this.legendRowHeight = new int[rows];
            this.legendColumnWidth = new int[columns];
            int row = 0;
            int column = 0;
            int length = Math.max(seriesCount, labels.length);
            for (int i = 0; i < length; ++i) {
                int index = i;
                if (legend.isLegendReverseOn()) {
                    index = length - i - 1;
                }
                if (seriesCount <= 1 && !multiSeriesOn ? labels[index] == null || labels[index].equals("") : this.chart.isSeriesEmpty(index) && (index >= labels.length || labels[index] == null || labels[index].equals(""))) continue;
                if (row == rows || row == rows - 1 && column >= rest && rest > 0) {
                    row = 0;
                    if (column >= columns - 1) break;
                    ++column;
                }
                Dimension labelSize = this.getLabelSize(labels[index], fm);
                Dimension imageSize = this.getImageSize(legend.getLegendImage(index));
                imageSize.height = imageSize.height > 0 ? imageSize.height : 6;
                imageSize.width = imageSize.width > 0 ? imageSize.width : 6;
                int width = labelSize.width + imageSize.width + 12;
                int height = Math.max(Math.max(imageSize.height + 6, labelSize.height + 2), 13);
                this.legendColumnWidth[column] = Math.max(this.legendColumnWidth[column], width);
                this.legendRowHeight[row] = Math.max(this.legendRowHeight[row], height);
                ++row;
            }
            for (column = 0; column < columns && column < this.legendColumnWidth.length; ++column) {
                this.actualLegend.width += this.legendColumnWidth[column];
            }
            for (row = 0; row < rows && row < this.legendRowHeight.length; ++row) {
                this.actualLegend.height += this.legendRowHeight[row];
            }
            Dimension size = this.chart.getSize();
            Dimension titleSize = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            switch (legendPosition) {
                default: {
                    this.actualLegend.x = size.width - this.actualLegend.width - 1;
                    this.actualLegend.y = size.height / 2 - this.actualLegend.height / 2;
                    gridBounds.width -= this.actualLegend.width + 5;
                    if (this.actualLegend.height > size.height - this.actualLegend.y - 12) {
                        this.actualLegend.x -= 9;
                        gridBounds.width -= 9;
                    }
                    if (this.chart.isTitleOn()) {
                        this.actualLegend.y = Math.max(this.actualLegend.y, titleSize.height + 7);
                        break;
                    }
                    this.actualLegend.y = Math.max(this.actualLegend.y, 10);
                    break;
                }
                case 0: {
                    this.actualLegend.x = 6;
                    this.actualLegend.y = size.height / 2 - this.actualLegend.height / 2;
                    gridBounds.x += this.actualLegend.width + 10;
                    gridBounds.width -= this.actualLegend.width + 10;
                    if (this.actualLegend.height > size.height - this.actualLegend.y - 12) {
                        gridBounds.x += 9;
                        gridBounds.width -= 9;
                    }
                    if (this.chart.isTitleOn()) {
                        this.actualLegend.y = Math.max(this.actualLegend.y, titleSize.height + 7);
                        break;
                    }
                    this.actualLegend.y = Math.max(this.actualLegend.y, 10);
                    break;
                }
                case 2: {
                    this.actualLegend.x = size.width / 2 - this.actualLegend.width / 2;
                    this.actualLegend.y = 6;
                    if (this.chart.isTitleOn()) {
                        this.actualLegend.y = titleSize != null ? titleSize.height + 7 : 7;
                    }
                    gridBounds.y += this.actualLegend.height + fm.getDescent();
                    gridBounds.height -= this.actualLegend.height + fm.getDescent();
                    if (this.actualLegend.width > size.width - this.actualLegend.x - 10) {
                        gridBounds.y += 12;
                        gridBounds.height -= 12;
                    }
                    this.actualLegend.x = Math.max(this.actualLegend.x, 10);
                    break;
                }
                case 3: {
                    this.actualLegend.x = size.width / 2 - this.actualLegend.width / 2;
                    this.actualLegend.y = size.height - this.actualLegend.height - 5;
                    gridBounds.height -= this.actualLegend.height + 2;
                    if (this.actualLegend.width > size.width - this.actualLegend.x - 10) {
                        this.actualLegend.y -= 12;
                        gridBounds.height -= 12;
                    }
                    this.actualLegend.x = Math.max(this.actualLegend.x, 10);
                }
            }
        }
    }

    private void calculateVisibleLegend(Legend legend) {
        this.visibleLegend = new Rectangle(this.actualLegend);
        Dimension size = this.chart.getSize();
        Rectangle bounds = this.chart.getTotalGraphBounds();
        switch (legend.getLegendPosition()) {
            default: {
                this.visibleLegend.x = bounds.x + bounds.width + 15;
                this.visibleLegend.y = this.actualLegend.y;
                this.visibleLegend.width = size.width - this.visibleLegend.x;
                this.visibleLegend.height = size.height - this.actualLegend.y - 12;
                if (this.actualLegend.width > this.visibleLegend.width) {
                    this.visibleLegend.height = Math.min(this.actualLegend.height, this.visibleLegend.height - 9);
                }
                if (this.actualLegend.height <= this.visibleLegend.height) break;
                this.visibleLegend.width = Math.min(this.actualLegend.width, this.visibleLegend.width - 9);
                break;
            }
            case 0: {
                this.visibleLegend.width = bounds.x - 15;
                this.visibleLegend.x = this.actualLegend.x;
                this.visibleLegend.y = this.actualLegend.y;
                this.visibleLegend.height = size.height - this.actualLegend.y - 12;
                if (this.actualLegend.width > this.visibleLegend.width) {
                    this.visibleLegend.height = Math.min(this.actualLegend.height, this.visibleLegend.height - 9);
                }
                if (this.actualLegend.height <= this.visibleLegend.height) break;
                this.visibleLegend.width = Math.min(this.actualLegend.width, this.visibleLegend.width - 9);
                this.visibleLegend.x += 9;
                break;
            }
            case 2: {
                this.visibleLegend.width = size.width - this.actualLegend.x - 9;
                this.visibleLegend.height = bounds.y - 13;
                if (this.chart.getGraphInsets().top != -1 && this.chart.isTitleOn()) {
                    this.visibleLegend.height -= this.getLabelSize((String)this.chart.getTitle(), (FontMetrics)this.getFontMetrics((Font)this.getFont((String)"titleFont"))).height;
                }
                if (this.actualLegend.height > this.visibleLegend.height) {
                    this.visibleLegend.width = Math.min(this.actualLegend.width, this.visibleLegend.width - 9);
                }
                if (this.actualLegend.width <= this.visibleLegend.width) break;
                this.visibleLegend.height = Math.min(this.actualLegend.height, this.visibleLegend.height - 9);
                break;
            }
            case 3: {
                this.visibleLegend.y = this.actualLegend.y = Math.max(this.actualLegend.y, bounds.y + bounds.height + 6);
                this.visibleLegend.width = size.width - this.actualLegend.x - 9;
                this.visibleLegend.height = size.height - this.visibleLegend.y - 4;
                if (this.actualLegend.height > this.visibleLegend.height) {
                    this.visibleLegend.width = Math.min(this.actualLegend.width, this.visibleLegend.width - 9);
                }
                if (this.actualLegend.width <= this.visibleLegend.width) break;
                this.visibleLegend.height = Math.min(this.actualLegend.height, this.visibleLegend.height - 9);
            }
        }
        this.horizontalLegendScrollerOn = this.actualLegend.width > this.visibleLegend.width;
        this.verticalLegendScrollerOn = this.actualLegend.height > this.visibleLegend.height;
    }

    protected void paintLegend(Graphics g, Legend legend, Rectangle bounds, String[] labels) {
        double offset;
        int rows;
        if (g == null || bounds == null || labels == null) {
            return;
        }
        this.calculateVisibleLegend(legend);
        g.setClip(this.visibleLegend.x, this.visibleLegend.y, this.visibleLegend.width - 2, this.visibleLegend.height + 1);
        if (this.legendBounds == null || this.legendBounds.length != labels.length) {
            this.legendBounds = new Rectangle[labels.length];
            for (int i = 0; i < this.legendBounds.length; ++i) {
                this.legendBounds[i] = new Rectangle();
            }
        }
        Font legendFont = this.getFont("legendFont");
        FontMetrics fm = this.getFontMetrics(legendFont);
        int entry_count = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (this.getSeriesCount() > 1 || this.chart.multiSeriesOn) {
                entry_count += this.chart.isSeriesEmpty(i) && (i >= labels.length || labels[i] == null || labels[i].equals("")) ? 0 : 1;
                continue;
            }
            entry_count += labels[i] == null || labels[i].equals("") ? 0 : 1;
        }
        int columns = legend.getLegendColumns();
        int legendPosition = legend.getLegendPosition();
        int rest = 0;
        if (columns == 0) {
            if (legendPosition == 1 || legendPosition == 0) {
                columns = 1;
                rows = entry_count;
            } else {
                columns = entry_count;
                rows = 1;
            }
        } else {
            rows = entry_count / columns;
            rest = entry_count % columns;
            if (rest > 0) {
                ++rows;
            }
        }
        g.setFont(this.getFont("legendFont"));
        int xpos = this.visibleLegend.x;
        int ypos = this.actualLegend.y + 1;
        if (this.actualLegend.width > this.visibleLegend.width) {
            offset = this.horizontalLegendFactor * (double)(this.actualLegend.width - this.visibleLegend.width);
            xpos -= (int)offset;
        }
        if (this.actualLegend.height > this.visibleLegend.height) {
            offset = this.verticalLegendFactor * (double)(this.actualLegend.height - this.visibleLegend.height);
            ypos -= (int)offset;
        }
        int row = 0;
        int column = 0;
        int length = Math.max(this.getSeriesCount(), labels.length);
        for (int i = 0; i < length; ++i) {
            int index = i;
            if (legend.isLegendReverseOn()) {
                index = length - i - 1;
            }
            if (this.getSeriesCount() <= 1 && !this.chart.multiSeriesOn ? labels[index] == null || labels[index].equals("") : this.chart.isSeriesEmpty(index) && (index >= labels.length || labels[index] == null || labels[index].equals(""))) continue;
            if (row == rows || row == rows - 1 && column >= rest && rest > 0) {
                if (this.legendColumnWidth != null && column < this.legendColumnWidth.length) {
                    xpos += this.legendColumnWidth[column];
                }
                ypos = this.actualLegend.y + 1;
                if (this.actualLegend.height > this.visibleLegend.height) {
                    double offset2 = this.verticalLegendFactor * (double)(this.actualLegend.height - this.visibleLegend.height);
                    ypos -= (int)offset2;
                }
                row = 0;
                if (column >= columns - 1) break;
                ++column;
            }
            if (this.legendRowHeight != null) {
                this.paintLegendElement(g, legend, index, xpos, ypos, this.legendRowHeight[row], labels[index], fm);
                ypos += this.legendRowHeight[row];
            }
            ++row;
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        if (!this.chart.isServletModeOn()) {
            this.paintLegendScrollers(g, legend);
        }
    }

    protected void paintLegendElement(Graphics g, Legend legend, int index, int xpos, int ypos, int height, String label, FontMetrics fm) {
        Color color;
        int normalizedHeight = fm.getAscent() - fm.getDescent();
        int boxSize = 6;
        if (legend.isLegendBoxSizeAsFont()) {
            boxSize = normalizedHeight;
        }
        String imageName = legend.getLegendImage(index);
        Dimension imageSize = this.getImageSize(imageName);
        imageSize.height = imageSize.height > 0 ? imageSize.height : boxSize;
        int n = imageSize.width = imageSize.width > 0 ? imageSize.width : boxSize;
        if (imageName != null && imageSize.height > 0 && imageSize.width > 0) {
            Image image = this.chart.getImage(imageName);
            if (image != null) {
                g.drawImage(image, xpos, ypos + 3, this.chart);
            }
        } else if (index < this.chart.getSeriesCount() && this.chart.isSampleHighlightOn(index)) {
            this.chart.renderer.paintSampleHighlight(g, index, -1, xpos + 3, ypos + 6, this.chart.getLegendColor(index));
        } else {
            color = legend.getLegendColor(index);
            Color color2 = null;
            if (color == null) {
                color = this.chart.getLegendColor(index);
                if (this.chart instanceof Chart) {
                    color2 = ((Chart)this.chart).getSampleColor2(index);
                }
                if (color2 == null) {
                    if (this.chart instanceof PieChart && ((PieChart)this.chart).isGradientSamplesOn() || this.chart instanceof BarChart && ((BarChart)this.chart).getBarShape() == 1 || this.chart instanceof LineChart && ((LineChart)this.chart).getLineStyle(index) == 1) {
                        color2 = LegendRenderer.getBrighter(color);
                        color = LegendRenderer.getDarker(color);
                    } else {
                        color2 = color;
                    }
                }
            } else {
                color2 = color;
            }
            GradientPaint paint = new GradientPaint(xpos, ypos, color, xpos + boxSize, ypos + boxSize, color2, true);
            ((Graphics2D)g).setPaint(paint);
            g.fillRect(xpos, ypos + (height - boxSize) / 2, boxSize, boxSize);
            g.setColor(Color.black);
            g.drawRect(xpos, ypos + (height - boxSize) / 2, boxSize, boxSize);
        }
        g.setColor(this.chart.getForeground());
        color = legend.getLabelColor(index);
        if (color != null) {
            g.setColor(color);
        }
        int normalizedOffset = (height - normalizedHeight) / 2;
        Dimension labelSize = this.getLabelSize(label, fm);
        int label_y = ypos + normalizedOffset + normalizedHeight;
        int label_x = xpos + imageSize.width + 6;
        this.paintLabel(g, label, label_x, label_y, labelSize, -1, 0, false);
        Rectangle b = this.legendBounds[index];
        b.x = xpos - 3;
        b.y = ypos;
        b.width = labelSize.width + label_x - xpos + 6;
        b.height = Math.max(imageSize.height + 5, labelSize.height + 2);
        b.height = Math.max(b.height, boxSize + 6);
        if (index >= 0 && index < this.chart.legendSelection.length && this.chart.legendSelection[index]) {
            g.setClip(this.visibleLegend.x - 3, this.visibleLegend.y, this.visibleLegend.width + 1, this.visibleLegend.height + 3);
            g.setColor(this.chart.getForeground());
            g.drawRect(b.x, b.y, b.width, b.height);
            g.setClip(this.visibleLegend.x, this.visibleLegend.y, this.visibleLegend.width - 2, this.visibleLegend.height + 1);
        }
    }

    private void paintLegendScrollers(Graphics g, Legend legend) {
        int slider;
        int scrollerSpace;
        if (this.verticalLegendScrollerOn && this.visibleLegend.height > 25) {
            int ypos = this.visibleLegend.y;
            int xpos = this.visibleLegend.x + this.visibleLegend.width - 2;
            if (legend.getLegendPosition() == 0) {
                xpos = this.visibleLegend.x - 13;
            }
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos + 4, ypos, xpos + 4, ypos + this.visibleLegend.height);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos + 5, ypos, xpos + 5, ypos + this.visibleLegend.height);
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.topLegendPushed);
            int n = this.topLegendPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine(xpos + 4, (ypos += n) + 3, xpos + 4, ypos + 3);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
            g.drawLine(xpos + 2, ypos + 5, xpos + 6, ypos + 5);
            ypos = this.visibleLegend.y + this.visibleLegend.height - 8;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.bottomLegendPushed);
            int n2 = this.bottomLegendPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine(xpos + 4, (ypos += n2) + 5, xpos + 4, ypos + 5);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
            g.drawLine(xpos + 2, ypos + 3, xpos + 6, ypos + 3);
            scrollerSpace = this.visibleLegend.height - 18;
            slider = Math.max(this.visibleLegend.height * scrollerSpace / this.actualLegend.height, 8);
            ypos = this.visibleLegend.y + 9 + (int)(this.verticalLegendFactor * (double)(scrollerSpace - slider));
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, slider, false);
            this.verticalLegendScroller.x = xpos;
            this.verticalLegendScroller.y = ypos;
            this.verticalLegendScroller.height = slider;
            this.verticalLegendScroller.width = 8;
        }
        if (this.horizontalLegendScrollerOn && this.visibleLegend.width > 26) {
            int xpos = this.visibleLegend.x - 1;
            int ypos = this.visibleLegend.y + this.visibleLegend.height + 1;
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos + 4, xpos + this.visibleLegend.width - 2, ypos + 4);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos, ypos + 5, xpos + this.visibleLegend.width - 2, ypos + 5);
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.leftLegendPushed);
            int n = this.leftLegendPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine((xpos += n) + 3, ypos + 4, xpos + 3, ypos + 4);
            g.drawLine(xpos + 4, ypos + 3, xpos + 4, ypos + 5);
            g.drawLine(xpos + 5, ypos + 2, xpos + 5, ypos + 6);
            xpos = this.visibleLegend.x + this.visibleLegend.width - 10;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.rightLegendPushed);
            int n3 = this.rightLegendPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine((xpos += n3) + 5, ypos + 4, xpos + 5, ypos + 4);
            g.drawLine(xpos + 4, ypos + 3, xpos + 4, ypos + 5);
            g.drawLine(xpos + 3, ypos + 2, xpos + 3, ypos + 6);
            scrollerSpace = this.visibleLegend.width - 19;
            slider = Math.max(this.visibleLegend.width * scrollerSpace / this.actualLegend.width, 8);
            xpos = this.visibleLegend.x + 8 + (int)(this.horizontalLegendFactor * (double)(scrollerSpace - slider));
            this.paintBox(g, Color.lightGray, xpos, ypos, slider, 8, false);
            this.horizontalLegendScroller.x = xpos;
            this.horizontalLegendScroller.y = ypos;
            this.horizontalLegendScroller.height = 8;
            this.horizontalLegendScroller.width = slider;
        }
    }

    public int getSelectedElement(Point point, Legend legend) {
        if (this.legendBounds == null || !legend.isLegendOn()) {
            return -1;
        }
        if (this.visibleLegend.contains(point)) {
            for (int i = 0; i < this.legendBounds.length; ++i) {
                if (this.legendBounds[i] == null || !this.legendBounds[i].contains(point)) continue;
                return i;
            }
        }
        return -1;
    }

    public void handleLegendScrollers(AWTEvent event) {
        if (!this.verticalLegendScrollerOn & !this.horizontalLegendScrollerOn) {
            return;
        }
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        Rectangle b = this.verticalLegendScroller;
        boolean inside_vertical = xpos >= b.x && xpos <= b.x + b.width && ypos >= b.y && ypos <= b.y + b.height;
        boolean insideTopButton = xpos >= b.x && xpos <= b.x + b.width;
        insideTopButton &= ypos >= this.visibleLegend.y && ypos <= this.visibleLegend.y + 8;
        boolean insideBottomButton = xpos >= b.x && xpos <= b.x + b.width;
        insideBottomButton &= ypos <= this.visibleLegend.y + this.visibleLegend.height && ypos >= this.visibleLegend.y + this.visibleLegend.height - 8;
        b = this.horizontalLegendScroller;
        boolean inside_horizontal = ypos >= b.y && ypos <= b.y + b.height && xpos >= b.x && xpos <= b.x + b.width;
        boolean insideLeftButton = ypos >= b.y && ypos <= b.y + b.height;
        insideLeftButton &= xpos >= this.visibleLegend.x && xpos <= this.visibleLegend.x + 8;
        boolean insideRightButton = ypos >= b.y && ypos <= b.y + b.height;
        insideRightButton &= xpos <= this.visibleLegend.x + this.visibleLegend.width && xpos >= this.visibleLegend.x + this.visibleLegend.width - 8;
        if (inside_vertical || inside_horizontal) {
            this.chart.new_cursor = HAND_CURSOR;
        }
        switch (event.getID()) {
            case 503: {
                break;
            }
            case 501: {
                this.topLegendPushed = insideTopButton;
                this.bottomLegendPushed = insideBottomButton;
                this.leftLegendPushed = insideLeftButton;
                this.rightLegendPushed = insideRightButton;
                if (inside_vertical || inside_horizontal || insideTopButton || insideBottomButton || insideLeftButton || insideRightButton) {
                    this.chart.shouldSelect = false;
                }
                if (inside_vertical) {
                    this.slidingVerticalLegend = true;
                    this.lastScrollerClick = ypos;
                } else if (inside_horizontal) {
                    this.slidingHorizontalLegend = true;
                    this.lastScrollerClick = xpos;
                } else if (insideTopButton) {
                    long delta = Math.round((1.0 - this.verticalLegendFactor) * (double)(this.actualLegend.height - this.visibleLegend.height));
                    int offset = 0;
                    for (int i = this.legendRowHeight.length - 1; i >= 0; --i) {
                        if ((long)(offset += this.legendRowHeight[i]) <= delta) continue;
                        delta = offset;
                        break;
                    }
                    this.verticalLegendFactor = 1.0 - (double)delta / (double)(this.actualLegend.height - this.visibleLegend.height);
                    this.verticalLegendFactor = Math.max(this.verticalLegendFactor, 0.0);
                } else if (insideBottomButton) {
                    long delta = Math.round(this.verticalLegendFactor * (double)(this.actualLegend.height - this.visibleLegend.height));
                    int offset = 0;
                    for (int i = 0; i < this.legendRowHeight.length; ++i) {
                        if ((long)(offset += this.legendRowHeight[i]) <= delta) continue;
                        delta = offset;
                        break;
                    }
                    this.verticalLegendFactor = (double)delta / (double)(this.actualLegend.height - this.visibleLegend.height);
                    this.verticalLegendFactor = Math.min(this.verticalLegendFactor, 1.0);
                } else if (insideLeftButton) {
                    long delta = Math.round((1.0 - this.horizontalLegendFactor) * (double)(this.actualLegend.width - this.visibleLegend.width));
                    int offset = 0;
                    for (int i = this.legendColumnWidth.length - 1; i >= 0; --i) {
                        if ((long)(offset += this.legendColumnWidth[i]) <= delta) continue;
                        delta = offset;
                        break;
                    }
                    this.horizontalLegendFactor = 1.0 - (double)delta / (double)(this.actualLegend.width - this.visibleLegend.width);
                    this.horizontalLegendFactor = Math.max(this.horizontalLegendFactor, 0.0);
                } else if (insideRightButton) {
                    long delta = Math.round(this.horizontalLegendFactor * (double)(this.actualLegend.width - this.visibleLegend.width));
                    int offset = 0;
                    for (int i = 0; i < this.legendColumnWidth.length; ++i) {
                        if ((long)(offset += this.legendColumnWidth[i]) <= delta) continue;
                        delta = offset;
                        break;
                    }
                    this.horizontalLegendFactor = (double)delta / (double)(this.actualLegend.width - this.visibleLegend.width);
                    this.horizontalLegendFactor = Math.min(this.horizontalLegendFactor, 1.0);
                }
                this.chart.needRender = true;
                this.chart.repaint();
                break;
            }
            case 506: {
                if (this.slidingVerticalLegend) {
                    this.chart.new_cursor = HAND_CURSOR;
                    int scrollerSpace = this.visibleLegend.height - 18;
                    int slider = Math.max(this.visibleLegend.height * scrollerSpace / this.actualLegend.height, 8);
                    double factor = (double)(ypos - this.lastScrollerClick) / (double)(scrollerSpace - slider);
                    this.verticalLegendFactor = Math.min(Math.max(this.verticalLegendFactor + factor, 0.0), 1.0);
                    this.lastScrollerClick = ypos;
                } else if (this.slidingHorizontalLegend) {
                    this.chart.new_cursor = HAND_CURSOR;
                    int scrollerSpace = this.visibleLegend.width - 18;
                    int slider = Math.max(this.visibleLegend.width * scrollerSpace / this.actualLegend.width, 8);
                    double factor = (double)(xpos - this.lastScrollerClick) / (double)(scrollerSpace - slider);
                    this.horizontalLegendFactor = Math.min(Math.max(this.horizontalLegendFactor + factor, 0.0), 1.0);
                    this.lastScrollerClick = xpos;
                }
                this.chart.needRender = true;
                this.chart.repaint();
                break;
            }
            case 502: {
                this.topLegendPushed = false;
                this.bottomLegendPushed = false;
                this.leftLegendPushed = false;
                this.rightLegendPushed = false;
                this.slidingVerticalLegend = false;
                this.slidingHorizontalLegend = false;
                this.chart.needRender = true;
                this.chart.repaint();
            }
        }
    }
}

