/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import net.sourceforge.jtds.jdbc.CharsetInfo;
import net.sourceforge.jtds.jdbc.JtdsConnection;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.ssl.SocketFactories;
import net.sourceforge.jtds.util.Logger;

class SharedSocket {
    private static ConcurrentHashMap macHash = new ConcurrentHashMap();
    private static long oneDay = 86400000L;
    private static long lastCache = System.currentTimeMillis();
    private Socket socket;
    private Socket sslSocket;
    private DataOutputStream out;
    private DataInputStream in;
    private int maxBufSize = 512;
    private final AtomicInteger _LastID = new AtomicInteger();
    private final ConcurrentMap<Integer, VirtualSocket> _VirtualSockets = new ConcurrentHashMap<Integer, VirtualSocket>();
    private VirtualSocket responseOwner;
    private final byte[] hdrBuf = new byte[8];
    private final File bufferDir;
    private static int globalMemUsage;
    private static int peakMemUsage;
    private static int memoryBudget;
    private static int minMemPkts;
    private static boolean securityViolation;
    private int tdsVersion;
    protected final int serverType;
    private CharsetInfo charsetInfo;
    private int packetCount;
    private String host;
    private int port;
    private boolean cancelPending;
    private final Object cancelMonitor = new Object();
    private final byte[] doneBuffer = new byte[9];
    private int doneBufferFrag = 0;
    private static final int TDS_DONE_TOKEN = 253;
    private static final int TDS_DONE_LEN = 9;
    private static final int TDS_HDR_LEN = 8;

    protected SharedSocket(File file, int n, int n2) {
        this.bufferDir = file;
        this.tdsVersion = n;
        this.serverType = n2;
    }

    SharedSocket(JtdsConnection jtdsConnection) throws IOException, UnknownHostException {
        this(jtdsConnection.getBufferDir(), jtdsConnection.getTdsVersion(), jtdsConnection.getServerType());
        this.host = jtdsConnection.getServerName();
        this.port = jtdsConnection.getPortNumber();
        this.socket = this.createSocketForJDBC3(jtdsConnection);
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
        this.socket.setTcpNoDelay(jtdsConnection.getTcpNoDelay());
        this.socket.setSoTimeout(jtdsConnection.getSocketTimeout() * 1000);
        this.socket.setKeepAlive(jtdsConnection.getSocketKeepAlive());
    }

    private Socket createSocketForJDBC3(JtdsConnection jtdsConnection) throws IOException {
        String string = jtdsConnection.getServerName();
        int n = jtdsConnection.getPortNumber();
        String string2 = jtdsConnection.getBindAddress();
        int n2 = jtdsConnection.getLoginTimeout();
        Socket socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        if (string2 != null && !string2.isEmpty()) {
            socket.bind(new InetSocketAddress(string2, 0));
        }
        socket.connect(inetSocketAddress, n2 * 1000);
        return socket;
    }

    String getMAC() {
        try {
            byte[] byArray;
            InetAddress inetAddress;
            String string;
            long l = System.currentTimeMillis();
            if (l - lastCache > oneDay) {
                lastCache = l;
                macHash.clear();
            }
            if ((string = (String)macHash.get(inetAddress = this.socket.getLocalAddress())) != null) {
                return string;
            }
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            byte[] byArray2 = byArray = networkInterface == null ? null : networkInterface.getHardwareAddress();
            if (byArray != null) {
                String string2 = "";
                for (int i = 0; i < byArray.length; ++i) {
                    String string3 = String.format("%02X", byArray[i]);
                    string2 = string2 + string3;
                }
                macHash.put(inetAddress, string2);
                return string2;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    void enableEncryption(String string) throws IOException {
        Logger.println("Enabling TLS encryption");
        SocketFactory socketFactory = SocketFactories.getSocketFactory(string, this.socket);
        this.sslSocket = socketFactory.createSocket(this.getHost(), this.getPort());
        this.setOut(new DataOutputStream(this.sslSocket.getOutputStream()));
        this.setIn(new DataInputStream(this.sslSocket.getInputStream()));
    }

    void disableEncryption() throws IOException {
        Logger.println("Disabling TLS encryption");
        this.sslSocket.close();
        this.sslSocket = null;
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
    }

    void setCharsetInfo(CharsetInfo charsetInfo) {
        this.charsetInfo = charsetInfo;
    }

    CharsetInfo getCharsetInfo() {
        return this.charsetInfo;
    }

    String getCharset() {
        return this.charsetInfo.getCharset();
    }

    RequestStream getRequestStream(int n, int n2) {
        VirtualSocket virtualSocket;
        int n3;
        do {
            n3 = this._LastID.incrementAndGet();
            virtualSocket = new VirtualSocket(n3);
        } while (this._VirtualSockets.putIfAbsent(n3, virtualSocket) != null);
        return new RequestStream(this, virtualSocket, n, n2);
    }

    ResponseStream getResponseStream(RequestStream requestStream, int n) {
        return new ResponseStream(this, requestStream.getVirtualSocket(), n);
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    protected void setTdsVersion(int n) {
        this.tdsVersion = n;
    }

    static void setMemoryBudget(int n) {
        memoryBudget = n;
    }

    static int getMemoryBudget() {
        return memoryBudget;
    }

    static void setMinMemPkts(int n) {
        minMemPkts = n;
    }

    static int getMinMemPkts() {
        return minMemPkts;
    }

    boolean isConnected() {
        return this.socket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(VirtualSocket virtualSocket) {
        Object object = this.cancelMonitor;
        synchronized (object) {
            if (this.responseOwner == virtualSocket && !this.cancelPending) {
                try {
                    this.cancelPending = true;
                    this.doneBufferFrag = 0;
                    byte[] byArray = new byte[]{6, 1, 0, 8, 0, 0, this.tdsVersion >= 3 ? (byte)1 : 0, 0};
                    this.getOut().write(byArray, 0, 8);
                    this.getOut().flush();
                    if (Logger.isActive()) {
                        Logger.logPacket(virtualSocket.id, false, byArray);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Max buffer memory used = " + peakMemUsage / 1024 + "KB");
        }
        for (VirtualSocket virtualSocket : this._VirtualSockets.values()) {
            if (virtualSocket == null || virtualSocket.diskQueue == null) continue;
            try {
                virtualSocket.diskQueue.close();
                virtualSocket.queueFile.delete();
            }
            catch (IOException iOException) {}
        }
        this._VirtualSockets.clear();
        try {
            if (this.sslSocket != null) {
                this.sslSocket.close();
                this.sslSocket = null;
            }
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceClose() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sslSocket = null;
                this.socket = null;
            }
        }
    }

    void closeStream(VirtualSocket virtualSocket) {
        this._VirtualSockets.remove(virtualSocket.id);
        if (virtualSocket.diskQueue != null) {
            try {
                virtualSocket.diskQueue.close();
                virtualSocket.queueFile.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sendNetPacket(VirtualSocket virtualSocket, byte[] byArray) throws IOException {
        ConcurrentMap<Integer, VirtualSocket> concurrentMap = this._VirtualSockets;
        synchronized (concurrentMap) {
            while (virtualSocket.inputPkts > 0) {
                if (Logger.isActive()) {
                    Logger.println("TdsSocket: Unread data in input packet queue");
                }
                this.dequeueInput(virtualSocket);
            }
            if (this.responseOwner != null) {
                byte[] byArray2 = null;
                boolean bl = this.responseOwner == virtualSocket;
                VirtualSocket virtualSocket2 = this.responseOwner;
                do {
                    byArray2 = this.readPacket(bl ? byArray2 : null);
                    if (bl) continue;
                    this.enqueueInput(virtualSocket2, byArray2);
                } while (byArray2[1] == 0);
            }
            this.getOut().write(byArray, 0, SharedSocket.getPktLen(byArray));
            if (byArray[1] != 0) {
                this.getOut().flush();
                this.responseOwner = virtualSocket;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getNetPacket(VirtualSocket virtualSocket, byte[] byArray) throws IOException {
        ConcurrentMap<Integer, VirtualSocket> concurrentMap = this._VirtualSockets;
        synchronized (concurrentMap) {
            if (virtualSocket.inputPkts > 0) {
                return this.dequeueInput(virtualSocket);
            }
            if (this.responseOwner == null) {
                throw new IOException("Stream " + virtualSocket.id + " attempting to read when no request has been sent");
            }
            if (this.responseOwner != virtualSocket) {
                throw new IOException("Stream " + virtualSocket.id + " is trying to read data that belongs to stream " + this.responseOwner.id);
            }
            return this.readPacket(byArray);
        }
    }

    private void enqueueInput(VirtualSocket virtualSocket, byte[] byArray) throws IOException {
        if (globalMemUsage + byArray.length > memoryBudget && virtualSocket.pktQueue.size() >= minMemPkts && !securityViolation && virtualSocket.diskQueue == null) {
            try {
                virtualSocket.queueFile = File.createTempFile("jtds", ".tmp", this.bufferDir);
                virtualSocket.diskQueue = new RandomAccessFile(virtualSocket.queueFile, "rw");
                while (virtualSocket.pktQueue.size() > 0) {
                    byte[] byArray2 = (byte[])virtualSocket.pktQueue.removeFirst();
                    virtualSocket.diskQueue.write(byArray2, 0, SharedSocket.getPktLen(byArray2));
                    ++virtualSocket.pktsOnDisk;
                }
            }
            catch (SecurityException securityException) {
                securityViolation = true;
                virtualSocket.queueFile = null;
                virtualSocket.diskQueue = null;
            }
        }
        if (virtualSocket.diskQueue != null) {
            virtualSocket.diskQueue.write(byArray, 0, SharedSocket.getPktLen(byArray));
            ++virtualSocket.pktsOnDisk;
        } else {
            virtualSocket.pktQueue.addLast(byArray);
            if ((globalMemUsage += byArray.length) > peakMemUsage) {
                peakMemUsage = globalMemUsage;
            }
        }
        ++virtualSocket.inputPkts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] dequeueInput(VirtualSocket virtualSocket) throws IOException {
        byte[] byArray = null;
        if (virtualSocket.pktsOnDisk > 0) {
            if (virtualSocket.diskQueue.getFilePointer() == virtualSocket.diskQueue.length()) {
                virtualSocket.diskQueue.seek(0L);
            }
            virtualSocket.diskQueue.readFully(this.hdrBuf, 0, 8);
            int n = SharedSocket.getPktLen(this.hdrBuf);
            byArray = new byte[n];
            System.arraycopy(this.hdrBuf, 0, byArray, 0, 8);
            virtualSocket.diskQueue.readFully(byArray, 8, n - 8);
            --virtualSocket.pktsOnDisk;
            if (virtualSocket.pktsOnDisk < 1) {
                try {
                    virtualSocket.diskQueue.close();
                    virtualSocket.queueFile.delete();
                }
                finally {
                    virtualSocket.queueFile = null;
                    virtualSocket.diskQueue = null;
                }
            }
        } else if (virtualSocket.pktQueue.size() > 0) {
            byArray = (byte[])virtualSocket.pktQueue.removeFirst();
            globalMemUsage -= byArray.length;
        }
        if (byArray != null) {
            --virtualSocket.inputPkts;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readPacket(byte[] byArray) throws IOException {
        try {
            this.getIn().readFully(this.hdrBuf);
        }
        catch (EOFException eOFException) {
            throw new IOException("DB server closed connection.");
        }
        byte by = this.hdrBuf[0];
        if (by != 2 && by != 1 && by != 15 && by != 4) {
            throw new IOException("Unknown packet type 0x" + Integer.toHexString(by & 0xFF));
        }
        int n = SharedSocket.getPktLen(this.hdrBuf);
        if (n < 8 || n > 65536) {
            throw new IOException("Invalid network packet length " + n);
        }
        if (byArray == null || n > byArray.length) {
            byArray = new byte[n];
            if (n > this.maxBufSize) {
                this.maxBufSize = n;
            }
        }
        System.arraycopy(this.hdrBuf, 0, byArray, 0, 8);
        try {
            this.getIn().readFully(byArray, 8, n - 8);
        }
        catch (EOFException eOFException) {
            throw new IOException("DB server closed connection.");
        }
        if (++this.packetCount == 1 && this.serverType == 1 && "NTLMSSP".equals(new String(byArray, 11, 7))) {
            byArray[1] = 1;
        }
        Object object = this.cancelMonitor;
        synchronized (object) {
            if (this.cancelPending) {
                int n2 = Math.min(9, n - 8);
                int n3 = 9 - n2;
                System.arraycopy(this.doneBuffer, n2, this.doneBuffer, 0, n3);
                System.arraycopy(byArray, n - n2, this.doneBuffer, n3, n2);
                this.doneBufferFrag = Math.min(9, this.doneBufferFrag + n2);
                if (this.doneBufferFrag < 9) {
                    byArray[1] = 0;
                }
                if (byArray[1] == 1) {
                    if ((this.doneBuffer[0] & 0xFF) < 253) {
                        throw new IOException("Expecting a TDS_DONE or TDS_DONEPROC.");
                    }
                    if ((this.doneBuffer[1] & 0x20) != 0) {
                        this.cancelPending = false;
                    } else {
                        byArray[1] = 0;
                    }
                }
            }
            if (byArray[1] != 0) {
                this.responseOwner = null;
            }
        }
        return byArray;
    }

    static int getPktLen(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        int n2 = (byArray[2] & 0xFF) << 8;
        return n2 | n;
    }

    protected void setTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    protected void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    protected DataInputStream getIn() {
        return this.in;
    }

    protected void setIn(DataInputStream dataInputStream) {
        this.in = dataInputStream;
    }

    protected DataOutputStream getOut() {
        return this.out;
    }

    protected void setOut(DataOutputStream dataOutputStream) {
        this.out = dataOutputStream;
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    static {
        memoryBudget = 100000;
        minMemPkts = 8;
    }

    static class VirtualSocket {
        final int id;
        final LinkedList pktQueue;
        File queueFile;
        RandomAccessFile diskQueue;
        int pktsOnDisk;
        int inputPkts;

        private VirtualSocket(int n) {
            this.id = n;
            this.pktQueue = new LinkedList();
        }
    }
}

