/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Nnrpd.CrLfOutputStream;
import Acme.Nnrpd.NewsDb;
import Acme.Nnrpd.NewsDbArticle;
import Acme.Nnrpd.NewsDbException;
import Acme.Nnrpd.NewsDbGroup;
import Acme.Nnrpd.NnrpdUtils;
import Acme.Nnrpd.OverviewCache;
import Acme.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ProxyNewsDb
extends NewsDb {
    private static final boolean avoidArticleHack = false;
    private String host;
    private int port;
    private Socket socket;
    private boolean postingOk;
    private String[] overviewFmt;
    private OverviewCache overviewCache;
    private DataInputStream din;
    private PrintStream pout;
    private Hashtable groupTable;
    private long groupsFetched;
    private Hashtable groupDescsTable;
    private long groupDescsFetched;
    private NewsDbGroup currentGroup;
    private int currentArtNum = -1;
    private String[] lastOkNames;

    public ProxyNewsDb(String proxyHost, int oCacheSize) throws NewsDbException {
        int colon = proxyHost.indexOf(58);
        if (colon == -1) {
            this.host = proxyHost;
            this.port = 119;
        } else {
            this.host = proxyHost.substring(0, colon);
            this.port = Utils.parseInt(proxyHost.substring(colon + 1), 119);
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.din = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.pout = new PrintStream(new CrLfOutputStream(new BufferedOutputStream(this.socket.getOutputStream())));
        }
        catch (IOException e) {
            throw new NewsDbException("problem opening socket to " + this.host + ": " + e);
        }
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 200: {
                this.postingOk = true;
                break;
            }
            case 201: {
                this.postingOk = false;
                break;
            }
            case 502: {
                throw new NewsDbException("no read permission on " + this.host);
            }
            default: {
                throw new NewsDbException("unexpected response to " + this.host + " initial connect: " + Utils.flattenStrarr(resp));
            }
        }
        this.pout.println("SLAVE");
        resp = this.readResp();
        this.pout.println("LIST schema");
        resp = this.readResp();
        respNum = Utils.parseInt(resp[0], -1);
        block8 : switch (respNum) {
            case 215: {
                try {
                    this.overviewFmt = Utils.splitStr(NnrpdUtils.readText(this.din));
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                this.pout.println("LIST overview.fmt");
                resp = this.readResp();
                respNum = Utils.parseInt(resp[0], -1);
                switch (respNum) {
                    case 215: {
                        try {
                            this.overviewFmt = Utils.splitStr(NnrpdUtils.readText(this.din));
                        }
                        catch (IOException iOException) {}
                        break block8;
                    }
                }
            }
        }
        if (this.overviewFmt != null) {
            int i = 0;
            while (i < this.overviewFmt.length) {
                if (this.overviewFmt[i].endsWith(":")) {
                    this.overviewFmt[i] = this.overviewFmt[i].substring(0, this.overviewFmt[i].length() - 1);
                }
                ++i;
            }
            this.overviewCache = new OverviewCache(oCacheSize);
        }
    }

    public boolean authorize(String user, String password) throws NewsDbException {
        this.pout.println("AUTHINFO USER " + user);
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 381: {
                this.pout.println("AUTHINFO PASS " + password);
                resp = this.readResp();
                respNum = Utils.parseInt(resp[0], -1);
                switch (respNum) {
                    case 281: {
                        return true;
                    }
                    case 502: {
                        return false;
                    }
                }
                throw new NewsDbException("unexpected response to AUTHINFO command: " + Utils.flattenStrarr(resp));
            }
        }
        throw new NewsDbException("unexpected response to AUTHINFO command: " + Utils.flattenStrarr(resp));
    }

    public boolean getPostingOk() throws NewsDbException {
        return this.postingOk;
    }

    public synchronized NewsDbGroup getGroup(String groupName) throws NewsDbException {
        if (this.currentGroup != null && groupName.equals(this.currentGroup.getName())) {
            return this.currentGroup;
        }
        this.checkGroups();
        NewsDbGroup group = (NewsDbGroup)this.groupTable.get(groupName);
        if (group != null) {
            return group;
        }
        return this.setGroup(groupName);
    }

    private synchronized NewsDbGroup setGroup(String groupName) throws NewsDbException {
        this.pout.println("GROUP " + groupName);
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 211: {
                try {
                    this.currentGroup = new NewsDbGroup(this.dbStamp, resp[4], Integer.parseInt(resp[1]), Integer.parseInt(resp[2]), Integer.parseInt(resp[3]), '?', (String)this.groupDescsTable.get(groupName));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NewsDbException("unparsable numbers in response to GROUP command: " + Utils.flattenStrarr(resp));
                }
                this.currentArtNum = this.currentGroup.getFirstArtNum();
                this.groupTable.put(this.currentGroup.getName(), this.currentGroup);
                return this.currentGroup;
            }
            case 411: {
                return null;
            }
        }
        throw new NewsDbException("unexpected response to GROUP command: " + Utils.flattenStrarr(resp));
    }

    public synchronized NewsDbArticle getArticle(NewsDbGroup group, int artNum) throws NewsDbException {
        if (group.getDbStamp() != this.dbStamp) {
            throw new NewsDbException("mismatched database stamps");
        }
        if (this.currentGroup == null || !group.getName().equals(this.currentGroup.getName())) {
            this.setGroup(group.getName());
        }
        this.pout.println("ARTICLE " + artNum);
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 220: {
                String text;
                this.currentArtNum = artNum;
                try {
                    text = NnrpdUtils.readText(this.din);
                }
                catch (IOException e) {
                    throw new NewsDbException("problem fetching article: " + e);
                }
                return new NewsDbArticle(this.dbStamp, text);
            }
            case 423: {
                return null;
            }
        }
        throw new NewsDbException("unexpected response to ARTICLE command: " + Utils.flattenStrarr(resp));
    }

    public synchronized NewsDbArticle getArticle(String messageId) throws NewsDbException {
        this.pout.println("ARTICLE " + messageId);
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 220: {
                String text;
                try {
                    text = NnrpdUtils.readText(this.din);
                }
                catch (IOException e) {
                    throw new NewsDbException("problem fetching article: " + e);
                }
                return new NewsDbArticle(this.dbStamp, text);
            }
            case 430: {
                return null;
            }
        }
        throw new NewsDbException("unexpected response to ARTICLE command: " + Utils.flattenStrarr(resp));
    }

    public synchronized String[][] getHeaders(String[] names, NewsDbGroup group, int firstArtNum, int lastArtNum) throws NewsDbException {
        if (this.overviewFmt == null) {
            return null;
        }
        if (names != this.lastOkNames) {
            if (!Utils.equalsStrings(names, this.overviewFmt)) {
                return null;
            }
            this.lastOkNames = names;
        }
        if (group.getDbStamp() != this.dbStamp) {
            throw new NewsDbException("mismatched database stamps");
        }
        long now = System.currentTimeMillis();
        long time = this.overviewCache.getLastTime(group);
        if (time == -1L || now - time >= 86400000L) {
            this.readOverview(group);
            this.overviewCache.setLastTime(group);
        }
        int numArts = lastArtNum - firstArtNum + 1;
        String[][] results = new String[numArts][];
        int i = 0;
        while (i < numArts) {
            int artNum = firstArtNum + i;
            results[i] = this.overviewCache.getEntry(group, artNum);
            ++i;
        }
        return results;
    }

    private void readOverview(NewsDbGroup group) throws NewsDbException {
        if (this.currentGroup == null || !group.getName().equals(this.currentGroup.getName())) {
            this.setGroup(group.getName());
        }
        this.pout.println("XOVER " + group.getFirstArtNum() + "-" + group.getLastArtNum());
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        block2 : switch (respNum) {
            case 224: {
                while (true) {
                    int artNum;
                    String line;
                    try {
                        line = this.din.readLine();
                    }
                    catch (IOException iOException) {
                        break block2;
                    }
                    if (line == null || line.equals(".")) break block2;
                    int tab = line.indexOf(9);
                    try {
                        artNum = Integer.parseInt(line.substring(0, tab));
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    String[] overviewEntry = Utils.splitStr(line.substring(tab + 1), '\t');
                    if (overviewEntry.length != this.overviewFmt.length) continue;
                    this.overviewCache.addEntry(overviewEntry, group, artNum);
                }
            }
            default: {
                throw new NewsDbException("unexpected response to XOVER command: " + Utils.flattenStrarr(resp));
            }
        }
    }

    public Enumeration getGroups() throws NewsDbException {
        this.checkGroups();
        return this.groupTable.elements();
    }

    public synchronized Enumeration getGroups(long since) throws NewsDbException {
        this.pout.println("NEWGROUPS " + NnrpdUtils.rfc977DateTime(since));
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 231: {
                return this.readGroups().elements();
            }
        }
        throw new NewsDbException("unexpected response to NEWGROUPS command: " + Utils.flattenStrarr(resp));
    }

    public synchronized Enumeration getGroups(long since, String distsPat) throws NewsDbException {
        this.pout.println("NEWGROUPS " + NnrpdUtils.rfc977DateTime(since) + " " + distsPat);
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 231: {
                return this.readGroups().elements();
            }
        }
        throw new NewsDbException("unexpected response to NEWGROUPS command: " + Utils.flattenStrarr(resp));
    }

    public Enumeration getMessageIds(String groupsPat, long since) throws NewsDbException {
        Vector messageIds = new Vector();
        return messageIds.elements();
    }

    public Enumeration getMessageIds(String groupsPat, long since, String distsPat) throws NewsDbException {
        Vector messageIds = new Vector();
        return messageIds.elements();
    }

    public synchronized void post(String artText) throws NewsDbException {
        this.pout.println("POST");
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 340: {
                this.pout.print(artText);
                this.pout.println(".");
                resp = this.readResp();
                respNum = Utils.parseInt(resp[0], -1);
                switch (respNum) {
                    case 441: {
                        throw new NewsDbException("post failed: " + Utils.flattenStrarr(resp));
                    }
                    default: {
                        throw new NewsDbException("unexpected response to posted article: " + Utils.flattenStrarr(resp));
                    }
                    case 240: {
                        return;
                    }
                }
            }
        }
        throw new NewsDbException("unexpected response to POST command: " + Utils.flattenStrarr(resp));
    }

    public synchronized void close() {
        this.pout.println("QUIT");
        try {
            this.din.close();
            this.pout.flush();
            this.pout.close();
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    private synchronized String[] readResp() throws NewsDbException {
        String line;
        this.pout.flush();
        try {
            line = this.din.readLine();
        }
        catch (IOException e) {
            throw new NewsDbException("problem reading remote response: " + e);
        }
        if (line == null || line.length() == 0) {
            throw new NewsDbException("problem reading remote response");
        }
        return Utils.splitStr(line);
    }

    private synchronized void checkGroups() throws NewsDbException {
        this.checkGroupDescs();
        long now = System.currentTimeMillis();
        if (this.groupTable != null && now - this.groupsFetched < 1800000L) {
            return;
        }
        this.pout.println("LIST");
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 215: {
                this.groupTable = this.readGroups();
                this.groupsFetched = now;
                return;
            }
        }
        throw new NewsDbException("unexpected response to LIST command: " + Utils.flattenStrarr(resp));
    }

    private synchronized void checkGroupDescs() throws NewsDbException {
        long now = System.currentTimeMillis();
        if (this.groupDescsTable != null && now - this.groupDescsFetched < 86400000L) {
            return;
        }
        this.pout.println("LIST newsgroups");
        String[] resp = this.readResp();
        int respNum = Utils.parseInt(resp[0], -1);
        switch (respNum) {
            case 215: {
                this.groupDescsTable = new Hashtable();
                while (true) {
                    String line;
                    try {
                        line = this.din.readLine();
                    }
                    catch (IOException iOException) {
                        break;
                    }
                    if (line == null || line.equals(".")) break;
                    int ws = Utils.strCSpan(line, " \t");
                    int nws = ws + Utils.strSpan(line, " \t", ws);
                    String groupName = line.substring(0, ws);
                    String groupDesc = line.substring(nws);
                    this.groupDescsTable.put(groupName, groupDesc);
                }
                this.groupDescsFetched = now;
                return;
            }
        }
        throw new NewsDbException("unexpected response to LIST newsgroups command: " + Utils.flattenStrarr(resp));
    }

    private synchronized Hashtable readGroups() throws NewsDbException {
        Hashtable<String, NewsDbGroup> gt = new Hashtable<String, NewsDbGroup>();
        while (true) {
            int firstArtNum;
            int lastArtNum;
            String line;
            try {
                line = this.din.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (line == null || line.equals(".")) break;
            String[] words = Utils.splitStr(line);
            String groupName = words[0];
            try {
                lastArtNum = Integer.parseInt(words[1]);
                firstArtNum = Integer.parseInt(words[2]);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            char flag = words[3].charAt(0);
            NewsDbGroup group = new NewsDbGroup(this.dbStamp, groupName, lastArtNum - firstArtNum + 1, firstArtNum, lastArtNum, flag, (String)this.groupDescsTable.get(groupName));
            gt.put(group.getName(), group);
        }
        return gt;
    }
}

