/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.CryptoUtils;

public abstract class Hash
extends CryptoUtils {
    protected int hashSize;
    protected byte[] hashBytes;

    public Hash(int hashSize) {
        this.hashSize = hashSize;
        this.hashBytes = new byte[hashSize];
    }

    public int hashSize() {
        return this.hashSize;
    }

    public abstract void reset();

    public abstract void add(byte var1);

    public void add(byte[] data, int off, int len) {
        int i = off;
        while (i < off + len) {
            this.add(data[i]);
            ++i;
        }
    }

    protected void prepare() {
    }

    public byte[] get() {
        this.prepare();
        byte[] hb = new byte[this.hashSize];
        System.arraycopy(this.hashBytes, 0, hb, 0, this.hashSize);
        return hb;
    }

    public void add(String str) {
        int len = str.length();
        char[] data = new char[len];
        str.getChars(0, len, data, 0);
        int i = 0;
        while (i < len) {
            this.add(data[i]);
            ++i;
        }
    }

    public void addASCII(String str) {
        int len = str.length();
        byte[] data = str.getBytes();
        this.add(data, 0, len);
    }

    public void add(byte[] data) {
        this.add(data, 0, data.length);
    }

    public void add(boolean b) {
        if (b) {
            this.add((byte)1);
        } else {
            this.add((byte)0);
        }
    }

    public void add(char c) {
        this.add((byte)(c >>> 8));
        this.add((byte)c);
    }

    public void add(short s) {
        this.add((byte)(s >>> 8));
        this.add((byte)s);
    }

    public void add(int i) {
        this.add((byte)(i >>> 24));
        this.add((byte)(i >>> 16));
        this.add((byte)(i >>> 8));
        this.add((byte)i);
    }

    public void add(long l) {
        this.add((byte)(l >>> 56));
        this.add((byte)(l >>> 48));
        this.add((byte)(l >>> 40));
        this.add((byte)(l >>> 32));
        this.add((byte)(l >>> 24));
        this.add((byte)(l >>> 16));
        this.add((byte)(l >>> 8));
        this.add((byte)l);
    }

    public void add(float f) {
        this.add(Float.floatToIntBits(f));
    }

    public void add(double d) {
        this.add(Double.doubleToLongBits(d));
    }

    public void add(Object o) {
        this.add(o.toString());
    }

    public static byte[] hashStr(String str, Hash hash) {
        hash.add(str);
        return hash.get();
    }

    public boolean equals(Hash otherHash) {
        if (otherHash.hashSize != this.hashSize) {
            return false;
        }
        otherHash.prepare();
        this.prepare();
        int i = 0;
        while (i < this.hashSize) {
            if (otherHash.hashBytes[i] != this.hashBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        this.prepare();
        int code = 0;
        int shift = 0;
        int i = 0;
        while (i < this.hashSize) {
            code ^= this.hashBytes[i] << shift;
            shift = (shift + 8) % 32;
            ++i;
        }
        return code;
    }

    public String toString() {
        this.prepare();
        return CryptoUtils.toStringBlock(this.hashBytes, 0, this.hashSize);
    }
}

