/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.FileFault;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.HttpNfcLease;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class VirtualMachineSnapshot
extends ManagedObject {
    public VirtualMachineSnapshot(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public VirtualMachineSnapshot[] getChildSnapshot() {
        ManagedObjectReference[] mors = (ManagedObjectReference[])this.getCurrentProperty("childSnapshot");
        VirtualMachineSnapshot[] vmns = new VirtualMachineSnapshot[mors.length];
        int i = 0;
        while (i < mors.length) {
            vmns[i] = new VirtualMachineSnapshot(this.getServerConnection(), mors[i]);
            ++i;
        }
        return vmns;
    }

    public VirtualMachineConfigInfo getConfig() {
        return (VirtualMachineConfigInfo)this.getCurrentProperty("config");
    }

    public HttpNfcLease exportSnapshot() throws TaskInProgress, InvalidState, FileFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().exportSnapshot(this.getMOR());
        return new HttpNfcLease(this.getServerConnection(), mor);
    }

    public Task removeSnapshot_Task(boolean removeChildren) throws TaskInProgress, RuntimeFault, RemoteException {
        return this.removeSnapshot_Task(removeChildren, null);
    }

    public Task removeSnapshot_Task(boolean removeChildren, Boolean consolidate) throws TaskInProgress, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().removeSnapshot_Task(this.getMOR(), removeChildren, consolidate));
    }

    public void renameSnapshot(String name, String description) throws InvalidName, RuntimeFault, RemoteException {
        this.getVimService().renameSnapshot(this.getMOR(), name, description);
    }

    public Task revertToSnapshot_Task(HostSystem host) throws VmConfigFault, TaskInProgress, FileFault, InvalidState, InsufficientResourcesFault, RuntimeFault, RemoteException {
        return this.revertToSnapshot_Task(host, null);
    }

    public Task revertToSnapshot_Task(HostSystem host, Boolean suppressPowerOn) throws VmConfigFault, TaskInProgress, FileFault, InvalidState, InsufficientResourcesFault, RuntimeFault, RemoteException {
        return new Task(this.getServerConnection(), this.getVimService().revertToSnapshot_Task(this.getMOR(), host == null ? null : host.getMOR(), suppressPowerOn));
    }
}

