/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class GIFDecoder
implements ImageProducer {
    private Vector consumers = new Vector();
    private byte[] bytePixels;
    private int[] intPixels;
    private int width;
    private int height;
    ColorModel colorModel;
    private int imageStatus;
    private String fullInfo;
    private String shortInfo;
    private String comment;
    private InputStream input;
    private boolean classColorModelAccessible;
    private int bitOffset;
    private int XC;
    private int YC;
    private int pass;
    private int ptr;
    private int oldYC;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private int transparentIndex;
    private static final String id87 = "GIF87a";
    private static final String id89 = "GIF89a";
    private static final short[][] EGA_PALETTE;
    private static final byte EXTENSION = 33;
    private static final byte IMAGESEP = 44;
    private static final byte TRAILER = 59;
    private static final byte INTERLACEMASK = 64;
    private static final byte COLORMAPMASK = -128;

    public GIFDecoder(InputStream inputStream) {
        try {
            Class.forName("java.awt.image.ColorModel");
            this.classColorModelAccessible = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {}
        this.bitOffset = 0;
        this.XC = 0;
        this.YC = 0;
        this.pass = 0;
        this.ptr = 0;
        this.oldYC = -1;
        this.r = new byte[256];
        this.g = new byte[256];
        this.b = new byte[256];
        this.transparentIndex = -1;
        this.input = inputStream;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && this.isConsumer(imageConsumer)) {
            return;
        }
        GIFDecoder gIFDecoder = this;
        synchronized (gIFDecoder) {
            if (this.imageStatus == 0) {
                try {
                    this.loadGIF(this.input);
                    this.imageStatus = 3;
                }
                catch (IOException iOException) {
                    this.imageStatus = 1;
                }
            }
        }
        if (this.imageStatus != 1) {
            imageConsumer.setDimensions(this.width, this.height);
            imageConsumer.setHints(26);
            if (this.colorModel != null) {
                imageConsumer.setColorModel(this.colorModel);
                imageConsumer.setPixels(0, 0, this.width, this.height, this.colorModel, this.bytePixels, 0, this.width);
            } else {
                imageConsumer.setPixels(0, 0, this.width, this.height, null, this.intPixels, 0, this.width);
            }
            imageConsumer.imageComplete(this.imageStatus);
        } else {
            imageConsumer.imageComplete(this.imageStatus);
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void loadGIF(InputStream inputStream) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.pass = 0;
        this.YC = 0;
        this.XC = 0;
        this.bitOffset = 0;
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = new byte[6];
        int n2 = 0;
        while (n2 < 6) {
            byArray[n2] = dataInputStream.readByte();
            ++n2;
        }
        String string = new String(byArray, 0);
        if (string.equals(id87)) {
            bl2 = false;
        } else if (string.equals(id89)) {
            bl2 = true;
        } else {
            this.gifWarning(inputStream, "not a GIF file");
        }
        byte by = dataInputStream.readByte();
        dataInputStream.readByte();
        by = dataInputStream.readByte();
        dataInputStream.readByte();
        by = dataInputStream.readByte();
        boolean bl3 = (by & 0xFFFFFF80) != 0;
        int n3 = (by & 7) + 1;
        int n4 = 1 << n3;
        int n5 = n4 - 1;
        dataInputStream.readByte();
        int n6 = dataInputStream.readByte() & 0xFF;
        if (n6 != 0 && !bl2) {
            this.gifWarning(inputStream, "corrupt GIF file (screen descriptor)");
        }
        if (bl3) {
            n = 0;
            while (n < n4) {
                this.r[n] = dataInputStream.readByte();
                this.g[n] = dataInputStream.readByte();
                this.b[n] = dataInputStream.readByte();
                ++n;
            }
        } else {
            n = 0;
            while (n < 256) {
                this.r[n] = (byte)EGA_PALETTE[n & 0xF][0];
                this.g[n] = (byte)EGA_PALETTE[n & 0xF][1];
                this.b[n] = (byte)EGA_PALETTE[n & 0xF][2];
                ++n;
            }
        }
        n = 0;
        while ((n = dataInputStream.readByte() & 0xFF) != 59) {
            int n7;
            int n8;
            if (n == 33) {
                int n9;
                int n10;
                int n11;
                int n12;
                n8 = dataInputStream.readByte() & 0xFF;
                if (n8 == 82) {
                    n7 = dataInputStream.readByte() & 0xFF;
                    if (n7 == 2) {
                        byte by2 = dataInputStream.readByte();
                        byte by3 = dataInputStream.readByte();
                        if (by3 <= 0 || by2 <= 0) {
                            by3 = 1;
                            by2 = 1;
                        }
                    } else {
                        dataInputStream.skipBytes(n7);
                    }
                    while ((n12 = dataInputStream.readByte() & 0xFF) > 0) {
                        dataInputStream.skipBytes(n12);
                    }
                    continue;
                }
                if (n8 == 254) {
                    n12 = 0;
                    while ((n12 = dataInputStream.readByte() & 0xFF) != 0) {
                        byte[] byArray2 = new byte[n12];
                        n11 = 0;
                        while (n11 < n12) {
                            byArray2[n11] = dataInputStream.readByte();
                            ++n11;
                        }
                        this.comment = this.comment != null ? String.valueOf(this.comment) + "\n" + new String(byArray2, 0) : new String(byArray2, 0);
                    }
                    continue;
                }
                if (n8 == 1) {
                    n12 = dataInputStream.readByte() & 0xFF;
                    int n13 = dataInputStream.readByte() & 0xFF;
                    n13 += (dataInputStream.readByte() & 0xFF) << 8;
                    n11 = dataInputStream.readByte() & 0xFF;
                    n11 += (dataInputStream.readByte() & 0xFF) << 8;
                    n10 = dataInputStream.readByte() & 0xFF;
                    n10 += (dataInputStream.readByte() & 0xFF) << 8;
                    n9 = dataInputStream.readByte() & 0xFF;
                    n9 += (dataInputStream.readByte() & 0xFF) << 8;
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.readByte();
                    dataInputStream.skipBytes(n12 - 12);
                    while ((n12 = dataInputStream.readByte() & 0xFF) != 0) {
                        dataInputStream.skipBytes(n12);
                    }
                    continue;
                }
                if (n8 == 249) {
                    n12 = 0;
                    while ((n12 = dataInputStream.readByte() & 0xFF) != 0) {
                        if (n12 == 4) {
                            int n14 = dataInputStream.readByte() & 0xFF;
                            n11 = dataInputStream.readByte() & 0xFF;
                            n10 = dataInputStream.readByte() & 0xFF;
                            n9 = dataInputStream.readByte() & 0xFF;
                            if (n14 != 1 || n11 != 0 || n10 != 0) continue;
                            this.transparentIndex = n9;
                            continue;
                        }
                        dataInputStream.skipBytes(n12);
                    }
                    continue;
                }
                if (n8 == 255) {
                    n12 = 0;
                    while ((n12 = dataInputStream.readByte() & 0xFF) != 0) {
                        dataInputStream.skipBytes(n12);
                    }
                    continue;
                }
                n12 = 0;
                while ((n12 = dataInputStream.readByte() & 0xFF) != 0) {
                    dataInputStream.skipBytes(n12);
                }
                continue;
            }
            if (n == 44) {
                if (bl) {
                    dataInputStream.skipBytes(8);
                    n8 = dataInputStream.readByte() & 0xFF;
                    if ((n8 & 0x80) != 0) {
                        n7 = 0;
                        while (n7 < 1 << (n8 & 7) + 1) {
                            dataInputStream.skipBytes(3);
                            ++n7;
                        }
                    }
                    dataInputStream.skipBytes(1);
                    n7 = 0;
                    while ((n7 = dataInputStream.readByte() & 0xFF) != 0) {
                        dataInputStream.skipBytes(n7);
                    }
                    continue;
                }
                this.readImage(dataInputStream, n3, n5, bl3, bl2);
                bl = true;
                continue;
            }
            String string2 = "Unknown block type (0x" + Integer.toString(n, 16) + ")";
            this.gifWarning(inputStream, string2);
            break;
        }
        if (!bl) {
            this.gifWarning(inputStream, "no image data found in GIF file");
        }
    }

    private void readImage(DataInputStream dataInputStream, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3;
        Object[] objectArray;
        int n4;
        int n5;
        int n6;
        boolean bl3;
        int n7 = 0;
        int n8 = 0;
        byte by = dataInputStream.readByte();
        dataInputStream.readByte();
        by = dataInputStream.readByte();
        dataInputStream.readByte();
        by = dataInputStream.readByte();
        this.width = (by & 0xFF) + 256 * (dataInputStream.readByte() & 0xFF);
        by = dataInputStream.readByte();
        this.height = (by & 0xFF) + 256 * (dataInputStream.readByte() & 0xFF);
        byte by2 = dataInputStream.readByte();
        boolean bl4 = bl3 = (by2 & 0x40) != 0;
        if ((by2 & 0x80) != 0) {
            n6 = 0;
            while (n6 < 1 << (by2 & 7) + 1) {
                this.r[n6] = dataInputStream.readByte();
                this.g[n6] = dataInputStream.readByte();
                this.b[n6] = dataInputStream.readByte();
                ++n6;
            }
        }
        boolean bl5 = !bl && (by2 & 0x80) == 0;
        n6 = dataInputStream.readByte() & 0xFF;
        int n9 = 1 << n6;
        int n10 = n9 + 1;
        int n11 = n5 = n9 + 2;
        int n12 = ++n6;
        int n13 = 1 << n6;
        int n14 = n13 - 1;
        byte[] byArray = null;
        int n15 = 0;
        while ((n15 = dataInputStream.readByte() & 0xFF) != 0) {
            n4 = 0;
            if (byArray == null) {
                byArray = new byte[n15];
            } else {
                objectArray = byArray;
                byArray = new byte[objectArray.length + n15];
                System.arraycopy(objectArray, 0, byArray, 0, objectArray.length);
                n4 = objectArray.length;
            }
            while (n15-- > 0) {
                byArray[n4++] = dataInputStream.readByte();
            }
        }
        n8 = this.width * this.height;
        this.bytePixels = new byte[n8];
        n4 = 0;
        objectArray = new int[4096];
        int[] nArray = new int[4096];
        int[] nArray2 = new int[4097];
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = this.readCode(byArray, n6, n14);
        while (n19 != n10) {
            int n20;
            if (n19 == n9) {
                n6 = n12;
                n13 = 1 << n6;
                n14 = n13 - 1;
                n11 = n5;
                n20 = n17 = (n19 = this.readCode(byArray, n6, n14));
                n18 = n20 & n2;
                if (!bl3) {
                    this.bytePixels[n4++] = (byte)n18;
                } else {
                    this.doInterlace(n18);
                }
                ++n7;
            } else {
                if (n11 >= 4096) break;
                int n21 = n19;
                n20 = n21;
                if (n20 >= n11) {
                    n20 = n17;
                    if (n16 > 4096) break;
                    nArray2[n16++] = n18;
                }
                while (n20 > n2) {
                    if (n16 > 4096) break;
                    nArray2[n16++] = nArray[n20];
                    n20 = objectArray[n20];
                }
                if (n16 > 4096) break;
                n18 = n20 & n2;
                nArray2[n16++] = n18;
                if (n7 + n16 > n8) {
                    n16 = n8 - n7;
                }
                n7 += n16;
                if (!bl3) {
                    n3 = n16 - 1;
                    while (n3 >= 0) {
                        this.bytePixels[n4++] = (byte)nArray2[n3];
                        --n3;
                    }
                } else {
                    n3 = n16 - 1;
                    while (n3 >= 0) {
                        this.doInterlace(nArray2[n3]);
                        --n3;
                    }
                }
                n16 = 0;
                objectArray[n11] = n17;
                nArray[n11] = n18;
                n17 = n21;
                if (++n11 >= n13 && n6 < 12) {
                    n13 *= 2;
                    n14 = (1 << ++n6) - 1;
                }
            }
            n19 = this.readCode(byArray, n6, n14);
            if (n7 >= n8) break;
        }
        if (n7 != n8 && !bl3) {
            n3 = 0;
            while (n3 < n8 - n7) {
                this.bytePixels[n7 + n3] = 0;
                ++n3;
            }
        }
        if (this.classColorModelAccessible) {
            this.colorModel = new IndexColorModel(8, 256, this.r, this.g, this.b, this.transparentIndex);
        } else {
            this.intPixels = new int[this.bytePixels.length];
            n3 = 0;
            while (n3 < this.bytePixels.length) {
                this.intPixels[n3] = this.transparentIndex > 0 && (this.bytePixels[n3] & 0xFF) == this.transparentIndex ? 0 : 0xFF000000 | (this.r[this.bytePixels[n3]] & 0xFF) << 16 | (this.g[this.bytePixels[n3]] & 0xFF) << 8 | this.b[this.bytePixels[n3]] & 0xFF;
                ++n3;
            }
        }
        this.fullInfo = "GIF" + (bl2 ? "89" : "87") + ", " + n + " bit" + (n == 1 ? "" : "s") + "per pixel, " + (bl3 ? "" : "non-") + "interlaced.";
        this.shortInfo = String.valueOf(this.width) + "x" + this.height + " GIF" + (bl2 ? "89" : "87");
    }

    private int readCode(byte[] byArray, int n, int n2) {
        int n3 = this.bitOffset / 8;
        int n4 = (byArray[n3] & 0xFF) + ((byArray[n3 + 1] & 0xFF) << 8);
        if (n >= 8 && n3 + 2 < byArray.length) {
            n4 += (byArray[n3 + 2] & 0xFF) << 16;
        }
        this.bitOffset += n;
        return (n4 >>= this.bitOffset % 8) & n2;
    }

    private void doInterlace(int n) {
        if (this.oldYC != this.YC) {
            this.ptr = this.YC * this.width;
            this.oldYC = this.YC;
        }
        if (this.YC < this.height) {
            this.bytePixels[this.ptr++] = (byte)n;
        }
        if (++this.XC == this.width) {
            this.XC = 0;
            switch (this.pass) {
                case 0: {
                    this.YC += 8;
                    if (this.YC < this.height) break;
                    ++this.pass;
                    this.YC = 4;
                    break;
                }
                case 1: {
                    this.YC += 8;
                    if (this.YC < this.height) break;
                    ++this.pass;
                    this.YC = 2;
                    break;
                }
                case 2: {
                    this.YC += 4;
                    if (this.YC < this.height) break;
                    ++this.pass;
                    this.YC = 1;
                    break;
                }
                case 3: {
                    this.YC += 2;
                    break;
                }
            }
        }
    }

    private void gifWarning(InputStream inputStream, String string) throws IOException {
        throw new IOException("Warning ! " + inputStream + " : " + string);
    }

    static {
        short[][] sArrayArray = new short[16][];
        sArrayArray[0] = new short[3];
        short[] sArray = new short[3];
        sArray[2] = 128;
        sArrayArray[1] = sArray;
        short[] sArray2 = new short[3];
        sArray2[1] = 128;
        sArrayArray[2] = sArray2;
        short[] sArray3 = new short[3];
        sArray3[1] = 128;
        sArray3[2] = 128;
        sArrayArray[3] = sArray3;
        short[] sArray4 = new short[3];
        sArray4[0] = 128;
        sArrayArray[4] = sArray4;
        short[] sArray5 = new short[3];
        sArray5[0] = 128;
        sArray5[2] = 128;
        sArrayArray[5] = sArray5;
        short[] sArray6 = new short[3];
        sArray6[0] = 128;
        sArray6[1] = 128;
        sArrayArray[6] = sArray6;
        sArrayArray[7] = new short[]{200, 200, 200};
        sArrayArray[8] = new short[]{100, 100, 100};
        sArrayArray[9] = new short[]{100, 100, 255};
        sArrayArray[10] = new short[]{100, 255, 100};
        sArrayArray[11] = new short[]{100, 255, 255};
        sArrayArray[12] = new short[]{255, 100, 100};
        sArrayArray[13] = new short[]{255, 100, 255};
        sArrayArray[14] = new short[]{255, 255, 100};
        sArrayArray[15] = new short[]{255, 255, 255};
        EGA_PALETTE = sArrayArray;
    }
}

