/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt;

import com.eteks.awt.PJAFontData;
import com.eteks.awt.PJAFontMetrics;
import com.eteks.awt.PJAGraphicsManager;
import com.eteks.tools.fontcapture.PJAFontCapture;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.peer.FontPeer;
import java.io.Serializable;

public class PJAFontPeer
implements FontPeer,
Serializable {
    private String name;
    private int style;
    private int minSize;
    private int maxSize;
    private PJAFontData[] originalFontData;
    private PJAFontData[] fontData;

    protected PJAFontPeer(String string, int n) {
        this.name = string;
        this.style = n;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    protected synchronized void addFontData(PJAFontData pJAFontData) {
        PJAFontData[] pJAFontDataArray;
        if (!pJAFontData.getName().equals(this.name) || pJAFontData.getStyle() != this.style) {
            throw new IllegalArgumentException("fontData and fontPeer name and style don't match");
        }
        if (this.originalFontData == null) {
            this.originalFontData = new PJAFontData[1];
            this.originalFontData[0] = pJAFontData;
            this.minSize = this.maxSize = pJAFontData.getSize();
        } else if (pJAFontData.getSize() < this.minSize) {
            pJAFontDataArray = new PJAFontData[this.maxSize - pJAFontData.getSize() + 1];
            System.arraycopy(this.originalFontData, 0, pJAFontDataArray, this.minSize - pJAFontData.getSize(), this.originalFontData.length);
            this.originalFontData = pJAFontDataArray;
            this.originalFontData[0] = pJAFontData;
            this.minSize = pJAFontData.getSize();
        } else if (pJAFontData.getSize() > this.maxSize) {
            pJAFontDataArray = new PJAFontData[pJAFontData.getSize() - this.minSize + 1];
            System.arraycopy(this.originalFontData, 0, pJAFontDataArray, 0, this.originalFontData.length);
            this.originalFontData = pJAFontDataArray;
            this.originalFontData[this.originalFontData.length - 1] = pJAFontData;
            this.maxSize = pJAFontData.getSize();
        } else {
            this.originalFontData[pJAFontData.getSize() - this.minSize] = pJAFontData;
        }
        this.fontData = new PJAFontData[this.originalFontData.length];
        System.arraycopy(this.originalFontData, 0, this.fontData, 0, this.originalFontData.length);
        int n = 0;
        while (n < this.fontData.length - 1) {
            int n2 = n + 1;
            while (n2 < this.fontData.length && this.fontData[n2] == null) {
                ++n2;
            }
            if (n < n2 - 1) {
                int n3 = n + 1;
                while (n3 < (n + n2 + 1) / 2) {
                    this.fontData[n3++] = this.fontData[n];
                }
                while (n3 < n2) {
                    this.fontData[n3++] = this.fontData[n2];
                }
            }
            n = n2;
        }
    }

    protected synchronized PJAFontData getFontData(int n) {
        if (this.fontData == null) {
            throw new NullPointerException("fontPeer doesn't have any data");
        }
        if (n < this.minSize) {
            n = this.minSize;
        } else if (n > this.maxSize) {
            n = this.maxSize;
        }
        return this.fontData[n - this.minSize];
    }

    protected FontMetrics getFontMetrics(Font font) {
        return new PJAFontMetrics(font, this.getFontData(font.getSize()));
    }

    protected FontMetrics getFontMetrics(int n) {
        boolean bl = PJAGraphicsManager.getDefaultGraphicsManager().isFontInstantiable();
        return new PJAFontMetrics(bl ? new Font(this.name, this.style, n) : null, this.getFontData(n));
    }

    public boolean equals(Object object) {
        return object instanceof PJAFontPeer && this.name.equals(((PJAFontPeer)object).name) && this.style == ((PJAFontPeer)object).style;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.style << 16);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[fontName=" + this.getName() + ", style=" + PJAFontData.styleToString(this.getStyle()) + "]";
    }

    public static void main(String[] stringArray) {
        PJAFontCapture.main(stringArray);
    }
}

