/*
 * Decompiled with CFR 0.152.
 */
import com.eteks.awt.PJAGraphicsManager;
import com.eteks.awt.PJAImage;
import com.eteks.tools.awt.GridBagConstraints2;
import com.eteks.tools.fontcapture.PJAFontCapture;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;

public class PJANativeToolkitComparison
extends ToolkitDemo {
    public static void main(String[] stringArray) {
        PJANativeToolkitComparison.showFirstDialog();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ToolkitDemo.GraphicsDrawer[] graphicsDrawerArray = new ToolkitDemo.GraphicsDrawer[]{new ToolkitDemo.GraphicsArcDrawer(), new ToolkitDemo.GraphicsPolygonDrawer(), new ToolkitDemo.GraphicsTextDrawer(), new ToolkitDemo.GraphicsImageDrawer()};
        int n = 0;
        while (n < graphicsDrawerArray.length) {
            Dimension dimension2 = new Dimension(graphicsDrawerArray[n].getWidth(), graphicsDrawerArray[n].getHeight());
            ToolkitDemo.GraphicsDrawer graphicsDrawer = graphicsDrawerArray[n];
            PJAImage pJAImage = new PJAImage(graphicsDrawer.getWidth(), graphicsDrawer.getHeight());
            try {
                graphicsDrawer.paint(((Image)pJAImage).getGraphics());
            }
            catch (Error error) {
                System.out.println(String.valueOf(String.valueOf(error)) + "\nIn case of an error related to font, run PJAFontCapture to generate at least one .pjaf font file.");
            }
            Image image = Toolkit.getDefaultToolkit().createImage(((Image)pJAImage).getSource());
            1 var8_9 = new 1(dimension2, image);
            Frame frame = new Frame("PJA Toolkit " + graphicsDrawer);
            frame.add("Center", var8_9);
            frame.pack();
            frame.move(0, dimension.height * n / graphicsDrawerArray.length);
            frame.show();
            2 var10_11 = new 2(graphicsDrawer, dimension2);
            Frame frame2 = new Frame("Native Toolkit " + graphicsDrawer);
            frame2.add("Center", var10_11);
            frame2.pack();
            frame2.move(dimension.width / 2, dimension.height * n / graphicsDrawerArray.length);
            frame2.show();
            ++n;
        }
        PJANativeToolkitComparison.showSpeedMeterDialog(graphicsDrawerArray);
    }

    private static void showFirstDialog() {
        3 var0 = new 3(new Frame(), "PJA Toolkit", true);
        boolean bl = PJAGraphicsManager.getDefaultGraphicsManager().getDefaultFont() == null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        var0.setLayout(gridBagLayout);
        Component component = new Label("Pure Java AWT Toolkit comparison demo.");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        component = new Label("\u00a9 Copyright 2000 eTeks <info@eteks.com>.");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 20, 5), 0, 0));
        if (bl) {
            component = new Label("No default font : run first PJA Font capture utility.");
            var0.add(component);
            gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 0, 10), 0, 0));
            component = new Label("(command line : java com.eteks.tools.fontcapture.PJAFontCapture)");
            var0.add(component);
            gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        }
        component = new Button(bl ? "Run Font capture" : " Ok ");
        var0.add(component);
        gridBagLayout.setConstraints(component, new GridBagConstraints2(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 10, 0), 0, 0));
        var0.setResizable(false);
        var0.pack();
        ((Window)var0).show();
        if (bl) {
            PJAFontCapture.showCaptureFontDialog("Continue demo");
            PJAGraphicsManager.getDefaultGraphicsManager().loadFonts();
        }
    }

    private static void showSpeedMeterDialog(ToolkitDemo.GraphicsDrawer[] graphicsDrawerArray) {
        4 var1_1 = new 4(new Frame(), "Average drawing duration", false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        var1_1.setLayout(gridBagLayout);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(graphicsDrawerArray.length + 1, 1, 0, 10));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(graphicsDrawerArray.length + 1, 3, 10, 10));
        panel.add(new Label(""));
        panel2.add(new Label("PJA (ms)", 1));
        panel2.add(new Label("Native (ms)", 1));
        panel2.add(new Label("Ratio (PJA/Native)", 1));
        Label[] labelArray = new Label[graphicsDrawerArray.length];
        Label[] labelArray2 = new Label[graphicsDrawerArray.length];
        Label[] labelArray3 = new Label[graphicsDrawerArray.length];
        int n = 0;
        while (n < graphicsDrawerArray.length) {
            panel.add(new Label(graphicsDrawerArray[n].toString()));
            labelArray[n] = new Label("00000 ", 2);
            labelArray[n].setForeground(Color.green);
            labelArray[n].setBackground(Color.black);
            panel2.add(labelArray[n]);
            labelArray2[n] = new Label("00000 ", 2);
            labelArray2[n].setForeground(Color.red);
            labelArray2[n].setBackground(Color.black);
            panel2.add(labelArray2[n]);
            labelArray3[n] = new Label("      1 ", 2);
            labelArray3[n].setForeground(Color.lightGray);
            labelArray3[n].setBackground(Color.black);
            panel2.add(labelArray3[n]);
            ++n;
        }
        var1_1.add(panel);
        gridBagLayout.setConstraints(panel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        var1_1.add(panel2);
        gridBagLayout.setConstraints(panel2, new GridBagConstraints2(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 0, 10, 10), 0, 0));
        Button button = new Button(" Quit ");
        var1_1.add(button);
        gridBagLayout.setConstraints(button, new GridBagConstraints2(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        var1_1.setResizable(false);
        var1_1.pack();
        ((Window)var1_1).show();
        long[] lArray = new long[graphicsDrawerArray.length];
        long[] lArray2 = new long[graphicsDrawerArray.length];
        Frame frame = new Frame();
        frame.addNotify();
        int n2 = 1;
        while (true) {
            long l = System.currentTimeMillis();
            int n3 = 0;
            while (n3 < graphicsDrawerArray.length) {
                try {
                    PJAImage pJAImage = new PJAImage(graphicsDrawerArray[n3].getWidth(), graphicsDrawerArray[n3].getHeight());
                    int n4 = n3;
                    lArray[n4] = lArray[n4] + PJANativeToolkitComparison.getDrawingDuration(((Image)pJAImage).getGraphics(), graphicsDrawerArray[n3]);
                    ((Image)pJAImage).flush();
                    labelArray[n3].setText(String.valueOf(String.valueOf(lArray[n3] / (long)n2)) + " ");
                    if (!Boolean.getBoolean("com.eteks.awt.useframe")) {
                        Image image = frame.createImage(graphicsDrawerArray[n3].getWidth(), graphicsDrawerArray[n3].getHeight());
                        int n5 = n3;
                        lArray2[n5] = lArray2[n5] + PJANativeToolkitComparison.getDrawingDuration(image.getGraphics(), graphicsDrawerArray[n3]);
                        image.flush();
                    } else {
                        int n6 = n3;
                        1.SynchronizedCanvas synchronizedCanvas = new 1.SynchronizedCanvas(graphicsDrawerArray, n6, lArray2);
                        Frame frame2 = new Frame();
                        frame2.add("Center", synchronizedCanvas);
                        frame2.pack();
                        frame2.move(0, var1_1.location().y + var1_1.size().height + 20);
                        Object object = synchronizedCanvas.paintLock;
                        synchronized (object) {
                            try {
                                frame2.show();
                                if (synchronizedCanvas.paintLock != null) {
                                    synchronizedCanvas.paintLock.wait();
                                }
                                Thread.sleep(200L);
                                frame2.dispose();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    labelArray2[n3].setText(String.valueOf(String.valueOf(lArray2[n3] / (long)n2)) + " ");
                    labelArray3[n3].setText(lArray2[n3] != 0L ? String.valueOf(String.valueOf(lArray[n3] / lArray2[n3])) + " " : "");
                }
                catch (Error error) {
                    System.out.println(String.valueOf(String.valueOf(error)) + "\nIn case of an error related to font, run PJAFontCapture to generate at least one .pjaf font file.");
                }
                ++n3;
            }
            try {
                long l2 = System.currentTimeMillis() - l;
                Thread.sleep(l2 < 500L ? 1000L - l2 : 1000L);
            }
            catch (InterruptedException interruptedException) {
                System.exit(0);
            }
            ++n2;
        }
    }

    private static long getDrawingDuration(Graphics graphics, ToolkitDemo.GraphicsDrawer graphicsDrawer) {
        System.gc();
        long l = System.currentTimeMillis();
        graphicsDrawer.paint(graphics);
        Toolkit.getDefaultToolkit().sync();
        return System.currentTimeMillis() - l;
    }

    static /* synthetic */ long access$0(Graphics graphics, ToolkitDemo.GraphicsDrawer graphicsDrawer) {
        return PJANativeToolkitComparison.getDrawingDuration(graphics, graphicsDrawer);
    }

    private static final class 1
    extends Canvas {
        private final /* synthetic */ Image val$nativeImage;
        private final /* synthetic */ Dimension val$drawerSize;

        public Dimension preferredSize() {
            return this.val$drawerSize;
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.val$nativeImage, 0, 0, this);
        }

        /* synthetic */ 1(Dimension dimension, Image image) {
            this.val$drawerSize = dimension;
            this.val$nativeImage = image;
        }
    }

    private static final class 2
    extends Canvas {
        private final /* synthetic */ ToolkitDemo.GraphicsDrawer val$drawer;
        private final /* synthetic */ Dimension val$drawerSize;

        public Dimension preferredSize() {
            return this.val$drawerSize;
        }

        public void paint(Graphics graphics) {
            this.val$drawer.paint(graphics);
        }

        /* synthetic */ 2(ToolkitDemo.GraphicsDrawer graphicsDrawer, Dimension dimension) {
            this.val$drawer = graphicsDrawer;
            this.val$drawerSize = dimension;
        }
    }

    private final class 3
    extends Dialog {
        public boolean action(Event event, Object object) {
            this.dispose();
            return true;
        }

        /* synthetic */ 3(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }

    private final class 4
    extends Dialog {
        public boolean action(Event event, Object object) {
            System.exit(0);
            return true;
        }

        /* synthetic */ 4(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
        }
    }
}

