/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.ext.PlotterChart;
import com.objectplanet.chart.ext.PlotterGrid;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlotterChartRenderer
extends ChartRenderer {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private boolean aU;
    private boolean a0;
    private boolean aY;
    private int aS;
    private int a3;
    private Rectangle[] aR;
    private Rectangle a2;
    private boolean a1;
    private int aZ;
    private int aX;
    private Rectangle aQ;
    Rectangle aV;
    private int aP;
    long aW;
    private final double[] aT = new double[]{1.0, 2.0, 2.5, 5.0};
    protected PlotterChart chart;

    public PlotterChartRenderer(PlotterChart plotterChart) {
        super(plotterChart);
        this.chart = plotterChart;
        this.legend = plotterChart.for();
        this.gridRenderer = plotterChart.if();
        this.legendRenderer = plotterChart.do();
        this.aR = new Rectangle[4];
        this.aR[1] = new Rectangle();
        this.aR[3] = new Rectangle();
        this.a3 = -1;
        this.aZ = -1;
        this.aX = -1;
    }

    public void reset() {
        this.aR = new Rectangle[4];
        this.aR[1] = new Rectangle();
        this.aR[3] = new Rectangle();
        this.a3 = -1;
        this.aZ = -1;
        this.aX = -1;
    }

    protected void calculateGraphBounds(Rectangle rectangle) {
        Object object;
        this.legendRenderer.calculateGraphBounds(this.legend, rectangle);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
        n3 += this.a(2, true);
        n4 += this.a(3, true);
        n += this.a(0, true);
        n2 += this.a(1, true);
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) && !this.chart.isRangeOn(1)) {
            n2 += 5;
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) && !this.chart.isRangeOn(0)) {
            n += 5;
        }
        if (this.chart.isRangeOn(1) || this.chart.isRangeOn(0) && !this.chart.isRangeOn(2)) {
            n3 += 5;
        }
        if (this.chart.isRangeOn(1) || this.chart.isRangeOn(0) && !this.chart.isRangeOn(3)) {
            n4 += 5;
        }
        n4 += this.a();
        String string = this.getLabel("rangeAxisLabel_right");
        fontMetrics = this.getFontMetrics(this.getFont("rangeAxisLabelFont"));
        int n5 = this.getLabelAngle("rangeAxisLabelAngle_right");
        Dimension dimension = this.getAngledLabelSize(this.getLabelSize(string, fontMetrics), n5);
        if (string != null) {
            n2 += dimension.width + 15;
        }
        if ((string = this.getLabel("rangeAxisLabel_left")) != null) {
            n5 = this.getLabelAngle("rangeAxisLabelAngle_left");
            dimension = this.getAngledLabelSize(this.getLabelSize(string, fontMetrics), n5);
            n += dimension.width + 15;
        }
        if ((string = this.getLabel("rangeAxisLabel_top")) != null) {
            n5 = this.getLabelAngle("rangeAxisLabelAngle_top");
            dimension = this.getAngledLabelSize(this.getLabelSize(string, fontMetrics), n5);
            n3 += dimension.height + 5;
        }
        if ((string = this.getLabel("rangeAxisLabel_bottom")) != null) {
            n5 = this.getLabelAngle("rangeAxisLabelAngle_bottom");
            dimension = this.getAngledLabelSize(this.getLabelSize(string, fontMetrics), n5);
            n4 += dimension.height + 5;
        }
        if (this.chart.isTitleOn()) {
            Dimension dimension2 = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            n3 += dimension2.height - 5;
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3)) {
            fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
            object = this.getLabel("rangeLabelPrefix");
            String string2 = this.getLabel("rangeLabelPostfix");
            int n6 = this.chart.getXRangeDecimalCount();
            String string3 = this.chart.formatRangeNumber(0, this.chart.getXUpperRange());
            String string4 = this.chart.formatRangeNumber(0, this.chart.getXLowerRange());
            if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                string3 = this.chart.formatRangeNumber(0, this.chart.getXLowerRange());
                string4 = this.chart.formatRangeNumber(0, this.chart.getXUpperRange());
            }
            string3 = object != null ? (String)object + string3 : string3;
            string4 = object != null ? (String)object + string4 : string4;
            string3 = string2 != null ? string3 + string2 : string3;
            string4 = string2 != null ? string4 + string2 : string4;
            int n7 = fontMetrics.stringWidth(string3);
            int n8 = fontMetrics.stringWidth(string4);
            n = Math.max(n8 / 2 + 2, n);
            n2 = Math.max(n7 / 2 + 2, n2);
        }
        object = this.chart.getGraphInsets();
        rectangle.x = rectangle.x + (((Insets)object).left == -1 ? n : ((Insets)object).left - 5);
        rectangle.width = rectangle.width - (((Insets)object).left == -1 ? n : ((Insets)object).left);
        rectangle.width = rectangle.width - (((Insets)object).right == -1 ? n2 : ((Insets)object).right - 9);
        rectangle.y = rectangle.y + (((Insets)object).top == -1 ? n3 : ((Insets)object).top - 5);
        rectangle.height = rectangle.height - (((Insets)object).top == -1 ? n3 : ((Insets)object).top);
        rectangle.height = rectangle.height - (((Insets)object).bottom == -1 ? n4 : ((Insets)object).bottom - 9);
        this.aQ = rectangle;
    }

    protected void checkDataIntegrity() {
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        this.aQ = rectangle;
        this.aV = rectangle2;
    }

    protected ChartSample checkSelection(Point point) {
        int n = this.chart.checkSelection(point);
        int n2 = this.chart.a8;
        if (n == -1 && n2 == -1) {
            return null;
        }
        ChartSample chartSample = new ChartSample(n2);
        chartSample.setSeries(n);
        return chartSample;
    }

    Rectangle if() {
        return this.aQ;
    }

    protected Rectangle getDataBounds(Grid grid) {
        if (this.aQ == null) {
            throw new IllegalArgumentException("graphBounds is NULL");
        }
        Rectangle rectangle = new Rectangle(this.aQ);
        double d = (this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
        double d2 = (this.chart.getXCurrentLowerRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
        double d3 = (this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange()) / (this.chart.getYUpperRange() - this.chart.getYLowerRange());
        double d4 = (this.chart.getYCurrentLowerRange() - this.chart.getYLowerRange()) / (this.chart.getYUpperRange() - this.chart.getYLowerRange());
        double d5 = Math.round((double)this.aQ.width / (1.0 - d - d2));
        double d6 = Math.round((double)this.aQ.height / (1.0 - d3 - d4));
        rectangle.width = (int)d5;
        rectangle.x = (int)((long)this.aQ.x - Math.round(d2 * d5));
        rectangle.height = (int)d6;
        rectangle.y = (int)((long)this.aQ.y - Math.round(d3 * d6));
        return rectangle;
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.paintSeries(graphics, rectangle);
    }

    public void render(Graphics graphics) {
        this.render(graphics, true);
    }

    protected void renderOffScreen(Graphics graphics) {
    }

    public void paintSeries(Graphics graphics, Rectangle rectangle) {
        Point point;
        int n;
        double[][] dArray;
        Color color;
        int n2;
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (n2 = 0; n2 < this.getSeriesCount(); ++n2) {
            if (!this.chart.isSeriesOn(n2)) continue;
            color = this.chart.getSeriesColor(n2);
            if (this.chart.isConnectedLinesOn(n2)) {
                this.paintLine(graphics, n2, color, rectangle);
            }
            dArray = this.chart.getPlots(n2);
            for (n = 0; dArray != null && n < dArray.length; ++n) {
                point = this.a(dArray[n][0], dArray[n][1], rectangle);
                if (point.y < rectangle.y || point.y > rectangle.y + rectangle.height || point.x < rectangle.x || point.x > rectangle.x + rectangle.width + 1) continue;
                this.paintPlotPoint(graphics, n2, n, point.x, point.y, color);
            }
            this.a(graphics, n2, rectangle, rectangle);
        }
        n2 = this.chart.getSelectedSeries();
        if (n2 >= 0 && n2 < this.getSeriesCount() && this.chart.isSeriesOn(n2)) {
            color = this.chart.getSeriesColor(n2);
            if (this.chart.isConnectedLinesOn(n2)) {
                this.paintLine(graphics, n2, color, rectangle);
            }
            dArray = this.chart.getPlots(n2);
            for (n = 0; dArray != null && n < dArray.length; ++n) {
                point = this.a(dArray[n][0], dArray[n][1], rectangle);
                if (point.y < rectangle.y || point.y > rectangle.y + rectangle.height || point.x < rectangle.x || point.x > rectangle.x + rectangle.width + 1) continue;
                this.paintPlotPoint(graphics, n2, n, point.x, point.y, color);
            }
            this.a(graphics, n2, rectangle, rectangle);
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void char(Graphics graphics, Rectangle rectangle) {
        Font font = this.getFont("plotLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        int n = this.getLabelAngle("plotLabelAngle");
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            String[] stringArray = this.chart.getPlotLabels(i);
            if (stringArray == null) {
                return;
            }
            int n2 = Integer.MIN_VALUE;
            for (int j = 0; j < Math.min(stringArray.length, this.chart.getPlots(i).length); ++j) {
                String string = stringArray[j];
                Dimension dimension = this.getLabelSize(string, fontMetrics);
                Dimension dimension2 = this.getAngledLabelSize(dimension, n);
                if (!this.chart.isPlotLabelsOn() || this.chart.getPlotLabelStyle() != 3 && this.chart.getPlotLabelStyle() != 5) continue;
                int n3 = this.chart.isRangeAdjusterOn(3) ? 8 : 0;
                int n4 = rectangle.y + rectangle.height + n3;
                int n5 = rectangle.x;
                int n6 = rectangle.x + rectangle.width;
                int n7 = this.a((double)this.chart.getPlots((int)i)[j][0], (double)this.chart.getPlots((int)i)[j][1], (Rectangle)rectangle).x;
                if (string == null || string.length() <= 0 || n7 < n5 || n7 > n6 + 1) continue;
                int n8 = n4 + this.a(3, false) + 4 - n3;
                if (n % 180 == 0) {
                    n8 += fontMetrics.getMaxAscent();
                }
                int n9 = n % 180 == 0 ? n7 - dimension2.width / 2 : (n % 360 > 90 && n % 360 < 180 || n % 360 > 270 ? n7 - dimension2.width + fontMetrics.getAscent() / 2 : n7 - fontMetrics.getAscent() / 2);
                graphics.setColor(this.chart.getForeground());
                if (n9 <= n2 && j != 0 && this.chart.isAutoLabelSpacingOn()) continue;
                if (string.trim().length() > 0) {
                    graphics.drawLine(Math.round(n7), n4, Math.round(n7), n4 + 3);
                    this.paintLabel(graphics, string, n9, n8, dimension, 0, n, false);
                }
                n2 = n9 + dimension2.width;
            }
        }
    }

    private void byte(Graphics graphics, Rectangle rectangle) {
        Serializable serializable;
        int n = this.chart.getXRangeLabelStyle();
        if (n == 4) {
            return;
        }
        if (n == 6) {
            serializable = new Rectangle(rectangle.x, 0, rectangle.width, Integer.MAX_VALUE);
            graphics.setClip((Shape)((Object)serializable));
        }
        serializable = this.getFont("xrangelabelfont");
        FontMetrics fontMetrics = this.getFontMetrics((Font)serializable);
        int n2 = this.getLabelAngle("xrangelabelangle");
        int n3 = Integer.MIN_VALUE;
        double[] dArray = this.chart.getXRangeLabelsPos();
        for (int i = 0; i < dArray.length; ++i) {
            int n4;
            int n5;
            String string = this.chart.getXRangeLabel(dArray[i]);
            Dimension dimension = this.getLabelSize(string, fontMetrics);
            Dimension dimension2 = this.getAngledLabelSize(dimension, n2);
            boolean bl = this.chart.getXRangeLabelLineOn(dArray[i]);
            int n6 = this.chart.isRangeAdjusterOn(3) ? 8 : 0;
            int n7 = rectangle.y + rectangle.height + n6;
            int n8 = rectangle.x;
            int n9 = rectangle.x + rectangle.width;
            int n10 = this.a((double)dArray[i], (double)0.0, (Rectangle)rectangle).x;
            if (string == null || string.length() <= 0 || n10 < n8 || n10 > n9 + 1) continue;
            if (this.chart.getXRangeLabelStyle() == 6) {
                n5 = rectangle.y;
                n4 = n2 % 180 == 0 ? n10 + 3 : (n2 % 360 > 90 && n2 % 360 < 180 || n2 % 360 > 270 ? n10 + fontMetrics.getAscent() / 2 : n10 + 1);
            } else {
                n5 = n7 + this.a(3, false) + 4 - n6;
                if (n2 % 180 == 0) {
                    n5 += fontMetrics.getMaxAscent();
                }
                n4 = n2 % 180 == 0 ? n10 - dimension2.width / 2 : (n2 % 360 > 90 && n2 % 360 < 180 || n2 % 360 > 270 ? n10 - dimension2.width + fontMetrics.getAscent() / 2 : n10 - fontMetrics.getAscent() / 2);
            }
            graphics.setFont((Font)serializable);
            Color color = this.chart.getXRangeLabelColor(dArray[i]);
            if (color == null) {
                color = this.chart.getXRangeLabelsColor();
            }
            graphics.setColor(color);
            if (n4 <= n3 && i != 0 && this.chart.isAutoLabelSpacingOn() || string == null || string.trim().length() <= 0) continue;
            this.paintLabel(graphics, string, n4, n5, dimension, 0, n2, false);
            if (n == 3 || n == 5) {
                graphics.drawLine(Math.round(n10), n7, Math.round(n10), n7 + 3);
            }
            if (bl) {
                graphics.setColor(color);
                for (int j = rectangle.y; j < rectangle.y + rectangle.height; j += 6) {
                    graphics.drawLine(n10, j, n10, j + Math.min(3, rectangle.y + rectangle.height - j));
                }
            }
            n3 = n4 + dimension2.width;
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintLine(Graphics graphics, int n, Color color, Rectangle rectangle) {
        double[][] dArray = this.chart.getPlots(n);
        for (int i = 0; dArray != null && i < dArray.length - 1; ++i) {
            int n2;
            double d;
            Point point = this.a(dArray[i][0], dArray[i][1], rectangle);
            Point point2 = this.a(dArray[i + 1][0], dArray[i + 1][1], rectangle);
            boolean bl = rectangle.contains(point);
            bl |= rectangle.contains(point2);
            bl |= point.x <= rectangle.x && point2.x >= rectangle.x + rectangle.width;
            bl |= point.y <= rectangle.y && point2.y >= rectangle.y + rectangle.height;
            if (bl |= point.y >= rectangle.y + rectangle.height && point2.y <= rectangle.y) {
                graphics.setColor(color);
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                if (this.chart.getLineWidth(n) > 1) {
                    d = 0.0;
                    if (point2.x - point.x != 0) {
                        d = Math.abs((double)(point2.y - point.y) / (double)(point2.x - point.x));
                    }
                    n2 = 1;
                    for (int j = 2; j <= this.chart.getLineWidth(n); ++j) {
                        int n3 = j / 2 * n2;
                        if (d <= 1.0) {
                            graphics.drawLine(point.x, point.y + n3, point2.x, point2.y + n3);
                        } else {
                            graphics.drawLine(point.x - n3, point.y, point2.x - n3, point2.y);
                        }
                        n2 = -n2;
                    }
                }
            }
            if (n != this.chart.getSelectedSeries() || this.chart.getSelectedSample() != -1) continue;
            d = 0.0;
            if (point2.x - point.x != 0) {
                d = Math.abs((double)(point2.y - point.y) / (double)(point2.x - point.x));
            }
            n2 = this.chart.getLineWidth(n) / 2 + 1;
            graphics.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
            if (d <= 1.0) {
                graphics.drawLine(point.x, point.y + n2, point2.x, point2.y + n2);
                continue;
            }
            graphics.drawLine(point.x - n2, point.y, point2.x - n2, point2.y);
        }
    }

    protected void paintPlotPoint(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        boolean bl = n == this.chart.getSelectedSeries() && (this.chart.getSelectedSample() == n2 || this.chart.getSelectedSample() == -1);
        String string = this.chart.getPlotImage(n);
        if (string == null) {
            string = this.chart.getPlotImage(n);
        }
        if (string == null) {
            string = this.chart.getPlotImage(-1);
        }
        if (string == null) {
            string = this.chart.getLegendImage(n);
        }
        Dimension dimension = this.getImageSize(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = this.chart.getImage(string);
            if (image != null) {
                graphics.drawImage(image, n3 - dimension.width / 2, n4 - dimension.height / 2, this.chart);
            }
        } else {
            int n5 = this.chart.getPlotSize(n, n2);
            if (n5 == 0) {
                n5 = 3;
            } else if (n5 < 0) {
                return;
            }
            int n6 = this.chart.getPlotStyle(n);
            Color color2 = this.chart.getChartBackground();
            graphics.setColor(color);
            switch (n6) {
                case 0: 
                case 1: 
                case 2: {
                    if (n6 == 0) {
                        graphics.drawOval(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    } else if (n6 == 2) {
                        if (n5 == 2) {
                            n5 = 3;
                        }
                        graphics.fillOval(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    } else if (n6 == 1) {
                        graphics.setColor(color2);
                        graphics.fillOval(n3 - n5 / 2, n4 - n5 / 2, n5 + 1, n5 + 1);
                        graphics.setColor(color);
                        graphics.drawOval(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    }
                    if (!bl) break;
                    graphics.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    if (n6 == 2) {
                        graphics.drawOval(n3 - n5 / 2, n4 - n5 / 2, n5 - 1, n5 - 1);
                    } else {
                        graphics.drawOval(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    }
                    if (n5 != 0 && n5 != 1) break;
                    graphics.drawLine(n3, n4, n3, n4);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (n6 == 3) {
                        graphics.drawRect(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    } else if (n6 == 5) {
                        graphics.fillRect(n3 - n5 / 2, n4 - n5 / 2, n5 + 1, n5 + 1);
                    } else if (n6 == 4) {
                        graphics.setColor(color2);
                        graphics.fillRect(n3 - n5 / 2, n4 - n5 / 2, n5 + 1, n5 + 1);
                        graphics.setColor(color);
                        graphics.drawRect(n3 - n5 / 2, n4 - n5 / 2, n5, n5);
                    }
                    if (!bl) break;
                    graphics.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    graphics.drawRect(n3 - n5 / 2 - 1, n4 - n5 / 2 - 1, n5 + 2, n5 + 2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int[] nArray = new int[4];
                    nArray[0] = nArray[2] = n3;
                    nArray[1] = n3 + n5 / 2;
                    nArray[3] = n3 - n5 / 2;
                    int[] nArray2 = new int[4];
                    nArray2[0] = n4 - n5 / 2;
                    nArray2[2] = n4 + n5 / 2;
                    nArray2[1] = nArray2[3] = n4;
                    if (n6 == 7) {
                        graphics.setColor(color2);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    } else if (n6 == 8) {
                        graphics.setColor(color);
                        graphics.fillPolygon(nArray, nArray2, 4);
                    }
                    graphics.setColor(color);
                    graphics.drawPolygon(nArray, nArray2, 4);
                    if (!bl) break;
                    nArray[1] = nArray[1] + 1;
                    nArray[3] = nArray[3] - 1;
                    nArray2[0] = nArray2[0] - 1;
                    nArray2[2] = nArray2[2] + 1;
                    graphics.setColor(PlotterChartRenderer.getDarker(PlotterChartRenderer.getDarker(color)));
                    graphics.drawPolygon(nArray, nArray2, 4);
                }
            }
        }
        graphics.setClip(shape);
    }

    protected void paintGrid(Graphics graphics, Grid grid, Rectangle rectangle) {
        Object object;
        Object object2;
        Color color = this.chart.getChartBackground();
        Color color2 = this.chart.getChartBackground2();
        graphics.setColor(color);
        if (color2 != null) {
            object2 = new GradientPaint(0.0f, rectangle.y + rectangle.height, color2, 0.0f, rectangle.y, color);
            ((Graphics2D)graphics).setPaint((Paint)object2);
        } else {
            graphics.setColor(this.chart.getChartBackground());
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        object2 = this.a(0.0, 0.0, rectangle);
        Dimension dimension = this.getImageSize(this.chart.getGridImage());
        if (this.chart.getGridImage() != null && dimension.height > 0 && dimension.width > 0 && (object = this.chart.getImage(this.chart.getGridImage())) != null) {
            graphics.drawImage((Image)object, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.chart);
        }
        if (this.chart.isRangeOn(0) || this.chart.isRangeOn(1) || this.chart.isYValueLinesOn()) {
            this.if(graphics, rectangle, 1);
        }
        if (this.chart.isRangeOn(2) || this.chart.isRangeOn(3) || this.chart.isXValueLinesOn()) {
            this.if(graphics, rectangle, 0);
        }
        if (this.chart.getGridLines() != null) {
            this.try(graphics, rectangle);
        }
        object = this.getFont("rangeLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics((Font)object);
        graphics.setFont((Font)object);
        Object object3 = this.chart.ae.keys();
        while (object3.hasMoreElements()) {
            double d;
            String string = (String)object3.nextElement();
            String string2 = this.chart.for(string);
            Double d2 = (Double)this.chart.ay.get(string);
            Color color3 = (Color)this.chart.aj.get(string);
            if (d2 == null || !((d = d2.doubleValue()) >= this.chart.getYCurrentLowerRange() && d <= this.chart.getYCurrentUpperRange()) && (!(d <= this.chart.getYCurrentLowerRange()) || !(d >= this.chart.getYCurrentUpperRange()))) continue;
            this.a(graphics, string2, d, color3, rectangle, fontMetrics, true, 1);
        }
        graphics.setColor(this.chart.getChartForeground());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        object3 = this.chart.getXAxisColor();
        if (this.chart.getXAxisColor() == null) {
            object3 = this.chart.getChartForeground().darker().darker();
        }
        graphics.setColor((Color)object3);
        if (this.chart.isXAxisOn() && ((Point)object2).y >= rectangle.y && ((Point)object2).y <= rectangle.y + rectangle.height) {
            graphics.drawLine(rectangle.x, ((Point)object2).y, rectangle.x + rectangle.width, ((Point)object2).y);
            if (((Point)object2).x - rectangle.x > 20) {
                graphics.drawLine(rectangle.x, ((Point)object2).y, rectangle.x + 7, ((Point)object2).y + 3);
                graphics.drawLine(rectangle.x, ((Point)object2).y, rectangle.x + 7, ((Point)object2).y - 3);
            }
            if (rectangle.x + rectangle.width - ((Point)object2).x > 20) {
                graphics.drawLine(rectangle.x + rectangle.width, ((Point)object2).y, rectangle.x + rectangle.width - 7, ((Point)object2).y + 3);
                graphics.drawLine(rectangle.x + rectangle.width, ((Point)object2).y, rectangle.x + rectangle.width - 7, ((Point)object2).y - 3);
            }
        }
        object3 = this.chart.getYAxisColor();
        if (this.chart.getYAxisColor() == null) {
            object3 = this.chart.getChartForeground().darker().darker();
        }
        if (this.chart.isYAxisOn() && ((Point)object2).x >= rectangle.x && ((Point)object2).x <= rectangle.x + rectangle.width) {
            graphics.setColor((Color)object3);
            graphics.drawLine(((Point)object2).x, rectangle.y, ((Point)object2).x, rectangle.y + rectangle.height);
            if (((Point)object2).y - rectangle.y > 20) {
                graphics.drawLine(((Point)object2).x, rectangle.y, ((Point)object2).x + 3, rectangle.y + 7);
                graphics.drawLine(((Point)object2).x, rectangle.y, ((Point)object2).x - 3, rectangle.y + 7);
            }
            if (rectangle.y + rectangle.height - ((Point)object2).y > 20) {
                graphics.drawLine(((Point)object2).x, rectangle.y + rectangle.height, ((Point)object2).x + 3, rectangle.y + rectangle.height - 7);
                graphics.drawLine(((Point)object2).x, rectangle.y + rectangle.height, ((Point)object2).x - 3, rectangle.y + rectangle.height - 7);
            }
        }
        this.char(graphics, rectangle);
        this.byte(graphics, rectangle);
    }

    private void if(Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        String string;
        Font font = this.getFont("rangeLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        if (n == 1) {
            string = this.chart.formatRangeNumber(1, 0.0);
            if (this.chart.getYCurrentUpperRange() > 0.0 && this.chart.getYCurrentLowerRange() < 0.0 || this.chart.getYCurrentUpperRange() < 0.0 && this.chart.getYCurrentLowerRange() > 0.0) {
                this.a(graphics, string, 0.0, null, rectangle, fontMetrics, false, n);
            }
            string = this.chart.formatRangeNumber(1, this.chart.getYCurrentUpperRange());
            this.a(graphics, string, this.chart.getYCurrentUpperRange(), null, rectangle, fontMetrics, false, n);
            string = this.chart.formatRangeNumber(1, this.chart.getYCurrentLowerRange());
            this.a(graphics, string, this.chart.getYCurrentLowerRange(), null, rectangle, fontMetrics, false, n);
            d6 = this.a(this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange(), this.chart.getYRangeInterval(), rectangle.height, fontMetrics, false);
            if (this.chart.getYCurrentUpperRange() > this.chart.getYCurrentLowerRange()) {
                for (d5 = Math.max(0.0, this.chart.getYCurrentLowerRange() - this.chart.getYCurrentLowerRange() % d6); d5 < this.chart.getYCurrentUpperRange(); d5 += d6) {
                    if (!(d5 > 0.0) || !(d5 > this.chart.getYCurrentLowerRange())) continue;
                    string = this.chart.formatRangeNumber(1, d5);
                    this.a(graphics, string, d5, null, rectangle, fontMetrics, false, n);
                }
                for (d5 = Math.min(0.0, this.chart.getYCurrentUpperRange() - this.chart.getYCurrentUpperRange() % d6); d5 > this.chart.getYCurrentLowerRange(); d5 -= d6) {
                    if (!(d5 < 0.0) || !(d5 < this.chart.getYCurrentUpperRange())) continue;
                    string = this.chart.formatRangeNumber(1, d5);
                    this.a(graphics, string, d5, null, rectangle, fontMetrics, false, n);
                }
            } else {
                for (d5 = Math.min(0.0, this.chart.getYCurrentLowerRange() - this.chart.getYCurrentLowerRange() % d6); d5 > this.chart.getYCurrentUpperRange(); d5 -= d6) {
                    if (!(d5 < 0.0) || !(d5 < this.chart.getYCurrentLowerRange())) continue;
                    string = this.chart.formatRangeNumber(1, d5);
                    this.a(graphics, string, d5, null, rectangle, fontMetrics, false, n);
                }
                for (d5 = Math.max(0.0, this.chart.getYCurrentUpperRange() - this.chart.getYCurrentUpperRange() % d6); d5 < this.chart.getYCurrentLowerRange(); d5 += d6) {
                    if (!(d5 > 0.0) || !(d5 > this.chart.getYCurrentUpperRange())) continue;
                    string = this.chart.formatRangeNumber(1, d5);
                    this.a(graphics, string, d5, null, rectangle, fontMetrics, false, n);
                }
            }
        } else if (n == 0) {
            string = this.chart.formatRangeNumber(0, 0.0);
            d6 = this.chart.getXCurrentUpperRange();
            d5 = this.chart.getXCurrentLowerRange();
            int n3 = this.chart.getXRangeDecimalCount();
            if (d6 > 0.0 && d5 < 0.0 || d6 < 0.0 && d5 > 0.0) {
                this.a(graphics, string, 0.0, null, rectangle, fontMetrics, false, n);
            }
            string = this.chart.formatRangeNumber(0, d6);
            this.a(graphics, string, d6, null, rectangle, fontMetrics, false, n);
            string = this.chart.formatRangeNumber(0, d5);
            this.a(graphics, string, d5, null, rectangle, fontMetrics, false, n);
            d4 = this.a(d6 - d5, this.chart.getXRangeInterval(), rectangle.width, fontMetrics, true);
            if (d6 >= d5) {
                for (d3 = Math.max(0.0, this.chart.getXCurrentLowerRange() - this.chart.getXCurrentLowerRange() % d4); d3 < d6; d3 += d4) {
                    if (!(d3 > 0.0) || !(d3 > d5)) continue;
                    string = this.chart.formatRangeNumber(0, d3);
                    this.a(graphics, string, d3, null, rectangle, fontMetrics, false, n);
                }
                for (d3 = Math.min(0.0, this.chart.getXCurrentUpperRange() - this.chart.getXCurrentUpperRange() % d4); d3 > d5; d3 -= d4) {
                    if (!(d3 < 0.0) || !(d3 < d6)) continue;
                    string = this.chart.formatRangeNumber(0, d3);
                    this.a(graphics, string, d3, null, rectangle, fontMetrics, false, n);
                }
            } else {
                for (d3 = Math.min(0.0, this.chart.getXCurrentLowerRange() - this.chart.getXCurrentLowerRange() % d4); d3 > d6; d3 -= d4) {
                    if (!(d3 < 0.0) || !(d3 < d5)) continue;
                    string = this.chart.formatRangeNumber(0, d3);
                    this.a(graphics, string, d3, null, rectangle, fontMetrics, false, n);
                }
                for (d3 = Math.max(0.0, this.chart.getXCurrentUpperRange() - this.chart.getXCurrentUpperRange() % d4); d3 < d5; d3 += d4) {
                    if (!(d3 > 0.0) || !(d3 > d6)) continue;
                    string = this.chart.formatRangeNumber(0, d3);
                    this.a(graphics, string, d3, null, rectangle, fontMetrics, false, n);
                }
            }
        }
        if (this.chart.isRangeAdjusterOn(1)) {
            int n4 = rectangle.x + rectangle.width + 5;
            int n5 = rectangle.y;
            graphics.setColor(this.chart.getBackground().darker());
            graphics.drawLine(n4, n5, n4, n5 + rectangle.height);
            graphics.setColor(this.chart.getBackground().brighter());
            graphics.drawLine(n4 + 1, n5, n4 + 1, n5 + rectangle.height);
            d2 = 0.0;
            d = 0.0;
            d4 = this.chart.getYUpperRange();
            d3 = this.chart.getYLowerRange();
            if (d4 - d3 != 0.0) {
                d2 = (this.chart.getYCurrentUpperRange() - d3) / (d4 - d3);
                d = (this.chart.getYCurrentLowerRange() - d3) / (d4 - d3);
            }
            int n6 = (int)Math.round((double)(n5 + rectangle.height) - d2 * (double)rectangle.height);
            int n7 = (int)Math.round((double)(n5 + rectangle.height) - d * (double)rectangle.height);
            this.aR[1].setBounds(n4 - 3, n6, 7, n7 - n6);
            this.paintBox(graphics, Color.lightGray, n4 - 3, n6, 6, n7 - n6, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n4 - 2, n6 + 2, n4 + 2, n6 + 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n4 - 2, n7 - 2, n4 + 2, n7 - 2);
        }
        if (this.chart.isRangeAdjusterOn(3)) {
            int n8 = rectangle.x;
            int n9 = rectangle.y + rectangle.height + 4;
            graphics.setColor(this.chart.getBackground().darker());
            graphics.drawLine(n8, n9, n8 + rectangle.width, n9);
            graphics.setColor(this.chart.getBackground().brighter());
            graphics.drawLine(n8, n9 + 1, n8 + rectangle.width, n9 + 1);
            d2 = 0.0;
            d = 0.0;
            if (this.chart.getXUpperRange() - this.chart.getXLowerRange() != 0.0) {
                d2 = (this.chart.getXCurrentUpperRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                d = (this.chart.getXCurrentLowerRange() - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange());
            }
            int n10 = (int)Math.round((double)n8 + d * (double)rectangle.width);
            n2 = (int)Math.round((double)n8 + d2 * (double)rectangle.width);
            this.aR[3].setBounds(n10, n9 - 3, n2 - n10, 7);
            this.paintBox(graphics, Color.lightGray, n10, n9 - 3, n2 - n10, 6, false);
            graphics.setColor(Color.gray);
            graphics.drawLine(n10 + 2, n9 - 2, n10 + 2, n9 + 2);
            graphics.setColor(Color.white);
            graphics.drawLine(n2 - 2, n9 - 2, n2 - 2, n9 + 2);
        }
        String[] stringArray = new String[]{"right", "left", "top", "bottom"};
        Font font2 = this.getFont("rangeAxisLabelFont");
        fontMetrics = this.getFontMetrics(font2);
        graphics.setFont(font2);
        graphics.setColor(this.chart.getForeground());
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.getLabel("rangeAxisLabel_" + stringArray[i]);
            if (string2 == null) continue;
            int n11 = this.getLabelAngle("rangeAxisLabelAngle_" + stringArray[i]);
            Dimension dimension = this.getLabelSize(string2, fontMetrics);
            Dimension dimension2 = this.getAngledLabelSize(dimension, n11);
            n2 = -100;
            int n12 = -100;
            Color color = this.chart.getForeground();
            if (stringArray[i].equals("right")) {
                n2 = rectangle.x + rectangle.width + this.a(1, true) + 10;
                n12 = rectangle.y + rectangle.height / 2 - dimension2.height / 2;
                color = this.chart.getRangeColor(1);
            } else if (stringArray[i].equals("left")) {
                n2 = rectangle.x - dimension2.width - this.a(0, true) - 10;
                n12 = rectangle.y + rectangle.height / 2 - dimension2.height / 2;
                color = this.chart.getRangeColor(0);
            } else if (stringArray[i].equals("top")) {
                n2 = rectangle.x + rectangle.width / 2 - dimension2.width / 2;
                n12 = rectangle.y - dimension2.height - this.a(2, true) - 5;
                color = this.chart.getRangeColor(2);
            } else if (stringArray[i].equals("bottom")) {
                n2 = rectangle.x + rectangle.width / 2 - dimension2.width / 2;
                n12 = rectangle.y + rectangle.height + this.a(3, true) + 5;
                n12 += this.a();
                color = this.chart.getRangeColor(3);
            }
            if (n11 % 180 == 0) {
                n12 += fontMetrics.getAscent();
            }
            graphics.setColor(color);
            this.paintLabel(graphics, string2, n2, n12, dimension, 0, n11, false);
        }
    }

    private void a(Graphics graphics, String string, double d, Color color, Rectangle rectangle, FontMetrics fontMetrics, boolean bl, int n) {
        if (n == 0) {
            int n2;
            Point point = this.a(d, this.chart.getYCurrentUpperRange(), rectangle);
            if (this.chart.isXValueLinesOn() || bl) {
                if (color != null) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(this.chart.getXValueLinesColor());
                }
                for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; n2 += 6) {
                    graphics.drawLine(point.x, n2, point.x, n2 + Math.min(3, rectangle.y + rectangle.height - n2));
                }
            }
            boolean bl2 = point.x > rectangle.x + (n2 = fontMetrics.stringWidth("-" + string)) && point.x < rectangle.x + rectangle.width - n2;
            if (bl2 |= d == this.chart.getXCurrentUpperRange() || d == this.chart.getXCurrentLowerRange()) {
                if (this.chart.isRangeOn(2)) {
                    graphics.setColor(this.chart.getRangeColor(2));
                    graphics.drawLine(point.x, point.y, point.x, point.y - 3);
                    graphics.drawString(string, point.x - fontMetrics.stringWidth(string) / 2 + 1, point.y - 5);
                }
                if (this.chart.isRangeOn(3)) {
                    graphics.setColor(this.chart.getRangeColor(3));
                    point = this.a(d, this.chart.getYCurrentLowerRange(), rectangle);
                    if (this.chart.isRangeAdjusterOn(3)) {
                        point.y += 8;
                    }
                    graphics.drawLine(point.x, point.y, point.x, point.y + 3);
                    int n3 = point.y + fontMetrics.getHeight();
                    graphics.drawString(string, point.x - fontMetrics.stringWidth(string) / 2 + 1, n3);
                }
            }
        } else if (n == 1) {
            int n4;
            Point point = this.a(this.chart.getXCurrentLowerRange(), d, rectangle);
            Color color2 = color;
            if (color2 == null) {
                color2 = this.chart.getYValueLinesColor();
            }
            if (bl) {
                graphics.setColor(color2);
                for (n4 = rectangle.x; n4 < rectangle.x + rectangle.width; n4 += 12) {
                    graphics.drawLine(n4, point.y, n4 + Math.min(9, rectangle.x + rectangle.width - n4), point.y);
                }
            } else if (this.chart.isYValueLinesOn()) {
                graphics.setColor(this.chart.getYValueLinesColor());
                for (n4 = rectangle.x; n4 < rectangle.x + rectangle.width; n4 += 6) {
                    graphics.drawLine(n4, point.y, n4 + Math.min(3, rectangle.x + rectangle.width - n4), point.y);
                }
            }
            boolean bl3 = point.y > rectangle.y + (n4 = fontMetrics.getAscent()) && point.y < rectangle.y + rectangle.height - n4;
            if (bl3 |= d == this.chart.getYCurrentUpperRange() || d == this.chart.getYCurrentLowerRange()) {
                if (bl) {
                    graphics.setColor(color2);
                    if (this.chart.getTargetLabelsPosition() == 0) {
                        graphics.drawLine(point.x, point.y, point.x - 3, point.y);
                        graphics.drawString(string, point.x - fontMetrics.stringWidth(string) - 4, point.y + fontMetrics.getHeight() - fontMetrics.getAscent() + 1);
                    } else {
                        point = this.a(this.chart.getXCurrentUpperRange(), d, rectangle);
                        graphics.drawLine(point.x, point.y, point.x + 3, point.y);
                        int n5 = point.x + 6;
                        if (this.chart.isRangeAdjusterOn(1)) {
                            n5 += 6;
                        }
                        graphics.drawString(string, n5, point.y + fontMetrics.getHeight() - fontMetrics.getAscent() + 1);
                    }
                } else {
                    if (this.chart.isRangeOn(0)) {
                        graphics.setColor(this.chart.getRangeColor(0));
                        graphics.drawLine(point.x, point.y, point.x - 3, point.y);
                        graphics.drawString(string, point.x - fontMetrics.stringWidth(string) - 4, point.y + fontMetrics.getHeight() - fontMetrics.getAscent() + 1);
                    }
                    if (this.chart.isRangeOn(1)) {
                        graphics.setColor(this.chart.getRangeColor(1));
                        point = this.a(this.chart.getXCurrentUpperRange(), d, rectangle);
                        graphics.drawLine(point.x, point.y, point.x + 3, point.y);
                        int n6 = point.x + 6;
                        if (this.chart.isRangeAdjusterOn(1)) {
                            n6 += 6;
                        }
                        graphics.drawString(string, n6, point.y + fontMetrics.getHeight() - fontMetrics.getAscent() + 1);
                    }
                }
            }
        }
    }

    private void a(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2) {
        Shape shape = graphics.getClip();
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        double[][] dArray = this.chart.getPlots(n);
        for (int i = 0; dArray != null && i < dArray.length; ++i) {
            int n2;
            int n3;
            Point point = this.a(dArray[i][0], dArray[i][1], rectangle);
            boolean bl = point.y >= rectangle.y && point.y <= rectangle.y + rectangle.height;
            if (!(bl &= point.x >= rectangle.x && point.x <= rectangle.x + rectangle.width + 1)) continue;
            Color color = this.chart.getSeriesLabelColor(n);
            if (color == null) {
                color = this.chart.getForeground();
            }
            graphics.setColor(color);
            Font font = this.getFont("seriesLabelFont_" + n);
            if (font == this.chart.getFont()) {
                font = this.getFont("seriesLabelFont");
            }
            graphics.setFont(font);
            String string = this.constructLabel(n, i, 0);
            if (string.length() > 0) {
                Dimension dimension = this.getLabelSize(string, graphics.getFontMetrics());
                int n4 = point.x - dimension.width / 2 + 1;
                n3 = point.y + dimension.height / 2;
                this.paintLabel(graphics, string, n4, n3, dimension, 0, 0, false);
            }
            string = this.constructLabel(n, i, 1);
            int n5 = Math.max(1, this.chart.getPlotSize(n, i));
            if (string.length() > 0) {
                Dimension dimension = this.getLabelSize(string, graphics.getFontMetrics());
                n3 = point.x - dimension.width / 2 + 1;
                n2 = point.y - n5 / 2 - 3;
                this.paintLabel(graphics, string, n3, n2, dimension, 0, 0, false);
            }
            if ((string = this.constructLabel(n, i, 2)).length() <= 0) continue;
            Dimension dimension = this.getLabelSize(string, graphics.getFontMetrics());
            n3 = point.x - dimension.width / 2 + 1;
            n2 = point.y + dimension.height + n5 / 2;
            this.paintLabel(graphics, string, n3, n2, dimension, 0, 0, false);
        }
        graphics.setClip(shape);
    }

    private void try(Graphics graphics, Rectangle rectangle) {
        Font font = this.getFont("rangeLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        double[] dArray = this.chart.getGridLines();
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > 0.0) || !(dArray[i] <= 100.0)) continue;
            double d = this.chart.getXLowerRange() + (this.chart.getXUpperRange() - this.chart.getXLowerRange()) / 100.0 * dArray[i];
            this.a(graphics, "", d, this.chart.getGridLineColor(i), rectangle, fontMetrics, true, 0);
        }
    }

    protected boolean paintFloatingLabels(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.chart.isPlotLabelsOn();
        bl |= this.chart.isXValueLabelsOn(-1) && this.chart.getValueLabelStyle() == 4;
        bl |= this.chart.isYValueLabelsOn(-1) && this.chart.getValueLabelStyle() == 4;
        boolean bl2 = this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == 4;
        int n = this.chart.aA;
        int n2 = this.chart.a8;
        if ((bl |= bl2) && (n > -1 || n2 > -1)) {
            Font font = this.getFont("floatingLabelFont");
            FontMetrics fontMetrics = this.getFontMetrics(font);
            graphics.setFont(font);
            if (n >= 0 && n2 >= 0) {
                String string = this.constructLabel(n, n2, 4);
                this.paintFloatingLabel(graphics, string, rectangle, n2, n, font, fontMetrics);
                return true;
            }
            if (this.chart.isFloatingOnLegendOn() && n2 == -1) {
                for (int i = 0; i < this.chart.getPlots(n).length; ++i) {
                    String string = this.constructLabel(n, i, 4);
                    this.paintFloatingLabel(graphics, string, rectangle, i, n, font, fontMetrics);
                }
                return true;
            }
        }
        return false;
    }

    protected void paintFloatingLabel(Graphics graphics, String string, Rectangle rectangle, int n, int n2, Font font, FontMetrics fontMetrics) {
        if (string == null || string.equals("")) {
            return;
        }
        double[][] dArray = this.chart.getPlots(n2);
        Point point = this.a(dArray[n][0], dArray[n][1], rectangle);
        if (point.x < rectangle.x || point.x > rectangle.x + rectangle.width || point.y < rectangle.y || point.y > rectangle.y + rectangle.height) {
            return;
        }
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        int n3 = Math.max(1, this.chart.getPlotSize(n2, n));
        point.x -= dimension.width / 2;
        point.y -= dimension.height / 2 + n3 / 2;
        point.x = Math.max(point.x, 3);
        point.x = Math.min(point.x, this.chart.getSize().width - dimension.width - 3);
        point.y = Math.max(point.y, fontMetrics.getAscent());
        point.y = Math.min(point.y, this.chart.getSize().height - dimension.height + fontMetrics.getAscent() - 1);
        int n4 = fontMetrics.getHeight();
        int n5 = fontMetrics.getDescent();
        graphics.setColor(new Color(255, 255, 231));
        graphics.fillRect(point.x - 2, point.y - n4 + n5 * 2 - 2, dimension.width + 5, dimension.height);
        graphics.setColor(PlotterChartRenderer.getDarker(this.chart.getSeriesColor(n2)));
        graphics.drawRect(point.x - 3, point.y - n4 + n5 * 2 - 3, dimension.width + 5, dimension.height + 1);
        graphics.setColor(Color.black);
        this.paintLabel(graphics, string, point.x, point.y, dimension, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    protected String constructLabel(int n, int n2, int n3) {
        String string;
        String string2;
        String string3;
        if (n < 0 || n >= this.getSeriesCount() || n2 < 0 || n2 >= this.chart.getPlots(n).length) {
            return "";
        }
        boolean bl = this.chart.isPlotLabelsOn() && (this.chart.getPlotLabelStyle() == n3 || this.chart.getPlotLabelStyle() == 5 && n3 == 4);
        boolean bl2 = this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == n3;
        boolean bl3 = this.chart.isXValueLabelsOn(n) && this.chart.getValueLabelStyle() == n3;
        boolean bl4 = this.chart.isYValueLabelsOn(n) && this.chart.getValueLabelStyle() == n3;
        String string4 = this.chart.getComplexLabelSeparator();
        if (string4 == null) {
            string4 = n3 == 3 ? " : " : ":";
        }
        String string5 = "";
        if (bl2 && (string3 = this.chart.getSeriesLabel(n)) != null) {
            string5 = string5 + string3;
            if (!string3.endsWith("\n") && (bl && this.chart.getPlotLabel(n, n2) != null || bl3 || bl4)) {
                string5 = string5 + string4;
            }
        }
        if (bl && (string3 = this.chart.getPlotLabel(n, n2)) != null) {
            string5 = string5 + string3;
            if (!string3.endsWith("\n") && (bl3 || bl4)) {
                string5 = string5 + string4;
            }
        }
        if (bl3) {
            string3 = this.getLabel("XValueLabelPrefix_" + n);
            if (string3 == null) {
                string3 = this.getLabel("XValueLabelPrefix");
            }
            if ((string2 = this.getLabel("XValueLabelPostfix_" + n)) == null) {
                string2 = this.getLabel("XValueLabelPostfix");
            }
            string = this.chart.formatNumber(this.chart.getPlots(n)[n2][0], this.chart.getXValueDecimalCount(n));
            string = string3 != null ? string3 + string : string;
            string = string2 != null ? string + string2 : string;
            string5 = string5 + string;
            if (bl4) {
                string5 = string5 + " , ";
            }
        }
        if (bl4) {
            string3 = this.getLabel("YValueLabelPrefix_" + n);
            if (string3 == null) {
                string3 = this.getLabel("YValueLabelPrefix");
            }
            if ((string2 = this.getLabel("YValueLabelPostfix_" + n)) == null) {
                string2 = this.getLabel("YValueLabelPostfix");
            }
            string = this.chart.formatNumber(this.chart.getPlots(n)[n2][1], this.chart.getYValueDecimalCount(n));
            string = string3 != null ? string3 + string : string;
            string = string2 != null ? string + string2 : string;
            string5 = string5 + string;
        }
        return string5;
    }

    private double a(double d, double d2, int n, FontMetrics fontMetrics, boolean bl) {
        int n2;
        int n3;
        if (d == 0.0) {
            if (bl) {
                return Math.abs(this.chart.getXCurrentUpperRange());
            }
            return Math.abs(this.chart.getYCurrentUpperRange());
        }
        if (bl) {
            String string = this.chart.formatRangeNumber(0, this.chart.getXCurrentUpperRange());
            String string2 = this.chart.formatRangeNumber(0, this.chart.getXCurrentLowerRange());
            n3 = Math.max(fontMetrics.stringWidth(string), fontMetrics.stringWidth(string2)) + 4;
        } else {
            n3 = fontMetrics.getHeight() + 4;
        }
        int n4 = (int)Math.round((double)n / (double)n3);
        if (bl) {
            if (this.chart.getXMaxValueLineCount() != -1) {
                n4 = Math.min(this.chart.getXMaxValueLineCount(), n4);
            }
            n2 = (int)Math.round(Math.abs(this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange()) * Math.pow(10.0, this.chart.getXRangeDecimalCount()));
        } else {
            if (this.chart.getYMaxValueLineCount() != -1) {
                n4 = Math.min(this.chart.getYMaxValueLineCount(), n4);
            }
            n2 = (int)Math.round(Math.abs(this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange()) * Math.pow(10.0, this.chart.getYRangeDecimalCount()));
        }
        n4 = Math.min(n4, n2 + 1);
        n4 = Math.max(1, n4);
        double d3 = 0.0;
        double d4 = d / (double)n4;
        d4 = Math.abs(d4);
        if (d2 > 0.0) {
            d3 = d2;
            double d5 = 1.0;
            while (d3 < d4) {
                for (int i = 0; i < this.aT.length; ++i) {
                    if (!(this.aT[i] * d5 * d3 >= d4)) continue;
                    d3 = this.aT[i] * d5 * d3;
                    break;
                }
                d5 *= 10.0;
            }
        } else {
            d3 = d4;
            boolean bl2 = false;
            double d6 = 10.0;
            while (!bl2 && d6 * 1.0E-12 < 1.0E14) {
                for (int i = 0; i < this.aT.length; ++i) {
                    if (!(this.aT[i] * d6 * 1.0E-12 >= d4)) continue;
                    d3 = this.aT[i] * d6 * 1.0E-12;
                    bl2 = true;
                    break;
                }
                d6 *= 10.0;
            }
        }
        return d3;
    }

    void case(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.chart.getXUpperRange() != this.chart.getXCurrentUpperRange();
        bl |= this.chart.getXLowerRange() != this.chart.getXCurrentLowerRange();
        bl |= this.chart.getYUpperRange() != this.chart.getYCurrentUpperRange();
        if (bl |= this.chart.getYLowerRange() != this.chart.getYCurrentLowerRange()) {
            int n = rectangle.x + 8;
            int n2 = rectangle.y + 8;
            this.paintBox(graphics, Color.lightGray, n, n2, 8, 8, this.a1);
            graphics.setColor(Color.black);
            graphics.drawLine(n + 3, n2 + 4, n + 5, n2 + 4);
        }
    }

    void int(Graphics graphics) {
        graphics.setColor(this.chart.getForeground());
        if (this.a2 != null) {
            int n;
            boolean bl = true;
            for (n = this.a2.x; n < this.a2.x + this.a2.width; ++n) {
                if (bl) {
                    graphics.drawLine(n, this.a2.y, n, this.a2.y);
                    graphics.drawLine(n, this.a2.y + this.a2.height, n, this.a2.y + this.a2.height);
                }
                bl = !bl;
            }
            bl = true;
            for (n = this.a2.y; n < this.a2.y + this.a2.height; ++n) {
                if (bl) {
                    graphics.drawLine(this.a2.x, n, this.a2.x, n);
                    graphics.drawLine(this.a2.x + this.a2.width, n, this.a2.x + this.a2.width, n);
                }
                bl = !bl;
            }
        }
    }

    private int a(int n, boolean bl) {
        n = Math.min(3, Math.max(0, n));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont("rangeLabelFont"));
        int n2 = 0;
        if (this.chart.isRangeOn(n)) {
            if (n == 1 || n == 0) {
                String string = this.chart.formatRangeNumber(1, this.chart.getYUpperRange());
                n2 = fontMetrics.stringWidth(string);
                string = this.chart.formatRangeNumber(1, this.chart.getYLowerRange());
                n2 = Math.max(fontMetrics.stringWidth(string), n2);
            }
            if (n == 2 || n == 3) {
                n2 = fontMetrics.getHeight() - 5;
            }
        }
        if (bl && (n == 1 || n == 0) && this.chart.getTargetLabelsPosition() == n) {
            int n3 = 0;
            Enumeration enumeration = this.chart.ae.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.chart.for(string);
                if (string2 == null || string2.length() <= 0) continue;
                n3 = Math.max(n3, fontMetrics.stringWidth(string2));
            }
            n2 = Math.max(n3, n2);
        }
        if ((n == 1 || n == 3) && this.chart.isRangeAdjusterOn(n)) {
            n2 += 6;
        }
        return n2 + 4;
    }

    private int a() {
        Object object;
        int n;
        int n2 = 0;
        int n3 = this.getLabelAngle("plotLabelAngle");
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont("plotLabelFont"));
        if (this.chart.isPlotLabelsOn() && (this.chart.getPlotLabelStyle() == 3 || this.chart.getPlotLabelStyle() == 5)) {
            for (n = 0; n < this.getSeriesCount(); ++n) {
                String[] stringArray = this.chart.getPlotLabels(n);
                for (int i = 0; i < stringArray.length; ++i) {
                    object = this.getLabelSize(stringArray[i], fontMetrics);
                    Dimension dimension = this.getAngledLabelSize((Dimension)object, n3);
                    n2 = Math.max(dimension.height, n2);
                }
            }
        }
        n = this.chart.getXRangeLabelStyle();
        if (this.chart.getXRangeLabels() != null && (n == 3 || n == 5)) {
            int n4 = this.getLabelAngle("xrangelabelangle");
            FontMetrics fontMetrics2 = this.getFontMetrics(this.getFont("xrangelabelfont"));
            object = this.chart.getXRangeLabels();
            for (int i = 0; i < ((String[])object).length; ++i) {
                Dimension dimension = this.getLabelSize(object[i], fontMetrics2);
                Dimension dimension2 = this.getAngledLabelSize(dimension, n4);
                if (dimension2.height <= n2) continue;
                n2 = dimension2.height;
                n3 = n4;
                fontMetrics = fontMetrics2;
            }
        }
        if (n3 % 180 == 0) {
            n2 -= fontMetrics.getMaxDescent();
        }
        return n2;
    }

    Point a(double d, double d2, Rectangle rectangle) {
        int n;
        int n2;
        if (rectangle == null) {
            return new Point(-1, -1);
        }
        Grid grid = this.chart.a();
        if (grid instanceof PlotterGrid) {
            double d3 = (d - this.chart.getXCurrentLowerRange()) / (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
            n2 = (int)Math.round((double)rectangle.x + (double)rectangle.width * d3);
            double d4 = (d2 - this.chart.getYCurrentLowerRange()) / (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
            n = (int)Math.round((double)(rectangle.y + rectangle.height) - (double)rectangle.height * d4);
        } else {
            if (this.aV == null) {
                return new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }
            n2 = (int)((double)this.aV.width * (d - this.chart.getXLowerRange()) / (this.chart.getXUpperRange() - this.chart.getXLowerRange())) + this.aV.x;
            double d5 = (d2 - grid.getCurrentLowerRange(0)) / (grid.getCurrentRange(0) - grid.getCurrentLowerRange(0));
            n = (int)Math.round((double)(rectangle.y + rectangle.height) - (double)rectangle.height * d5);
        }
        return new Point(n2, n);
    }

    protected Point getSampleCenter(int n, int n2) {
        double[][] dArray = this.chart.getPlots(n2);
        return this.a(dArray[n][0], dArray[n][1], this.aQ);
    }

    void if(AWTEvent aWTEvent) {
        if (this.aP != -1 || this.aU || this.a0 || this.aY) {
            return;
        }
        int n = ((MouseEvent)aWTEvent).getX();
        int n2 = ((MouseEvent)aWTEvent).getY();
        long l = System.currentTimeMillis();
        switch (aWTEvent.getID()) {
            case 501: {
                this.aZ = n;
                this.aX = n2;
                boolean bl = false;
                bl |= this.chart.getXUpperRange() != this.chart.getXCurrentUpperRange();
                bl |= this.chart.getXLowerRange() != this.chart.getXCurrentLowerRange();
                bl |= this.chart.getYUpperRange() != this.chart.getYCurrentUpperRange();
                boolean bl2 = bl |= this.chart.getYLowerRange() != this.chart.getYCurrentLowerRange();
                bl2 &= n > this.aQ.x + 8 && n < this.aQ.x + 17;
                if (bl2 &= n2 > this.aQ.y + 8 && n2 < this.aQ.y + 17) {
                    double d;
                    double d2;
                    double d3 = Math.abs(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange());
                    double d4 = Math.abs(this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange());
                    if (d3 > 0.0 || d4 > 0.0) {
                        d2 = 0.1 * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                        d = d2 * d3 / (d3 + d4);
                        this.chart.setXCurrentUpperRange(this.chart.getXCurrentUpperRange() + d);
                        this.chart.setXCurrentLowerRange(this.chart.getXCurrentLowerRange() - (d2 - d));
                    }
                    d3 = Math.abs(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange());
                    d4 = Math.abs(this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange());
                    if (d3 > 0.0 || d4 > 0.0) {
                        d2 = 0.1 * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                        d = d2 * d3 / (d3 + d4);
                        this.chart.setYCurrentUpperRange(this.chart.getYCurrentUpperRange() + d);
                        this.chart.setYCurrentLowerRange(this.chart.getYCurrentLowerRange() - (d2 - d));
                    }
                    this.a1 = true;
                } else if (l - this.aW < 350L) {
                    this.chart.setXCurrentUpperRange(this.chart.getXUpperRange());
                    this.chart.setXCurrentLowerRange(this.chart.getXLowerRange());
                    this.chart.setYCurrentUpperRange(this.chart.getYUpperRange());
                    this.chart.setYCurrentLowerRange(this.chart.getYLowerRange());
                }
                this.chart.repaint();
                break;
            }
            case 506: {
                if (this.a1 || this.aZ < 0 || this.aX < 0) break;
                int n3 = Math.max(this.aQ.x + 1, this.aZ);
                int n4 = Math.max(this.aQ.y + 1, this.aX);
                n3 = Math.min(this.aQ.x + this.aQ.width - 1, n3);
                n4 = Math.min(this.aQ.y + this.aQ.height - 1, n4);
                int n5 = Math.max(this.aQ.x + 1, n);
                int n6 = Math.max(this.aQ.y + 1, n2);
                n5 = Math.min(this.aQ.x + this.aQ.width - 1, n5);
                n6 = Math.min(this.aQ.y + this.aQ.height - 1, n6);
                this.a2 = new Rectangle();
                this.a2.x = Math.min(n3, n5);
                this.a2.y = Math.min(n4, n6);
                this.a2.width = Math.abs(n3 - n5);
                this.a2.height = Math.abs(n4 - n6);
                if (this.a2.width < 3 || this.a2.height < 3) {
                    this.a2 = null;
                }
                this.chart.repaint();
                break;
            }
            case 502: {
                this.aZ = -1;
                this.aX = -1;
                if (l - this.aW > 100L && this.a2 != null) {
                    Rectangle rectangle = new Rectangle(this.a2.x - 1, this.a2.y - 1, this.a2.width + 2, this.a2.height + 2);
                    double d = (double)(rectangle.x - this.aQ.x) / (double)this.aQ.width;
                    double d5 = (double)(this.aQ.x + this.aQ.width - rectangle.x - rectangle.width) / (double)this.aQ.width;
                    double d6 = this.chart.getXCurrentLowerRange() + d * (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
                    double d7 = this.chart.getXCurrentUpperRange() - d5 * (this.chart.getXCurrentUpperRange() - this.chart.getXCurrentLowerRange());
                    if (Math.abs(d7 - d6) >= Math.abs(this.chart.getXUpperRange() - this.chart.getXLowerRange()) / 1000.0) {
                        this.chart.setXCurrentLowerRange(d6);
                        this.chart.setXCurrentUpperRange(d7);
                    }
                    d = (double)(this.aQ.y + this.aQ.height - rectangle.y - rectangle.height) / (double)this.aQ.height;
                    d5 = (double)(rectangle.y - this.aQ.y) / (double)this.aQ.height;
                    d6 = this.chart.getYCurrentLowerRange() + d * (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
                    d7 = this.chart.getYCurrentUpperRange() - d5 * (this.chart.getYCurrentUpperRange() - this.chart.getYCurrentLowerRange());
                    if (Math.abs(d7 - d6) >= Math.abs(this.chart.getYUpperRange() - this.chart.getYLowerRange()) / 1000.0) {
                        this.chart.setYCurrentLowerRange(d6);
                        this.chart.setYCurrentUpperRange(d7);
                    }
                }
                this.a2 = null;
                this.a1 = false;
                this.chart.repaint();
            }
        }
    }

    void a(AWTEvent aWTEvent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = -1;
        int n2 = ((MouseEvent)aWTEvent).getX();
        int n3 = ((MouseEvent)aWTEvent).getY();
        Rectangle rectangle = this.aR[1];
        if (this.chart.isRangeAdjusterOn(1) && rectangle != null) {
            bl = n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width;
            bl = bl && n3 >= rectangle.y - 3 && n3 <= rectangle.y + rectangle.height + 1;
            bl2 = n3 >= rectangle.y - 1 && n3 <= rectangle.y + 3;
            bl2 = bl2 && n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width;
            bl3 = n3 >= rectangle.y + rectangle.height - 3 && n3 <= rectangle.y + rectangle.height + 1;
            boolean bl4 = bl3 = bl3 && n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width;
            if (bl || bl2 || bl3) {
                n = 3;
            }
        }
        if (n == -1 && this.chart.isRangeAdjusterOn(3) && rectangle != null) {
            rectangle = this.aR[3];
            bl = n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height;
            bl = bl && n2 >= rectangle.x - 1 && n2 <= rectangle.x + rectangle.width + 1;
            bl3 = n2 >= rectangle.x - 1 && n2 <= rectangle.x + 2;
            bl3 = bl3 && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height;
            bl2 = n2 >= rectangle.x + rectangle.width - 3 && n2 <= rectangle.x + rectangle.width + 1;
            boolean bl5 = bl2 = bl2 && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height;
            if (bl || bl2 || bl3) {
                n = 1;
            }
        }
        if ((bl2 || bl3) && bl) {
            if (n == 3) {
                this.chart.a(RESIZE_CURSOR);
            } else if (n == 1) {
                this.chart.a(RESIZE_HOR_CURSOR);
            }
        } else if (bl) {
            this.chart.a(HAND_CURSOR);
        }
        switch (aWTEvent.getID()) {
            case 503: {
                break;
            }
            case 501: {
                this.aU = bl2 && bl;
                this.a0 = bl3 && bl;
                this.aY = bl && !bl2 && !bl3;
                this.a3 = n;
                this.aS = n3;
                if (this.a3 == 1) {
                    this.aS = n2;
                }
                long l = System.currentTimeMillis();
                if (bl && !bl2 && !bl3 && l - this.aW < 350L) {
                    if (n == 3) {
                        this.chart.setYCurrentUpperRange(this.chart.getYUpperRange());
                        this.chart.setYCurrentLowerRange(this.chart.getYLowerRange());
                    } else if (n == 1) {
                        this.chart.setXCurrentUpperRange(this.chart.getXUpperRange());
                        this.chart.setXCurrentLowerRange(this.chart.getXLowerRange());
                    }
                }
                this.chart.repaint();
                break;
            }
            case 506: {
                int n4 = ((MouseEvent)aWTEvent).getY();
                if (this.a3 == 1) {
                    n4 = ((MouseEvent)aWTEvent).getX();
                }
                Rectangle rectangle2 = this.aQ;
                if (this.a3 == 3) {
                    if (this.aU) {
                        this.chart.a(RESIZE_CURSOR);
                        double d = 1.0 - (double)(n4 -= rectangle2.y) / (double)rectangle2.height;
                        this.a(3, d, 0.0);
                    } else if (this.a0) {
                        this.chart.a(RESIZE_CURSOR);
                        double d = 1.0 - (double)(n4 -= rectangle2.y) / (double)rectangle2.height;
                        this.a(3, 0.0, d);
                    } else if (this.aY) {
                        this.chart.a(HAND_CURSOR);
                        int n5 = this.aS - n4;
                        double d = (double)n5 / (double)rectangle2.height;
                        this.a(3, d);
                        this.aS = n4;
                    }
                } else if (this.a3 == 1) {
                    if (this.aU) {
                        this.chart.a(RESIZE_HOR_CURSOR);
                        double d = (double)(n4 -= rectangle2.x) / (double)rectangle2.width;
                        this.a(1, d, 0.0);
                    } else if (this.a0) {
                        this.chart.a(RESIZE_HOR_CURSOR);
                        double d = (double)(n4 -= rectangle2.x) / (double)rectangle2.width;
                        this.a(1, 0.0, d);
                    } else if (this.aY) {
                        this.chart.a(HAND_CURSOR);
                        int n6 = n4 - this.aS;
                        double d = (double)n6 / (double)rectangle2.width;
                        this.a(1, d);
                        this.aS = n4;
                    }
                }
                this.chart.repaint();
                break;
            }
            case 502: {
                this.aY = false;
                this.a0 = false;
                this.aU = false;
                this.chart.repaint();
            }
        }
    }

    void do(AWTEvent aWTEvent) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.aQ != null) {
            n = this.aQ.y;
            n2 = this.aQ.x - (this.display3dOn ? this.depth3dPoint.x : 0);
            n3 = this.aQ.x + this.aQ.width;
            n4 = this.aQ.y + this.aQ.height - (this.display3dOn ? this.depth3dPoint.y : 0);
        }
        long l = System.currentTimeMillis();
        int n5 = ((MouseEvent)aWTEvent).getX();
        int n6 = ((MouseEvent)aWTEvent).getY();
        Insets insets = this.chart.getGraphInsets();
        switch (aWTEvent.getID()) {
            case 501: {
                this.aZ = n5;
                this.aX = n6;
                if (this.aP < 0 || l - this.aW >= 350L) break;
                switch (this.aP) {
                    case 0: {
                        insets.left = -1;
                        break;
                    }
                    case 1: {
                        insets.right = -1;
                        break;
                    }
                    case 2: {
                        insets.top = -1;
                        break;
                    }
                    case 3: {
                        insets.bottom = -1;
                    }
                }
                break;
            }
            case 503: {
                if (this.chart.isGridAdjustmentOn(2) && n5 >= n2 && n5 <= n3 && n6 >= n - 1 && n6 <= n + 3) {
                    this.chart.a(GRID_CURSOR_VERT);
                    this.aP = 2;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(0) && n5 >= n2 - 1 && n5 <= n2 + 3 && n6 >= n && n6 <= n4) {
                    this.chart.a(GRID_CURSOR_HORZ);
                    this.aP = 0;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(3) && n5 >= n2 && n5 <= n3 && n6 >= n4 - 3 && n6 <= n4 + 1) {
                    this.chart.a(GRID_CURSOR_VERT);
                    this.aP = 3;
                    break;
                }
                if (this.chart.isGridAdjustmentOn(2) && n5 >= n3 - 3 && n5 <= n3 + 1 && n6 >= n && n6 <= n4) {
                    this.chart.a(GRID_CURSOR_HORZ);
                    this.aP = 1;
                    break;
                }
                this.aP = -1;
                break;
            }
            case 506: {
                int n7 = 0;
                int n8 = 0;
                if (this.display3dOn) {
                    n7 = this.depth3dPoint.x;
                    n8 = this.depth3dPoint.y;
                }
                if (this.aP < 0) break;
                Dimension dimension = this.chart.getSize();
                switch (this.aP) {
                    case 0: {
                        insets.left = Math.max(0, n5) + n7;
                        if (this.aQ != null) {
                            insets.left = Math.min(insets.left, this.aQ.x + this.aQ.width - 5);
                        }
                        this.chart.a(GRID_CURSOR_HORZ);
                        break;
                    }
                    case 1: {
                        insets.right = Math.max(dimension.width - n5, 0);
                        if (this.aQ != null) {
                            insets.right = Math.min(insets.right, dimension.width - this.aQ.x - 5);
                        }
                        this.chart.a(GRID_CURSOR_HORZ);
                        break;
                    }
                    case 2: {
                        insets.top = Math.max(n6, 0);
                        if (this.aQ != null) {
                            insets.top = Math.min(insets.top, this.aQ.y + this.aQ.height - 5);
                        }
                        this.chart.a(GRID_CURSOR_VERT);
                        break;
                    }
                    case 3: {
                        insets.bottom = Math.max(dimension.height - n6, 0) - n8;
                        if (this.aQ != null) {
                            insets.bottom = Math.min(insets.bottom, dimension.height - this.aQ.y - 5);
                        }
                        this.chart.a(GRID_CURSOR_VERT);
                    }
                }
                this.chart.repaint();
            }
        }
        this.chart.setGraphInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void a(int n, double d, double d2) {
        if (n == 1) {
            double d3;
            if (d != 0.0) {
                d3 = this.chart.getXLowerRange() + d * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                    if (d3 > this.chart.getXCurrentLowerRange()) {
                        this.chart.setXCurrentUpperRange(d3);
                    }
                    this.chart.setXCurrentUpperRange(Math.min(this.chart.getXCurrentUpperRange(), this.chart.getXUpperRange()));
                } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                    if (d3 < this.chart.getXCurrentLowerRange()) {
                        this.chart.setXCurrentUpperRange(d3);
                    }
                    this.chart.setXCurrentUpperRange(Math.max(this.chart.getXCurrentUpperRange(), this.chart.getXUpperRange()));
                }
            }
            if (d2 != 0.0) {
                d3 = this.chart.getXLowerRange() + d2 * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
                if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                    if (d3 < this.chart.getXCurrentUpperRange()) {
                        this.chart.setXCurrentLowerRange(d3);
                    }
                    this.chart.setXCurrentLowerRange(Math.max(this.chart.getXCurrentLowerRange(), this.chart.getXLowerRange()));
                } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                    if (d3 > this.chart.getXCurrentUpperRange()) {
                        this.chart.setXCurrentLowerRange(d3);
                    }
                    this.chart.setXCurrentLowerRange(Math.min(this.chart.getXCurrentLowerRange(), this.chart.getXLowerRange()));
                }
            }
        } else if (n == 3) {
            double d4;
            if (d != 0.0) {
                d4 = this.chart.getYLowerRange() + d * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                    if (d4 > this.chart.getYCurrentLowerRange()) {
                        this.chart.setYCurrentUpperRange(d4);
                    }
                    this.chart.setYCurrentUpperRange(Math.min(this.chart.getYCurrentUpperRange(), this.chart.getYUpperRange()));
                } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                    if (d4 < this.chart.getYCurrentLowerRange()) {
                        this.chart.setYCurrentUpperRange(d4);
                    }
                    this.chart.setYCurrentUpperRange(Math.max(this.chart.getYCurrentUpperRange(), this.chart.getYUpperRange()));
                }
            }
            if (d2 != 0.0) {
                d4 = this.chart.getYLowerRange() + d2 * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
                if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                    if (d4 < this.chart.getYCurrentUpperRange()) {
                        this.chart.setYCurrentLowerRange(d4);
                    }
                    this.chart.setYCurrentLowerRange(Math.max(this.chart.getYCurrentLowerRange(), this.chart.getYLowerRange()));
                } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                    if (d4 > this.chart.getYCurrentUpperRange()) {
                        this.chart.setYCurrentLowerRange(d4);
                    }
                    this.chart.setYCurrentLowerRange(Math.min(this.chart.getYCurrentLowerRange(), this.chart.getYLowerRange()));
                }
            }
        }
    }

    private void a(int n, double d) {
        if (n == 1) {
            double d2 = d * (this.chart.getXUpperRange() - this.chart.getXLowerRange());
            if (this.chart.getXUpperRange() >= this.chart.getXLowerRange()) {
                if (d2 >= 0.0) {
                    d2 = Math.min(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange(), d2);
                } else if (this.chart.getXCurrentLowerRange() + d2 < this.chart.getXLowerRange()) {
                    d2 = this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange();
                }
            } else if (this.chart.getXUpperRange() < this.chart.getXLowerRange()) {
                if (d2 <= 0.0) {
                    d2 = Math.max(this.chart.getXUpperRange() - this.chart.getXCurrentUpperRange(), d2);
                } else if (this.chart.getXCurrentLowerRange() + d2 > this.chart.getXLowerRange()) {
                    d2 = this.chart.getXLowerRange() - this.chart.getXCurrentLowerRange();
                }
            }
            this.chart.setXCurrentUpperRange(this.chart.getXCurrentUpperRange() + d2);
            this.chart.setXCurrentLowerRange(this.chart.getXCurrentLowerRange() + d2);
        } else if (n == 3) {
            double d3 = d * (this.chart.getYUpperRange() - this.chart.getYLowerRange());
            if (this.chart.getYUpperRange() >= this.chart.getYLowerRange()) {
                if (d3 >= 0.0) {
                    d3 = Math.min(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange(), d3);
                } else if (this.chart.getYCurrentLowerRange() + d3 < this.chart.getYLowerRange()) {
                    d3 = this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange();
                }
            } else if (this.chart.getYUpperRange() < this.chart.getYLowerRange()) {
                if (d3 <= 0.0) {
                    d3 = Math.max(this.chart.getYUpperRange() - this.chart.getYCurrentUpperRange(), d3);
                } else if (this.chart.getYCurrentLowerRange() + d3 > this.chart.getYLowerRange()) {
                    d3 = this.chart.getYLowerRange() - this.chart.getYCurrentLowerRange();
                }
            }
            this.chart.setYCurrentUpperRange(this.chart.getYCurrentUpperRange() + d3);
            this.chart.setYCurrentLowerRange(this.chart.getYCurrentLowerRange() + d3);
        }
    }

    public boolean isAnyFloatingLabelsOn(int n) {
        int n2 = this.chart.getValueLabelStyle();
        int n3 = this.chart.getPlotLabelStyle();
        int n4 = this.chart.getSeriesLabelStyle();
        boolean bl = this.chart.isXValueLabelsOn(n) || this.chart.isYValueLabelsOn(n);
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = bl && n2 == 4;
        bl4 |= bl2 && (n3 == 4 || n3 == 5);
        return bl4 |= bl3 && n4 == 4;
    }
}

