/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.util.beans;

import java.lang.reflect.Method;

public class BeanUtil {
    public static final String PREFIX_GETTER_IS = "is";
    public static final String PREFIX_GETTER_GET = "get";
    public static final String PREFIX_SETTER = "set";
    public static final String PREFIX_ADDER = "add";

    public static boolean isAdder(Method method) {
        int n2 = BeanUtil.getParameterCount(method);
        if (n2 != 1) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        String string = method.getName();
        return string.startsWith(PREFIX_ADDER);
    }

    public static boolean isGetter(Method method) {
        int n2 = BeanUtil.getParameterCount(method);
        if (n2 > 0) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            return false;
        }
        String string = method.getName();
        if (!string.startsWith(PREFIX_GETTER_GET)) {
            if (!string.startsWith(PREFIX_GETTER_IS)) {
                return false;
            }
        }
        if (string.startsWith(PREFIX_GETTER_IS) && !clazz.equals(Boolean.TYPE)) {
            if (!clazz.equals(Boolean.class)) {
                return false;
            }
        }
        return true;
    }

    private static int getParameterCount(Method method) {
        return method.getParameterTypes().length;
    }

    public static boolean isSetter(Method method) {
        int n2 = BeanUtil.getParameterCount(method);
        if (n2 != 1) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        String string = method.getName();
        return string.startsWith(PREFIX_SETTER);
    }

    public static String getPropertyName(Method method) {
        String string = method.getName();
        String string2 = BeanUtil.getSubstringIfPrefixMatches(string, PREFIX_GETTER_GET);
        if (string2 == null) {
            string2 = BeanUtil.getSubstringIfPrefixMatches(string, PREFIX_SETTER);
        }
        if (string2 == null) {
            string2 = BeanUtil.getSubstringIfPrefixMatches(string, PREFIX_GETTER_IS);
        }
        if (string2 == null) {
            string2 = BeanUtil.getSubstringIfPrefixMatches(string, PREFIX_ADDER);
        }
        return BeanUtil.toLowerCamelCase(string2);
    }

    public static String toLowerCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    private static String getSubstringIfPrefixMatches(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }
}

