/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.context;

import java.io.IOException;
import java.io.Serializable;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextImpl;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class JMXContextHelper {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugJMXContext");
    private static final JMXContextAccess DEFAULT_JMXCONTEXTACCESS;
    private static JMXContextAccess SINGLETON;

    public static JMXContext getJMXContext(boolean bl) {
        return SINGLETON.getJMXContext(bl);
    }

    public static void putJMXContext(JMXContext jMXContext) {
        SINGLETON.putJMXContext(jMXContext);
    }

    public static void removeJMXContext() {
        SINGLETON.removeJMXContext();
    }

    public static synchronized void setJMXContextAccess(JMXContextAccess jMXContextAccess) {
        if (!KernelStatus.isServer() || SINGLETON != DEFAULT_JMXCONTEXTACCESS || jMXContextAccess == null) {
            return;
        }
        SINGLETON = jMXContextAccess;
    }

    static {
        SINGLETON = DEFAULT_JMXCONTEXTACCESS = new DefaultJMXContextAccessImpl();
    }

    private static class DefaultJMXContextAccessImpl
    implements JMXContextAccess {
        private DefaultJMXContextAccessImpl() {
        }

        public JMXContext getJMXContext(boolean bl) {
            WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
            SerializableWorkContext serializableWorkContext = (SerializableWorkContext)workContextMap.get("weblogic.management.JMXContext");
            JMXContext jMXContext = null;
            if (serializableWorkContext != null) {
                jMXContext = (JMXContext)serializableWorkContext.get();
            }
            if (bl && jMXContext == null) {
                jMXContext = new JMXContextImpl();
            }
            return jMXContext;
        }

        public void putJMXContext(JMXContext jMXContext) {
            block4: {
                WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                try {
                    workContextMap.put("weblogic.management.JMXContext", PrimitiveContextFactory.create((Serializable)jMXContext));
                }
                catch (PropertyReadOnlyException propertyReadOnlyException) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.getJMXContext(): WorkContext property is read-only: " + propertyReadOnlyException.getStackTrace());
                    }
                }
                catch (IOException iOException) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block4;
                    DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.getJMXContext(): IOException: " + iOException.getStackTrace());
                }
            }
        }

        public void removeJMXContext() {
            block5: {
                try {
                    WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                    WorkContext workContext = workContextMap.get("weblogic.management.JMXContext");
                    if (workContext != null) {
                        workContextMap.remove("weblogic.management.JMXContext");
                    }
                }
                catch (NoWorkContextException noWorkContextException) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.removeJMXContext(): No WorkContext is available: " + noWorkContextException.getMessage());
                    }
                }
                catch (PropertyReadOnlyException propertyReadOnlyException) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block5;
                    DEBUG_LOGGER.debug("DefaultJMXContextAccessImpl.removeJMXContext(): WorkContext property is read-only: " + propertyReadOnlyException.getMessage());
                }
            }
        }
    }

    public static interface JMXContextAccess {
        public JMXContext getJMXContext(boolean var1);

        public void putJMXContext(JMXContext var1);

        public void removeJMXContext();
    }
}

