/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxFloat
extends IfxObject {
    private double value;

    IfxFloat() throws SQLException {
        this.setIfxType(3);
    }

    IfxFloat(double d2) throws SQLException {
        this.setIfxType(3);
        this.value = d2;
        this.unnullify();
    }

    IfxFloat(Double d2) throws SQLException {
        this.setIfxType(3);
        if (d2 != null) {
            this.value = d2;
            this.unnullify();
        }
    }

    IfxFloat(float f2) throws SQLException {
        this.setIfxType(3);
        this.value = f2;
        this.unnullify();
    }

    IfxFloat(Float f2) throws SQLException {
        this.setIfxType(3);
        if (f2 != null) {
            this.value = f2.floatValue();
            this.unnullify();
        }
    }

    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[8];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) {
        boolean bl = true;
        bl = IfxFloat.isIfxNull(byArray, n, n2);
        if (!bl) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(byArray, n);
        } else {
            this.nullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxFloat) {
            IfxFloat ifxFloat = (IfxFloat)object;
            if (ifxFloat.isNull()) {
                return false;
            }
            return this.value == ifxFloat.value;
        }
        return false;
    }

    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        byte by = this.isNull() ? (byte)0 : (byte)this.value;
        return by;
    }

    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.doubleValue();
            this.unnullify();
        }
    }

    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public void fromDouble(double d2) throws SQLException {
        this.value = d2;
        this.unnullify();
    }

    public void fromDouble(Double d2) throws SQLException {
        if (d2 == null) {
            this.nullify();
        } else {
            this.value = d2;
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.value;
        return s;
    }

    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.doubleValue();
            this.unnullify();
        }
    }

    public int toInt() throws SQLException {
        this.clearWarning();
        int n = this.isNull() ? 0 : (int)this.value;
        return n;
    }

    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.doubleValue();
            this.unnullify();
        }
    }

    public long toLong() throws SQLException {
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        return l;
    }

    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.doubleValue();
            this.unnullify();
        }
    }

    public float toFloat() throws SQLException {
        this.clearWarning();
        float f2 = this.isNull() ? 0.0f : (float)this.value;
        return f2;
    }

    public void fromFloat(float f2) throws SQLException {
        this.value = f2;
        this.unnullify();
    }

    public void fromFloat(Float f2) throws SQLException {
        if (f2 == null) {
            this.nullify();
        } else {
            this.value = f2.doubleValue();
            this.unnullify();
        }
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.doubleValue();
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        boolean bl = this.isNull() ? false : this.value != 0.0;
        return bl;
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    public String toString() {
        String string = this.isNull() ? null : Double.toString(this.value);
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            try {
                this.value = Double.valueOf(string.trim());
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    static boolean isIfxNull(double d2) {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d2);
        return IfxFloat.isIfxNull(byArray);
    }

    static boolean isIfxNull(byte[] byArray) {
        return IfxFloat.isIfxNull(byArray, 0, byArray.length);
    }

    static boolean isIfxNull(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 8) {
            if (byArray[n3 + n] != -1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] byArray = new byte[8];
        double d2 = 0.0;
        int n = 0;
        while (n < 8) {
            byArray[n] = -1;
            d2 = IfxToJavaType.IfxToJavaDouble(byArray);
            ++n;
        }
        return d2;
    }
}

