/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxDecimal
extends IfxObject {
    private BigDecimal value = null;
    private short encodedLength = 0;
    protected short dec_exp = 0;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts = 0;
    protected byte[] dec_dgts;
    public static final String digChar = "0123456789";
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    public static final short BYTESHIFT = 8;
    public static final short BYTEMASK = 255;
    public static final short BYTESIGNED = 128;
    public static final short BYTEMASK7 = 127;
    private static final short DEFAULT_DOUBLE_SCALE = 15;
    private static final short DEFAULT_FLOAT_SCALE = 6;

    public IfxDecimal() throws SQLException {
        this.setIfxType(5);
    }

    public IfxDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal;
            this.unnullify();
        }
    }

    public IfxDecimal(byte[] byArray) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        this.convBigDecimal(byArray, 0, byArray.length);
    }

    public byte[] toIfx() {
        if (this.value == null) {
            byte[] byArray = new byte[4];
            IfxDecimal.byfill(byArray, (byte)0);
            this.nullify();
            return byArray;
        }
        this.convFromBigDecimal(this.value);
        this.unnullify();
        return this.convIfx(true);
    }

    public byte[] toIfxTuple() {
        if (this.value == null) {
            int n = ((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
            byte[] byArray = new byte[n];
            IfxDecimal.byfill(byArray, (byte)0);
            this.nullify();
            return byArray;
        }
        this.convFromBigDecimal(this.value);
        this.unnullify();
        return this.convIfx(false);
    }

    public void fromIfx(byte[] byArray, short s) {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    public void fromIfx(byte[] byArray, int n, int n2, short s) {
        this.encodedLength = s;
        this.convBigDecimal(byArray, n, n2);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value.doubleValue();
    }

    public void fromByte(Byte by) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
        }
    }

    public void fromByte(Byte by, int n) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
            this.value = this.value.setScale(n, 4);
        }
    }

    public void fromByte(byte by) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)by);
        this.unnullify();
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value.doubleValue();
    }

    public void fromShort(Short s) throws SQLException {
        this.encodedLength = (short)1280;
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    public void fromShort(Short s, int n) throws SQLException {
        this.encodedLength = (short)(1280 + n);
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
            this.value = this.value.setScale(n, 4);
        }
    }

    public void fromShort(short s) throws SQLException {
        this.encodedLength = (short)1280;
        this.value = new BigDecimal((double)s);
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value.intValue();
    }

    public void fromInt(Integer n) throws SQLException {
        this.encodedLength = (short)2560;
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
        }
    }

    public void fromInt(Integer n, int n2) throws SQLException {
        this.encodedLength = (short)(2560 + n2);
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
            this.value = this.value.setScale(n2, 4);
        }
    }

    public void fromInt(int n) throws SQLException {
        this.encodedLength = (short)2560;
        this.value = new BigDecimal((double)n);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.longValue();
    }

    public void fromLong(Long l) throws SQLException {
        this.encodedLength = (short)4864;
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    public void fromLong(Long l, int n) throws SQLException {
        this.encodedLength = (short)(4864 + n);
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
            this.value = this.value.setScale(n, 4);
        }
    }

    public void fromLong(long l) throws SQLException {
        this.encodedLength = (short)4864;
        this.value = new BigDecimal(Long.toString(l));
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public void fromFloat(Float f2) throws SQLException {
        this.encodedLength = 0;
        if (f2 == null) {
            this.nullify();
        } else {
            this.fromFloat(f2.floatValue());
        }
    }

    public void fromFloat(Float f2, int n) throws SQLException {
        this.encodedLength = 0;
        if (f2 == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(f2.toString());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    public void fromFloat(float f2) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Float.toString(f2));
        this.value = this.value.setScale(6, 4);
        this.unnullify();
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    public void fromDouble(Double d2) throws SQLException {
        this.encodedLength = 0;
        if (d2 == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d2);
        }
    }

    public void fromDouble(Double d2, int n) throws SQLException {
        this.encodedLength = 0;
        if (d2 == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(d2.toString());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    public void fromDouble(double d2) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Double.toString(d2));
        this.value = this.value.setScale(15, 4);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal;
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.setScale(n, 4);
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal bigDecimal, int n, short s) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.setScale(n, 4);
            this.encodedLength = s;
            this.unnullify();
        }
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.intValue() != 0;
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
        }
    }

    public void fromBoolean(Boolean bl, int n) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
            this.value = this.value.setScale(n, 4);
        }
    }

    public void fromBoolean(boolean bl) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)(bl ? 1 : 0));
        this.unnullify();
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    public void fromString(String string) throws SQLException {
        this.encodedLength = 0;
        if (string == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(string.trim());
            this.unnullify();
        }
    }

    public void fromString(String string, int n) throws SQLException {
        this.encodedLength = 0;
        if (string == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(string.trim());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxDecimal && this.value.equals(((IfxDecimal)object).value);
    }

    public short getEncodedLength() {
        if (this.encodedLength == 0 && !this.isNull) {
            this.computeEncodedLength();
            return this.encodedLength;
        }
        return this.encodedLength;
    }

    public void setEncodedLength(int n) {
        this.encodedLength = (short)n;
    }

    private void convBigDecimal(byte[] byArray, int n, int n2) {
        String string;
        int n3 = n;
        if (byArray[n3] == 0 && byArray[n3 + 1] == 0) {
            this.value = null;
            return;
        }
        this.dec_ndgts = n == 0 ? (short)(n2 - n3 - 1) : (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        this.dec_dgts = new byte[this.dec_ndgts];
        IfxDecimal.bycopy(byArray, n3 + 1, this.dec_dgts, 0);
        short s = byArray[n3];
        this.dec_pos = 1;
        if ((s & 0x80) == 0) {
            IfxDecimal.decComplement(this.dec_dgts, 0);
            s = (short)(s ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = s = (short)((s & 0x7F) - 64);
        int[] nArray = new int[1];
        if (this.encodedLength != 0) {
            nArray[0] = IfxDecimal.precDec(this.encodedLength);
            if (nArray[0] == 255) {
                nArray[0] = -1;
            }
        } else {
            nArray[0] = -1;
        }
        this.value = (string = this.stringValue(nArray)) == null ? null : new BigDecimal(new BigInteger(string), nArray[0]);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    private void convFromBigDecimal(BigDecimal bigDecimal) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.dec_pos = 1;
        String string = bigDecimal.unscaledValue().toString();
        int n4 = bigDecimal.scale();
        int n5 = string.length();
        char c2 = string.charAt(0);
        if (c2 == '-') {
            this.dec_pos = 0;
            ++n;
            --n5;
        } else if (c2 == '+') {
            ++n;
            --n5;
        }
        n2 = n5 - n4;
        if (n2 % 2 != 0) {
            ++n5;
            this.dec_exp = (short)((n2 + 1) / 2);
            n3 = 1;
            bl = true;
        } else {
            this.dec_exp = (short)(n2 / 2);
        }
        byte[] byArray = new byte[n5];
        IfxDecimal.byfill(byArray, (byte)0);
        int n6 = n;
        while (n6 < string.length()) {
            int n7 = digChar.indexOf(string.charAt(n6));
            byArray[n3] = (byte)n7;
            ++n3;
            ++n6;
        }
        n5 = (byArray = this.adjust(byArray, bl, n, string, bigDecimal)).length;
        this.dec_ndgts = n5 % 2 == 1 ? (short)(n5 / 2 + 1) : (short)(n5 / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        int n8 = 0;
        while (n8 < n5 / 2) {
            this.dec_dgts[n8] = (byte)(byArray[2 * n8] * 10 + byArray[2 * n8 + 1]);
            ++n8;
        }
        if (n5 % 2 == 1) {
            this.dec_dgts[n8] = (byte)(byArray[2 * n8] * 10);
        }
        if (this.encodedLength == 0) {
            this.computeEncodedLength();
        } else {
            this.dec_ndgts = (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        }
    }

    private byte[] adjust(byte[] byArray, boolean bl, int n, String string, BigDecimal bigDecimal) {
        int n2;
        int n3;
        int n4 = 0;
        if (this.encodedLength != 0) {
            n3 = IfxDecimal.precTot(this.encodedLength);
            n2 = n3 / 2;
            if (n3 % 2 == 1) {
                ++n2;
            }
            n4 = IfxDecimal.precDec(this.encodedLength) / 2;
        } else {
            n3 = 32;
            n2 = 16;
        }
        byte[] byArray2 = byArray;
        int n5 = bl ? byArray.length - 1 : byArray.length;
        if (n5 > n3) {
            BigInteger bigInteger = bigDecimal.unscaledValue().abs();
            BigInteger bigInteger2 = new BigInteger("10");
            BigInteger bigInteger3 = new BigInteger("1");
            int n6 = 0;
            while (n6 < n5 - n3) {
                bigInteger3 = bigInteger3.multiply(bigInteger2);
                ++n6;
            }
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger3);
            int n7 = 0;
            int n8 = 0;
            if (bl) {
                ++n8;
            }
            if (byArray.length > n3 + n8) {
                n7 = byArray[n3 + n8];
            }
            n7 *= 10;
            if (byArray.length > n3 + n8 + 1) {
                n7 += byArray[n3 + n8 + 1];
            }
            if (n7 >= 50) {
                bigIntegerArray[0] = bigIntegerArray[0].add(new BigInteger("1"));
            }
            String string2 = bigIntegerArray[0].toString();
            int n9 = 0;
            if (bl || string.charAt(n) == '0') {
                ++n9;
            }
            byte[] byArray3 = null;
            byArray3 = bl ? new byte[n3 + 1] : new byte[n3];
            IfxDecimal.byfill(byArray3, (byte)0);
            int n10 = 0;
            while (n10 < string2.length()) {
                int n11 = digChar.indexOf(string2.charAt(n10));
                if (n11 != -1) {
                    byArray3[n9] = (byte)n11;
                }
                ++n10;
                ++n9;
            }
            byArray2 = byArray3;
        } else if (byArray.length < n3 && n4 != 0 && this.encodedLength != 0) {
            byArray2 = new byte[n3];
            IfxDecimal.byfill(byArray2, (byte)0);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    protected void computeEncodedLength() {
        if (this.dec_ndgts == 0 || this.dec_pos == -1) {
            this.encodedLength = 0;
            return;
        }
        int n = 2 * (this.dec_ndgts - this.dec_exp);
        int n2 = 2 * this.dec_ndgts;
        if (this.dec_dgts[this.dec_ndgts - 1] % 10 == 0) {
            --n;
            --n2;
        }
        if (this.dec_dgts[0] < 10) {
            --n2;
        }
        if (n < 0) {
            n2 += -n;
            n = 0;
        }
        this.encodedLength = (short)(((byte)n2 << 8) + n);
    }

    protected int extractExponent(String string, int n) {
        int n2 = 0;
        boolean bl = true;
        int n3 = n;
        while (n3 < string.length() && string.charAt(n3) != 'E') {
            ++n3;
        }
        if (n3 == string.length()) {
            return n2;
        }
        if (string.charAt(++n3) == '+') {
            ++n3;
        } else if (string.charAt(n3) == '-') {
            ++n3;
            bl = false;
        }
        int n4 = n3;
        while (n4 < string.length()) {
            n2 = n2 * 10 + digChar.indexOf(string.charAt(n4));
            ++n4;
        }
        return bl ? n2 : -n2;
    }

    private byte[] convIfx(boolean bl) {
        int n = bl ? 2 : 0;
        byte[] byArray = new byte[this.dec_ndgts + 1 + n];
        boolean bl2 = false;
        IfxDecimal.byfill(byArray, (byte)0);
        if (bl) {
            int n2 = this.dec_ndgts + 1;
            byArray[0] = (byte)(n2 >> 8 & 0xFF);
            byArray[1] = (byte)(n2 & 0xFF);
        }
        if (this.dec_pos == -1) {
            return byArray;
        }
        byArray[n] = (byte)(this.dec_exp + 64 & 0x7F);
        IfxDecimal.bycopy(this.dec_dgts, 0, byArray, n + 1);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x80);
            } else {
                IfxDecimal.decComplement(byArray, 1 + n);
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 0x7F);
            }
        } else {
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] | 0x80);
        }
        return byArray;
    }

    private static byte[] byfill(byte[] byArray, byte by) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return byArray;
    }

    private static char[] charfill(char[] cArray, int n, int n2, char c2) {
        int n3 = n;
        while (n3 <= n2 && n3 < cArray.length) {
            cArray[n3] = c2;
            ++n3;
        }
        return cArray;
    }

    private static void bycopy(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        int n4 = n;
        while (n4 < byArray.length && n3 < byArray2.length) {
            byArray2[n3] = byArray[n4];
            ++n4;
            ++n3;
        }
    }

    private static void charcopy(char[] cArray, int n, int n2, char[] cArray2, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < cArray.length && n5 <= n2 && n4 < cArray2.length) {
            cArray2[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
    }

    private static byte[] decComplement(byte[] byArray, int n) {
        int n2 = 100;
        int n3 = byArray.length - 1;
        while (n3 >= n) {
            if (byArray[n3] != 0 || n2 != 100) {
                byArray[n3] = (byte)(n2 - byArray[n3]);
                n2 = 99;
            }
            --n3;
        }
        return byArray;
    }

    private char[] sigdigToChar() {
        char[] cArray = new char[this.dec_ndgts * 2];
        int n = 0;
        while (n < this.dec_ndgts) {
            cArray[n * 2] = digChar.charAt(this.dec_dgts[n] / 10);
            cArray[n * 2 + 1] = digChar.charAt(this.dec_dgts[n] % 10);
            ++n;
        }
        return cArray;
    }

    private String stringValue(int[] nArray) {
        char[] cArray;
        int n;
        int n2;
        if (this.dec_pos == -1) {
            return null;
        }
        if (this.dec_ndgts <= 0) {
            if (nArray[0] == -1) {
                nArray[0] = 0;
            }
            return "0";
        }
        int n3 = this.dec_exp * 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (nArray[0] == -1) {
            if (n2 > n3) {
                for (n2 = this.dec_ndgts * 2; n2 > 0; n2 -= 2) {
                    if (n2 > n3 + 1 && this.dec_dgts[n2 / 2 - 1] == 0) {
                        continue;
                    }
                    if (n2 < n3 + 1 || this.dec_dgts[n2 / 2 - 1] % 10 != 0) break;
                    --n2;
                    break;
                }
                if (n2 <= 0) {
                    nArray[0] = 0;
                    return "0";
                }
                nArray[0] = n2 - n3;
            } else {
                nArray[0] = 0;
                n5 = n3 - n2;
            }
            n = n2 + n5;
        } else if (nArray[0] == n2 - n3) {
            n = n2;
        } else if (nArray[0] > n2 - n3) {
            n5 = nArray[0] - (n2 - n3);
            if (n3 < 0) {
                n6 = -n3;
                n = nArray[0];
            } else {
                n = n2 + n5;
            }
        } else if (n3 >= 0) {
            n = n3 + nArray[0];
            bl = true;
        } else {
            if (-n3 > nArray[0]) {
                return "0";
            }
            n = nArray[0];
            n6 = -n3;
            bl = true;
        }
        if (this.dec_pos == 0) {
            cArray = new char[1 + n];
            cArray[0] = 45;
            n4 = 1;
        } else {
            cArray = new char[n];
        }
        if (n6 > 0) {
            IfxDecimal.charfill(cArray, n4, n4 + n6 - 1, '0');
        }
        int n7 = 0;
        while (n7 < this.dec_ndgts && n4 + n6 + n7 * 2 + 1 < cArray.length) {
            cArray[n4 + n6 + n7 * 2] = digChar.charAt(this.dec_dgts[n7] / 10);
            cArray[n4 + n6 + n7 * 2 + 1] = digChar.charAt(this.dec_dgts[n7] % 10);
            ++n7;
        }
        if (n4 + n6 + n7 * 2 < cArray.length && n7 < this.dec_ndgts) {
            cArray[n4 + n6 + n7 * 2] = digChar.charAt(this.dec_dgts[n7] / 10);
        }
        if (n5 > 0) {
            IfxDecimal.charfill(cArray, n4 + n6 + n2, cArray.length - 1, '0');
        } else if (bl) {
            boolean bl2 = false;
            if (n4 + n6 + n7 * 2 < cArray.length) {
                if (this.dec_dgts[n7] % 10 >= 5) {
                    if (this.dec_dgts[n7] / 10 == 9) {
                        cArray[n4 + n6 + n7 * 2] = 48;
                        bl2 = true;
                    } else {
                        cArray[n4 + n6 + n7 * 2] = digChar.charAt(digChar.indexOf(cArray[n4 + n6 + n7 * 2]) + 1);
                    }
                }
            } else if (this.dec_dgts[n7] / 10 >= 5) {
                bl2 = true;
            }
            if (bl2) {
                int n8 = n4 + n6 + (n7 - 1) * 2 + 1;
                while (n8 >= n4) {
                    if (cArray[n8] != '9') {
                        cArray[n8] = digChar.charAt(digChar.indexOf(cArray[n8]) + 1);
                        break;
                    }
                    cArray[n8] = 48;
                    --n8;
                }
                if (n8 < n4) {
                    char[] cArray2 = new char[cArray.length + 1];
                    int n9 = 0;
                    if (n4 == 1) {
                        cArray2[n9++] = 45;
                    }
                    cArray2[n9++] = 49;
                    while (n9 < cArray2.length) {
                        cArray2[n9] = 48;
                        ++n9;
                    }
                    return new String(cArray2);
                }
            }
        }
        return new String(cArray);
    }

    private static char[] trimZerosFB(char[] cArray, int n) {
        int n2 = n;
        while (n2 < cArray.length && cArray[n2] == '0') {
            ++n2;
        }
        if (n2 == cArray.length) {
            char[] cArray2 = new char[2];
            cArray2[1] = 48;
            return cArray2;
        }
        int n3 = cArray.length - 1;
        while (n3 >= n2 && cArray[n3] == '0') {
            --n3;
        }
        char[] cArray3 = new char[n3 - n2 + 2];
        int n4 = 1;
        int n5 = n2;
        while (n5 <= n3) {
            cArray3[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
        return cArray3;
    }

    protected static int precTot(int n) {
        return n >> 8 & 0xFF;
    }

    protected static int precDec(int n) {
        return n & 0xFF;
    }

    protected static int decLength(int n) {
        int n2 = IfxDecimal.precTot(n);
        int n3 = IfxDecimal.precDec(n);
        int n4 = (n2 + (n3 & 1) + 3) / 2;
        return n4;
    }

    protected static String getIfxTypeName(int n) {
        int n2 = IfxDecimal.precDec(n);
        if (n2 == 255) {
            return "decimal(16)";
        }
        return "decimal(" + IfxDecimal.precTot(n) + ", " + n2 + ")";
    }
}

