/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;

public class IfxArray
implements java.sql.Array {
    private Map typeMap = null;
    private IfxComplexInput inputStream = null;
    private IfxComplexOutput outputStream = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private IfxColumnInfo elementInfo = null;
    private Vector elementInfoVector = null;
    private int JDBCType = 0;
    private int IfxType = 0;
    private boolean typeMappingNeeded = false;
    private int elementCount = -1;
    Object value;

    IfxArray(byte[] byArray, Vector vector, IfxConnection ifxConnection) throws SQLException {
        this.inputStream = new IfxComplexInput(byArray, 0, byArray.length, vector, false, ifxConnection);
        this.outputStream = new IfxComplexOutput(false, false);
        this.outputStream.setConnection(ifxConnection);
        this.setConnection(ifxConnection);
        Vector vector2 = ((IfxColumnInfo)vector.get((int)0)).child;
        this.elementInfo = (IfxColumnInfo)vector2.get(0);
        this.IfxType = this.elementInfo.SQLtype;
        if (IfxTypes.isUDT(this.IfxType)) {
            if (this.elementInfo.ExtendedId == 1) {
                this.IfxType = 43;
                this.JDBCType = -1;
            } else if (this.elementInfo.ExtendedId == 10) {
                this.IfxType = 102;
                this.JDBCType = 2004;
            } else if (this.elementInfo.ExtendedId == 11) {
                this.IfxType = 101;
                this.JDBCType = 2005;
            } else if (this.elementInfo.ExtendedId == 5) {
                this.IfxType = 45;
                this.JDBCType = IfxDriver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
            } else {
                this.JDBCType = 2000;
            }
        } else if (this.IfxType == 14) {
            this.JDBCType = 1111;
        } else if (this.IfxType == 10) {
            byte by = IfxDateTime.getStartCode((short)this.elementInfo.ColLength);
            this.JDBCType = by >= 6 ? 92 : 93;
        } else {
            this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
            if (this.IfxType == 4 && !ifxConnection.getMapReal()) {
                this.JDBCType = 6;
            }
        }
        this.setTypeMappingNeeded(vector2);
    }

    IfxArray(Object object, IfxConnection ifxConnection) throws SQLException {
        this.value = object;
        if (!object.getClass().isArray()) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxArray(Object, Connection) object isn't an array", ifxConnection);
        }
        this.setConnection(ifxConnection);
        Class<?> clazz = object.getClass().getComponentType();
        String string = null;
        if (clazz.isPrimitive()) {
            string = clazz.getName();
            if (string.equals("short")) {
                this.JDBCType = 5;
                this.IfxType = 1;
            } else if (string.equals("int")) {
                this.JDBCType = 4;
                this.IfxType = 2;
            } else if (string.equals("float")) {
                this.JDBCType = 6;
                this.IfxType = 4;
            } else if (string.equals("double")) {
                this.JDBCType = 8;
                this.IfxType = 3;
            } else if (string.equals("boolean")) {
                this.JDBCType = IfxDriver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
                this.IfxType = 45;
            } else if (string.equals("long")) {
                this.JDBCType = -5;
                this.IfxType = 17;
            }
        } else {
            string = clazz.getName();
            if (string.equals("java.lang.timestamp")) {
                this.JDBCType = 93;
                this.IfxType = 10;
            } else if (string.equals("java.lang.time")) {
                this.JDBCType = 92;
                this.IfxType = 10;
            } else if (string.equals("boolean")) {
                this.JDBCType = IfxDriver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
                this.IfxType = 45;
            } else {
                this.IfxType = IfxTypes.FromJavaToIfxType(string);
                if (this.IfxType == 49) {
                    if (((Object[])object).length > 0) {
                        IfxUDTInfo ifxUDTInfo;
                        Object object2 = ((Object[])object)[0];
                        if (object2 != null && object2 instanceof SQLData && (ifxUDTInfo = ifxConnection.getUDTInfo((IfxColumnInfo)null, object2.getClass().getName())) != null) {
                            this.JDBCType = ifxUDTInfo.JDBCtype;
                            if (this.JDBCType == 2002) {
                                this.IfxType = 22;
                            } else if (this.JDBCType == 2000) {
                                this.IfxType = 40;
                            } else if (this.JDBCType == 2001) {
                                this.IfxType = ifxUDTInfo.source;
                            }
                        }
                    } else {
                        this.IfxType = 40;
                        this.JDBCType = 2000;
                    }
                } else {
                    this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
                    if (this.IfxType == 4 && !ifxConnection.getMapReal()) {
                        this.JDBCType = 6;
                    }
                }
            }
        }
        this.typeMappingNeeded = false;
    }

    void setTypeMappingNeeded(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(n2);
            int n3 = IfxTypes.FromIfxToJDBCType(ifxColumnInfo.SQLtype);
            if (ifxColumnInfo.SQLtype == 4 && !this.conn.getMapReal()) {
                n3 = 6;
            }
            if (n3 == 2003 || n3 == 2001 || n3 == 2000 || n3 == 2001 || n3 == 1111 || n3 == 2002) {
                this.typeMappingNeeded = true;
                return;
            }
            if (ifxColumnInfo.child != null) {
                this.setTypeMappingNeeded(ifxColumnInfo.child);
            }
            ++n2;
        }
    }

    private void clear() {
        this.value = null;
        this.elementCount = -1;
        this.outputStream.reset();
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, ifxConnection);
        }
    }

    public String getBaseTypeName() throws SQLException {
        String string = null;
        if (this.IfxType != 40 && this.IfxType != 41) {
            string = IfxTypes.IfxTypeToName(this.IfxType);
        } else {
            Class clazz;
            string = new String("unknown");
            if (this.typeMap != null && this.elementInfo != null && this.elementInfo.ExtendedName != null && (clazz = (Class)this.typeMap.get(this.elementInfo.ExtendedName)) != null) {
                string = clazz.getName();
            }
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        return string;
    }

    public int getBaseType() throws SQLException {
        return this.JDBCType;
    }

    public Object getArray() throws SQLException {
        return this.getArray((Map)this.conn.getTypeMap());
    }

    public Object getArray(Map map) throws SQLException {
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.value;
        }
        this.typeMap = map;
        this.inputStream.setTypeMap(this.typeMap);
        this.inputStream.reset();
        this.value = this.inputStream.readArrayElements(this.JDBCType);
        this.elementCount = -1;
        return this.value;
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.getArray(l, n, (Map)this.conn.getTypeMap());
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.getSubArray(l, n);
        }
        this.getArray(map);
        return this.getSubArray(l, n);
    }

    private Object getSubArray(long l, int n) throws SQLException {
        Object object;
        this.verifyIndexCount(l, n);
        --l;
        try {
            object = Array.newInstance(this.value.getClass().getComponentType(), n);
            System.arraycopy(this.value, (int)l, object, 0, n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return object;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet((Map)this.conn.getTypeMap());
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        Object object = this.getArray(map);
        return this.setResultSet(object);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, (Map)this.conn.getTypeMap());
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        Object object = this.getArray(l, n, map);
        return this.setResultSet(object);
    }

    private ResultSet setResultSet(Object object) throws SQLException {
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(2, this.conn);
        ifxResultSetMetaData.setEncodedLength(1, 8);
        ifxResultSetMetaData.setNullable(1, 0);
        ifxResultSetMetaData.setMaxWidth(1, 8);
        ifxResultSetMetaData.setColtitle(1, "Index");
        ifxResultSetMetaData.setColumnName(1, "Index");
        ifxResultSetMetaData.setIfxColumnType(1, 17);
        ifxResultSetMetaData.setEncodedLength(2, this.elementInfo.ColLength);
        ifxResultSetMetaData.setNullable(2, this.elementInfo.Nullable);
        ifxResultSetMetaData.setMaxWidth(2, this.elementInfo.MaxWidth);
        ifxResultSetMetaData.setColtitle(2, this.elementInfo.Coltitle);
        ifxResultSetMetaData.setColumnName(2, this.elementInfo.ColName);
        ifxResultSetMetaData.setRightDecimal(2, this.elementInfo.RightDecimal);
        ifxResultSetMetaData.setIfxColumnType(2, this.elementInfo.SQLtype);
        ifxResultSetMetaData.setColumnExtendedId(2, this.elementInfo.ExtendedId);
        ifxResultSetMetaData.setDistinct(2, this.elementInfo.IsDistinct);
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        this.loadResultSet(ifxClientResultSet, object);
        return ifxClientResultSet;
    }

    private void loadResultSet(IfxClientResultSet ifxClientResultSet, Object object) throws SQLException {
        long l;
        long l2 = l = object == null ? 0L : (long)Array.getLength(object);
        if (l > 0L) {
            ifxClientResultSet.newRow((int)l);
            int n = 0;
            while ((long)n < l) {
                ifxClientResultSet.updateLong(n + 1, 1, (long)(n + 1));
                ifxClientResultSet.updateObject(n + 1, 2, Array.get(object, n));
                ++n;
            }
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setType(1003);
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
    }

    private void verifyIndexCount(long l, int n) throws SQLException {
        if (this.elementCount == -1) {
            if (!this.value.getClass().getComponentType().isPrimitive()) {
                this.elementCount = ((Object[])this.value).length;
            } else {
                switch (this.IfxType) {
                    case 2: {
                        this.elementCount = ((int[])this.value).length;
                        break;
                    }
                    case 1: {
                        this.elementCount = ((short[])this.value).length;
                        break;
                    }
                    case 17: {
                        this.elementCount = ((long[])this.value).length;
                        break;
                    }
                    case 4: {
                        this.elementCount = ((float[])this.value).length;
                        break;
                    }
                    case 3: {
                        this.elementCount = ((double[])this.value).length;
                        break;
                    }
                    case 45: {
                        this.elementCount = ((boolean[])this.value).length;
                        break;
                    }
                    default: {
                        this.elementCount = ((Object[])this.value).length;
                    }
                }
            }
        }
        if (l < 1L || l + (long)n > (long)(this.elementCount + 1)) {
            throw IfxErrMsg.getSQLException(-79781, this.conn);
        }
    }
}

