/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartSample;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class BarChart
extends Chart {
    public static final int SIDE_BY_SIDE_BARS = 0;
    public static final int STACKED_BARS = 1;
    public static final int BEHIND_BARS = 2;
    public static final int BLOCK = 0;
    public static final int CYLINDER = 1;
    private Color[] aL;
    private boolean aI;
    private boolean aJ;
    private Color aO;
    private boolean aM;
    private double aP;
    private int aN;
    private int aK;

    public BarChart() {
        this(1);
    }

    public BarChart(int n) {
        this(n, 100.0);
    }

    public BarChart(int n, double d) {
        this(n, d, 0.0);
    }

    public BarChart(int n, double d, double d2) {
        this(1, n, d, d2);
    }

    public BarChart(int n, int n2, double d, double d2) {
        super(n2);
        this.renderer = new BarChartRenderer(this);
        this.chartType = "bar";
        this.aL = new Color[n2];
        this.setAutomaticRepaintOn(false);
        this.setSeriesCount(n);
        this.grid.setRange(0, d);
        this.grid.setLowerRange(0, d2);
        this.grid.setCurrentRange(0, d);
        this.grid.setCurrentLowerRange(0, d2);
        this.aI = false;
        this.S = 1;
        this.R = 1;
        this.Z = 1;
        this.aJ = true;
        this.aM = false;
        this.aP = 0.4;
        this.aN = 0;
        this.u = false;
        this.aO = null;
        this.T = false;
        this.setAutomaticRepaintOn(true);
    }

    public void reset() {
        super.reset();
        this.aI = false;
        this.Z = 1;
        this.R = 1;
        this.S = 1;
        this.aJ = true;
        this.aM = false;
        this.aP = 0.4;
        this.aN = 0;
        this.u = false;
        this.aO = null;
        this.T = false;
    }

    protected double getHighestValue(int n) {
        if (this.aN == 1 && this.getSeriesRange(0) == n) {
            double d = super.getHighestValue(n);
            int n2 = this.getSampleCount();
            int n3 = this.getSeriesCount();
            for (int i = 0; i < n2; ++i) {
                double d2 = 0.0;
                for (int j = 0; j < n3; ++j) {
                    ChartSample chartSample = this.getSample(j, i);
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value > 0.0)) continue;
                    d2 += chartSample.value.doubleValue();
                }
                d = Math.max(d, d2);
            }
            return d;
        }
        return super.getHighestValue(n);
    }

    protected double getLowestValue(int n) {
        if (this.aN == 0) {
            return super.getLowestValue(n);
        }
        double d = super.getLowestValue(n);
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n3; ++j) {
                ChartSample chartSample = this.getSample(j, i);
                if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || !(chartSample.value < 0.0)) continue;
                d2 += chartSample.value.doubleValue();
            }
            d = Math.min(d, d2);
        }
        return d;
    }

    public int getValuePosition(double d) {
        return this.grid.a(0, d, this.getGraphBounds());
    }

    public void setMultiColorOn(boolean bl) {
        if (bl != this.aI) {
            this.aI = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiColorOn() {
        return this.aI;
    }

    public void setBarLabels(String[] stringArray) {
        this.X = stringArray;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public String[] getBarLabels() {
        if (this.X != null) {
            return this.X;
        }
        return this.getSampleLabels();
    }

    public void setBarLabelsOn(boolean bl) {
        this.ag = bl;
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public boolean isBarLabelsOn() {
        return this.ag;
    }

    public synchronized void setBarLabelColor(int n, Color color) {
        try {
            this.aL[n] = color;
            this.autoRepaint();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid sample index: " + n);
        }
    }

    public Color getBarLabelColor(int n) {
        if (this.X != null && n < this.aL.length) {
            return this.aL[n];
        }
        return null;
    }

    public void setBarOutlineOn(boolean bl) {
        if (this.aJ != bl) {
            this.aJ = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isBarOutlineOn() {
        return this.aJ;
    }

    public void setBarOutlineColor(Color color) {
        if (color != this.aO) {
            this.aO = color;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public Color getBarOutlineColor() {
        return this.aO;
    }

    public void setBarAlignment(int n) {
        this.grid.setGridAlignment(n);
        this.needRender = true;
        this.needGraphBounds = true;
        this.needChartCalculation = true;
        this.autoRepaint();
    }

    public int getGridAlignment() {
        return this.grid.getGridAlignment();
    }

    public void setBarType(int n) {
        if (n != this.aN) {
            if (n == 0 || n == 1 || n == 2) {
                this.aN = n;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar type: " + n);
            }
        }
    }

    public int getBarType() {
        return this.aN;
    }

    public void setBarShape(int n) {
        if (n != this.aK) {
            if (n == 1 || n == 0) {
                this.aK = n;
                this.needRender = true;
                this.needChartCalculation = true;
                this.autoRepaint();
            } else {
                throw new IllegalArgumentException("Invalid bar shape: " + n);
            }
        }
    }

    public int getBarShape() {
        return this.aK;
    }

    public void setAutoLabelSpacingOn(boolean bl) {
        if (bl != this.aM) {
            this.aM = bl;
            this.needRender = true;
            this.autoRepaint();
        }
    }

    public boolean isAutoLabelSpacingOn() {
        return this.aM;
    }

    public void setBarWidth(double d) {
        if (d != this.aP) {
            d = Math.max(0.0, d);
            this.aP = d = Math.min(1.0, d);
            this.needRender = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public double getBarWidth() {
        return this.aP;
    }

    public Rectangle getBarBounds(int n, int n2) {
        return ((BarChartRenderer)this.renderer).a(n, n2);
    }

    public void setMultiSeriesOn(boolean bl) {
        if (bl != this.u) {
            this.u = bl;
            this.needRender = true;
            this.needGraphBounds = true;
            this.needChartCalculation = true;
            this.autoRepaint();
        }
    }

    public boolean isMultiSeriesOn() {
        return this.u;
    }

    public String[] getLegendLabels() {
        String[] stringArray = this.legend.getLegendLabels();
        if (stringArray != null) {
            return stringArray;
        }
        if (this.getSeriesCount() > 1 || this.aN == 1 || this.u) {
            return this.getSeriesLabels();
        }
        return this.getSampleLabels();
    }

    protected void checkDataIntegrity() {
        super.checkDataIntegrity();
        this.renderer.checkDataIntegrity();
        int n = this.chartData.getSampleCount();
        if (n != this.aL.length) {
            this.needRender = true;
            Color[] colorArray = new Color[n];
            int n2 = Math.min(n, this.aL.length);
            System.arraycopy(this.aL, 0, colorArray, 0, n2);
            this.aL = colorArray;
        }
    }

    public ChartSample checkSelection(Point point) {
        return this.renderer.checkSelection(point);
    }
}

