/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions.service;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.extension.AclRuleType;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAclRule
extends VcloudEntity<AclRuleType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminResourceClassActionRef;

    public AdminAclRule(VcloudClient client, AclRuleType aclRuleParams) {
        super(client, aclRuleParams);
        this.sortAdminAclRuleLinkRefs();
    }

    private void sortAdminAclRuleLinkRefs() {
        if (this.getResource() != null) {
            for (LinkType link : ((AclRuleType)this.getResource()).getLink()) {
                if (!link.getRel().equals("up") || !link.getType().equals("application/vnd.vmware.admin.resourceClassAction+xml")) continue;
                this.adminResourceClassActionRef = link;
            }
        }
    }

    public static AdminAclRule getAdminAclRuleByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new AdminAclRule(client, (AclRuleType)AdminAclRule.getResourceByReference(client, reference));
    }

    public static AdminAclRule getAdminAclRuleById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminAclRule(client, (AclRuleType)AdminAclRule.getEntityById(client, vCloudId, "application/vnd.vmware.admin.aclRule+xml"));
    }

    public void delete() throws VCloudException {
        SdkUtil.delete(this.getVcloudClient(), this.getReference().getHref(), 204);
    }

    public ReferenceType getAdminResourceClassActionReference() throws VCloudException {
        if (this.adminResourceClassActionRef != null) {
            return this.adminResourceClassActionRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }
}

