/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.SelectorExtensionType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectExtension
extends VcloudEntity<ObjectExtensionType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    ObjectExtension(VcloudClient client, ObjectExtensionType entityType) {
        super(client, entityType);
    }

    public static ObjectExtension getObjectExtensionByObject(VcloudClient client, ObjectExtensionType objectExtensionType) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + objectExtensionType.getHref());
        return new ObjectExtension(client, objectExtensionType);
    }

    public ObjectExtensionType getObjectExtension() throws VCloudException {
        String objectExtensionUrl = this.getReference().getHref();
        return (ObjectExtensionType)SdkUtil.get(this.getVcloudClient(), objectExtensionUrl, 200);
    }

    public ObjectExtensionType updateObjectExtension(ObjectExtensionType objectExtension) throws VCloudException {
        String url = this.getReference().getHref();
        ObjectFactory objectFactory = new ObjectFactory();
        String updateObjectExtension = JAXBUtil.marshal(objectFactory.createObjectExtension(objectExtension));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (ObjectExtensionType)SdkUtil.put(this.getVcloudClient(), url, updateObjectExtension, "application/vnd.vmware.admin.extensibility.object+xml", 200);
    }

    public List<SelectorExtensionType> getSelectorExtensions() throws VCloudException {
        String url = ((ObjectExtensionType)this.getResource()).getHref() + "/selectorExtensions";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType selectorExtensionsType = (SelectorExtensionsType)SdkUtil.get(this.getVcloudClient(), url, 200);
        return selectorExtensionsType.getSelectorExtension();
    }

    public void delete() throws VCloudException {
        String deleteUrl = this.getReference().getHref();
        SdkUtil.delete(this.getVcloudClient(), deleteUrl, 204);
    }
}

