/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.GatewayFeaturesType;
import com.vmware.vcloud.api.rest.schema.GatewayType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.SyslogServerType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeGateway
extends VcloudEntity<GatewayType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminVdcReference;

    EdgeGateway(VcloudClient client, GatewayType gatewayType) {
        super(client, gatewayType);
        this.sortRefs();
    }

    private void sortRefs() {
        for (LinkType adminVdcNetworkLink : ((GatewayType)this.getResource()).getLink()) {
            if (!adminVdcNetworkLink.getRel().equals("up") || !adminVdcNetworkLink.getType().equals("application/vnd.vmware.admin.vdc+xml")) continue;
            this.adminVdcReference = adminVdcNetworkLink;
        }
    }

    public ReferenceType getAdminVdcReference() throws VCloudException {
        if (this.adminVdcReference != null) {
            return this.adminVdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public static EdgeGateway getEdgeGatewayByReference(VcloudClient client, ReferenceType edgeGatewayTypeRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + edgeGatewayTypeRef.getHref());
        return new EdgeGateway(client, (GatewayType)EdgeGateway.getResourceByReference(client, edgeGatewayTypeRef));
    }

    public static EdgeGateway getEdgeGatewayById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new EdgeGateway(client, (GatewayType)EdgeGateway.getEntityById(client, vCloudId, "application/vnd.vmware.admin.edgeGateway+xml"));
    }

    public Task updateEdgeGateway(GatewayType gatewayParams) throws VCloudException {
        String requestXml = JAXBUtil.marshal(new ObjectFactory().createEdgeGateway(gatewayParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), ((GatewayType)this.getResource()).getHref(), requestXml, "application/vnd.vmware.admin.edgeGateway+xml", 202));
    }

    public Task reapplyServices() throws VCloudException {
        String reapplyServicesURL = this.getReference().getHref() + "/action/reapplyServices";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), reapplyServicesURL, null, null, 202));
    }

    public Task redeploy() throws VCloudException {
        String redeployURL = this.getReference().getHref() + "/action/redeploy";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), redeployURL, null, null, 202));
    }

    public Task syncSyslogServer() throws VCloudException {
        String suncServerSysURL = this.getReference().getHref() + "/action/syncSyslogServerSettings";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), suncServerSysURL, null, null, 202));
    }

    public Task upgradeConfig() throws VCloudException {
        String upgradeConfigURL = this.getReference().getHref() + "/action/upgradeConfig";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), upgradeConfigURL, null, null, 202));
    }

    public static Task delete(VcloudClient client, ReferenceType edgeGatewayRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, edgeGatewayRef.getHref(), 202));
    }

    public Task delete() throws VCloudException {
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.delete(this.getVcloudClient(), ((GatewayType)this.getResource()).getHref(), 202));
    }

    public Task configureServices(GatewayFeaturesType gatewayFeaturesType) throws VCloudException {
        String configureServicesUrl = this.getReference().getHref() + "/action/configureServices";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createEdgeGatewayServiceConfiguration(gatewayFeaturesType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), configureServicesUrl, requestBodyXml, "application/vnd.vmware.admin.edgeGatewayServiceConfiguration+xml", 202));
    }

    public Task configureSyslogServerSettings(SyslogServerType syslogServerSettings) throws VCloudException {
        String conServerSysURL = this.getReference().getHref() + "/action/configureSyslogServerSettings";
        ObjectFactory objectFactory = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory.createSyslogServerSettings(syslogServerSettings));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), conServerSysURL, requestBodyXml, "application/vnd.vmware.vcloud.SyslogSettings+xml", 202));
    }
}

