/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AllocatedIpAddressType;
import com.vmware.vcloud.api.rest.schema.AllocatedIpAddressesType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.NetworkConfigurationType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgVdcNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.AllocatedIpAddress;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminOrgVdcNetwork
extends VcloudEntity<OrgVdcNetworkType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType adminVdcReference;

    AdminOrgVdcNetwork(VcloudClient client, OrgVdcNetworkType orgVdcNetworkType) {
        super(client, orgVdcNetworkType);
        this.sortRefs();
    }

    public ReferenceType getAdminVdcReference() throws VCloudException {
        if (this.adminVdcReference != null) {
            return this.adminVdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    private void sortRefs() {
        for (LinkType adminVdcNetworkLink : ((OrgVdcNetworkType)this.getResource()).getLink()) {
            if (!adminVdcNetworkLink.getRel().equals("up") || !adminVdcNetworkLink.getType().equals("application/vnd.vmware.admin.vdc+xml")) continue;
            this.adminVdcReference = adminVdcNetworkLink;
        }
    }

    public NetworkConfigurationType getConfiguration() {
        return ((OrgVdcNetworkType)this.getResource()).getConfiguration();
    }

    public static AdminOrgVdcNetwork getOrgVdcNetworkByReference(VcloudClient client, ReferenceType adminOrgVdcNetworkRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + adminOrgVdcNetworkRef.getHref());
        return new AdminOrgVdcNetwork(client, (OrgVdcNetworkType)AdminOrgVdcNetwork.getResourceByReference(client, adminOrgVdcNetworkRef));
    }

    public static AdminOrgVdcNetwork getOrgVdcNetworkById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminOrgVdcNetwork(client, (OrgVdcNetworkType)AdminOrgVdcNetwork.getEntityById(client, vCloudId, "application/vnd.vmware.admin.network+xml"));
    }

    public Task updateOrgVdcNetwork(OrgVdcNetworkType orgVdcNetworkType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String orgVdcNetworkUpdateUrl = this.getReference().getHref();
        String orgVdcNetworkUpdateRequestXmlString = JAXBUtil.marshal(of.createOrgVdcNetwork(orgVdcNetworkType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + orgVdcNetworkUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), orgVdcNetworkUpdateUrl, orgVdcNetworkUpdateRequestXmlString, "application/vnd.vmware.vcloud.orgVdcNetwork+xml", 202));
    }

    public Task delete() throws VCloudException {
        String orgVdcNetworkUrl = this.getReference().getHref();
        return AdminOrgVdcNetwork.deleteOrgVdcNetwork(this.getVcloudClient(), orgVdcNetworkUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType adminOrgVdcNetworkRef) throws VCloudException {
        return AdminOrgVdcNetwork.deleteOrgVdcNetwork(client, adminOrgVdcNetworkRef.getHref());
    }

    private static Task deleteOrgVdcNetwork(VcloudClient client, String orgVdcNetworkUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, orgVdcNetworkUrl, 202));
    }

    public List<AllocatedIpAddress> getAllocatedAddresses() throws VCloudException {
        String allocatedAddressesHref = this.getReference().getHref() + "/allocatedAddresses";
        AllocatedIpAddressesType allocatedIpAddressesType = (AllocatedIpAddressesType)SdkUtil.get(this.getVcloudClient(), allocatedAddressesHref, 200);
        ArrayList<AllocatedIpAddress> allocatedIpAddresses = new ArrayList<AllocatedIpAddress>();
        for (AllocatedIpAddressType allocatedIpAddressType : allocatedIpAddressesType.getIpAddress()) {
            allocatedIpAddresses.add(new AllocatedIpAddress(this.getVcloudClient(), allocatedIpAddressType));
        }
        return allocatedIpAddresses;
    }

    public Task reset() throws VCloudException {
        String taskCanelActionUrl = this.getReference().getHref() + "/action/reset";
        return AdminOrgVdcNetwork.executeAction(this.getVcloudClient(), taskCanelActionUrl, null, null, 202);
    }

    public static Task reset(VcloudClient client, ReferenceType adminOrgNetworkReference) throws VCloudException {
        return AdminOrgVdcNetwork.executeAction(client, adminOrgNetworkReference.getHref() + "/action/reset", null, null, 202);
    }

    private static Task executeAction(VcloudClient client, String adminOrgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, adminOrgActionUrl, content, contentType, statusCode));
    }
}

