/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.TaskStatusType;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
extends VcloudEntity<TaskType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private ReferenceType blockingTaskReference;

    public Task(VcloudClient client, TaskType taskResource_v1_5) {
        super(client, taskResource_v1_5);
        this.sortTaskRefs_v1_5();
    }

    private void sortTaskRefs_v1_5() {
        for (LinkType taskLink : ((TaskType)this.getResource()).getLink()) {
            if (!taskLink.getRel().equals("down") || !taskLink.getType().equals("application/vnd.vmware.admin.blockingTask+xml")) continue;
            this.blockingTaskReference = taskLink;
        }
    }

    public Boolean isBlockingTask() {
        return this.blockingTaskReference != null;
    }

    public ReferenceType getBlockingTaskReference() throws VCloudException {
        if (this.isBlockingTask().booleanValue()) {
            return this.blockingTaskReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public static Task getTaskByReference(VcloudClient client, ReferenceType taskRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + taskRef.getHref());
        return new Task(client, (TaskType)Task.getResourceByReference(client, taskRef));
    }

    public ReferenceType getUserReference() {
        return ((TaskType)this.getResource()).getUser();
    }

    public static ReferenceType getUserReference(VcloudClient client, ReferenceType taskReference) throws VCloudException {
        return ((TaskType)new Task(client, (TaskType)Task.getResourceByReference(client, taskReference)).getResource()).getUser();
    }

    public ReferenceType getOrgReference() {
        return ((TaskType)this.getResource()).getOrganization();
    }

    public static ReferenceType getOrgReference(VcloudClient client, ReferenceType taskReference) throws VCloudException {
        return ((TaskType)new Task(client, (TaskType)Task.getResourceByReference(client, taskReference)).getResource()).getOrganization();
    }

    public Integer getProgress() {
        return ((TaskType)this.getResource()).getProgress();
    }

    public static Integer getProgress(VcloudClient client, ReferenceType taskReference) throws VCloudException {
        return ((TaskType)new Task(client, (TaskType)Task.getResourceByReference(client, taskReference)).getResource()).getProgress();
    }

    public void cancelTask() throws VCloudException {
        String taskCanelActionUrl = this.getReference().getHref() + "/action/cancel";
        Task.executeAction(this.getVcloudClient(), taskCanelActionUrl, null, null, 204);
    }

    public static void cancelTask(VcloudClient client, ReferenceType taskReference) throws VCloudException {
        Task.executeAction(client, taskReference.getHref() + "/action/cancel", null, null, 204);
    }

    private static void executeAction(VcloudClient client, String vappActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        SdkUtil.post(client, vappActionUrl, content, contentType, statusCode);
    }

    private static void waitForTaskCompletion(VcloudClient client, ReferenceType taskRef, long endTime, long period) throws VCloudException, TimeoutException {
        Task task = Task.getTaskByReference(client, taskRef);
        while (((TaskType)task.getResource()).getStatus().equals(TaskStatusType.QUEUED.value()) || ((TaskType)task.getResource()).getStatus().equals(TaskStatusType.RUNNING.value()) || ((TaskType)task.getResource()).getStatus().equals(TaskStatusType.PRERUNNING.value())) {
            if (period > 0L) {
                try {
                    Thread.sleep(period);
                }
                catch (InterruptedException e) {
                    throw new VCloudRuntimeException(e);
                }
            }
            task = Task.getTaskByReference(client, task.getReference());
            if (System.currentTimeMillis() <= endTime || endTime <= 0L) continue;
            logger.info(SdkUtil.getI18nString(SdkMessage.TASK_TIMEOUT) + " - " + ((TaskType)task.getResource()).getOperation() + " - " + task.getReference().getHref());
            throw new TimeoutException(SdkUtil.getI18nString(SdkMessage.TASK_TIMEOUT) + " - " + ((TaskType)task.getResource()).getOperation() + " - " + task.getReference().getHref());
        }
        if (((TaskType)task.getResource()).getStatus().equals(TaskStatusType.ABORTED.value())) {
            logger.info(SdkUtil.getI18nString(SdkMessage.TASK_ABORTED) + " - " + ((TaskType)task.getResource()).getOperation() + " - " + task.getReference().getHref());
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.TASK_ABORTED) + " - " + ((TaskType)task.getResource()).getOperation() + " - " + task.getReference().getHref());
        }
        if (((TaskType)task.getResource()).getStatus().equals(TaskStatusType.CANCELED.value())) {
            logger.info(SdkUtil.getI18nString(SdkMessage.TASK_CANCELLED) + " - " + ((TaskType)task.getResource()).getError().getMessage());
            throw new VCloudException(((TaskType)task.getResource()).getError());
        }
        if (((TaskType)task.getResource()).getStatus().equals(TaskStatusType.ERROR.value())) {
            logger.info(SdkUtil.getI18nString(SdkMessage.TASK_ERRORED) + " - " + ((TaskType)task.getResource()).getError().getMessage());
            throw new VCloudException(((TaskType)task.getResource()).getError());
        }
    }

    public void waitForTask(long timeout) throws VCloudException, TimeoutException {
        long endTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        Task.waitForTaskCompletion(this.getVcloudClient(), this.getReference(), endTime, 0L);
    }

    public static void waitForTask(VcloudClient client, ReferenceType taskRef, long timeout) throws VCloudException, TimeoutException {
        long endTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        Task.waitForTaskCompletion(client, taskRef, endTime, 0L);
    }

    public void waitForTask(long timeout, long period) throws VCloudException, TimeoutException {
        long endTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        Task.waitForTaskCompletion(this.getVcloudClient(), this.getReference(), endTime, period);
    }

    public static void waitForTask(VcloudClient client, ReferenceType taskRef, long timeout, long period) throws VCloudException, TimeoutException {
        long endTime = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        Task.waitForTaskCompletion(client, taskRef, endTime, period);
    }

    public static Task getTaskById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Task(client, (TaskType)Task.getEntityById(client, vCloudId, "application/vnd.vmware.vcloud.task+xml"));
    }

    public Task updateTask(TaskType taskType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String taskUpdateUrl = this.getReference().getHref();
        String taskUpdateRequestXmlString = JAXBUtil.marshal(of.createTask(taskType));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), taskUpdateUrl, taskUpdateRequestXmlString, "application/vnd.vmware.vcloud.task+xml", 200));
    }
}

