/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.api.rest.schema.ErrorType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private String responseXml;
    private int responseStatusCode;

    String getResponseXml() {
        return this.responseXml;
    }

    void setResponseXml(String responseXml) {
        this.responseXml = responseXml;
    }

    int getResponseStatusCode() {
        return this.responseStatusCode;
    }

    void setResonseStatusCode(int resonseStatucCode) {
        this.responseStatusCode = resonseStatucCode;
    }

    public boolean isExpected(int expectedStatusCode) {
        if (this.getResponseStatusCode() != expectedStatusCode) {
            logger.info(SdkUtil.getI18nString(SdkMessage.EXPECTED_STATUS_CODE_MSG) + " - " + expectedStatusCode);
            logger.info(SdkUtil.getI18nString(SdkMessage.ACTUAL_STATUS_CODE_MSG) + " - " + this.getResponseStatusCode());
            return false;
        }
        return true;
    }

    public <T> T getResource() throws VCloudException {
        if (this.getResponseXml() == null || this.getResponseXml().isEmpty()) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_RESPONSE_RECEIVED_MSG));
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(this.getResponseXml().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
            throw new VCloudRuntimeException(e);
        }
        return (T)JAXBUtil.unmarshallResource(is);
    }

    public void handleUnExpectedResponse() throws VCloudException {
        if (this.getResponseXml() != null && !this.getResponseXml().isEmpty()) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(this.getResponseXml().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
                throw new VCloudRuntimeException(e);
            }
            ErrorType errorType = (ErrorType)JAXBUtil.unmarshallResource(is);
            throw new VCloudException(errorType);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.NO_ERROR_MSG) + " - " + this.getResponseStatusCode());
    }
}

