/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.timedio.Dbio;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.utils.AsciiInput;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;

public class RawDbio
extends Dbio
implements Runnable {
    protected Socket _socket = null;
    private Thread _runner = null;
    private long _currentTimeout = 0L;
    static final boolean READAHEAD = true;
    private static final String CONNECT = "CONNECT";
    private static final String TERMINATOR = "\r\n";
    private static final String HTTP_VERSION = "HTTP/1.0";
    private static final String USER_AGENT = "User-agent:";
    private static final String JDBC_VERSION = "Sybase jConnect for JDBC (TM) 5.5";
    private static final String SUCCESS_CONNECT = "200";

    public RawDbio(String host, int port, InStreamMgr ioMgr, SybProperty props) throws SQLException {
        super(host, port, ioMgr, props);
        Debug.println(this, "new RawDbio");
    }

    protected void close() {
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {}
            this._socket = null;
        }
    }

    protected void doConnect(int timeout) throws IOException {
        for (int retry = 0; retry < 1000; ++retry) {
            Debug.println(this, "attempting connection to " + this._host + ":" + this._port + ", retry # " + retry);
            try {
                if (this._proxyHost != null) {
                    this._socket = new Socket(this._proxyHost, this._proxyPort);
                    break;
                }
                this._socket = new Socket(this._host, this._port);
                break;
            }
            catch (SocketException jnse) {
                if (jnse.getMessage().startsWith("Address already in use")) {
                    continue;
                }
                throw jnse;
            }
        }
        this.setUpSocket(timeout);
        Debug.println(this, "connection successful");
    }

    protected int reallyRead(long timeout) throws IOException {
        if (timeout != this._currentTimeout) {
            this._currentTimeout = timeout;
            this._socket.setSoTimeout((int)timeout);
        }
        return this._in.read(this._bufIntv._buf, this._bufIntv._offset + this._bRead, this._bufIntv._length - this._bRead);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.doRead(0L);
                }
            }
            catch (IOException ioe) {
                this._lastEx = ioe;
                this._ioMgr.reportError("JZ0T2");
                continue;
            }
            break;
        }
    }

    private void sendHTTPConnect(InputStream is, OutputStream os, String url) throws IOException {
        StringBuffer request = new StringBuffer(CONNECT);
        request.append(" ");
        request.append(url);
        request.append(" ");
        request.append(HTTP_VERSION);
        request.append(TERMINATOR);
        request.append(USER_AGENT);
        request.append(" ");
        request.append(JDBC_VERSION);
        request.append(TERMINATOR);
        request.append(TERMINATOR);
        int len = request.length();
        byte[] ascii = request.toString().getBytes();
        os.write(ascii, 0, len);
        os.flush();
        boolean connected = false;
        String nextLine = AsciiInput.readLine(is);
        if (nextLine == null) {
            ErrorMessage.raiseIOException("JZ0I7");
        }
        if (nextLine.indexOf(SUCCESS_CONNECT) == -1) {
            ErrorMessage.raiseIOException("JZ0I8", nextLine);
        }
        while (nextLine != null) {
            nextLine = AsciiInput.readLine(is);
        }
    }

    protected void setUpSocket(int timeout) throws IOException {
        this._socket.setTcpNoDelay(true);
        if ((long)timeout != this._currentTimeout) {
            this._currentTimeout = timeout;
            this._socket.setSoTimeout(timeout);
        }
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
        if (this._proxyHost != null) {
            Debug.println(this, "sendHTTPConnect: (" + this._host + ":" + this._port + ")");
            this.sendHTTPConnect(this._in, this._out, String.valueOf(this._host) + ":" + this._port);
        }
    }

    public boolean startAsync() {
        if (this._runner == null) {
            this._runner = new Thread(this);
            this._runner.start();
            Debug.println(this, "Reader thread running.");
        }
        return true;
    }

    public void stopAsync() {
        if (this._runner != null) {
            try {
                try {
                    this._runner.stop();
                    this._runner.join(1L);
                }
                catch (Exception exception) {
                }
                Object var2_1 = null;
                this._runner = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._runner = null;
                throw throwable;
            }
        }
    }
}

