/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.CachedTdsInt;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsInt
extends TdsDataObject {
    long _value;

    public TdsInt(TdsProtocolContext context) throws IOException {
        super(context);
    }

    protected void beginRead() throws IOException {
        Debug.println(this, "reading");
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0L;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 48: {
                            this._value = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            this._value = this.readShort();
                            break;
                        }
                        case 56: {
                            this._value = this.readInt();
                            break;
                        }
                        case 38: {
                            this._value = this.readINTN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 3;
                break;
            }
        }
    }

    public void cache() throws IOException {
        Debug.println(this, "caching");
        this.beginRead();
    }

    public void clear() throws IOException {
        Debug.println(this, "clearing");
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    protected TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsInt(this);
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.doRead();
        BigDecimal retVal = null;
        if (!this._isNull) {
            retVal = new BigDecimal((double)this._value);
        }
        retVal = Convert.setScale(retVal, scale);
        return retVal;
    }

    public boolean getBoolean() throws SQLException {
        this.doRead();
        return this._value != 0L;
    }

    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(this._value);
        return (byte)this._value;
    }

    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    public float getFloat() throws SQLException {
        this.doRead();
        return this._value;
    }

    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(this._value);
        return (int)this._value;
    }

    public long getLong() throws SQLException {
        this.doRead();
        return this._value;
    }

    public Object getObject() throws SQLException {
        this.doRead();
        Integer retVal = null;
        if (!this._isNull) {
            retVal = new Integer((int)this._value);
        }
        return retVal;
    }

    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(this._value);
        return (short)this._value;
    }

    public String getString() throws SQLException {
        this.doRead();
        String retVal = null;
        if (!this._isNull) {
            retVal = String.valueOf(this._value);
        }
        return retVal;
    }
}

