/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowFormatToken
extends Token
implements ResultSetMetaData {
    public static final int IMAGE_COLUMN_DISPLAY_SIZE = 1;
    protected int _numColumns;
    protected int _numUserColumns;
    protected int[] _userColumnMap;
    protected DataFormat[] _column;
    private TdsProtocolContext _tpc = null;

    public RowFormatToken() {
        this._numColumns = 0;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken(int columns) throws SQLException {
        this._numUserColumns = this._numColumns = columns;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken(TdsInputStream in) throws IOException {
        this.readLength(in);
        this._numColumns = in.readShort();
        this.addDataFormats(in, this._numColumns);
    }

    public void addDataFormats(TdsInputStream in, int num) throws IOException {
        this._column = new DataFormat[num];
        this._numUserColumns = 0;
        this.prepareUserColMap(num);
        int i = 0;
        while (i < num) {
            this._column[i] = this.dataFormatFactory(in);
            if ((this._column[i]._status & 1) == 0) {
                this._userColumnMap[this._numUserColumns] = i;
                ++this._numUserColumns;
            }
            ++i;
        }
        Debug.println(this, "RowFormat packet # columns = " + num + ", visible columns = " + this._numUserColumns);
    }

    protected DataFormat dataFormatFactory(TdsInputStream in) throws IOException {
        return new DataFormat(in);
    }

    public String getCatalogName(int column) throws SQLException {
        this.mapColumn(column);
        if (!this.isFakeMetadataEnabled()) {
            Debug.notImplemented(this, "getCatalogName");
        }
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        return this._column[this.mapColumn((int)column)]._className;
    }

    public int getColumnCount() throws SQLException {
        return this._numUserColumns;
    }

    public int getColumnDisplaySize(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        switch (this.getDataFormat((int)column)._datatype) {
            case 48: {
                return 3;
            }
            case 52: {
                return 6;
            }
            case 56: {
                return 11;
            }
            case 38: {
                switch (this.getDataFormat((int)column)._length) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 20;
                    }
                }
                return 11;
            }
            case 59: {
                return 46;
            }
            case 62: {
                return 85;
            }
            case 109: {
                switch (this.getDataFormat((int)column)._length) {
                    case 4: {
                        return 46;
                    }
                    case 8: {
                        return 85;
                    }
                }
                return 46;
            }
            case 58: 
            case 61: 
            case 111: {
                return 25;
            }
            case 122: {
                return 12;
            }
            case 60: {
                return 21;
            }
            case 110: {
                switch (this.getDataFormat((int)column)._length) {
                    case 4: {
                        return 12;
                    }
                    case 8: {
                        return 21;
                    }
                }
                return 21;
            }
            case 106: 
            case 108: {
                return this.getDataFormat((int)column)._precision + 2;
            }
            case 37: 
            case 45: 
            case 225: {
                return this.getDataFormat((int)column)._length * 2;
            }
            case 34: {
                return 1;
            }
            case 35: 
            case 39: 
            case 47: 
            case 50: 
            case 103: 
            case 104: 
            case 175: {
                return this.getDataFormat((int)column)._length;
            }
        }
        ErrorMessage.raiseError("JZ0P4");
        Debug.assert(null, false);
        return -1;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.getName(this.mapColumn(column));
    }

    public int getColumnType(int column) throws SQLException {
        return RowFormatToken.sqlTypeToJdbcType(this.getDataFormat(this.mapColumn(column)), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnTypeName(int colIndex) throws SQLException {
        String string;
        PreparedStatement ps;
        ResultSet rs;
        block12: {
            String string2;
            block10: {
                block11: {
                    rs = null;
                    ps = null;
                    int column = this.mapColumn(colIndex);
                    int type = this.getDataFormat((int)column)._datatype;
                    try {
                        try {
                            ps = this._tpc._conn.getMDA(null).getMetaDataAccessor("COLUMNTYPENAME", this._tpc);
                            switch (type) {
                                case 37: 
                                case 38: 
                                case 39: 
                                case 109: 
                                case 110: 
                                case 111: {
                                    type = RowFormatToken.sqlTypeToJdbcType(this.getDataFormat(column), true);
                                    break;
                                }
                            }
                            ps.setInt(1, type);
                            ps.setInt(2, this.getDataFormat((int)column)._usertype);
                            Debug.println(this, "datatype= " + type + " usertype = " + this.getDataFormat((int)column)._usertype);
                            rs = ps.executeQuery();
                            if (rs.next()) {
                                string2 = rs.getString(1);
                                Object var8_8 = null;
                                if (rs == null) break block10;
                                break block11;
                            }
                            ErrorMessage.raiseError("JZ0P8");
                            string = "";
                            break block12;
                        }
                        catch (SQLException sqe) {
                            Debug.printStackTrace(this, sqe);
                            throw sqe;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        if (ps == null) throw throwable;
                        ps.close();
                        throw throwable;
                    }
                }
                rs.close();
            }
            if (ps == null) return string2;
            ps.close();
            return string2;
        }
        Object var8_9 = null;
        if (rs != null) {
            rs.close();
        }
        if (ps == null) return string;
        ps.close();
        return string;
    }

    protected DataFormat getDataFormat(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return this._column[column];
    }

    protected int getDatatype(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return this.getDataFormat((int)column)._datatype;
    }

    protected String getLabel(int column) throws SQLException {
        return this.getName(column);
    }

    public int getLength(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return this.getDataFormat((int)column)._length;
    }

    protected String getName(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return this.getDataFormat((int)column)._name;
    }

    public int getPrecision(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        return this.getDataFormat((int)column)._precision;
    }

    public int getScale(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        return this.getDataFormat((int)column)._scale;
    }

    public String getSchemaName(int column) throws SQLException {
        this.mapColumn(column);
        if (!this.isFakeMetadataEnabled()) {
            Debug.notImplemented(this, "getSchemaName");
        }
        return "";
    }

    protected int getStatus(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return this.getDataFormat((int)column)._status;
    }

    public String getTableName(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        switch (this.getDataFormat((int)column)._datatype) {
            case 34: 
            case 35: {
                return this.getDataFormat((int)column)._tableName;
            }
        }
        if (!this.isFakeMetadataEnabled()) {
            Debug.notImplemented(this, "getTableName");
        }
        return "";
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)column))._status & 0x40) != 0;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            return ((SybDatabaseMetaData)this._tpc._conn.getMetaData()).isCaseSensitive();
        }
        catch (SQLException sqe) {
            Debug.printStackTrace(this, sqe);
            throw sqe;
        }
    }

    public boolean isCurrency(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        switch (this.getDataFormat((int)column)._datatype) {
            case 60: 
            case 110: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.mapColumn(column);
        return false;
    }

    private boolean isFakeMetadataEnabled() throws SQLException {
        SybProperty sp = ((Tds)this._tpc._protocol).getSybProperty();
        return sp.getBoolean(39);
    }

    public int isNullable(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        return (this.getDataFormat((int)column)._status & 0x20) == 0 ? 0 : 1;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)column))._status & 0x10) == 0;
    }

    public boolean isSearchable(int column) throws SQLException {
        Debug.println(this, "isSearchable, column: " + column);
        Object rs = null;
        Object ps = null;
        int type = RowFormatToken.sqlTypeToJdbcType(this.getDataFormat(--column), false);
        Debug.println(this, "jdbc type= " + type);
        return ((Tds)this._tpc._protocol).isTypeSearchable(type);
    }

    public boolean isSigned(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        switch (this.getDataFormat((int)column)._datatype) {
            case 38: 
            case 48: 
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)column))._status & 0x10) != 0;
    }

    protected int mapColumn(int column) throws SQLException {
        if (column > this._numUserColumns || column < 1) {
            ErrorMessage.raiseError("JZ008", String.valueOf(column));
        }
        return this._userColumnMap[--column];
    }

    protected void prepareUserColMap(int num) {
        this._userColumnMap = new int[num];
    }

    protected long readLength(TdsInputStream in) throws IOException {
        long len = in.readShort();
        return len;
    }

    protected void setPc(TdsProtocolContext tpc) {
        this._tpc = tpc;
    }

    protected static int sqlTypeToJdbcType(DataFormat d, boolean tosql) {
        switch (d._datatype) {
            case 50: {
                return -7;
            }
            case 38: {
                switch (d._length) {
                    case 1: {
                        return tosql ? 48 : -6;
                    }
                    case 2: {
                        return tosql ? 52 : 5;
                    }
                    case 4: {
                        return tosql ? 56 : 4;
                    }
                    case 8: {
                        return tosql ? 38 : -5;
                    }
                }
                Debug.assert(null, false);
                return 1111;
            }
            case 48: {
                return -6;
            }
            case 52: {
                return 5;
            }
            case 56: {
                return 4;
            }
            case 109: {
                switch (d._length) {
                    case 4: {
                        return tosql ? 59 : 7;
                    }
                    case 8: {
                        return tosql ? 62 : 8;
                    }
                }
                Debug.assert(null, false);
                return 1111;
            }
            case 59: {
                return 7;
            }
            case 62: {
                return 8;
            }
            case 60: 
            case 110: 
            case 122: {
                if (tosql) {
                    return d._length == 4 ? 122 : 60;
                }
                return 3;
            }
            case 106: 
            case 108: {
                if (d._usertype == 26) {
                    return 3;
                }
                return 2;
            }
            case 39: {
                if (d._usertype == 1) {
                    return tosql ? 47 : 1;
                }
                return tosql ? 39 : 12;
            }
            case 47: {
                return 1;
            }
            case 35: 
            case 175: {
                return -1;
            }
            case 111: {
                switch (d._length) {
                    case 4: {
                        return tosql ? 58 : 93;
                    }
                    case 8: {
                        return tosql ? 61 : 93;
                    }
                }
                Debug.assert(null, false);
                return 1111;
            }
            case 58: 
            case 61: {
                return 93;
            }
            case 45: {
                return -2;
            }
            case 37: {
                if (d._usertype == 3) {
                    return tosql ? 45 : -2;
                }
                return tosql ? 37 : -3;
            }
            case 225: {
                if (d._usertype == 34) {
                    return 1;
                }
                if (d._usertype == 35) {
                    return 12;
                }
                return -4;
            }
            case 34: {
                return -4;
            }
            case 31: 
            case 103: 
            case 104: {
                return 1111;
            }
            case 36: 
            case 255: {
                switch (d._blobType) {
                    case 1: 
                    case 2: {
                        return 2000;
                    }
                    case 3: {
                        return -1;
                    }
                    case 4: {
                        return -4;
                    }
                }
            }
        }
        Debug.assert(null, false);
        return 1111;
    }
}

