/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DoneToken;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.BufferInterval;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;

public class PduInputFormatter
extends InputStream {
    private static final int LOW_BYTE = 255;
    private int _nextIn = 0;
    private int _packetEnd = 0;
    private int _status = 1;
    private int _type;
    private BufferInterval _pdu;
    private byte[] _buf = null;
    private TdsProtocolContext _tpc;

    public PduInputFormatter(TdsProtocolContext tpc) {
        this._tpc = tpc;
        Debug.println(this, "Constructor");
    }

    public int available() throws IOException {
        int avail = this._tpc.available();
        return avail += this._packetEnd - this._nextIn;
    }

    public void close() {
        while ((this._status & 1) == 0) {
            try {
                this.readPacket();
            }
            catch (IOException iOException) {
                break;
            }
        }
        this._nextIn = 0;
        this._packetEnd = 0;
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
        Debug.println(this, "slurped");
    }

    public int read() throws IOException {
        while (this._nextIn >= this._packetEnd) {
            if (this.readPacket()) continue;
            Debug.println(this, "read() EOF");
            return -1;
        }
        int nextByte = this._buf[this._nextIn++] & 0xFF;
        return nextByte;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int inPacket = this._packetEnd - this._nextIn;
            while (inPacket <= 0) {
                if (!this.readPacket()) {
                    if (toRead == len) {
                        Debug.println(this, "read(byte[]) EOF");
                        return -1;
                    }
                    return len - toRead;
                }
                inPacket = this._packetEnd - this._nextIn;
            }
            int numRead = inPacket > toRead ? toRead : inPacket;
            System.arraycopy(this._buf, this._nextIn, b, off, numRead);
            toRead -= numRead;
            off += numRead;
            this._nextIn += numRead;
        }
        return len;
    }

    private boolean readPacket() throws IOException {
        if (this._pdu != null) {
            this._pdu.free();
            this._pdu = null;
        }
        this._pdu = this._tpc.getChunk();
        if (this._pdu == null) {
            this._nextIn = 0;
            this._packetEnd = 0;
            return false;
        }
        this._buf = this._pdu._buf;
        this._nextIn = this._pdu._offset;
        this._type = this._buf[this._nextIn++] & 0xFF;
        this._status = this._buf[this._nextIn++] & 0xFF;
        int packetLen = ((this._buf[this._nextIn++] & 0xFF) << 8) + (0xFF & this._buf[this._nextIn++]);
        this._nextIn += 4;
        this._packetEnd = this._nextIn + packetLen - 8;
        Debug.println(this, "readPacket() _nextIn = " + this._nextIn + ", _packetEnd = " + this._packetEnd);
        if ((this._status & 2) != 0) {
            this._pdu.free();
            this._pdu = null;
            this._nextIn = 0;
            this._packetEnd = 0;
            this._tpc._tdsToken = new DoneToken(32, 0, 0);
            return false;
        }
        return true;
    }

    public long skip(long n) throws IOException {
        int avail = this._packetEnd - this._nextIn;
        int need = (int)n;
        Debug.println(this, "skip(" + n + ")");
        while (avail < need) {
            need -= avail;
            this._nextIn += avail;
            if (!this.readPacket()) {
                Debug.println(this, "skip() EOF");
                return n;
            }
            avail = this._packetEnd - this._nextIn;
        }
        this._nextIn += need;
        return n;
    }
}

