/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class CachedTdsJdbcInputStream
extends TdsJdbcInputStream {
    public CachedTdsJdbcInputStream(TdsJdbcInputStream stream) throws IOException {
        super(stream._context, null);
        Debug.println(this, "CachedTdsJdbcInputStream()");
        byte[] data = null;
        try {
            data = stream.getRawBytes();
        }
        catch (SQLException sqle) {
            Debug.println("Failed to grab data. " + sqle);
        }
        Debug.assert(this, stream._state == 3, "Tried to create a cached stream with uncached input source");
        stream.copyInto(this);
        if (data == null) {
            Debug.assert(this, this._isNull, "data stream was null, but object was flagged as not null.");
            Debug.println(this, "source was null, assigning an empty input stream to cached copy.");
            data = new byte[]{};
        }
        this.in = new ByteArrayInputStream(data);
        Debug.println(this, "input stream built from bytes.");
    }

    protected void beginRead() throws IOException {
        Debug.println(this, "beginRead()");
        Debug.assert(this, this._state == 3, "not cached!");
        this.reset();
    }

    public void cache() throws IOException {
        Debug.println(this, "cache() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
        this.reset();
    }

    public void clear() throws IOException {
        Debug.println(this, "clear() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
        this.reset();
    }

    protected void doRead() throws SQLException {
        Debug.println(this, "doRead()");
        Debug.assert(this, this._state == 3, "not cached!");
        this.safeReset();
    }

    public void endRead() throws SQLException {
        Debug.println(this, "endRead() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
    }

    protected void getSize() throws IOException {
        Debug.println(this, "getSize() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
    }

    public void initialize() {
        Debug.println(this, "initialize()");
        if (this._state != 3) {
            this._state = 3;
            Debug.println(this, "set state to cached");
        }
    }

    public void open(boolean caching) {
        Debug.println(this, "open() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
    }

    public void reset() throws IOException {
        Debug.println(this, "reset() in = " + this.in);
        Debug.assert(this, this._state == 3, "not cached!");
        this.in.reset();
    }

    public void resetInputStream(InputStream is) {
        Debug.println(this, "resetInputStream() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
        this.safeReset();
    }

    private void safeReset() {
        try {
            this.in.reset();
        }
        catch (IOException ioe) {
            Debug.assert(this, false, "Failed to reset a cached stream" + ioe);
        }
    }

    public void setManager(CacheManager cm) {
        Debug.println(this, "setManager() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
    }

    public void startRead() throws IOException {
        Debug.println(this, "startRead() does NOTHING");
        Debug.assert(this, this._state == 3, "not cached!");
        this.reset();
    }
}

