/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybDataSource;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybXAConnection;
import com.sybase.jdbc2.utils.Debug;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SybXADataSource
extends SybDataSource
implements XADataSource {
    public SybXADataSource() {
        Debug.println(this, "SybXADataSource()");
    }

    protected SybConnection createConnection(String url, SybUrlProvider up) throws SQLException {
        Debug.println(this, "SybXADataSource.createConnection()");
        return new SybXAConnection(this, up);
    }

    protected synchronized SybUrlProvider createSybUrlProvider() {
        Debug.println(this, "SybXADS.createSybUrlProvider");
        SybUrlProvider up = super.createSybUrlProvider();
        if (this.getResourceManagerType() == 1) {
            boolean usemd = true;
            SybProperty props = up.getSybProperty();
            try {
                usemd = props.getBoolean(6);
            }
            catch (SQLException sQLException) {
                Debug.println(this, "failed to retrieve USE_METADATA property!");
            }
            if (usemd) {
                Debug.println(this, "overriding USE_METADATA property while connecting to XAServer");
                props.setProperty(6, new Boolean(false));
            }
        }
        return up;
    }

    public Connection getConnection() throws SQLException {
        Debug.println(this, "user called getConnection() on a XADataSource");
        ErrorMessage.raiseError("JZ0S3", "getConnection()");
        Debug.assert(this, false, "unreachable statement");
        return null;
    }

    public Connection getConnection(String user, String passwd) throws SQLException {
        return this.getConnection();
    }

    public XAConnection getXAConnection() throws SQLException {
        Debug.println(this, "getXAConnection()");
        return (XAConnection)((Object)super.getConnection());
    }

    public XAConnection getXAConnection(String user, String passwd) throws SQLException {
        Debug.println(this, "getXAConnection(" + user + ", " + passwd + ")");
        return (XAConnection)((Object)super.getConnection(user, passwd));
    }
}

