/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.TextPointer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class SybResultSet
implements com.sybase.jdbcx.SybResultSet,
Cacheable {
    protected static final int BEFORE_FIRST = -1;
    protected static final int AFTER_LAST = -2;
    protected static final int INSERT_ROW = -3;
    protected static final int UNDEFINED = -4;
    protected ProtocolResultSet _prs;
    protected JdbcDataObject _currentColumn;
    protected SybStatement _statement;
    protected int _state = 2;
    private Hashtable _nameToColumn = null;
    private Hashtable _labelToColumn = null;
    protected CacheManager _cm;
    protected int _rowIndex;
    protected int _lastRowIndex = -4;
    protected int _concurType = 1007;
    protected String _concurTypeString = "CONCUR_READ_ONLY";
    protected int _scrollType = 1003;
    protected int _fetchSize = 0;
    protected int _fetchDirection = 1000;

    public SybResultSet(SybStatement stmt, ProtocolResultSet prs) throws SQLException {
        Debug.println(this, "Constructor()");
        this._statement = stmt;
        this._prs = prs;
        this._rowIndex = -1;
        if (this._prs != null) {
            this._scrollType = this._prs.getType();
        }
    }

    public boolean absolute(int row) throws SQLException {
        int deepestRow;
        Debug.println(this, "absolute(" + row + ")");
        this.checkForScrollability("absolute(int)");
        if (this._lastRowIndex == 0) {
            return false;
        }
        if (row == 0) {
            ErrorMessage.raiseError("JZ0I3", String.valueOf(row), "absolute(int)");
        }
        if (row < 0) {
            if (this._lastRowIndex == -4) {
                if (!this.last()) {
                    Debug.assert(this, this.isBeforeFirst(), "Empty result set, but cursor is not before first");
                    return false;
                }
                Debug.assert(this, this._lastRowIndex != -4, "Unable to reach last row");
            }
            Debug.println(this, "calculated row = " + (row += this._lastRowIndex + 1));
            if (row <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (row <= (deepestRow = this._prs.getNumRowsCached())) {
            this._rowIndex = row;
            this._prs.absolute(row);
            return true;
        }
        if (deepestRow > 0) {
            this._rowIndex = deepestRow;
            this._prs.absolute(this._rowIndex);
        }
        while (this._rowIndex < row && this.next()) {
        }
        return this._rowIndex == row;
    }

    public void afterLast() throws SQLException {
        Debug.println(this, "afterLast()");
        this.checkForScrollability("afterLast()");
        if (this.last()) {
            this.next();
        }
    }

    public void beforeFirst() throws SQLException {
        Debug.println(this, "beforeFirst()");
        this.checkForScrollability("beforeFirst()");
        if (this.first()) {
            this.previous();
        }
    }

    public void cache() throws IOException {
        try {
            this.close();
        }
        catch (SQLException sqle) {
            ErrorMessage.raiseIOException("JZ006", sqle.getMessage());
        }
    }

    public void cancelRowUpdates() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "cancelRowUpdates()", this._concurTypeString);
    }

    private void checkForScrollability(String method) throws SQLException {
        switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", method, "TYPE_FORWARD_ONLY");
                break;
            }
            case 1005: {
                Debug.notImplemented(this, String.valueOf(method) + " for TYPE_SCROLL_SENSITIVE");
                break;
            }
            default: {
                Debug.assert(this, false, "Unrecognized ResultSet type = " + this._scrollType);
            }
            case 1004: 
        }
    }

    protected void checkResultSet() throws SQLException {
        if (this._state != 2) {
            ErrorMessage.raiseError("JZ0R0");
        }
    }

    public void clear() throws IOException {
        try {
            this.close(false);
        }
        catch (SQLException sqe) {
            ErrorMessage.raiseIOException("JZ006", sqe.getMessage());
        }
    }

    public void clearWarnings() throws SQLException {
        this._prs.clearWarnings();
    }

    public void close() throws SQLException {
        Debug.println(this, "close()");
        this.close(false);
    }

    protected void close(boolean cancelling) throws SQLException {
        Debug.println(this, "close(" + cancelling + ")");
        this.markDead(cancelling);
    }

    public void deleteRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "deleteRow()", this._concurTypeString);
    }

    public int findColumn(String columnName) throws SQLException {
        Integer x;
        Debug.println(this, "findColumn() " + columnName);
        if (this._statement._context._conn._props.getBoolean(40)) {
            Integer x2;
            Debug.println(this, "findColumn is looking at column labels");
            if (this._labelToColumn == null) {
                Debug.println(this, "initialize _labelToColumn hashtable");
                this._labelToColumn = new Hashtable();
            }
            if ((x2 = (Integer)this._labelToColumn.get(columnName)) != null) {
                Debug.println(this, "it was hashed");
                return x2;
            }
            int column = this._prs.findColumnByLabel(columnName);
            this._labelToColumn.put(columnName, new Integer(column));
            Debug.println(this, "Got it = " + column);
            return column;
        }
        Debug.println(this, "findColumn is looking at column names");
        if (this._nameToColumn == null) {
            Debug.println(this, "initialize _nameToColumn hashtable");
            this._nameToColumn = new Hashtable();
        }
        if ((x = (Integer)this._nameToColumn.get(columnName)) != null) {
            Debug.println(this, "it was hashed");
            return x;
        }
        int column = this._prs.findColumn(columnName);
        this._nameToColumn.put(columnName, new Integer(column));
        Debug.println(this, "Got it = " + column);
        return column;
    }

    public boolean first() throws SQLException {
        Debug.println(this, "first()");
        this.checkForScrollability("first()");
        this.moveToCurrentRow();
        if (this._rowIndex == 1) {
            return true;
        }
        return this.absolute(1);
    }

    public Array getArray(int i) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public Array getArray(String colName) throws SQLException {
        Debug.notSupported(this, "getArray(String)");
        return null;
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getAsciiStream();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getColumn(columnIndex).getBigDecimal(scale);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(columnName, -1);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getBinaryStream();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Blob getBlob(int i) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        Debug.notSupported(this, "getBlob(String)");
        return null;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getBoolean();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getByte();
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getBytes();
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getCharacterStream();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Clob getClob(int i) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public Clob getClob(String colName) throws SQLException {
        Debug.notSupported(this, "getClob(String)");
        return null;
    }

    protected JdbcDataObject getColumn(int columnIndex) throws SQLException {
        Debug.println(this, "getColumn " + columnIndex);
        this.checkResultSet();
        this._currentColumn = this._prs.getColumn(columnIndex);
        return this._currentColumn;
    }

    public int getConcurrency() throws SQLException {
        return this._concurType;
    }

    public String getCursorName() throws SQLException {
        Debug.println(this, "getCursorName()");
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return Convert.objectToDate(this.getColumn(columnIndex).getDateObject(91, null));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return Convert.objectToDate(this.getColumn(columnIndex).getDateObject(91, cal));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getDouble();
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getFloat();
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getInt();
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getLong();
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return this._prs.getMetaData();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getObject();
    }

    public Object getObject(int i, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(String, java.util.Map)");
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        Debug.notSupported(this, "getRef(String)");
        return null;
    }

    public int getRow() throws SQLException {
        Debug.println(this, "getRow(), where actual row index = " + this._rowIndex);
        if (this._rowIndex <= 0) {
            return 0;
        }
        return this._rowIndex;
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getShort();
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getState() {
        if (this._state == 4) {
            return 0;
        }
        return 1;
    }

    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    public String getString(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getString();
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public TextPointer getSybTextPointer(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getTextPtr();
    }

    public TextPointer getSybTextPointer(String columnName) throws SQLException {
        return this.getSybTextPointer(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return Convert.objectToTime(this.getColumn(columnIndex).getDateObject(92, null));
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return Convert.objectToTime(this.getColumn(columnIndex).getDateObject(92, cal));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(columnIndex).getDateObject(93, null));
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return Convert.objectToTimestamp(this.getColumn(columnIndex).getDateObject(93, cal));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public int getType() throws SQLException {
        return this._scrollType;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getColumn(columnIndex).getUnicodeStream();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._prs.getWarnings();
    }

    public void insertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "insertRow()", this._concurTypeString);
    }

    public boolean isAfterLast() throws SQLException {
        return this._rowIndex == -2;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this._rowIndex == -1;
    }

    public boolean isFirst() throws SQLException {
        return this._rowIndex == 1;
    }

    public boolean isLast() throws SQLException {
        if (this._lastRowIndex != -4) {
            return this._rowIndex == this._lastRowIndex;
        }
        Debug.notImplemented(this, "isLast()");
        return false;
    }

    public boolean last() throws SQLException {
        Debug.println(this, "last()");
        this.checkForScrollability("last()");
        this.moveToCurrentRow();
        if (this._lastRowIndex == -4) {
            if (this._prs.getNumRowsCached() > 0) {
                this._rowIndex = this._prs.getNumRowsCached();
                this._prs.absolute(this._rowIndex);
            }
            while (this.next()) {
            }
            this.previous();
        } else if (this._lastRowIndex != 0) {
            this._rowIndex = this._lastRowIndex;
            this._prs.absolute(this._rowIndex);
        }
        return this._lastRowIndex != 0;
    }

    protected synchronized void markDead(boolean cancelling) throws SQLException {
        if (this._state == 4) {
            return;
        }
        this._state = 4;
        if (this._prs != null) {
            this._prs.close(cancelling);
            if (this._statement != null) {
                Debug.println(this, "clearing warnings in markDead");
                try {
                    SQLWarning sqw = this._prs.getWarnings();
                    if (sqw != null) {
                        this._statement.handleSQLE(sqw);
                    }
                }
                catch (SQLException sQLException) {}
                this._statement.setRowCount(this._prs.getCount());
            }
        }
        if (this._cm != null) {
            this._cm.doneReading();
            this._cm.dead(this);
            this._cm = null;
        }
        if (this._statement != null) {
            this._statement._currentRS = null;
            this._statement = null;
        }
        this._nameToColumn = null;
        this._prs = null;
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
    }

    public boolean next() throws SQLException {
        Debug.println(this, "next");
        this.checkResultSet();
        this.moveToCurrentRow();
        switch (this._rowIndex) {
            case -2: {
                return false;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex > 0) {
                    ++this._rowIndex;
                    break;
                }
                Debug.assert(this, false, "row index has bad value = " + this._rowIndex);
            }
        }
        Debug.assert(this, this._prs != null);
        boolean ret = this._prs.next();
        if (!ret) {
            Debug.println(this, "Last row encountered is #" + (this._rowIndex - 1));
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            if (this._rowIndex == 1) {
                this._lastRowIndex = 0;
                this._rowIndex = -1;
            } else {
                this._lastRowIndex = this._rowIndex - 1;
                this._rowIndex = -2;
            }
        }
        this._currentColumn = null;
        return ret;
    }

    public void open(boolean cacheable) {
    }

    public boolean previous() throws SQLException {
        Debug.println(this, "previous()");
        this.checkForScrollability("previous()");
        boolean retVal = true;
        switch (this._rowIndex) {
            case -1: {
                return false;
            }
            case 1: {
                this._rowIndex = -1;
                retVal = false;
                break;
            }
            case -2: {
                this._rowIndex = this._lastRowIndex;
                break;
            }
            default: {
                --this._rowIndex;
            }
        }
        this._prs.previous();
        return retVal;
    }

    public void refreshRow() throws SQLException {
        switch (this._scrollType) {
            case 1005: {
                Debug.notImplemented(this, "refreshRow() FOR TYPE_SCROLL_SENSITIVE");
                break;
            }
            default: {
                Debug.assert(this, false, "Unrecognized ResultSet type = " + this._scrollType);
            }
            case 1003: 
            case 1004: 
        }
    }

    public boolean relative(int rowOffset) throws SQLException {
        Debug.println(this, "relative(" + rowOffset + ")");
        this.checkForScrollability("relative(int)");
        this.moveToCurrentRow();
        boolean retVal = false;
        if (this._rowIndex != -1 && this._rowIndex != -2) {
            int targetRow = this._rowIndex + rowOffset;
            if (targetRow <= 0) {
                this.beforeFirst();
            } else {
                retVal = this.absolute(targetRow);
            }
        }
        return retVal;
    }

    public void reset() throws IOException {
        Debug.notSupported(this, "reset()");
    }

    public void resetInputStream(InputStream is) {
        Debug.notSupported(this, "resetInputStream(InputStream is)");
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        block0 : switch (this._scrollType) {
            case 1003: {
                ErrorMessage.raiseError("JZ0BT", "setFetchDirection(int)", "TYPE_FORWARD_ONLY");
                break;
            }
            case 1004: 
            case 1005: {
                switch (direction) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this._fetchDirection = direction;
                        break block0;
                    }
                }
                ErrorMessage.raiseError("JZ0I3", String.valueOf(direction), "setFetchDirection(int)");
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows == 0) {
            return;
        }
        int currentMaxRows = this._statement.getMaxRows();
        if (rows < 0 || currentMaxRows > 0 && rows > currentMaxRows) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._fetchSize = rows;
    }

    public void setManager(CacheManager cm) {
        this._cm = cm;
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateAsciiStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(int, BigDecimal)", this._concurTypeString);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x, int precision, int scale) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBigDecimal(String, BigDecimal)", this._concurTypeString);
    }

    public void updateBigDecimal(String columnName, BigDecimal x, int precision, int scale) throws SQLException {
        Debug.notImplemented(this, "updateBigDecimal");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(int, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBinaryStream(String, java.io.InputStream, int)", this._concurTypeString);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(int, boolean)", this._concurTypeString);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBoolean(String, boolean)", this._concurTypeString);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(int, byte)", this._concurTypeString);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateByte(String, byte)", this._concurTypeString);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(int, byte[])", this._concurTypeString);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateBytes(String, byte[])", this._concurTypeString);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(int, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateCharacterStream(String, java.io.Reader, int)", this._concurTypeString);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(int, java.sql.Date)", this._concurTypeString);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDate(String, java.sql.Date)", this._concurTypeString);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(int, double)", this._concurTypeString);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateDouble(String, double)", this._concurTypeString);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(int, float)", this._concurTypeString);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateFloat(String, float)", this._concurTypeString);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(int, int)", this._concurTypeString);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateInt(String, int)", this._concurTypeString);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(int, long)", this._concurTypeString);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateLong(String, long)", this._concurTypeString);
    }

    public void updateNull(int columnIndex) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(int)", this._concurTypeString);
    }

    public void updateNull(String columnName) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateNull(String)", this._concurTypeString);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object)", this._concurTypeString);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(int, Object, int)", this._concurTypeString);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object)", this._concurTypeString);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateObject(String, Object, int)", this._concurTypeString);
    }

    public void updateRow() throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateRow()", this._concurTypeString);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(int, short)", this._concurTypeString);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateShort(String, short)", this._concurTypeString);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(int, String)", this._concurTypeString);
    }

    public void updateString(String columnName, String x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateString(String, String)", this._concurTypeString);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(int, java.sql.Time)", this._concurTypeString);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTime(String, java.sql.Time)", this._concurTypeString);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(int, java.sql.Timestamp)", this._concurTypeString);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        ErrorMessage.raiseError("JZ0BT", "updateTimestamp(String, java.sql.Timestamp)", this._concurTypeString);
    }

    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        if (this._currentColumn == null) {
            ErrorMessage.raiseError("JZ0NC");
        }
        return this._currentColumn.isNull();
    }
}

