/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybConnectionProxy;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.utils.Debug;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SybPooledConnection
extends SybConnection
implements PooledConnection {
    private Vector _listeners = null;
    private SybConnectionProxy _currentProxy = null;

    protected SybPooledConnection(SybUrlProvider up, int loginTimeout) throws SQLException {
        super(up, null, loginTimeout);
        Debug.println(this, "SybPooledConnection()");
        this._listeners = new Vector(5);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        Debug.println(this, "addConnectionEventListener()");
        Debug.assert(this, listener != null, "Tried to add a null listener");
        this._listeners.add(listener);
    }

    public void close() throws SQLException {
        Debug.println(this, "close()");
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            this._currentProxy.close();
        }
        this._listeners.clear();
        super.close();
    }

    public Connection getConnection() throws SQLException {
        Debug.println(this, "getConnection()");
        this.reAssignProxy(this);
        return this._currentProxy;
    }

    protected void notifyListeners(SQLException sqe) {
        ConnectionEvent event;
        Debug.println(this, "notifyListeners()");
        if (sqe == null) {
            Debug.println(this, "event is a connection closed event");
            event = new ConnectionEvent(this);
        } else {
            Debug.println(this, "event is a connection error event");
            event = new ConnectionEvent(this, sqe);
        }
        Debug.println(this, "Broadcasting event to the listeners");
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionEventListener listener = (ConnectionEventListener)enumeration.nextElement();
            if (sqe != null) {
                listener.connectionErrorOccurred(event);
                continue;
            }
            listener.connectionClosed(event);
        }
    }

    private final void reAssignProxy(SybPooledConnection poolConn) {
        if (this._currentProxy != null && !this._currentProxy.wasClosed()) {
            try {
                this._currentProxy.close();
            }
            catch (SQLException sqe) {
                Debug.println(this, "problem closing proxy. " + sqe);
            }
        }
        this._currentProxy = new SybConnectionProxy(poolConn);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Debug.println(this, "removeConnectionEventListener()");
        Debug.assert(this, listener != null, "Tried to remove a null listener");
        this._listeners.remove(listener);
    }
}

