/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.LimiterInputStream;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.tds.SybBigDecimal;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SybCursorResultSet
extends SybResultSet
implements com.sybase.jdbcx.SybCursorResultSet {
    protected Cursor _cursor;
    private ParamManager _paramMgr;
    private ParamManager _insertParamMgr;
    private boolean _rowDeleted = false;
    private boolean _rowUpdated = false;
    private boolean _rowInserted = false;
    private int _savedCurrentRow = -4;

    protected SybCursorResultSet(SybStatement stmt, ProtocolResultSet prs) throws SQLException {
        super(stmt, prs);
        this._cursor = this._statement._cursor;
        this._concurType = this._cursor.getConcurrency();
        if (this._concurType != 1007) {
            int paramCount = prs.getMetaData().getColumnCount();
            this._paramMgr = new ParamManager(paramCount, stmt._context);
            this._insertParamMgr = new ParamManager(paramCount, stmt._context);
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this._rowDeleted || this._rowUpdated || this._rowInserted) {
            ErrorMessage.raiseError("JZ0RM");
        }
        try {
            this._paramMgr.clearParamArray(true);
            this._insertParamMgr.clearParamArray(true);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    protected void close(boolean cancelling) throws SQLException {
        Debug.println(this, "close()");
        this._cursor.close(true);
        super.close(cancelling);
    }

    public void deleteRow() throws SQLException {
        if (this._cursor.delete(this._prs) == 1) {
            this._rowDeleted = true;
        }
    }

    public void deleteRow(String table) throws SQLException {
        this._cursor.setTable(table);
        this._cursor.delete(this._prs);
    }

    protected JdbcDataObject getColumn(int idx) throws SQLException {
        Debug.println(this, "getColumn " + idx);
        this.checkResultSet();
        Debug.println(this, "reading column data from current row.");
        if (this._rowIndex == -3) {
            Param[] params = this._insertParamMgr.getParams();
            if (idx < 1 || idx > params.length) {
                ErrorMessage.raiseError("JZ008", String.valueOf(idx));
            }
            this._currentColumn = params[idx - 1]._sqlType == -999 || params[idx - 1]._sqlType == -998 ? null : (JdbcDataObject)((Object)params[idx - 1]);
        } else if (this._paramMgr != null) {
            Param[] params = this._paramMgr.getParams();
            if (idx < 1 || idx > params.length) {
                ErrorMessage.raiseError("JZ008", String.valueOf(idx));
            }
            if (params[idx - 1]._sqlType == -999 || params[idx - 1]._sqlType == -998) {
                this._currentColumn = this._prs.getColumn(idx);
            } else {
                if (this._rowDeleted) {
                    ErrorMessage.raiseError("JZ0RM");
                }
                this._currentColumn = (JdbcDataObject)((Object)params[idx - 1]);
            }
        } else {
            this._currentColumn = this._prs.getColumn(idx);
        }
        return this._currentColumn;
    }

    public int getConcurrency() throws SQLException {
        if (this._cursor == null) {
            ErrorMessage.raiseError("JZ00D");
        }
        return this._cursor.getConcurrency();
    }

    public String getCursorName() throws SQLException {
        Debug.println(this, "getCursorName()");
        Debug.assert(this, this._cursor != null, "reference to underlying cursor was null");
        return this._cursor.getName();
    }

    public int getFetchSize() throws SQLException {
        return this._cursor.getFetchSize();
    }

    public void insertRow() throws SQLException {
        if (this._rowIndex != -3) {
            ErrorMessage.raiseError("JZ0BR", "insertRow()");
        }
        String insertClause = "INSERT INTO " + this._cursor.getTable() + " ";
        ResultSetMetaData rft = this._prs.getMetaData();
        int numUserColumns = rft.getColumnCount();
        Param[] params = this._insertParamMgr.getParams();
        boolean firstCol = true;
        int i = 0;
        while (i < numUserColumns) {
            if (params[i]._sqlType != -999) {
                insertClause = !firstCol ? String.valueOf(insertClause) + ", " : String.valueOf(insertClause) + "( ";
                insertClause = String.valueOf(insertClause) + rft.getColumnName(i + 1);
                firstCol = false;
            }
            ++i;
        }
        if (!firstCol) {
            insertClause = String.valueOf(insertClause) + " ) ";
            firstCol = true;
        }
        insertClause = String.valueOf(insertClause) + "VALUES (";
        int offset = insertClause.length();
        int i2 = 0;
        while (i2 < numUserColumns) {
            if (params[i2]._sqlType == -999) {
                params[i2]._sqlType = -998;
            } else {
                if (!firstCol) {
                    insertClause = String.valueOf(insertClause) + ", ";
                    offset += 2;
                }
                insertClause = String.valueOf(insertClause) + "?";
                firstCol = false;
                params[i2]._paramMarkerOffset = offset++;
            }
            ++i2;
        }
        if (this._cursor.insert(this._prs, this._insertParamMgr, insertClause = String.valueOf(insertClause) + ")") == 1) {
            this._rowInserted = true;
        }
    }

    public boolean isLanguageCursor() {
        return this._cursor.isLanguageCursor();
    }

    public void moveToCurrentRow() throws SQLException {
        if (this._rowIndex == -3) {
            Debug.println(this, "Moving cursor from insert row to current row.");
            this._rowIndex = this._savedCurrentRow;
            this._rowInserted = false;
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this._concurType == 1008) {
            if (this._rowIndex != -3) {
                Debug.println(this, "Moving cursor from current row to insert row.");
                Debug.assert(this, this._rowInserted ^ true, "tried to move to insert row, and row was marked inserted");
                this._savedCurrentRow = this._rowIndex;
                this._rowIndex = -3;
                try {
                    this._insertParamMgr.clearParamArray(true);
                }
                catch (IOException ioe) {
                    ErrorMessage.raiseError("JZ006", ioe.getMessage());
                }
            }
        } else {
            ErrorMessage.raiseError("JZ0BT", "moveToInsertRow()", this._concurTypeString);
        }
    }

    public boolean next() throws SQLException {
        Debug.println(this, "next");
        this.checkResultSet();
        this.moveToCurrentRow();
        switch (this._rowIndex) {
            case -2: {
                return false;
            }
            case -1: {
                this._rowIndex = 1;
                break;
            }
            default: {
                if (this._rowIndex > 0) {
                    ++this._rowIndex;
                    break;
                }
                Debug.assert(this, false, "row index has bad value = " + this._rowIndex);
            }
        }
        if (this._paramMgr != null) {
            try {
                this._paramMgr.clearParamArray(true);
            }
            catch (IOException iOException) {}
        }
        this._rowDeleted = false;
        this._rowUpdated = false;
        this._rowInserted = false;
        Debug.assert(this, this._prs != null);
        boolean ret = this._prs.next();
        if (!ret) {
            this._prs.close(false);
            if (this._cm != null) {
                this._cm.doneReading();
            }
            this._prs = this._cursor.fetch();
            ret = this._prs == null ? false : this._prs.next();
        }
        if (!ret) {
            if (this._statement != null && this._prs != null) {
                this._statement.setRowCount(this._prs.getCount());
            }
            if (this._rowIndex == 1) {
                this._rowIndex = -1;
                this._lastRowIndex = 0;
            } else {
                this._lastRowIndex = this._rowIndex - 1;
                this._rowIndex = -2;
            }
            Debug.println(this, "End of result set. Last row = #" + this._lastRowIndex);
        }
        return ret;
    }

    public boolean rowDeleted() throws SQLException {
        return this._rowDeleted;
    }

    public boolean rowInserted() throws SQLException {
        return this._rowInserted;
    }

    public boolean rowUpdated() throws SQLException {
        return this._rowUpdated;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows == 0) {
            return;
        }
        int currentMaxRows = this._statement.getMaxRows();
        if (rows < 0 || currentMaxRows > 0 && rows > currentMaxRows) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this._cursor.setFetchSize(rows);
    }

    private void setParam(int type, int index, Object value) throws SQLException {
        this.setParam(type, index, value, 0);
    }

    private void setParam(int type, int index, Object value, int scale) throws SQLException {
        this.checkResultSet();
        if (this._paramMgr != null) {
            if (this._rowIndex != -3) {
                Debug.println(this, "UPDATE: Set param #" + index + " to value " + value);
                this._paramMgr.setParam(index, type, value, scale);
            } else {
                Debug.println(this, "INSERT: Set param #" + index + " to value " + value);
                this._insertParamMgr.setParam(index, type, value, scale);
                this._rowInserted = false;
            }
        } else {
            ErrorMessage.raiseError("JZ00H");
        }
    }

    public void updateAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new LimiterInputStream(x, length), "8859_1");
            this.setParam(-1, parameterIndex, isr, length);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParam(2, parameterIndex, x);
    }

    public void updateBigDecimal(int parameterIndex, BigDecimal x, int precision, int scale) throws SQLException {
        if (x == null) {
            x = new BigDecimal("0");
        }
        SybBigDecimal sbd = new SybBigDecimal(x, precision, scale);
        this.setParam(2, parameterIndex, sbd);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x, int precision, int scale) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x, precision, scale);
    }

    public void updateBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(-4, parameterIndex, x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateBoolean(int parameterIndex, boolean x) throws SQLException {
        Boolean value = new Boolean(x);
        this.setParam(-7, parameterIndex, value);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(int parameterIndex, byte x) throws SQLException {
        Integer value = new Integer(x);
        if (value < 0) {
            this.setParam(5, parameterIndex, value);
        } else {
            this.setParam(-6, parameterIndex, value);
        }
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateBytes(int parameterIndex, byte[] x) throws SQLException {
        int length = 0;
        if (x != null) {
            length = x.length;
        }
        if (length > 255) {
            this.setParam(-4, parameterIndex, x);
        } else {
            this.setParam(-3, parameterIndex, x);
        }
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateCharacterStream(int parameterIndex, Reader r, int length) throws SQLException {
        this.setParam(-1, parameterIndex, r, length);
    }

    public void updateCharacterStream(String columnName, Reader r, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), r, length);
    }

    public void updateDate(int parameterIndex, Date x) throws SQLException {
        this.setParam(91, parameterIndex, new DateObject(x));
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateDouble(int parameterIndex, double x) throws SQLException {
        Double value = new Double(x);
        this.setParam(8, parameterIndex, value);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateFloat(int parameterIndex, float x) throws SQLException {
        Float value = new Float(x);
        this.setParam(7, parameterIndex, value);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateInt(int parameterIndex, int x) throws SQLException {
        Integer value = new Integer(x);
        this.setParam(4, parameterIndex, value);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(int parameterIndex, long x) throws SQLException {
        Long value = new Long(x);
        this.setParam(-5, parameterIndex, value);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateNull(int parameterIndex) throws SQLException {
        int originalType = this.getMetaData().getColumnType(parameterIndex);
        Debug.println(this, "updateNull is using " + originalType + " instead of Types.NULL (" + 0 + ")");
        this.setParam(originalType, parameterIndex, null);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateObject(int parameterIndex, Object x) throws SQLException {
        this.updateObject(parameterIndex, x, 0);
    }

    public void updateObject(int parameterIndex, Object x, int scale) throws SQLException {
        if (x == null) {
            this.updateNull(parameterIndex);
        } else if (x instanceof String) {
            this.updateString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setParam(2, parameterIndex, x, scale);
        } else if (x instanceof Boolean) {
            this.setParam(-7, parameterIndex, x, scale);
        } else if (x instanceof Integer) {
            this.setParam(4, parameterIndex, x, scale);
        } else if (x instanceof Long) {
            this.setParam(-5, parameterIndex, x, scale);
        } else if (x instanceof Float) {
            this.setParam(7, parameterIndex, x, scale);
        } else if (x instanceof Double) {
            this.setParam(8, parameterIndex, x, scale);
        } else if (x instanceof byte[]) {
            this.updateBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.updateDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.updateTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.updateTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Serializable) {
            this.setParam(2000, parameterIndex, x, scale);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, 0);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateRow() throws SQLException {
        StringBuffer setClause = new StringBuffer("UPDATE " + this._cursor.getTable() + " SET ");
        int offset = setClause.length();
        ResultSetMetaData rft = this._prs.getMetaData();
        int numUserColumns = rft.getColumnCount();
        Param[] params = this._paramMgr.getParams();
        boolean firstCol = true;
        int i = 0;
        while (i < numUserColumns) {
            if (params[i]._sqlType == -999) {
                params[i]._sqlType = -998;
            } else if (params[i]._sqlType != -998) {
                if (!firstCol) {
                    setClause.append(", ");
                    offset += 2;
                }
                String colName = rft.getColumnName(i + 1);
                offset += colName.length() + 3;
                setClause.append(String.valueOf(colName) + " = ?");
                params[i]._paramMarkerOffset = offset++;
                firstCol = false;
            }
            ++i;
        }
        Debug.println(this, "Set Clause: " + setClause.toString());
        if (firstCol) {
            ErrorMessage.raiseError("JZ00G");
        }
        if (this._cursor.update(this._prs, this._paramMgr, setClause.toString()) == 1) {
            this._rowUpdated = true;
        }
    }

    public void updateRow(String table) throws SQLException {
        this._cursor.setTable(table);
        this.updateRow();
    }

    public void updateShort(int parameterIndex, short x) throws SQLException {
        Integer value = new Integer(x);
        this.setParam(5, parameterIndex, value);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateString(int parameterIndex, String x) throws SQLException {
        int length = 0;
        if (x != null && (length = x.length()) == 0) {
            x = new String(" ");
        }
        this.setParam(12, parameterIndex, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateTime(int parameterIndex, Time x) throws SQLException {
        this.setParam(92, parameterIndex, new DateObject(x));
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParam(93, parameterIndex, new DateObject(x));
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }
}

