/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybCursorResultSet;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class SybCallableStatement
extends SybPreparedStatement
implements com.sybase.jdbcx.SybCallableStatement {
    protected boolean _hasOutParam = false;

    SybCallableStatement(ProtocolContext pc, String sql) throws SQLException {
        super(pc, sql);
        Debug.println(this, "Constructor()");
        if (this._hasReturn) {
            this._paramMgr.setParam(1, -998, new Integer(0), 0);
            this._paramMgr.registerParam(1, 4, 0);
            this._returnHasBeenRegistered = false;
        }
    }

    public void addBatch() throws SQLException {
        if (this._batchCmdsCount < 1) {
            this._query = this.handleCallBody(this._query);
        }
        super.addBatch();
    }

    public void cancel() throws SQLException {
        Debug.println(this, "cancel");
        this.checkStatement(false);
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException iOException) {}
        super.cancel();
    }

    private void checkOutParamRegistration(int index) throws SQLException {
        if (!this._allowsOutputParms) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(index));
        } else if (this._hasReturn && index == 1) {
            this._returnHasBeenRegistered = true;
        }
    }

    public void clearParams() throws SQLException {
        try {
            this._paramMgr.clearParams(false);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public boolean execute() throws SQLException {
        Debug.println(this, "execute " + this._query);
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.executeLoop();
            }
            return this._currentRS != null;
        }
        return super.execute(this._query, this._paramMgr);
    }

    public int[] executeBatch() throws SQLException {
        if (this._hasReturn || this._hasOutParam) {
            ErrorMessage.raiseError("JZ0BP");
        }
        return super.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        Debug.println(this, "executeQuery " + this._query);
        this.clearParams();
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                return this.queryLoop();
            }
            return this._currentRS;
        }
        return super.executeQuery(this._query, this._paramMgr);
    }

    public int executeUpdate() throws SQLException {
        Debug.println(this, "executeUpdate " + this._query);
        this.clearParams();
        int ret = -1;
        if (this._rpcName != null) {
            this.checkStatement(true);
            if (this._cursor != null) {
                ErrorMessage.raiseError("JZ0S3");
            }
            if (this.sendRpc(this._rpcName, this._paramMgr)) {
                ret = this.updateLoop();
            }
        } else {
            ret = super.executeUpdate(this._query, this._paramMgr);
        }
        return ret;
    }

    public Array getArray(int i) throws SQLException {
        Debug.notSupported(this, "getArray(int)");
        return null;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getBigDecimal(parameterIndex, -1);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getBigDecimal(scale);
    }

    public Blob getBlob(int i) throws SQLException {
        Debug.notSupported(this, "getBlob(int)");
        return null;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getBoolean();
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getByte();
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getBytes();
    }

    public Clob getClob(int i) throws SQLException {
        Debug.notSupported(this, "getClob(int)");
        return null;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(91, null));
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return Convert.objectToDate(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(91, cal));
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getDouble();
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getFloat();
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getInt();
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getLong();
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutObjectAt(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        Debug.notImplemented(this, "getObject(int, java.util.Map)");
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        Debug.notSupported(this, "getRef(int)");
        return null;
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getShort();
    }

    public String getString(int parameterIndex) throws SQLException {
        return this._paramMgr.getOutValueAt(parameterIndex).getString();
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(92, null));
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return Convert.objectToTime(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(92, cal));
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(93, null));
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return Convert.objectToTimestamp(this._paramMgr.getOutValueAt(parameterIndex).getDateObject(93, cal));
    }

    protected void handleParam(ParamManager pm) throws SQLException {
        if (this._batchCmds == null) {
            this._paramMgr.getParameter();
        } else {
            pm.getParameter();
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.checkOutParamRegistration(parameterIndex);
        this._paramMgr.registerParam(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.checkOutParamRegistration(parameterIndex);
        this._paramMgr.registerParam(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this._paramMgr.registerParam(parameterIndex, sqlType, typeName);
    }

    public boolean sendRpc(String rpc, ParamManager params) throws SQLException {
        try {
            if (this._rsConcur == -9) {
                this._rsConcur = 1007;
            }
            if (this._rsConcur == 1008) {
                Debug.println(this, "creating a cursor because user requested updatable concurrency.");
                this.checkCursor(false);
            }
            if (this._cursor != null) {
                ProtocolResultSet prs = this._cursor.open(rpc, params, true);
                prs.setType(this._rsType);
                this._currentRS = new SybCursorResultSet(this, prs);
                this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
                this._state = 2;
                return false;
            }
            this._protocol.rpc(this._context, rpc, params);
        }
        catch (SQLException sqe) {
            this.handleSQLE(sqe);
        }
        return true;
    }

    public void setParameterName(int index, String name) {
        Param[] params = this._paramMgr.getParams();
        if (params.length >= index && index > 0) {
            params[index - 1]._name = name;
        } else {
            Debug.assert(this, false, "Parameter index out of range.");
        }
    }

    public boolean wasNull() throws SQLException {
        return this._paramMgr.wasNull();
    }
}

