/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.EscapeTokenizer;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Escape {
    protected static final int CALL = 1;
    protected static final int RETURN_CALL = 2;
    protected static final int DATE = 3;
    protected static final int TIME = 4;
    protected static final int TIMESTAMP = 5;
    protected static final int FUNCTION = 6;
    protected static final int LIKE_ESCAPE = 7;
    protected static final int OUTER_JOIN = 8;
    protected static final int UNKNOWN = -1;
    private static final char LEFT_CURLY = '{';
    private static final char RIGHT_CURLY = '}';
    private static final char COMMA = ',';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char PERCENT_SIGN = '%';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final int MAX_ARGUMENTS = 4;
    private int _type;
    private String _body;

    Escape(String text) throws SQLException {
        Debug.println(this, "Escape constructor called on text '" + text + "'");
        int length = text.length();
        Debug.assert(this, text.charAt(0) == '{');
        Debug.assert(this, text.charAt(length - 1) == '}');
        int firstKeywordIndex = 1;
        while (firstKeywordIndex < length && Character.isWhitespace(text.charAt(firstKeywordIndex))) {
            ++firstKeywordIndex;
        }
        Debug.println(this, "firstKeywordIndex = " + firstKeywordIndex);
        if (firstKeywordIndex == length) {
            ErrorMessage.raiseError("JZ0S8", text);
        }
        int firstIndexPastKeyword = firstKeywordIndex;
        while (firstIndexPastKeyword < length && !Character.isWhitespace(text.charAt(firstIndexPastKeyword))) {
            ++firstIndexPastKeyword;
        }
        Debug.println(this, "firstIndexPastKeyword = " + firstIndexPastKeyword);
        if (firstIndexPastKeyword == length) {
            ErrorMessage.raiseError("JZ0S8", text);
        }
        String keyword = text.substring(firstKeywordIndex, firstIndexPastKeyword).toLowerCase();
        Debug.println(this, "keyword = " + keyword);
        if (keyword.equals("call")) {
            this._type = 1;
        } else if (keyword.equals("?") || keyword.equals("?=") || keyword.equals("?=call")) {
            firstIndexPastKeyword = text.toLowerCase().indexOf("call") + 4;
            this._type = 2;
        } else if (keyword.equals("d")) {
            this._type = 3;
        } else if (keyword.equals("t")) {
            this._type = 4;
        } else if (keyword.equals("ts")) {
            this._type = 5;
        } else if (keyword.equals("fn")) {
            this._type = 6;
        } else if (keyword.equals("escape")) {
            this._type = 7;
        } else if (keyword.equals("oj")) {
            this._type = 8;
        } else {
            ErrorMessage.raiseError("JZ0S8", text);
        }
        Debug.println(this, "_type = " + this._type);
        int firstBodyIndex = firstIndexPastKeyword;
        while (firstBodyIndex < length && Character.isWhitespace(text.charAt(firstBodyIndex))) {
            ++firstBodyIndex;
        }
        if (firstBodyIndex == length) {
            ErrorMessage.raiseError("JZ0S8", text);
        }
        this._body = text.substring(firstBodyIndex, length - 1);
        Debug.println(this, "_body = " + this._body);
    }

    Escape(String text, int type) throws SQLException {
        this._body = text;
        this._type = type;
    }

    protected String doMap(String mapString) throws SQLException {
        String[] arguments = new String[5];
        Debug.assert(this, this._type == 6);
        int start = this._body.indexOf(40);
        int end = this._body.lastIndexOf(41);
        if (start < 0 || end < 0 || end < start + 1) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        String argumentString = this._body.substring(start + 1, end);
        int i = 1;
        while (i <= 4 && argumentString.length() > 0) {
            int commaIndex = this.nextComma(argumentString);
            if (commaIndex < 0) {
                arguments[i] = argumentString;
                break;
            }
            if (commaIndex == 0) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            } else {
                arguments[i] = argumentString.substring(0, commaIndex);
                argumentString = argumentString.substring(commaIndex + 1);
            }
            ++i;
        }
        StringBuffer returnValue = new StringBuffer();
        int mapLength = mapString.length();
        int i2 = 0;
        while (i2 < mapLength) {
            if (mapString.charAt(i2) == '%') {
                int argumentNumber = 0;
                try {
                    argumentNumber = Integer.parseInt(mapString.substring(i2 + 1, i2 + 2));
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.assert(this, false);
                }
                Debug.assert(this, argumentNumber <= 4);
                if (arguments[argumentNumber] == null) {
                    Debug.println(this, "couldn't map body '" + this._body + "' using map string '" + mapString + "'; argument #" + argumentNumber + " not found");
                    ErrorMessage.raiseError("JZ0S8", this._body);
                } else {
                    returnValue.append(arguments[argumentNumber]);
                }
                ++i2;
            } else {
                returnValue.append(mapString.charAt(i2));
            }
            ++i2;
        }
        return returnValue.toString();
    }

    protected String functionName() throws SQLException {
        String returnValue = null;
        Debug.assert(this, this._type == 6);
        try {
            StringTokenizer tokenizer = new StringTokenizer(this._body, " \t\n\r(");
            returnValue = tokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        returnValue = returnValue.toLowerCase();
        if (returnValue.equals("convert") || returnValue.equals("timestampadd") || returnValue.equals("timestampdiff")) {
            int end;
            int start;
            if (returnValue.equals("convert")) {
                start = this._body.lastIndexOf(44) + 1;
                end = this._body.lastIndexOf(41) - 1;
            } else {
                start = this._body.indexOf(40) + 1;
                end = this._body.indexOf(44) - 1;
            }
            int length = this._body.length();
            Debug.println(this, "body = '" + this._body + "', start = " + start + ", end = " + end);
            while (start <= length && Character.isWhitespace(this._body.charAt(start))) {
                ++start;
            }
            while (end > 0 && Character.isWhitespace(this._body.charAt(end))) {
                --end;
            }
            Debug.println(this, "start = " + start + ", end = " + end);
            if (start < 0 || end < 0 || end < start + 1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
            returnValue = String.valueOf(returnValue) + this._body.substring(start, end + 1).toLowerCase();
        }
        return returnValue;
    }

    protected String getBody() {
        return this._body;
    }

    protected int getType() {
        return this._type;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextComma(String s) throws SQLException {
        int length = s.length();
        int returnValue = -1;
        int state = 1;
        int i = 0;
        while (i < length) {
            char nextChar = s.charAt(i);
            switch (nextChar) {
                case '\"': 
                case '\'': {
                    state = EscapeTokenizer.nextState(state, nextChar);
                    break;
                }
                case '(': {
                    if (state != 1 || (i = EscapeTokenizer.matchClosingChar(nextChar, new StringBuffer(s), i)) >= 0) break;
                    ErrorMessage.raiseError("JZ0S8", this._body);
                    break;
                }
                case ',': {
                    if (state != 1) break;
                    return i;
                }
            }
            ++i;
        }
        return returnValue;
    }
}

