/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.CacheStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CharsetToUniInputStream
extends RawInputStream {
    private int _currentChar;
    private int _readBytes = 0;
    private int _lengthLimit = 0;
    private InputStreamReader _isr = null;
    private RawInputStream _ris = null;
    private boolean _even;
    private boolean _closed;

    public CharsetToUniInputStream(InputStream stream, int length, int lengthLimit, CacheManager cm, String charsetName) throws UnsupportedEncodingException, IOException {
        super(stream, length, lengthLimit, cm);
        this._lengthLimit = lengthLimit * 2;
        this._ris = new RawInputStream(stream, length, lengthLimit, cm);
        this._isr = charsetName == null ? new InputStreamReader(this._ris) : new InputStreamReader((InputStream)this._ris, charsetName);
        this._even = true;
        this._closed = false;
    }

    public int available() throws IOException {
        if (this._closed) {
            return 0;
        }
        int avail = this._lengthLimit - this._readBytes;
        Debug.println(this, "Available = " + avail);
        return avail;
    }

    public boolean cache(CacheStream is) throws IOException {
        return this._ris.cache(is);
    }

    public void close() throws IOException {
        this._ris.close();
    }

    public int read() throws IOException {
        int retVal;
        if (this._closed) {
            return -1;
        }
        if (this._even) {
            this._currentChar = this._isr.read();
            if (this._currentChar == -1) {
                Debug.println(this, "end of data");
                this._closed = true;
                return -1;
            }
            retVal = (this._currentChar & 0xFF00) >> 8;
        } else {
            retVal = this._currentChar & 0xFF;
        }
        this._even ^= true;
        ++this._readBytes;
        return retVal;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        Debug.println(this, "read into buffer " + length);
        int i = 0;
        while (i < length) {
            int val = this.read();
            if (val == -1) {
                return i == 0 ? -1 : i;
            }
            buf[i + offset] = (byte)(val & 0xFF);
            ++i;
        }
        return i;
    }

    public void setCached(boolean cached) {
        this._ris.setCached(cached);
    }

    public long skip(long n) throws IOException {
        long i = 0L;
        while (i < n) {
            if (this.read() < 0) break;
            ++i;
        }
        return i;
    }
}

