/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.TraceInputStream;
import com.sybase.jdbc2.jdbc.TraceOutputStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Capture
implements com.sybase.jdbcx.Capture {
    public static final int OFFLINE = 0;
    public static final int PAUSE = 1;
    public static final int RECORD = 2;
    public static final int TDS_DUMP_VSN_0 = 0;
    public static final int TDS_DUMP_VSN_1 = 1;
    public static final String PROGRAM_NAME = "Capture";
    public static final String CLIENT_NAME = "jConnect Application";
    public static final String SERVER_NAME = "Application Server";
    public static final int NAME_LENGTH = 256;
    public static final int REQUEST = 1;
    public static final int RESPONSE = 2;
    private DataOutputStream _captureStream;
    private TraceOutputStream _out;
    private TraceInputStream _in;
    private String _programName;

    public Capture(OutputStream captureStream) throws IOException {
        this(captureStream, PROGRAM_NAME);
    }

    public Capture(OutputStream captureStream, String programName) throws IOException {
        this._programName = programName;
        this._captureStream = new DataOutputStream(captureStream);
        this.writeStreamHeader();
    }

    public InputStream getInputStream(InputStream in) {
        Debug.println(this, "Capture.getInputStream()");
        if (this._in == null) {
            this._in = new TraceInputStream(this, in, 2);
        }
        return this._in;
    }

    private byte[] getNameByteArray(String src) {
        byte[] buf = new byte[256];
        int length = src.length() < 256 ? src.length() : 256;
        System.arraycopy(src.getBytes(), 0, buf, 0, length);
        return buf;
    }

    public OutputStream getOutputStream(OutputStream out) {
        Debug.println(this, "Capture.getOutputStream()");
        if (this._out == null) {
            this._out = new TraceOutputStream(this, out, 2);
        }
        return this._out;
    }

    public void pause() {
        Debug.println(this, "Capture.pause()");
        if (this._in != null && this._out != null) {
            this._in.setState(1);
            this._out.setState(1);
        }
    }

    public void resume() {
        Debug.println(this, "Capture.resume()");
        if (this._in != null && this._out != null) {
            this._in.setState(2);
            this._out.setState(2);
        }
    }

    public synchronized void writeBuffer(int source, byte[] b, int off, int len) throws IOException {
        Debug.println(this, "Capture.writeBuffer(" + source + ", b, " + off + ", " + len + ")");
        this._captureStream.writeInt(source);
        this._captureStream.writeInt(len);
        this._captureStream.write(b, off, len);
        this._captureStream.flush();
    }

    private void writeStreamHeader() throws IOException {
        Debug.println(this, "Capture.writeStreamHeader()");
        this._captureStream.writeInt(1);
        this._captureStream.writeInt(885842144);
        this._captureStream.write(this.getNameByteArray(this._programName), 0, 256);
        this._captureStream.writeInt(0);
        this._captureStream.writeInt(0);
        this._captureStream.write(this.getNameByteArray(CLIENT_NAME), 0, 256);
        this._captureStream.write(this.getNameByteArray(SERVER_NAME), 0, 256);
        this._captureStream.flush();
    }
}

