/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.PieChart;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PieChartRenderer
extends ChartRenderer {
    public static final int SELECTION_STYLE_TRIANGLE = 0;
    public static final int SELECTION_STYLE_CIRCLE = 1;
    public static final int SELECTION_STYLE_DETACHED = 2;
    private double[][] angle_start;
    private double[][] angle_end;
    private Rectangle[] pieBounds;
    private Rectangle[] pieOuterBounds;
    private Point[] pieCenter;
    private int[] pieWidth;
    private double oldAngle;
    private int rotatedPie;
    private long lastClickTime;
    private int pointingDistance;
    private double size_factor;
    private int top_slice;
    private int bottom_slice;
    private static final int PAINT_RIGHT = 0;
    private static final int PAINT_LEFT = 1;
    private static final int PAINT_90 = 2;
    private static final int PAINT_270 = 3;
    PieChart chart;

    public PieChartRenderer(PieChart chart) {
        super(chart);
        this.chart = chart;
        this.legend = chart.legend;
        this.gridRenderer = chart.gridRenderer;
        this.legendRenderer = chart.legendRenderer;
        int seriesCount = chart.getSeriesCount();
        int sampleCount = chart.getSampleCount();
        this.angle_start = new double[seriesCount][sampleCount];
        this.angle_end = new double[seriesCount][sampleCount];
        this.pieBounds = new Rectangle[seriesCount == 1 ? 1 : sampleCount];
        this.pieOuterBounds = new Rectangle[seriesCount == 1 ? 1 : sampleCount];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        for (int i = 0; i < this.pieBounds.length; ++i) {
            this.pieBounds[i] = new Rectangle();
            this.pieOuterBounds[i] = new Rectangle();
            this.pieCenter[i] = new Point();
        }
    }

    protected Point getSampleCenter(int sample, int serie) {
        Point centerPoint = new Point();
        int seriesCount = this.getSeriesCount();
        Point center = this.pieCenter[seriesCount > 1 ? sample : 0];
        if (center == null) {
            return null;
        }
        double start = this.angle_start[serie][sample];
        double end = this.angle_end[serie][sample];
        double angle = -((start + end) / 2.0);
        double factor = 1.0;
        int width = this.pieWidth[seriesCount == 1 ? 0 : sample];
        double detach = 0.0;
        if (this.chart.isSelected(serie, sample) && start - end < 360.0 && this.chart.getSelectionStyle() == 2) {
            detach = (double)width * this.chart.getDetachedDistance() / 2.0;
        }
        if (this.display3dOn) {
            int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
            factor = (double)(width - change) / (double)width;
        }
        double rad = angle * (Math.PI / 180);
        centerPoint.x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.3 + Math.cos(rad) * detach);
        centerPoint.y = center.y + (int)Math.round((Math.sin(rad) * (double)width * 0.3 + Math.sin(rad) * detach) * factor);
        if (this.chart.getGraphBounds().contains(centerPoint)) {
            return centerPoint;
        }
        return null;
    }

    public Polygon getSlicePolygon(int serie, int sample) {
        double detach;
        Polygon poly = new Polygon();
        int pieIndex = 0;
        double start = this.angle_start[0][sample];
        double stop = this.angle_end[0][sample];
        if (this.getSeriesCount() == 1) {
            detach = this.chart.getDetachedSlice(0, sample);
        } else {
            detach = this.chart.getDetachedSlice(sample, serie);
            pieIndex = sample;
            start = this.angle_start[serie][pieIndex];
            stop = this.angle_end[serie][pieIndex];
        }
        start = -start;
        stop = -stop;
        int width = this.pieWidth[pieIndex];
        Point center = new Point();
        center.x = this.pieCenter[pieIndex].x;
        center.y = this.pieCenter[pieIndex].y;
        double factor = 1.0;
        if (this.display3dOn) {
            int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
            factor = (double)(width - change) / (double)width;
        }
        double rad = (start + stop) * (Math.PI / 180) / 2.0;
        int angle_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.5 * detach);
        int angle_y = center.y + (int)Math.round(Math.sin(rad) * (double)width * 0.5 * detach * factor);
        poly.addPoint(angle_x, angle_y);
        rad = start * (Math.PI / 180);
        angle_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.5 * (1.0 + detach));
        angle_y = center.y + (int)Math.round(Math.sin(rad) * (double)width * 0.5 * (1.0 + detach) * factor);
        poly.addPoint(angle_x, angle_y);
        for (double cur_angle = start + 5.0; cur_angle < stop; cur_angle += 5.0) {
            rad = cur_angle * (Math.PI / 180);
            angle_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.5 * (1.0 + detach));
            angle_y = center.y + (int)Math.round(Math.sin(rad) * (double)width * 0.5 * (1.0 + detach) * factor);
            poly.addPoint(angle_x, angle_y);
        }
        rad = stop * (Math.PI / 180);
        angle_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.5 * (1.0 + detach));
        angle_y = center.y + (int)Math.round(Math.sin(rad) * (double)width * 0.5 * (1.0 + detach) * factor);
        poly.addPoint(angle_x, angle_y);
        return poly;
    }

    protected void calculateGraphBounds(Rectangle gridBounds) {
        Insets insets;
        Dimension size = this.chart.getSize();
        this.legendRenderer.calculateGraphBounds(this.legend, gridBounds);
        this.display3dOn = this.chart.is3DModeOn();
        if (this.chart.isTitleOn()) {
            Dimension titleSize = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            gridBounds.y += titleSize.height;
            gridBounds.height -= titleSize.height;
        }
        if ((insets = this.chart.getGraphInsets()) != null) {
            if (insets.top != -1) {
                int bottom = gridBounds.y + gridBounds.height;
                gridBounds.y = insets.top;
                gridBounds.height = bottom - gridBounds.y;
            }
            if (insets.left != -1) {
                int right = gridBounds.x + gridBounds.width;
                gridBounds.x = insets.left;
                gridBounds.width = right - gridBounds.x;
            }
            if (insets.bottom != -1) {
                gridBounds.height = size.height - insets.bottom - gridBounds.y;
            }
            if (insets.right != -1) {
                gridBounds.width = size.width - insets.right - gridBounds.x;
            }
        }
    }

    public void render(Graphics g) {
        this.render(g, !this.chart.isServletModeOn());
    }

    protected void checkDataIntegrity() {
        int seriesCount = this.chart.getSeriesCount();
        int sampleCount = this.chart.getSampleCount();
        this.angle_start = new double[seriesCount][sampleCount];
        this.angle_end = new double[seriesCount][sampleCount];
        this.pieBounds = new Rectangle[seriesCount == 1 ? 1 : sampleCount];
        this.pieOuterBounds = new Rectangle[seriesCount == 1 ? 1 : sampleCount];
        this.pieCenter = new Point[this.pieBounds.length];
        this.pieWidth = new int[this.pieBounds.length];
        for (int i = 0; i < this.pieBounds.length; ++i) {
            this.pieBounds[i] = new Rectangle();
            this.pieOuterBounds[i] = new Rectangle();
            this.pieCenter[i] = new Point();
        }
    }

    protected void renderData(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        this.paintPies(g, gridBounds);
        this.paintStaticLabels(g);
    }

    protected void calculateChartData(Rectangle gridBounds, Rectangle dataBounds) {
    }

    private void paintPies(Graphics g, Rectangle bounds) {
        Rectangle bounds1 = new Rectangle(10, 10, this.chart.getSize().width - 20, this.chart.getSize().height - 20);
        this.calculateGraphBounds(bounds1);
        int seriesCount = this.getSeriesCount();
        if (seriesCount == 1) {
            double[] values = this.chart.getSampleValues(0);
            this.calculatePieBounds(bounds, 1);
            this.paintPie(g, this.pieBounds[0], values, 0);
        } else {
            int sampleCount = this.getSampleCount();
            this.calculatePieBounds(bounds, sampleCount);
            for (int sample = 0; sample < sampleCount; ++sample) {
                double[] values = new double[seriesCount];
                for (int serie = 0; serie < seriesCount; ++serie) {
                    values[serie] = this.chart.getSampleValue(serie, sample);
                }
                this.paintPie(g, this.pieBounds[sample], values, sample);
            }
        }
    }

    private void calculatePieBounds(Rectangle bounds, int count) {
        int y;
        int max = 0;
        int optimal_x = count;
        int optimal_y = 1;
        for (int x = 1; x <= count; ++x) {
            for (y = 1; y <= count; ++y) {
                int size;
                if (x * y < count || (size = Math.min(bounds.width / x, bounds.height / y)) <= max) continue;
                max = size;
                optimal_x = x;
                optimal_y = y;
            }
        }
        int currentPie = 0;
        for (y = 0; y < optimal_y; ++y) {
            for (int x = 0; x < optimal_x; ++x) {
                if (currentPie >= count) continue;
                Rectangle r = this.pieOuterBounds[currentPie];
                r.width = bounds.width / optimal_x;
                r.height = bounds.height / optimal_y;
                r.x = bounds.x + r.width * x;
                r.y = bounds.y + r.height * y;
                if (count > 1) {
                    r.width -= 10;
                    r.height -= 10;
                    r.x += 5;
                    r.y += 5;
                }
                this.pieBounds[currentPie].setBounds(this.pieOuterBounds[currentPie]);
                ++currentPie;
            }
        }
    }

    private void paintPie(Graphics g, Rectangle bounds, double[] values, int pieIndex) {
        double bottom_end;
        double bottom_start;
        double end;
        double start;
        int slice;
        double top_end;
        double top_start;
        int i;
        int effect3d;
        int width;
        if (bounds == null || bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            if (!Double.isNaN(values[i2])) continue;
            values[i2] = 0.0;
        }
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        int percentLabelStyle = this.chart.getPercentLabelStyle();
        boolean valueLabelsOn = this.chart.isValueLabelsOn();
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean percentLabelsOn = this.chart.isPercentLabelsOn();
        boolean outsideOn = percentLabelsOn && percentLabelStyle == 1 || sampleLabelsOn && sampleLabelStyle == 1 || seriesLabelsOn && seriesLabelStyle == 1 || valueLabelsOn && valueLabelStyle == 1;
        boolean pointingOn = percentLabelsOn && percentLabelStyle == 5 || sampleLabelsOn && sampleLabelStyle == 5 || seriesLabelsOn && seriesLabelStyle == 5 || valueLabelsOn && valueLabelStyle == 5;
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        int max_label_width = 0;
        int max_label_height = 0;
        double detachedDistance = this.chart.getDetachedDistance();
        int selectionStyle = this.chart.getSelectionStyle();
        if (outsideOn || pointingOn) {
            Font font = this.getFont("outsideLabelFont");
            if (pointingOn) {
                font = this.getFont("pointingLabelFont");
            }
            FontMetrics fm = this.getFontMetrics(font);
            for (int serie = 0; serie < seriesCount; ++serie) {
                for (int sample = 0; sample < sampleCount; ++sample) {
                    ChartSample s = seriesCount == 1 ? this.chart.getSample(0, sample) : this.chart.getSample(serie, sample);
                    if (s == null || s.value == null || s.value.isNaN()) continue;
                    String label = this.chart.constructLabel(serie, sample, 1, true, null);
                    if (pointingOn) {
                        label = this.chart.constructLabel(serie, sample, 5, true, null);
                    }
                    Dimension labelSize = this.getLabelSize(label, fm);
                    max_label_width = Math.max(max_label_width, labelSize.width);
                    max_label_height = Math.max(max_label_height, labelSize.height);
                }
            }
            bounds.x += max_label_width;
            bounds.width -= max_label_width * 2;
            if (outsideOn && !pointingOn) {
                bounds.y += max_label_height;
                bounds.height -= max_label_height * 2;
            }
        }
        int height = width = Math.min(bounds.width, bounds.height);
        int center_x = bounds.x + bounds.width / 2;
        int center_y = bounds.y + bounds.height / 2;
        Font pieLabelFont = this.getFont("pieLabelFont");
        if (pieLabelFont == null) {
            pieLabelFont = this.chart.getFont();
        }
        FontMetrics fm = this.getFontMetrics(pieLabelFont);
        g.setFont(pieLabelFont);
        double pieAngle = this.chart.getAngle();
        double pieDepth = this.chart.getDepth();
        if (this.display3dOn) {
            effect3d = (int)Math.round((double)width * pieDepth * (pieAngle / 90.0));
            center_y -= effect3d / 2;
            double factor_width = (double)bounds.width / (double)width;
            int new_width = (int)Math.round((double)width * factor_width);
            int new_height = (int)Math.round((double)(height -= (int)Math.round((double)width * (pieAngle / 90.0))) * factor_width);
            effect3d = (int)Math.round((double)new_width * pieDepth * (pieAngle / 90.0));
            int height3d = new_height + effect3d;
            center_y = bounds.y + bounds.height / 2 - effect3d / 2;
            if (center_y - new_height / 2 < bounds.y) {
                double factor_height = (double)new_height / (double)height3d;
                height3d = bounds.height;
                new_height = (int)Math.round((double)height3d * factor_height);
                effect3d = bounds.height - new_height;
                factor_width = (double)width / (double)height;
                new_width = (int)Math.round((double)new_height * factor_width);
                center_y = bounds.y + bounds.height / 2 - effect3d / 2;
            }
            width = new_width;
            height = new_height;
        }
        this.size_factor = (double)height / (double)width;
        if (outsideOn || pointingOn) {
            int cur_width;
            if (this.display3dOn) {
                if (!pointingOn) {
                    if ((height = (int)((double)(width -= (int)((double)width / 11.0)) * this.size_factor)) + (effect3d = (int)Math.round((double)width * pieDepth * (pieAngle / 90.0))) + width / 10 > bounds.height) {
                        height = bounds.height - effect3d - width / 11;
                        width = (int)((double)height / this.size_factor);
                        effect3d = (int)Math.round((double)width * pieDepth * (pieAngle / 90.0));
                    }
                    center_y = this.pieBounds[pieIndex].y + this.pieBounds[pieIndex].height / 2 - effect3d / 2;
                } else {
                    cur_width = (int)((double)width * 1.1) + max_label_width * 2;
                    if (this.pieOuterBounds[pieIndex].width < cur_width) {
                        width -= Math.min(width / 11, cur_width - this.pieOuterBounds[pieIndex].width);
                        height = (int)((double)width * this.size_factor);
                    }
                }
            } else {
                if (!pointingOn) {
                    width -= width / 11;
                } else {
                    cur_width = Math.min(width, height) + max_label_width * 2 + 70;
                    if (this.pieOuterBounds[pieIndex].width < cur_width) {
                        width -= Math.min(70, cur_width - this.pieOuterBounds[pieIndex].width);
                    }
                }
                height = width;
            }
            this.pointingDistance = (this.pieOuterBounds[pieIndex].width - width) / 2 - max_label_width;
        }
        if (this.chart.isPieLabelsOn()) {
            Font font = this.getFont("pieLabelFont");
            String label = this.chart.getSampleLabel(pieIndex);
            Dimension labelSize = this.getLabelSize(label, this.getFontMetrics(font));
            if (this.display3dOn) {
                int effect3d2 = (int)Math.round((double)width * pieDepth * (pieAngle / 90.0));
                int ypos = center_y + height / 2 + labelSize.height - fm.getDescent() + 2;
                if ((ypos += effect3d2) > bounds.y + bounds.height) {
                    int needed = ypos - (bounds.y + bounds.height);
                    height -= needed;
                    center_y -= needed / 2;
                }
            } else {
                width = height -= labelSize.height;
                center_y -= labelSize.height / 2;
            }
        }
        this.pieCenter[pieIndex].x = center_x;
        this.pieCenter[pieIndex].y = center_y;
        this.pieWidth[pieIndex] = width;
        double sum = 0.0;
        for (int i3 = 0; i3 < values.length; ++i3) {
            sum += Math.abs(values[i3]);
        }
        if (sum == 0.0) {
            return;
        }
        double next_start = 0.0;
        double startAngle = 90.0;
        seriesCount = this.getSeriesCount();
        for (i = 0; i < values.length; ++i) {
            if (seriesCount == 1) {
                this.angle_start[0][i] = startAngle + (double)this.chart.startAngle[0];
            } else {
                this.angle_start[i][pieIndex] = startAngle + (double)this.chart.startAngle[pieIndex];
            }
            if (!Double.isNaN(values[i])) {
                startAngle = 90.0 - (next_start += Math.abs(values[i])) * 360.0 / sum;
            }
            if (seriesCount == 1) {
                this.angle_end[0][i] = startAngle + (double)this.chart.startAngle[0];
                continue;
            }
            this.angle_end[i][pieIndex] = startAngle + (double)this.chart.startAngle[pieIndex];
        }
        for (i = 0; i < values.length; ++i) {
            if (seriesCount == 1) {
                if (this.angle_start[0][i] > -270.0 && this.angle_end[0][i] <= -270.0 || this.angle_start[0][i] >= 90.0 && this.angle_end[0][i] <= 90.0) {
                    this.top_slice = i;
                }
                if (!(this.angle_start[0][i] >= -90.0 && this.angle_end[0][i] < -90.0) && (!(this.angle_start[0][i] > -450.0) || !(this.angle_end[0][i] <= -450.0))) continue;
                this.bottom_slice = i;
                continue;
            }
            if (this.angle_start[i][pieIndex] > -270.0 && this.angle_end[i][pieIndex] <= -270.0 || this.angle_start[i][pieIndex] >= 90.0 && this.angle_end[i][pieIndex] <= 90.0) {
                this.top_slice = i;
            }
            if (!(this.angle_start[i][pieIndex] > -90.0 && this.angle_end[i][pieIndex] <= -90.0) && (!(this.angle_start[i][pieIndex] > -450.0) || !(this.angle_end[i][pieIndex] <= -450.0))) continue;
            this.bottom_slice = i;
        }
        if (this.top_slice < 0 || this.bottom_slice < 0) {
            return;
        }
        if (seriesCount == 1) {
            top_start = this.angle_start[0][this.top_slice];
            top_end = this.angle_end[0][this.top_slice];
        } else {
            top_start = this.angle_start[this.top_slice][pieIndex];
            top_end = this.angle_end[this.top_slice][pieIndex];
        }
        ChartSample s = seriesCount == 1 ? this.chart.getSample(0, this.top_slice) : this.chart.getSample(this.top_slice, pieIndex);
        boolean selected = seriesCount == 1 ? this.chart.isSelected(0, this.top_slice) : this.chart.isSelected(this.top_slice, pieIndex);
        double detached = selected && selectionStyle == 2 ? detachedDistance : (seriesCount == 1 ? this.chart.getDetachedSlice(0, this.top_slice) : this.chart.getDetachedSlice(this.top_slice, pieIndex));
        if (s != null) {
            this.paintPieSegment((Graphics2D)g, this.top_slice, this.chart.getSampleColor(this.top_slice), top_start, top_start - top_end, width, height, center_x, center_y, selected, detached, 2);
        }
        if ((slice = this.top_slice - 1) == -1) {
            slice = values.length - 1;
        }
        while (values[slice] == 0.0) {
            if (--slice != -1) continue;
            slice = values.length - 1;
        }
        if (seriesCount == 1) {
            start = this.angle_start[0][slice];
            end = this.angle_end[0][slice];
        } else {
            start = this.angle_start[slice][pieIndex];
            end = this.angle_end[slice][pieIndex];
        }
        while (start <= -90.0 && start > -270.0 && end <= -90.0 && end > -270.0 || start <= -450.0 && start > -630.0 && end <= -450.0 && end > -630.0) {
            if (slice != this.bottom_slice && slice != this.top_slice) {
                s = seriesCount == 1 ? this.chart.getSample(0, slice) : this.chart.getSample(slice, pieIndex);
                selected = seriesCount == 1 ? this.chart.isSelected(0, slice) : this.chart.isSelected(slice, pieIndex);
                detached = selected && selectionStyle == 2 ? detachedDistance : (seriesCount == 1 ? this.chart.getDetachedSlice(0, slice) : this.chart.getDetachedSlice(slice, pieIndex));
                if (s != null) {
                    this.paintPieSegment((Graphics2D)g, slice, this.chart.getSampleColor(slice), start, start - end, width, height, center_x, center_y, selected, detached, 0);
                }
            }
            if (--slice == -1) {
                slice = values.length - 1;
            }
            if (seriesCount == 1) {
                start = this.angle_start[0][slice];
                end = this.angle_end[0][slice];
                continue;
            }
            start = this.angle_start[slice][pieIndex];
            end = this.angle_end[slice][pieIndex];
        }
        slice = this.top_slice + 1;
        if (slice == values.length) {
            slice = 0;
        }
        while (values[slice] == 0.0) {
            if (++slice != values.length) continue;
            slice = 0;
        }
        if (seriesCount == 1) {
            start = this.angle_start[0][slice];
            end = this.angle_end[0][slice];
        } else {
            start = this.angle_start[slice][pieIndex];
            end = this.angle_end[slice][pieIndex];
        }
        for (int iterations = 0; (-90.0 <= start && start <= 90.0 && -90.0 <= end && end <= 90.0 || -450.0 <= start && start <= -270.0 && -450.0 <= end && end <= -270.0) && iterations < values.length; ++iterations) {
            if (slice != this.bottom_slice && slice != this.top_slice) {
                s = seriesCount == 1 ? this.chart.getSample(0, slice) : this.chart.getSample(slice, pieIndex);
                selected = seriesCount == 1 ? this.chart.isSelected(0, slice) : this.chart.isSelected(slice, pieIndex);
                detached = selected && selectionStyle == 2 ? detachedDistance : (seriesCount == 1 ? this.chart.getDetachedSlice(0, slice) : this.chart.getDetachedSlice(slice, pieIndex));
                if (s != null) {
                    this.paintPieSegment((Graphics2D)g, slice, this.chart.getSampleColor(slice), start, start - end, width, height, center_x, center_y, selected, detached, 1);
                }
            }
            if (++slice == values.length) {
                slice = 0;
            }
            if (seriesCount == 1) {
                start = this.angle_start[0][slice];
                end = this.angle_end[0][slice];
                continue;
            }
            start = this.angle_start[slice][pieIndex];
            end = this.angle_end[slice][pieIndex];
        }
        if (seriesCount == 1) {
            bottom_start = this.angle_start[0][this.bottom_slice];
            bottom_end = this.angle_end[0][this.bottom_slice];
        } else {
            bottom_start = this.angle_start[this.bottom_slice][pieIndex];
            bottom_end = this.angle_end[this.bottom_slice][pieIndex];
        }
        if (this.bottom_slice != -1) {
            s = seriesCount == 1 ? this.chart.getSample(0, this.bottom_slice) : this.chart.getSample(this.bottom_slice, pieIndex);
            selected = seriesCount == 1 ? this.chart.isSelected(0, this.bottom_slice) : this.chart.isSelected(this.bottom_slice, pieIndex);
            detached = selected && selectionStyle == 2 ? detachedDistance : (seriesCount == 1 ? this.chart.getDetachedSlice(0, this.bottom_slice) : this.chart.getDetachedSlice(this.bottom_slice, pieIndex));
            if (s != null) {
                this.paintPieSegment((Graphics2D)g, this.bottom_slice, this.chart.getSampleColor(this.bottom_slice), bottom_start, bottom_start - bottom_end, width, height, center_x, center_y, selected, detached, 3);
            }
        }
        if (this.chart.isSliceSeperatorOn()) {
            boolean prev_selected = false;
            for (slice = 0; slice < values.length; ++slice) {
                if (seriesCount == 1) {
                    start = this.angle_start[0][slice];
                    end = this.angle_end[0][slice];
                    selected = this.chart.isSelected(0, slice);
                    s = this.chart.getSample(0, slice);
                } else {
                    start = this.angle_start[slice][pieIndex];
                    end = this.angle_end[slice][pieIndex];
                    selected = this.chart.isSelected(slice, pieIndex);
                    s = this.chart.getSample(slice, pieIndex);
                }
                detached = selected && selectionStyle == 2 ? detachedDistance : (seriesCount == 1 ? this.chart.getDetachedSlice(0, slice) : this.chart.getDetachedSlice(slice, pieIndex));
                if (detached != 0.0) continue;
                if (s != null && s.value != null && !s.value.isNaN()) {
                    if (this.chart.getSliceSeperatorColor() != null) {
                        g.setColor(this.chart.getSliceSeperatorColor());
                    } else {
                        g.setColor(PieChartRenderer.getDarker(this.chart.getSampleColor(slice)));
                    }
                    double start_rad = (double)(-Math.round(start)) * (Math.PI / 180);
                    int start_x = center_x + (int)Math.round(Math.cos(start_rad) * ((double)width * 0.5));
                    int start_y = center_y + (int)Math.round(Math.sin(start_rad) * ((double)height * 0.5));
                    double stop_rad = (double)(-Math.round(end)) * (Math.PI / 180);
                    int stop_x = center_x + (int)Math.round(Math.cos(stop_rad) * ((double)width * 0.5));
                    int stop_y = center_y + (int)Math.round(Math.sin(stop_rad) * ((double)height * 0.5));
                    if (prev_selected) {
                        g.drawLine(center_x, center_y, start_x, start_y);
                    }
                    g.drawLine(center_x, center_y, stop_x, stop_y);
                }
                prev_selected = selected;
            }
        }
        if (this.chart.isPieLabelsOn()) {
            String label = seriesCount == 1 ? this.chart.getSeriesLabel(pieIndex) : this.chart.getSampleLabel(pieIndex);
            Font font = this.getFont("pieLabelFont");
            if (label != null && label.trim().length() > 0) {
                Color c;
                Dimension labelSize = this.getLabelSize(label, this.getFontMetrics(font));
                int xpos = center_x - labelSize.width / 2;
                int ypos = center_y + height / 2 + fm.getHeight() - fm.getDescent() + 3;
                if (this.display3dOn) {
                    ypos += (int)Math.round((double)width * pieDepth * (pieAngle / 90.0));
                }
                g.setColor((c = this.chart.getSampleLabelColor(pieIndex)) != null ? c : this.chart.getForeground());
                this.paintLabel(g, label, xpos, ypos, labelSize, 0, 0, false);
            }
        }
    }

    private void paintPieSegment(Graphics2D g, int slice, Color color, double startAngle, double angle, int width, int height, int center_x, int center_y, boolean selected, double distance, int part) {
        Arc2D.Double arc1;
        Arc2D.Double arc;
        GradientPaint outline;
        GradientPaint paint;
        boolean isTopAndBottomSlice;
        if (distance > 0.0 && angle < 360.0) {
            double mid = -startAngle + angle / 2.0;
            double rad = mid * (Math.PI / 180);
            center_x += (int)Math.round(Math.cos(rad) * ((double)width * (distance / 2.0)));
            center_y += (int)Math.round(Math.sin(rad) * ((double)height * (distance / 2.0)));
        }
        Point center = new Point(center_x, center_y);
        int xpos = center_x - width / 2;
        int ypos = center_y - height / 2;
        double start = startAngle;
        double extent = -angle;
        double end = start + extent;
        int d = (int)Math.round((double)((float)width * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0));
        boolean bl = isTopAndBottomSlice = slice == this.top_slice && slice == this.bottom_slice;
        if (this.chart.isGradientSamplesOn()) {
            paint = new GradientPaint(xpos, 0.0f, PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)), (float)((double)xpos + (double)width * 0.66), 0.0f, PieChartRenderer.getBrighter(color), true);
            outline = new GradientPaint(xpos, ypos, PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)), (float)xpos + (float)((double)width * 1.5), (float)ypos + (float)((double)height * 1.5), color);
        } else {
            paint = new GradientPaint(xpos, 0.0f, PieChartRenderer.getDarker(color), (float)((double)xpos + (double)width * 0.66), 0.0f, PieChartRenderer.getDarker(color), true);
            outline = new GradientPaint(xpos, ypos, PieChartRenderer.getDarker(color), (float)xpos + (float)((double)width * 1.5), (float)ypos + (float)((double)height * 1.5), PieChartRenderer.getDarker(color));
        }
        if (this.display3dOn) {
            if (!isTopAndBottomSlice || part != 3) {
                arc = new Arc2D.Double(xpos, ypos + d, width, height, start, extent, 2);
                arc1 = new Arc2D.Double(xpos, ypos + d, width, height, start, extent, 0);
                g.setPaint(paint);
                g.fill(arc);
                if (this.chart.isSliceSeperatorOn()) {
                    if (this.chart.getSliceSeperatorColor() != null) {
                        g.setColor(this.chart.getSliceSeperatorColor());
                        g.setPaint(outline);
                        g.draw(arc1);
                    } else {
                        g.setPaint(outline);
                        g.draw(arc);
                    }
                } else {
                    g.setPaint(outline);
                    g.draw(arc1);
                }
            }
            if (start < -360.0) {
                start += 720.0;
            } else if (start < 0.0) {
                start += 360.0;
            }
            end = start + extent;
            if (isTopAndBottomSlice) {
                if (part == 2) {
                    if (start >= 270.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, 180.0, end - 180.0, paint, outline, false, true);
                    } else if (start <= 90.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, -180.0, end + 180.0, paint, outline, false, true);
                    } else if (start + extent <= -90.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, start, -start, paint, outline, true, false);
                    }
                } else if (part == 3) {
                    if (start >= 270.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, start, 180.0 - start, paint, outline, true, false);
                    } else if (start < 90.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, start, -180.0 - start, paint, outline, true, false);
                    } else if (start + extent <= -90.0) {
                        this.paint3DSegment(g, xpos, ypos, width, height, center, d, 0.0, end, paint, outline, false, true);
                    }
                } else if (part == 1 && start == 90.0 && extent == -180.0) {
                    this.paint3DSegment(g, xpos, ypos, width, height, center, d, 90.0, -90.0, paint, outline, true, false);
                    this.paint3DSegment(g, xpos, ypos, width, height, center, d, -90.0, 90.0, paint, outline, true, false);
                }
            } else {
                this.paint3DSegment(g, xpos, ypos, width, height, center, d, start, extent, paint, outline, true, true);
            }
        }
        if (!isTopAndBottomSlice || part != 2) {
            paint = this.chart.isGradientSamplesOn() ? new GradientPaint(xpos, ypos, PieChartRenderer.getDarker(color), (float)xpos + (float)width, (float)ypos + (float)height, PieChartRenderer.getBrighter(color)) : new GradientPaint(xpos, ypos, color, (float)xpos + (float)width, (float)ypos + (float)height, color);
            arc = new Arc2D.Double(xpos, ypos, width, height, start, extent, 2);
            arc1 = new Arc2D.Double(xpos, ypos, width, height, start, extent, 0);
            g.setPaint(paint);
            g.fill(arc);
            g.setPaint(outline);
            if (this.chart.isSliceSeperatorOn()) {
                if (this.chart.getSliceSeperatorColor() != null) {
                    g.setColor(this.chart.getSliceSeperatorColor());
                    g.setPaint(outline);
                    g.draw(arc1);
                } else {
                    g.setPaint(outline);
                    g.draw(arc);
                }
            } else {
                g.setPaint(outline);
                g.draw(arc1);
            }
        }
        if (selected) {
            this.paintSelectionMarker(g, color, (int)Math.round(-startAngle), (int)Math.round(-angle), width, height, center_x, center_y, this.chart.getSelectionStyle());
        }
    }

    private void paint3DSegment(Graphics2D g, int x, int y, int width, int height, Point center, int d, double start, double extent, GradientPaint paint, GradientPaint outline, boolean startEdge, boolean stopEdge) {
        boolean passes_180;
        double angle = Math.toRadians(-start);
        double start_x = (double)x + (Math.cos(angle) * 0.5 + 0.5) * (double)width;
        double start_y = (double)y + (Math.sin(angle) * 0.5 + 0.5) * (double)height;
        angle = Math.toRadians(-start - extent);
        double end_x = (double)x + (Math.cos(angle) * 0.5 + 0.5) * (double)width;
        double end_y = (double)y + (Math.sin(angle) * 0.5 + 0.5) * (double)height;
        GeneralPath start_poly = new GeneralPath();
        start_poly.moveTo(center.x, center.y + d + 1);
        start_poly.lineTo(center.x, center.y);
        start_poly.lineTo((float)start_x, (float)start_y);
        start_poly.lineTo((float)start_x, (float)start_y + (float)d + 1.0f);
        start_poly.closePath();
        GeneralPath end_poly = new GeneralPath();
        end_poly.moveTo(center.x, center.y + d + 1);
        end_poly.lineTo(center.x, center.y);
        end_poly.lineTo((float)end_x, (float)end_y);
        end_poly.lineTo((float)end_x, (float)end_y + (float)d + 1.0f);
        end_poly.closePath();
        g.setPaint(outline);
        g.drawLine(center.x, center.y, center.x, center.y + d);
        g.setPaint(PieChartRenderer.getDarker(outline.getColor2()));
        if (startEdge && (start > 270.0 || start < 90.0)) {
            g.fill(start_poly);
        }
        if (stopEdge && (start + extent > -270.0 && start + extent < -90.0 || start + extent > 90.0 && start + extent < 270.0)) {
            g.fill(end_poly);
        }
        g.setPaint(paint);
        boolean passes_0 = start >= 0.0 && start + extent <= 0.0 || start >= -360.0 && start + extent <= -360.0;
        boolean bl = passes_180 = start >= -180.0 && start + extent <= -180.0 || start >= 180.0 && start + extent <= 180.0;
        if (passes_0 && passes_180) {
            if (start <= 90.0) {
                this.paint3DSegmentArc(g, x, y, width, height, d, start, -start, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, -180.0, start + extent + 180.0, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, 0.0, -180.0, paint, outline);
            } else {
                this.paint3DSegmentArc(g, x, y, width, height, d, 0.0, 180.0, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, start, 180.0 - start, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, 0.0, start + extent, paint, outline);
            }
            g.drawLine(x, center.y, x - 1, center.y + d);
            g.drawLine(x + width, center.y, x + width, center.y + d);
        } else if (passes_0) {
            this.paint3DSegmentArc(g, x, y, width, height, d, start, -start, paint, outline);
            this.paint3DSegmentArc(g, x, y, width, height, d, 0.0, start + extent, paint, outline);
            g.drawLine(x + width, center.y, x + width, center.y + d);
        } else if (passes_180) {
            if (start <= 90.0) {
                this.paint3DSegmentArc(g, x, y, width, height, d, start, 180.0 + start, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, -180.0, start + extent + 180.0, paint, outline);
            } else {
                this.paint3DSegmentArc(g, x, y, width, height, d, 180.0, start + extent - 180.0, paint, outline);
                this.paint3DSegmentArc(g, x, y, width, height, d, start, 180.0 - start, paint, outline);
            }
            g.drawLine(x, center.y, x - 1, center.y + d);
        } else {
            this.paint3DSegmentArc(g, x, y, width, height, d, start, extent, paint, outline);
        }
        g.setPaint(PieChartRenderer.getDarker(outline.getColor2()));
        if (startEdge && start > 90.0 && start < 270.0) {
            g.fill(start_poly);
        }
        if (stopEdge && (start + extent > 270.0 || start + extent > -90.0 && start + extent < 90.0 || start + extent < -270.0 && start + extent > -360.0)) {
            g.fill(end_poly);
        }
        g.setPaint(outline);
        if (startEdge) {
            g.drawLine((int)start_x, (int)start_y, (int)start_x, (int)start_y + d);
        }
        if (stopEdge) {
            g.drawLine((int)end_x, (int)end_y, (int)end_x, (int)end_y + d);
        }
    }

    private void paint3DSegmentArc(Graphics2D g, int x, int y, int width, int height, int d, double start, double extent, Paint paint, Paint outline) {
        GeneralPath path = new GeneralPath();
        Arc2D.Double arc = new Arc2D.Double(x, y, width, height, start, extent, 0);
        Point2D start_p = arc.getStartPoint();
        path.moveTo((float)start_p.getX(), (float)start_p.getY());
        path.append(arc, false);
        Arc2D.Double arc1 = new Arc2D.Double(x, y + d, width, height, start + extent, -extent, 0);
        path.append(arc1, true);
        path.closePath();
        g.setPaint(paint);
        g.fill(path);
        g.setPaint(outline);
        g.draw(arc1);
    }

    private void paintSelectionMarker(Graphics g, Color color, double startAngle, double angle, int width, int height, int center_x, int center_y, int style) {
        if (style == 1) {
            double mid = startAngle - angle / 2.0;
            double rad = mid * (Math.PI / 180);
            int x = center_x + (int)Math.round(Math.cos(rad) * ((double)width * 0.4));
            int y = center_y + (int)Math.round(Math.sin(rad) * ((double)height * 0.4));
            int m_width = Math.max(width / 16, 3);
            int m_height = Math.max(height / 16, 3);
            int off_x = m_width / 2;
            int off_y = m_height / 2;
            g.setColor(PieChartRenderer.getDarker(color));
            g.fillOval(x - off_x, y - off_y, m_width, m_height);
            g.setColor(PieChartRenderer.getDarker(color));
            g.drawArc(x - off_x, y - off_y, m_width, m_height, 45, 180);
            g.setColor(PieChartRenderer.getDarker(PieChartRenderer.getDarker(color)));
            g.drawArc(x - off_x + 1, y - off_y + 1, m_width - 2, m_height - 2, 45, 180);
            g.setColor(color);
            g.drawArc(x - off_x + 1, y - off_y + 1, m_width - 2, m_height - 2, 45, -180);
            g.setColor(color.brighter());
            g.drawArc(x - off_x, y - off_y, m_width, m_height, 45, -180);
        } else if (style == 0) {
            double mid = startAngle - angle / 2.0;
            double rad = mid * (Math.PI / 180);
            int w = (int)Math.round((double)width * 0.7);
            int h = (int)Math.round((double)height * 0.7);
            int xpos = center_x + (int)Math.round(Math.cos(rad) * ((double)width * 0.1));
            int ypos = center_y + (int)Math.round(Math.sin(rad) * ((double)height * 0.1));
            g.setColor(PieChartRenderer.getDarker(color));
            g.fillArc(xpos -= (int)Math.round((double)w / 2.0), ypos -= (int)Math.round((double)h / 2.0), w + 1, h + 1, (int)(-Math.round(startAngle)), (int)Math.round(angle));
        }
    }

    protected void paintFloatingLabel(Graphics g, String label, Rectangle gridBounds, int sample, int series, Font font, FontMetrics fm) {
        int seriesCount = this.getSeriesCount();
        Point center = this.pieCenter[seriesCount > 1 ? sample : 0];
        if (label == null || series < 0 || series >= this.getSeriesCount() || sample < 0 || sample >= this.getSampleCount() || fm == null || center == null) {
            return;
        }
        double start = this.angle_start[series][sample];
        double end = this.angle_end[series][sample];
        double angle = -((start + end) / 2.0);
        double factor = 1.0;
        int width = this.pieWidth[seriesCount == 1 ? 0 : sample];
        if (this.display3dOn) {
            int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
            factor = (double)(width - change) / (double)width;
        }
        double rad = angle * (Math.PI / 180);
        int label_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.3);
        int label_y = center.y + (int)Math.round(Math.sin(rad) * (double)width * 0.3 * factor);
        Dimension labelSize = this.getLabelSize(label, fm);
        Color frameColor = PieChartRenderer.getDarker(this.chart.getSampleColor(this.getSeriesCount() == 1 ? sample : series));
        this.paintFloatingLabel(g, label, label_x -= labelSize.width / 2, label_y -= labelSize.height / 2 - fm.getAscent(), labelSize, frameColor, fm);
    }

    private void paintStaticLabels(Graphics g) {
        boolean pointingOn;
        if (g == null) {
            return;
        }
        int seriesCount = this.getSeriesCount();
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        int percentLabelStyle = this.chart.getPercentLabelStyle();
        boolean valueLabelsOn = this.chart.isValueLabelsOn();
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean percentLabelsOn = this.chart.isPercentLabelsOn();
        boolean do_paint = percentLabelsOn && percentLabelStyle != 3;
        do_paint |= valueLabelsOn && valueLabelStyle != 3;
        do_paint |= sampleLabelsOn && sampleLabelStyle != 3;
        if (!(do_paint |= seriesLabelsOn && seriesCount > 1 && seriesLabelStyle != 3)) {
            return;
        }
        Font font = this.getFont("insideLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        int sampleCount = this.getSampleCount();
        for (int serie = 0; serie < seriesCount; ++serie) {
            for (int sample = 0; sample < sampleCount; ++sample) {
                ChartSample s = this.chart.getSample(serie, sample);
                if (s == null || s.value == null || s.value.isNaN()) continue;
                String label = this.chart.constructLabel(serie, sample, 0, true, null);
                this.paintInsideLabel(g, label, serie, sample, font, fm);
            }
        }
        boolean outsideOn = percentLabelsOn && percentLabelStyle == 1 || sampleLabelsOn && sampleLabelStyle == 1 || seriesLabelsOn && seriesLabelStyle == 1 || valueLabelsOn && valueLabelStyle == 1;
        boolean bl = pointingOn = percentLabelsOn && percentLabelStyle == 5 || sampleLabelsOn && sampleLabelStyle == 5 || seriesLabelsOn && seriesLabelStyle == 5 || valueLabelsOn && valueLabelStyle == 5;
        if (outsideOn && !pointingOn) {
            this.paintOutsideLabels(g);
        }
        if (pointingOn) {
            this.paintPointingLabels(g);
        }
    }

    private void paintInsideLabel(Graphics g, String label, int serie, int index, Font font, FontMetrics fm) {
        Color color;
        int seriesCount = this.getSeriesCount();
        Point center = this.pieCenter[seriesCount > 1 ? index : 0];
        if (center == null) {
            return;
        }
        double start = this.angle_start[serie][index];
        double end = this.angle_end[serie][index];
        double angle = -((start + end) / 2.0);
        double factor = 1.0;
        int width = this.pieWidth[seriesCount == 1 ? 0 : index];
        double detach = 0.0;
        if (this.chart.isSelected(serie, index) && start - end < 360.0 && this.chart.getSelectionStyle() == 2) {
            detach = (double)width * this.chart.getDetachedDistance() / 2.0;
        }
        if (this.display3dOn) {
            int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
            factor = (double)(width - change) / (double)width;
        }
        double rad = angle * (Math.PI / 180);
        int label_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.35 + Math.cos(rad) * detach);
        int label_y = center.y + (int)Math.round((Math.sin(rad) * (double)width * 0.35 + Math.sin(rad) * detach) * factor);
        Dimension labelSize = this.getLabelSize(label, fm);
        label_x -= labelSize.width / 2;
        label_y -= labelSize.height / 2 - fm.getAscent();
        int pieIndex = 0;
        if (seriesCount > 1) {
            pieIndex = index;
        }
        if ((color = this.chart.getInsideLabelColor(pieIndex)) == null) {
            color = this.chart.getInsideLabelColor(-1);
        }
        if (color == null) {
            Color c = this.chart.getSampleColor(seriesCount == 1 ? index : serie);
            color = (c.getRed() + c.getGreen() + c.getBlue()) / 3 > 110 ? Color.black : Color.white;
        }
        g.setColor(color);
        this.paintLabel(g, label, label_x, label_y, labelSize, this.chart.getMultilineLabelAlignment(), 0, false);
    }

    private void paintOutsideLabels(Graphics g) {
        Font font = this.getFont("outsideLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        Rectangle[] first = new Rectangle[sampleCount];
        Rectangle[] prev = new Rectangle[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            prev[i] = new Rectangle(-10, -10, -10, -10);
        }
        for (int serie = 0; serie < seriesCount; ++serie) {
            for (int sample = 0; sample < sampleCount; ++sample) {
                boolean should_paint;
                Color color;
                ChartSample s = this.chart.getSample(serie, sample);
                if (s == null || s.value == null || s.value.isNaN()) continue;
                Point center = this.pieCenter[seriesCount > 1 ? sample : 0];
                if (center == null) {
                    return;
                }
                String label = this.chart.constructLabel(serie, sample, 1, true, null);
                double start = this.angle_start[serie][sample];
                double end = this.angle_end[serie][sample];
                double angle = -((start + end) / 2.0);
                double factor = 1.0;
                int width = this.pieWidth[seriesCount == 1 ? 0 : sample];
                if (this.display3dOn) {
                    int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
                    factor = (double)(width - change) / (double)width;
                }
                double detach = 0.0;
                if (this.chart.isSelected(serie, sample) && start - end < 360.0 && this.chart.getSelectionStyle() == 2) {
                    detach = (double)width * this.chart.getDetachedDistance() / 2.0;
                }
                angle = (angle + 360.0) % 360.0;
                double rad = angle * (Math.PI / 180);
                Dimension labelSize = this.getLabelSize(label, fm);
                int label_x = center.x + (int)Math.round(Math.cos(rad) * (double)width * 0.5 + Math.cos(rad) * detach);
                int label_y = center.y + (int)Math.round((Math.sin(rad) * (double)width * 0.5 + Math.sin(rad) * detach) * factor);
                label_y -= labelSize.height / 2;
                double label_space = Math.max((double)width * 0.05, 10.0);
                if (angle > 292.5 && angle <= 337.5) {
                    label_x = (int)((double)label_x + label_space * Math.cos(rad));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) - (double)(labelSize.height / 2)));
                } else if (angle > 247.5 && angle <= 292.5) {
                    label_x = (int)((double)label_x + (label_space * Math.cos(rad) - (double)(labelSize.width / 2)));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) - (double)(labelSize.height / 2)));
                } else if (angle > 202.5 && angle <= 247.5) {
                    label_x = (int)((double)label_x + (label_space * Math.cos(rad) - (double)labelSize.width));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) - (double)(labelSize.height / 2)));
                } else if (angle > 157.5 && angle <= 202.5) {
                    label_x = (int)((double)label_x + (label_space * Math.cos(rad) - (double)labelSize.width));
                    label_y = (int)((double)label_y + label_space * Math.sin(rad));
                } else if (angle > 112.5 && angle <= 157.5) {
                    label_x = (int)((double)label_x + (label_space * Math.cos(rad) - (double)labelSize.width));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) + (double)(labelSize.height / 2)));
                } else if (angle > 67.5 && angle <= 112.5) {
                    label_x = (int)((double)label_x + (label_space * Math.cos(rad) - (double)(labelSize.width / 2)));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) + (double)(labelSize.height / 2)));
                } else if (angle > 22.5 && angle <= 67.5) {
                    label_x = (int)((double)label_x + label_space * Math.cos(rad));
                    label_y = (int)((double)label_y + (label_space * Math.sin(rad) + (double)(labelSize.height / 2)));
                } else {
                    label_x = (int)((double)label_x + label_space * Math.cos(rad));
                    label_y = (int)((double)label_y + label_space * Math.sin(rad));
                }
                if (this.display3dOn && angle > 7.0 && angle < 173.0) {
                    label_y = (int)((long)label_y + Math.round((double)((float)width * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0)));
                }
                int pieIndex = 0;
                if (seriesCount > 1) {
                    pieIndex = sample;
                }
                if ((color = this.chart.getOutsideLabelColor(pieIndex)) == null) {
                    color = this.chart.getOutsideLabelColor(-1);
                }
                if (color == null) {
                    color = this.chart.getForeground();
                }
                g.setColor(color);
                Rectangle cur = new Rectangle(label_x, label_y, labelSize.width, labelSize.height);
                Rectangle inter = seriesCount == 1 ? cur.intersection(prev[0]) : cur.intersection(prev[sample]);
                boolean bl = should_paint = inter.width <= 0 || inter.height <= 0;
                if (!(seriesCount == 0 && sample == 0 || seriesCount > 0 && serie == 0)) {
                    inter = seriesCount == 1 ? cur.intersection(first[0]) : cur.intersection(first[sample]);
                    should_paint &= inter.width <= 0 || inter.height <= 0;
                }
                if (should_paint) {
                    this.paintLabel(g, label, label_x, label_y + fm.getAscent(), labelSize, this.chart.getMultilineLabelAlignment(), 0, false);
                    if (seriesCount == 1) {
                        prev[0] = cur;
                    } else {
                        prev[sample] = cur;
                    }
                }
                if (seriesCount == 1 && sample == 0) {
                    first[0] = cur;
                    continue;
                }
                if (seriesCount <= 1 || serie != 0) continue;
                first[sample] = cur;
            }
        }
    }

    private void paintPointingLabels(Graphics g) {
        boolean pointingOn;
        boolean bl = pointingOn = this.chart.isPercentLabelsOn() && this.chart.getPercentLabelStyle() == 5 || this.chart.isSampleLabelsOn() && this.chart.getSampleLabelStyle() == 5 || this.chart.isSeriesLabelsOn() && this.chart.getSeriesLabelStyle() == 5 || this.chart.isValueLabelsOn() && this.chart.getValueLabelStyle() == 5;
        if (!pointingOn) {
            return;
        }
        Font font = this.getFont("pointingLabelFont");
        FontMetrics fm = this.getFontMetrics(font);
        g.setFont(font);
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        int pieCount = seriesCount > 1 ? sampleCount : 1;
        int sliceCount = seriesCount > 1 ? seriesCount : sampleCount;
        for (int pieIndex = 0; pieIndex < pieCount; ++pieIndex) {
            int delta_x;
            double rad;
            int y0;
            int y1;
            int y2;
            int y3;
            int x1;
            int x3;
            int i;
            int i2;
            Point center = this.pieCenter[pieIndex];
            if (center == null) continue;
            int length = sliceCount;
            String[] pointingLabels = new String[length];
            Dimension[] labelSize = new Dimension[length];
            Point[] labelPos = new Point[length];
            Point[] lineStart = new Point[length];
            double[] sampleAngle = new double[length];
            for (int slice = 0; slice < sliceCount; ++slice) {
                double angle;
                double end;
                double start;
                if (this.getSeriesCount() == 1) {
                    start = this.angle_start[0][slice];
                    end = this.angle_end[0][slice];
                } else {
                    start = this.angle_start[slice][pieIndex];
                    end = this.angle_end[slice][pieIndex];
                }
                sampleAngle[slice] = angle = -((start + end) / 2.0);
                ChartSample s = pieCount == 1 ? this.chart.getSample(0, slice) : this.chart.getSample(slice, pieIndex);
                if (s == null || s.value == null || s.value.isNaN()) continue;
                pointingLabels[slice] = pieCount == 1 ? this.chart.constructLabel(0, slice, 5, true, null) : this.chart.constructLabel(slice, pieIndex, 5, true, null);
                double factor = 1.0;
                int width = this.pieWidth[pieCount == 1 ? 0 : pieIndex];
                if (this.display3dOn) {
                    int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
                    factor = (double)(width - change) / (double)width;
                }
                boolean selected = seriesCount == 1 ? this.chart.isSelected(0, slice) : this.chart.isSelected(slice, pieIndex);
                double detach = 0.0;
                if (selected && start - end < 360.0 && this.chart.getSelectionStyle() == 2) {
                    detach = (double)width * this.chart.getDetachedDistance() / 2.0;
                }
                double rad2 = (angle += angle < 0.0 ? 360.0 : 0.0) * (Math.PI / 180);
                labelSize[slice] = this.getLabelSize(pointingLabels[slice], fm);
                double line_x = (double)center.x + ((double)width / 2.0 + detach) * Math.cos(rad2);
                double line_y = (double)center.y + ((double)(width + 2) / 2.0 + detach) * Math.sin(rad2) * factor;
                int label_x = sampleAngle[slice] >= 90.0 && sampleAngle[slice] < 270.0 || sampleAngle[slice] >= 450.0 && sampleAngle[slice] < 630.0 ? center.x - width / 2 - this.pointingDistance - labelSize[slice].width : center.x + width / 2 + this.pointingDistance;
                int label_y = (int)(line_y - (double)labelSize[slice].height / 2.0 + (double)fm.getAscent());
                lineStart[slice] = new Point((int)line_x, (int)line_y);
                labelPos[slice] = new Point(label_x, label_y);
            }
            int first_right = 0;
            for (int i3 = length - 1; i3 >= 0; --i3) {
                if (pointingLabels[i3] == null || !((sampleAngle[i3] + 90.0) % 360.0 < (sampleAngle[first_right] + 90.0) % 360.0)) continue;
                first_right = i3;
            }
            int first_left = 0;
            for (int i4 = 0; i4 < length; ++i4) {
                if (pointingLabels[i4] == null || !((sampleAngle[i4] + 90.0) % 360.0 > (sampleAngle[first_left] + 90.0) % 360.0)) continue;
                first_left = i4;
            }
            String[] rPointingLab = new String[length];
            String[] lPointingLab = new String[length];
            Dimension[] rLabelSize = new Dimension[length];
            Dimension[] lLabelSize = new Dimension[length];
            Point[] rLabelPos = new Point[length];
            Point[] lLabelPos = new Point[length];
            Point[] rLineStart = new Point[length];
            Point[] lLineStart = new Point[length];
            double[] rSampleAngle = new double[length];
            double[] lSampleAngle = new double[length];
            int rcount = 0;
            int lcount = 0;
            for (i2 = 0; i2 < length; ++i2) {
                if (!(sampleAngle[first_right] >= -90.0 && sampleAngle[first_right] < 90.0) && (!(sampleAngle[first_right] >= 270.0) || !(sampleAngle[first_right] < 450.0))) continue;
                if (pointingLabels[first_right] != null && !pointingLabels[first_right].equals("")) {
                    rPointingLab[rcount] = pointingLabels[first_right];
                    rLabelPos[rcount] = labelPos[first_right];
                    rLabelSize[rcount] = labelSize[first_right];
                    rLineStart[rcount] = lineStart[first_right];
                    rSampleAngle[rcount] = sampleAngle[first_right];
                    ++rcount;
                }
                first_right = first_right == length - 1 ? 0 : first_right + 1;
            }
            for (i2 = 0; i2 < length; ++i2) {
                if (!(sampleAngle[first_left] >= 90.0 && sampleAngle[first_left] < 270.0) && (!(sampleAngle[first_left] >= 450.0) || !(sampleAngle[first_left] < 630.0))) continue;
                if (pointingLabels[first_left] != null && !pointingLabels[first_left].equals("")) {
                    lPointingLab[lcount] = pointingLabels[first_left];
                    lLabelPos[lcount] = labelPos[first_left];
                    lLabelSize[lcount] = labelSize[first_left];
                    lLineStart[lcount] = lineStart[first_left];
                    lSampleAngle[lcount] = sampleAngle[first_left];
                    ++lcount;
                }
                first_left = first_left == 0 ? length - 1 : first_left - 1;
            }
            this.alignPointingLabels(pieIndex, rLabelPos, rLabelSize, rLineStart, center, rcount, fm);
            this.alignPointingLabels(pieIndex, lLabelPos, lLabelSize, lLineStart, center, lcount, fm);
            Color color = this.chart.getPointingLabelColor(pieIndex);
            if (color == null) {
                color = this.chart.getPointingLabelColor(-1);
            }
            if (color == null) {
                color = this.chart.getForeground();
            }
            g.setColor(color);
            for (i = 0; i < rcount; ++i) {
                if (rLabelPos[i] == null) continue;
                int x2 = x3 = rLineStart[i].x + 2;
                x1 = x3;
                y2 = y3 = rLineStart[i].y + 1;
                int x0 = rLabelPos[i].x - 2;
                y0 = y1 = rLabelPos[i].y - fm.getAscent() + rLabelSize[i].height / 2 + 1;
                rad = rSampleAngle[i] * (Math.PI / 180);
                if (y3 > center.y && y0 > y3 || y3 <= center.y && y0 < y3) {
                    delta_x = (int)((double)(y0 - y3) / Math.tan(rad));
                    delta_x = Math.min(delta_x, x0 - x3 - this.pointingDistance / 2);
                    x2 = x3 + Math.max(delta_x, 0);
                    y2 = y0;
                    if (x0 > x3) {
                        g.drawLine(x0, y0, x2, y2);
                        g.drawLine(x2, y2, x3, y3);
                    }
                } else {
                    delta_x = (this.pieWidth[pieIndex] / 2 - (x3 - center.x)) / 3;
                    x1 = Math.max(x3, x0 - this.pointingDistance / 2);
                    x2 = x3 + Math.max(0, delta_x);
                    if (x0 > x3) {
                        g.drawLine(x0, y0, x1, y1);
                        g.drawLine(x1, y1, x2, y2);
                        g.drawLine(x2, y2, x3, y3);
                    }
                }
                this.paintLabel(g, rPointingLab[i], rLabelPos[i].x, rLabelPos[i].y, rLabelSize[i], 0, 0, false);
            }
            for (i = 0; i < lcount; ++i) {
                if (lLabelPos[i] == null) continue;
                int x0 = lLabelPos[i].x + lLabelSize[i].width;
                int x2 = x3 = lLineStart[i].x;
                x1 = x3;
                y0 = y1 = lLabelPos[i].y - fm.getAscent() + lLabelSize[i].height / 2 + 1;
                y2 = y3 = lLineStart[i].y + 1;
                rad = lSampleAngle[i] * (Math.PI / 180);
                if (y3 > center.y && y0 > y3 || y3 <= center.y && y0 < y3) {
                    delta_x = (int)((double)(y0 - y3) / Math.tan(rad));
                    delta_x = Math.max(delta_x, x0 - x3 + this.pointingDistance / 2);
                    x2 = x3 + Math.min(delta_x, 0);
                    y2 = y0;
                    if (x3 > x0) {
                        g.drawLine(x0, y0, x2, y2);
                        g.drawLine(x2, y2, x3, y3);
                    }
                } else {
                    delta_x = (this.pieWidth[pieIndex] / 2 - (center.x - x3)) / 3;
                    x1 = Math.min(x3, x0 + this.pointingDistance / 2);
                    x2 = x3 - Math.max(0, delta_x);
                    if (x3 > x0) {
                        g.drawLine(x0, y0, x1, y1);
                        g.drawLine(x1, y1, x2, y2);
                        g.drawLine(x2, y2, x3, y3);
                    }
                }
                this.paintLabel(g, lPointingLab[i], lLabelPos[i].x, lLabelPos[i].y, lLabelSize[i], 0, 0, false);
            }
        }
    }

    private void alignPointingLabels(int pieIndex, Point[] labelPos, Dimension[] labelSize, Point[] lineStart, Point center, int length, FontMetrics fm) {
        if (labelPos == null || labelSize == null || lineStart == null || length < 1) {
            return;
        }
        labelPos[0].y = Math.max(labelPos[0].y, this.pieOuterBounds[pieIndex].y + fm.getAscent());
        labelPos[length - 1].y = Math.min(labelPos[length - 1].y, this.pieOuterBounds[pieIndex].y + this.pieOuterBounds[pieIndex].height - labelSize[length - 1].height + fm.getAscent());
        int space_needed = labelSize[0].height;
        for (int i = 1; i < length; ++i) {
            space_needed += labelSize[i].height + 10;
        }
        int pieHeight = this.pieWidth[pieIndex];
        if (this.display3dOn) {
            int effect3d = (int)Math.round((double)((float)this.pieWidth[pieIndex] * this.chart.getDepth()) * ((double)this.chart.getAngle() / 90.0));
            pieHeight = (int)Math.round((double)this.pieWidth[pieIndex] * this.size_factor + (double)(effect3d / 2));
        }
        int top = center.y - pieHeight / 2;
        if (space_needed <= pieHeight) {
            int free_space = labelPos[0].y - (top + fm.getAscent());
            block1: for (int i = 1; i < length; ++i) {
                int j;
                int gap = labelPos[i].y - (labelPos[i - 1].y + labelSize[i - 1].height) - 10;
                if (gap > 0) {
                    free_space += gap;
                    continue;
                }
                if (gap >= 0) continue;
                if (-gap < free_space) {
                    free_space += gap;
                    for (j = i; j > 0; --j) {
                        gap = j == 1 ? (gap += labelPos[j - 1].y - (top + fm.getAscent())) : (gap += labelPos[j - 1].y - (labelPos[j - 2].y + labelSize[j - 2].height) - 10);
                        labelPos[j - 1].y = labelPos[j].y - labelSize[j - 1].height - 10;
                        if (gap >= 0) continue block1;
                    }
                    continue;
                }
                for (j = 1; j <= i; ++j) {
                    labelPos[j].y = labelPos[j - 1].y + labelSize[j - 1].height + 10;
                }
                free_space = 0;
            }
        } else {
            int visible_labels = length;
            while (space_needed > this.pieOuterBounds[pieIndex].height) {
                int mid = visible_labels / 2;
                if (visible_labels % 2 == 1) {
                    mid = length - mid;
                }
                labelPos[length - mid] = null;
                space_needed -= labelSize[length - mid].height + 10;
                --visible_labels;
            }
            int offset = (this.pieOuterBounds[pieIndex].height - space_needed) / 2;
            int cur_pos = this.pieOuterBounds[pieIndex].y + fm.getAscent() + offset;
            for (int i = 0; i < length; ++i) {
                if (labelPos[i] == null) continue;
                labelPos[i].y = cur_pos;
                cur_pos += labelSize[i].height + 10;
            }
        }
    }

    public ChartSample checkSelection(Point point) {
        int selected;
        if (point == null) {
            return null;
        }
        this.mouseOverSeriesIndex = -1;
        this.mouseOverSampleIndex = -1;
        ChartSample foundSample = super.checkSelection(point);
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        if (foundSample == null && (selected = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (seriesCount > 1 || this.chart.chartType.equals("line") || this.chart.multiSeriesOn) {
                foundSample = new ChartSample(-1);
                foundSample.setSeries(selected);
            } else if (selected < sampleCount) {
                foundSample = this.chart.getSample(0, selected);
                if (foundSample != null) {
                    foundSample.setSeries(-1);
                }
            } else if (selected >= sampleCount) {
                selected = -1;
            } else {
                foundSample = this.chart.getSample(0, selected);
            }
        }
        if (foundSample == null) {
            int pieIndex = -1;
            for (int i = 0; this.pieBounds != null && i < this.pieBounds.length; ++i) {
                Rectangle bounds = this.pieBounds[i];
                if (bounds == null || !bounds.contains(point)) continue;
                pieIndex = i;
                break;
            }
            if (pieIndex >= 0) {
                double r;
                int i;
                double rad;
                double angle;
                point.x -= this.pieCenter[pieIndex].x;
                point.y -= this.pieCenter[pieIndex].y;
                if (this.display3dOn) {
                    int width = this.pieWidth[pieIndex];
                    int change = (int)Math.round((double)width * ((double)this.chart.getAngle() / 90.0));
                    double factor = (double)width / (double)(width - change);
                    point.y = (int)Math.round((double)point.y * factor);
                }
                if ((angle = -((rad = Math.atan2(point.y, point.x)) * 57.29577951308232)) > 90.0 && angle <= 180.0) {
                    angle = -360.0 + angle;
                }
                double segment_angle = 0.0;
                double stop = 0.0;
                double start = 0.0;
                if (seriesCount == 1) {
                    for (i = 0; i < sampleCount; ++i) {
                        start = this.angle_start[0][i];
                        stop = this.angle_end[0][i];
                        if (!(angle <= start && angle > stop || angle - 360.0 <= start && angle - 360.0 > stop) && (!(angle + 360.0 <= start) || !(angle + 360.0 > stop))) continue;
                        foundSample = this.chart.getSample(0, i);
                        segment_angle = (start + stop) / 2.0;
                        break;
                    }
                } else {
                    for (i = 0; i < seriesCount; ++i) {
                        start = this.angle_start[i][pieIndex];
                        stop = this.angle_end[i][pieIndex];
                        if (!(angle <= start && angle > stop || angle - 360.0 <= start && angle - 360.0 > stop) && (!(angle + 360.0 <= start) || !(angle + 360.0 > stop))) continue;
                        foundSample = this.chart.getSample(i, pieIndex);
                        segment_angle = (start + stop) / 2.0;
                        break;
                    }
                }
                if (foundSample != null && foundSample.isSelected() && this.chart.getSelectionStyle() == 2) {
                    double segment_rad = segment_angle * (Math.PI / 180);
                    double detachedDistance = this.chart.getDetachedDistance();
                    point.x = (int)((double)point.x - Math.cos(segment_rad) * (double)this.pieWidth[pieIndex] * 0.5 * detachedDistance);
                    point.y = (int)((double)point.y + Math.sin(segment_rad) * (double)this.pieWidth[pieIndex] * 0.5 * detachedDistance);
                    rad = Math.atan2(point.y, point.x);
                    angle = -(rad * 57.29577951308232);
                    if (angle > 90.0 && angle <= 180.0) {
                        angle = -360.0 + angle;
                    }
                    if (!(angle <= start && angle > stop || stop > start && (angle <= start || angle >= stop))) {
                        return null;
                    }
                }
                if ((r = Math.sqrt(point.x * point.x + point.y * point.y)) > (double)(this.pieWidth[pieIndex] / 2)) {
                    return null;
                }
            }
        }
        if (foundSample != null) {
            this.mouseOverSampleIndex = foundSample.getIndex();
            this.mouseOverSeriesIndex = foundSample.getSeries();
            this.mousePosition = point;
        } else {
            this.mouseOverSampleIndex = -1;
            this.mouseOverSeriesIndex = -1;
        }
        return foundSample;
    }

    protected void handlePieRotation(AWTEvent e) {
        int seriesCount = this.getSeriesCount();
        switch (e.getID()) {
            case 501: {
                ChartSample sample = this.checkSelection(((MouseEvent)e).getPoint());
                this.rotatedPie = 0;
                if (seriesCount != 1 && sample != null) {
                    this.rotatedPie = sample.getIndex();
                }
                if (this.rotatedPie != -1) {
                    int xpos = ((MouseEvent)e).getX();
                    int ypos = ((MouseEvent)e).getY();
                    double rad = Math.atan2(ypos -= this.pieCenter[this.rotatedPie].y, xpos -= this.pieCenter[this.rotatedPie].x);
                    this.oldAngle = -(rad * 57.29577951308232);
                    if (sample == null) {
                        this.oldAngle = Double.NaN;
                    }
                }
                this.lastClickTime = System.currentTimeMillis();
                break;
            }
            case 506: {
                double rad;
                double angle;
                double delta_angle;
                int xpos = ((MouseEvent)e).getX();
                int ypos = ((MouseEvent)e).getY();
                if (new Double(this.oldAngle).isNaN()) break;
                if (this.rotatedPie != -1 && Math.abs(delta_angle = (angle = -((rad = Math.atan2(ypos -= this.pieCenter[this.rotatedPie].y, xpos -= this.pieCenter[this.rotatedPie].x)) * 57.29577951308232)) - this.oldAngle) >= 2.0) {
                    int n = this.rotatedPie;
                    this.chart.startAngle[n] = (int)((double)this.chart.startAngle[n] + (delta_angle - delta_angle % 2.0));
                    int n2 = this.rotatedPie;
                    this.chart.startAngle[n2] = this.chart.startAngle[n2] - 360;
                    int n3 = this.rotatedPie;
                    this.chart.startAngle[n3] = this.chart.startAngle[n3] % 360;
                    this.oldAngle = angle;
                }
                if (System.currentTimeMillis() - this.lastClickTime > 150L) {
                    this.chart.shouldSelect = false;
                }
                this.chart.needRender = true;
                this.chart.repaint();
            }
        }
    }

    protected boolean isAnyFloatingLabelsOn(int serie) {
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        int percentLabelStyle = this.chart.getPercentLabelStyle();
        boolean valueLabelsOn = this.chart.isValueLabelsOn(serie);
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean percentLabelsOn = this.chart.isPercentLabelsOn();
        boolean labels_on = valueLabelsOn && valueLabelStyle == 3;
        labels_on |= sampleLabelsOn && (sampleLabelStyle == 3 || sampleLabelStyle == 4);
        labels_on |= seriesLabelsOn && seriesLabelStyle == 3;
        return labels_on |= percentLabelsOn && percentLabelStyle == 3;
    }
}

