/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.PGRefCursorResultSet;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2ResultSet
implements BaseResultSet,
PGRefCursorResultSet {
    private boolean updateable = false;
    private boolean doingUpdates = false;
    private HashMap updateValues = null;
    private boolean usingOID = false;
    private Vector primaryKeys;
    private boolean singleTable = false;
    private String tableName = null;
    private PreparedStatement updateStatement = null;
    private PreparedStatement insertStatement = null;
    private PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;
    private int resultsettype;
    private int resultsetconcurrency;
    private int fetchdirection = 1002;
    protected final BaseConnection connection;
    protected final BaseStatement statement;
    protected final Field[] fields;
    protected final Query originalQuery;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected Vector rows;
    protected int current_row = -1;
    protected int row_offset;
    protected byte[][] this_row;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean onInsertRow = false;
    public byte[][] rowBuffer = null;
    protected int fetchSize;
    protected ResultCursor cursor;
    private HashMap columnNameIndexMap;
    private String refCursorName;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final NumberFormatException FAST_NUMBER_FAILED = new NumberFormatException();
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public AbstractJdbc2ResultSet(Query originalQuery, BaseStatement statement, Field[] fields, Vector tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency) throws SQLException {
        this.originalQuery = originalQuery;
        this.connection = (BaseConnection)statement.getConnection();
        this.statement = statement;
        this.fields = fields;
        this.rows = tuples;
        this.cursor = cursor;
        this.maxRows = maxRows;
        this.maxFieldSize = maxFieldSize;
        this.resultsettype = rsType;
        this.resultsetconcurrency = rsConcurrency;
    }

    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    protected Object internalGetObject(int columnIndex, Field field) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
        }
        String type = this.getPGType(columnIndex);
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        if (type.equals("refcursor")) {
            String cursorName = this.getString(columnIndex);
            String fetchSql = "FETCH ALL IN \"" + cursorName + "\"";
            ResultSet rs = this.connection.execSQLQuery(fetchSql, this.resultsettype, 1007);
            ((AbstractJdbc2ResultSet)rs).setRefCursor(cursorName);
            return rs;
        }
        return null;
    }

    private void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsettype == 1003) {
            throw new PSQLException(GT.tr("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY."), PSQLState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean absolute(int index) throws SQLException {
        int internalIndex;
        this.checkScrollable();
        if (index == 0) {
            this.beforeFirst();
            return false;
        }
        int rows_size = this.rows.size();
        if (index < 0) {
            if (index < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + index;
        } else {
            if (index > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = index - 1;
        }
        this.current_row = internalIndex;
        this.this_row = (byte[][])this.rows.elementAt(internalIndex);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public void afterLast() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size > 0) {
            this.current_row = rows_size;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    public void beforeFirst() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    public boolean first() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public java.sql.Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public java.sql.Array getArray(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return this.createArray(i);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public abstract Blob getBlob(int var1) throws SQLException;

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int i) throws SQLException {
        this.checkResultSet(i);
        boolean bl = this.wasNullFlag = this.this_row[i - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (((AbstractJdbc2Connection)this.connection).haveMinimumCompatibleVersion("7.2")) {
            return new CharArrayReader(this.getString(i).toCharArray());
        }
        Encoding encoding = this.connection.getEncoding();
        InputStream input = this.getBinaryStream(i);
        try {
            return encoding.getDecodingReader(input);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unexpected error while decoding character data from a large object."), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public abstract Clob getClob(int var1) throws SQLException;

    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetconcurrency;
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        return this.connection.getTimestampUtils().toDate(cal, this.getString(i));
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        return this.connection.getTimestampUtils().toTime(cal, this.getString(i));
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        return this.connection.getTimestampUtils().toTimestamp(cal, this.getString(i));
    }

    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    public Object getObjectImpl(String columnName, Map map) throws SQLException {
        return this.getObjectImpl(this.findColumn(columnName), map);
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Ref getRef(int i) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return 0;
        }
        int rows_size = this.rows.size();
        if (this.current_row < 0 || this.current_row >= rows_size) {
            return 0;
        }
        return this.row_offset + this.current_row + 1;
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsettype;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        return this.current_row >= rows_size && rows_size > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row == 0;
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        if (this.current_row != rows_size - 1) {
            return false;
        }
        if (this.cursor == null) {
            return true;
        }
        if (this.maxRows > 0 && this.row_offset + this.current_row == this.maxRows) {
            return true;
        }
        this.row_offset += rows_size - 1;
        int fetchRows = this.fetchSize;
        if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
            fetchRows = this.maxRows - this.row_offset;
        }
        this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
        this.rows.insertElementAt(this.this_row, 0);
        this.current_row = 0;
        return this.rows.size() == 1;
    }

    public boolean last() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size <= 0) {
            return false;
        }
        this.current_row = rows_size - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        this.onInsertRow = false;
        return true;
    }

    public boolean previous() throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row - 1 < 0) {
            this.current_row = -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        --this.current_row;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        return this.absolute(this.current_row + 1 + rows);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", new Integer(direction)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchdirection = direction;
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call cancelRowUpdates() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    public synchronized void deleteRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call deleteRow() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException(GT.tr("Currently positioned before the start of the ResultSet.  You cannot call deleteRow() here."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isAfterLast()) {
            throw new PSQLException(GT.tr("Currently positioned after the end of the ResultSet.  You cannot call deleteRow() here."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.rows.size() == 0) {
            throw new PSQLException(GT.tr("There are no rows in this ResultSet."), PSQLState.INVALID_CURSOR_STATE);
        }
        int numKeys = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuffer deleteSQL = new StringBuffer("DELETE FROM ").append(this.tableName).append(" where ");
            for (int i = 0; i < numKeys; ++i) {
                deleteSQL.append("\"");
                deleteSQL.append(((PrimaryKey)this.primaryKeys.get((int)i)).name);
                deleteSQL.append("\" = ?");
                if (i >= numKeys - 1) continue;
                deleteSQL.append(" and ");
            }
            this.deleteStatement = this.connection.prepareStatement(deleteSQL.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < numKeys; ++i) {
            this.deleteStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(i)).getValue());
        }
        this.deleteStatement.executeUpdate();
        this.rows.removeElementAt(this.current_row);
        --this.current_row;
        this.moveToCurrentRow();
    }

    public synchronized void insertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new PSQLException(GT.tr("Not on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues.size() == 0) {
            throw new PSQLException(GT.tr("You must specify at least one column value to insert a row."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        StringBuffer insertSQL = new StringBuffer("INSERT INTO ").append(this.tableName).append(" (");
        StringBuffer paramSQL = new StringBuffer(") values (");
        Iterator columnNames = this.updateValues.keySet().iterator();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasNext()) {
            String columnName = (String)columnNames.next();
            insertSQL.append("\"");
            insertSQL.append(columnName);
            insertSQL.append("\"");
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = this.connection.prepareStatement(insertSQL.toString());
        Iterator keys = this.updateValues.keySet().iterator();
        int i2 = 1;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object o = this.updateValues.get(key);
            this.insertStatement.setObject(i2, o);
            ++i2;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long insertedOID = ((AbstractJdbc2Statement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", new Long(insertedOID));
        }
        this.updateRowBuffer();
        this.rows.addElement(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer(false);
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.this_row = (byte[][])this.rows.elementAt(this.current_row);
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean copyCurrentRow) throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        if (copyCurrentRow) {
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.updateValues.clear();
    }

    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            InputStreamReader reader = new InputStreamReader(x, "ASCII");
            char[] data = new char[length];
            int numRead = 0;
            while ((n = reader.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (UnsupportedEncodingException uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), null, (Throwable)ie);
        }
    }

    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] data = new byte[length];
        int numRead = 0;
        try {
            int n;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided InputStream failed."), null, (Throwable)ie);
        }
        if (numRead == length) {
            this.updateBytes(columnIndex, data);
        } else {
            byte[] data2 = new byte[numRead];
            System.arraycopy(data, 0, data2, 0, numRead);
            this.updateBytes(columnIndex, data2);
        }
    }

    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateValue(columnIndex, new Boolean(x));
    }

    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, String.valueOf(x));
    }

    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            char[] data = new char[length];
            int numRead = 0;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided Reader failed."), null, (Throwable)ie);
        }
    }

    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateValue(columnIndex, new Double(x));
    }

    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateValue(columnIndex, new Float(x));
    }

    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.updateValue(columnIndex, new Integer(x));
    }

    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.updateValue(columnIndex, new Long(x));
    }

    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        String columnTypeName = this.connection.getPGType(this.fields[columnIndex - 1].getOID());
        this.updateValue(columnIndex, new NullObject(columnTypeName));
    }

    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    public void refreshRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t refresh the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0) {
            return;
        }
        StringBuffer selectSQL = new StringBuffer("select ");
        int numColumns = Array.getLength(this.fields);
        for (int i = 0; i < numColumns; ++i) {
            selectSQL.append(this.fields[i].getColumnName(this.connection));
            if (i >= numColumns - 1) continue;
            selectSQL.append(", ");
        }
        selectSQL.append(" from ").append(this.tableName).append(" where ");
        int numKeys = this.primaryKeys.size();
        for (int i = 0; i < numKeys; ++i) {
            PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i);
            selectSQL.append(primaryKey.name).append("= ?");
            if (i >= numKeys - 1) continue;
            selectSQL.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("selecting " + selectSQL.toString());
        }
        this.selectStatement = this.connection.prepareStatement(selectSQL.toString());
        int j = 0;
        int i = 1;
        while (j < numKeys) {
            this.selectStatement.setObject(i, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
            ++j;
            ++i;
        }
        AbstractJdbc2ResultSet rs = (AbstractJdbc2ResultSet)this.selectStatement.executeQuery();
        if (rs.next()) {
            this.rowBuffer = rs.rowBuffer;
        }
        this.rows.setElementAt(this.rowBuffer, this.current_row);
        this.this_row = this.rowBuffer;
        this.connection.getLogger().debug("done updates");
        rs.close();
        this.selectStatement.close();
        this.selectStatement = null;
    }

    public synchronized void updateRow() throws SQLException {
        int i;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call updateRow() when on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (!this.doingUpdates) {
            return;
        }
        StringBuffer updateSQL = new StringBuffer("UPDATE " + this.tableName + " SET  ");
        int numColumns = this.updateValues.size();
        Iterator columns = this.updateValues.keySet().iterator();
        int i2 = 0;
        while (columns.hasNext()) {
            String column = (String)columns.next();
            updateSQL.append("\"");
            updateSQL.append(column);
            updateSQL.append("\" = ?");
            if (i2 < numColumns - 1) {
                updateSQL.append(", ");
            }
            ++i2;
        }
        updateSQL.append(" WHERE ");
        int numKeys = this.primaryKeys.size();
        for (i = 0; i < numKeys; ++i) {
            PrimaryKey primaryKey = (PrimaryKey)this.primaryKeys.get(i);
            updateSQL.append("\"");
            updateSQL.append(primaryKey.name);
            updateSQL.append("\" = ?");
            if (i >= numKeys - 1) continue;
            updateSQL.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("updating " + updateSQL.toString());
        }
        this.updateStatement = this.connection.prepareStatement(updateSQL.toString());
        i = 0;
        for (Object o : this.updateValues.values()) {
            this.updateStatement.setObject(i + 1, o);
            ++i;
        }
        int j = 0;
        while (j < numKeys) {
            this.updateStatement.setObject(i + 1, ((PrimaryKey)this.primaryKeys.get(j)).getValue());
            ++j;
            ++i;
        }
        this.updateStatement.executeUpdate();
        this.updateStatement.close();
        this.updateStatement = null;
        this.updateRowBuffer();
        this.connection.getLogger().debug("copying data");
        System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
        this.rows.setElementAt(this.rowBuffer, this.current_row);
        this.connection.getLogger().debug("done updates");
        this.updateValues.clear();
        this.doingUpdates = false;
    }

    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.updateValue(columnIndex, new Short(x));
    }

    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    boolean isUpdateable() throws SQLException {
        this.checkClosed();
        if (this.resultsetconcurrency == 1007) {
            throw new PSQLException(GT.tr("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateable) {
            return true;
        }
        this.connection.getLogger().debug("checking if rs is updateable");
        this.parseQuery();
        if (!this.singleTable) {
            this.connection.getLogger().debug("not a single table");
            return false;
        }
        this.connection.getLogger().debug("getting primary keys");
        this.primaryKeys = new Vector();
        this.usingOID = false;
        int oidIndex = this.findColumnIndex("oid");
        int i = 0;
        if (oidIndex > 0) {
            ++i;
            this.primaryKeys.add(new PrimaryKey(oidIndex, "oid"));
            this.usingOID = true;
        } else {
            String[] s = AbstractJdbc2ResultSet.quotelessTableName(this.tableName);
            String quotelessTableName = s[0];
            String quotelessSchemaName = s[1];
            ResultSet rs = this.connection.getMetaData().getPrimaryKeys("", quotelessSchemaName, quotelessTableName);
            while (rs.next()) {
                String columnName = rs.getString(4);
                int index = this.findColumn(columnName);
                if (index > 0) {
                    this.primaryKeys.add(new PrimaryKey(index, columnName));
                }
                ++i;
            }
            rs.close();
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("no of keys=" + i);
        }
        if (i < 1) {
            throw new PSQLException(GT.tr("No primary key found for table {0}.", this.tableName), PSQLState.DATA_ERROR);
        }
        boolean bl = this.updateable = this.primaryKeys.size() > 0;
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    public static String[] quotelessTableName(String fullname) {
        StringBuffer buf = new StringBuffer(fullname);
        String[] parts = new String[]{null, ""};
        StringBuffer acc = new StringBuffer();
        boolean betweenQuotes = false;
        block4: for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < buf.length() - 1 && buf.charAt(i + 1) == '\"') {
                        ++i;
                        acc.append(c);
                        continue block4;
                    }
                    betweenQuotes = !betweenQuotes;
                    continue block4;
                }
                case '.': {
                    if (betweenQuotes) {
                        acc.append(c);
                        continue block4;
                    }
                    parts[1] = acc.toString();
                    acc = new StringBuffer();
                    continue block4;
                }
                default: {
                    acc.append(betweenQuotes ? c : Character.toLowerCase(c));
                }
            }
        }
        parts[0] = acc.toString();
        return parts;
    }

    private void parseQuery() {
        String l_sql = this.originalQuery.toString(null);
        StringTokenizer st = new StringTokenizer(l_sql, " \r\t\n");
        boolean tableFound = false;
        boolean tablesChecked = false;
        String name = "";
        this.singleTable = true;
        while (!tableFound && !tablesChecked && st.hasMoreTokens()) {
            name = st.nextToken();
            if (!tableFound) {
                if (!name.toLowerCase().equals("from")) continue;
                this.tableName = st.nextToken();
                tableFound = true;
                continue;
            }
            tablesChecked = true;
            this.singleTable = !name.equalsIgnoreCase(",");
        }
    }

    private void updateRowBuffer() throws SQLException {
        block7: for (String columnName : this.updateValues.keySet()) {
            int columnIndex = this.findColumn(columnName) - 1;
            Object valueObject = this.updateValues.get(columnName);
            if (valueObject instanceof NullObject) {
                this.rowBuffer[columnIndex] = null;
                continue;
            }
            switch (this.getSQLType(columnIndex + 1)) {
                case -7: 
                case -6: 
                case -5: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 1111: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(String.valueOf(valueObject));
                    continue block7;
                }
                case 91: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Date)valueObject));
                    continue block7;
                }
                case 92: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Time)valueObject));
                    continue block7;
                }
                case 93: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(null, (Timestamp)valueObject));
                    continue block7;
                }
                case 0: {
                    continue block7;
                }
            }
            this.rowBuffer[columnIndex] = (byte[])valueObject;
        }
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    public String getRefCursor() {
        return this.refCursorName;
    }

    private void setRefCursor(String refCursorName) {
        this.refCursorName = refCursorName;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0."), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row + 1 >= this.rows.size()) {
            if (this.cursor == null || this.maxRows > 0 && this.row_offset + this.rows.size() >= this.maxRows) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.row_offset += this.rows.size();
            int fetchRows = this.fetchSize;
            if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
                fetchRows = this.maxRows - this.row_offset;
            }
            this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
            this.current_row = 0;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        } else {
            ++this.current_row;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public void close() throws SQLException {
        this.rows = null;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Encoding encoding = this.connection.getEncoding();
        try {
            return this.trimString(columnIndex, encoding.decode(this.this_row[columnIndex - 1]));
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return AbstractJdbc2ResultSet.toBoolean(this.getString(columnIndex));
    }

    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            if ((s = s.trim()).length() == 0) {
                return 0;
            }
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(BYTEMAX);
                    int lt = i.compareTo(BYTEMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"byte", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.byteValue();
                }
                catch (NumberFormatException ex) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"byte", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        String s = this.getFixedString(columnIndex);
        if (s != null) {
            s = s.trim();
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(SHORTMAX);
                    int lt = i.compareTo(SHORTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"short", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.shortValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"short", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public int getInt(int columnIndex) throws SQLException {
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return AbstractJdbc2ResultSet.toInt(this.getFixedString(columnIndex));
    }

    public long getLong(int columnIndex) throws SQLException {
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastLong(columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return AbstractJdbc2ResultSet.toLong(this.getFixedString(columnIndex));
    }

    private long getFastLong(int columnIndex) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[--columnIndex] == null;
        if (this.wasNullFlag) {
            return 0L;
        }
        byte[] bytes = this.this_row[columnIndex];
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        long val = 0L;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10L;
            val += (long)(b - 48);
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    private int getFastInt(int columnIndex) throws SQLException {
        int start;
        boolean neg;
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[--columnIndex] == null;
        if (this.wasNullFlag) {
            return 0;
        }
        byte[] bytes = this.this_row[columnIndex];
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int val = 0;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length > 10) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 9) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10;
            val += b - 48;
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return AbstractJdbc2ResultSet.toFloat(this.getFixedString(columnIndex));
    }

    public double getDouble(int columnIndex) throws SQLException {
        return AbstractJdbc2ResultSet.toDouble(this.getFixedString(columnIndex));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return AbstractJdbc2ResultSet.toBigDecimal(this.getFixedString(columnIndex), scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (!this.wasNullFlag) {
            if (this.fields[columnIndex - 1].getFormat() == 1) {
                return this.this_row[columnIndex - 1];
            }
            if (this.connection.haveMinimumCompatibleVersion("7.2")) {
                if (this.fields[columnIndex - 1].getOID() == 17) {
                    return this.trimBytes(columnIndex, PGbytea.toBytes(this.this_row[columnIndex - 1]));
                }
                return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
            }
            if (this.fields[columnIndex - 1].getOID() == 26) {
                LargeObjectManager lom = this.connection.getLargeObjectAPI();
                LargeObject lob = lom.open(this.getInt(columnIndex));
                byte[] buf = lob.read(lob.size());
                lob.close();
                return this.trimBytes(columnIndex, buf);
            }
            return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
        }
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            byte[] b = this.getBytes(columnIndex);
            if (b != null) {
                return new ByteArrayInputStream(b);
            }
        } else if (this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getInt(columnIndex));
            return lob.getInputStream();
        }
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName), null);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), null);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        Object result = this.internalGetObject(columnIndex, field);
        if (result != null) {
            return result;
        }
        return this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        int col = this.findColumnIndex(columnName);
        if (col == 0) {
            throw new PSQLException(GT.tr("The column name {0} was not found in this ResultSet.", columnName), PSQLState.UNDEFINED_COLUMN);
        }
        return col;
    }

    private int findColumnIndex(String columnName) {
        Integer index;
        if (this.columnNameIndexMap == null) {
            this.columnNameIndexMap = new HashMap(this.fields.length * 2);
            for (int i = 0; i < this.fields.length; ++i) {
                this.columnNameIndexMap.put(this.fields[i].getColumnLabel().toLowerCase(), new Integer(i + 1));
            }
        }
        if ((index = (Integer)this.columnNameIndexMap.get(columnName)) != null) {
            return index;
        }
        index = (Integer)this.columnNameIndexMap.get(columnName.toLowerCase());
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        return 0;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public String getFixedString(int col) throws SQLException {
        boolean bl = this.wasNullFlag = this.this_row[col - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        String s = this.getString(col);
        if (s.length() < 2) {
            return s;
        }
        char ch = s.charAt(0);
        if (ch > '-') {
            return s;
        }
        if (ch == '(') {
            s = "-" + PGtokenizer.removePara(s).substring(1);
        } else if (ch == '$') {
            s = s.substring(1);
        } else if (ch == '-' && s.charAt(1) == '$') {
            s = "-" + s.substring(2);
        }
        return s;
    }

    protected String getPGType(int column) throws SQLException {
        return this.connection.getPGType(this.fields[column - 1].getOID());
    }

    protected int getSQLType(int column) throws SQLException {
        return this.connection.getSQLType(this.fields[column - 1].getOID());
    }

    private void checkUpdateable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdateable()) {
            throw new PSQLException(GT.tr("ResultSet is not updateable.  The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details."), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("This ResultSet is closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    protected void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(column), new Integer(this.fields.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkResultSet(int column) throws SQLException {
        this.checkClosed();
        if (this.this_row == null) {
            throw new PSQLException(GT.tr("ResultSet not positioned properly, perhaps you need to call next."), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(column);
    }

    public static boolean toBoolean(String s) {
        if (s != null) {
            if ((s = s.trim()).equalsIgnoreCase("t") || s.equalsIgnoreCase("true") || s.equals("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false") || s.equals("0")) {
                return false;
            }
            try {
                if (Double.valueOf(s) == 1.0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(INTMAX);
                    int lt = i.compareTo(INTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"int", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.intValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"int", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static long toLong(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(LONGMAX);
                    int lt = i.compareTo(LONGMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"long", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.longValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"long", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String s, int scale) throws SQLException {
        if (s != null) {
            BigDecimal val;
            try {
                s = s.trim();
                val = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"BigDecimal", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
            if (scale == -1) {
                return val;
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"BigDecimal", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return null;
    }

    public static float toFloat(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"float", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", new Object[]{"double", s}), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0;
    }

    private boolean isColumnTrimmable(int columnIndex) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(int p_columnIndex, byte[] p_bytes) throws SQLException {
        if (this.maxFieldSize > 0 && p_bytes.length > this.maxFieldSize && this.isColumnTrimmable(p_columnIndex)) {
            byte[] l_bytes = new byte[this.maxFieldSize];
            System.arraycopy(p_bytes, 0, l_bytes, 0, this.maxFieldSize);
            return l_bytes;
        }
        return p_bytes;
    }

    private String trimString(int p_columnIndex, String p_string) throws SQLException {
        if (this.maxFieldSize > 0 && p_string.length() > this.maxFieldSize && this.isColumnTrimmable(p_columnIndex)) {
            return p_string.substring(0, this.maxFieldSize);
        }
        return p_string;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rows.size() == 0)) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results."), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(columnIndex);
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateValues.put(this.fields[columnIndex - 1].getColumnName(this.connection), value);
        }
    }

    class NullObject
    extends PGobject {
        NullObject(String type) {
            this.setType(type);
        }

        public String getValue() {
            return null;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            return AbstractJdbc2ResultSet.this.getObject(this.index);
        }
    }

    public class CursorResultHandler
    implements ResultHandler {
        private SQLException error;

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            AbstractJdbc2ResultSet.this.rows = tuples;
            AbstractJdbc2ResultSet.this.cursor = cursor;
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2ResultSet.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

