/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.snmp;
import com.ireasoning.protocol.Listener;
import com.ireasoning.protocol.Msg;
import com.ireasoning.protocol.TimeoutException;
import com.ireasoning.protocol.snmp.SnmpErrorStatus;
import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpTarget;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.util.ParseArguments;
import java.io.IOException;
import java.util.ArrayList;

public class snmpwalk
extends snmp
implements Listener {
    static int _walkMethod = 1;
    private int timeout = 60000;
    public ArrayList output = new ArrayList();
    private long stime = 0L;
    private long etime = 0L;

    public snmpwalk(String[] stringArray, int n) {
        this.parseOptions(stringArray, "snmpwalk", false, false);
        this.timeout = n * 1000;
    }

    public static void main(String[] stringArray) {
        snmpwalk snmpwalk2 = new snmpwalk(stringArray, 2);
        ArrayList arrayList = snmpwalk2.walk();
        System.out.println(arrayList);
    }

    public ArrayList walk() {
        this.output = new ArrayList();
        this.walk2();
        return this.output;
    }

    private void walk1() {
        this.stime = System.currentTimeMillis();
        this.etime = this.stime + (long)this.timeout;
        this.output = new ArrayList();
        try {
            SnmpSession snmpSession = new SnmpSession(this._host, this._port, this._community, this._community, this._version);
            snmpSession.setTimeout(this.timeout);
            if (this._isSnmpV3) {
                snmpSession.setV3Params(this._user, this._authProtocol, this._authPassword, this._privProtocol, this._privPassword);
            }
            snmpSession.snmpWalk(this._oids[0], (Listener)this);
        }
        catch (TimeoutException timeoutException) {
            System.out.println("time out");
            this.output = null;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
            this.output = null;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.output = null;
        }
    }

    public void handleMsg(Object object, Msg msg) {
        SnmpPdu snmpPdu = (SnmpPdu)msg;
        if (snmpPdu.getErrorStatus() != 0) {
            System.out.println("Error: " + SnmpErrorStatus.ERR_STRINGS[snmpPdu.getErrorStatus()]);
            this.output = null;
            return;
        }
        if (snmpPdu.isSnmpV3AuthenticationFailed()) {
            System.out.println("Authentication failed");
            this.output = null;
            return;
        }
        if (!snmpPdu.hasMore()) {
            System.out.println("<End of MIB View Reached>");
            ((SnmpSession)object).close();
            return;
        }
        this.output = this.print(snmpPdu, this.output);
        System.out.println("new output " + this.output.size() + " " + this.output);
    }

    private ArrayList walk2() {
        this.stime = System.currentTimeMillis();
        this.etime = this.stime + (long)this.timeout;
        this.output = new ArrayList();
        try {
            SnmpPdu snmpPdu;
            SnmpTarget snmpTarget = new SnmpTarget(this._host, this._port, this._community, this._community, this._version);
            SnmpSession snmpSession = new SnmpSession(snmpTarget);
            snmpSession.setTimeout(this.timeout);
            if (this._isSnmpV3) {
                snmpSession.setV3Params(this._user, this._authProtocol, this._authPassword, this._privProtocol, this._privPassword);
            }
            if (!(snmpPdu = snmpSession.snmpGetNextRequest(this._oids[0])).hasMore()) {
                System.out.println("End of mib view reached");
                return null;
            }
            this.output = this.print(snmpPdu, this.output);
            while (true) {
                if (System.currentTimeMillis() > this.etime) {
                    return this.output;
                }
                if (!(snmpPdu = snmpSession.snmpGetNextRequest(snmpPdu.getFirstVarBind().getName())).hasMore()) break;
                this.output = this.print(snmpPdu, this.output);
            }
            System.out.println("End of mib view reached");
            snmpSession.close();
            return this.output;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return null;
        }
    }

    private void walk3() {
        try {
            SnmpTarget snmpTarget = new SnmpTarget(this._host, this._port, this._community, this._community);
            SnmpSession snmpSession = new SnmpSession(snmpTarget);
            if (this._isSnmpV3) {
                snmpSession.setV3Params(this._user, this._authProtocol, this._authPassword, this._privProtocol, this._privPassword);
            }
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[]{new SnmpVarBind(this._oids[0])};
            SnmpPdu snmpPdu = new SnmpPdu(-95, snmpVarBindArray);
            SnmpPdu snmpPdu2 = null;
            snmpPdu2 = snmpSession.send(snmpPdu);
            if (!snmpPdu2.hasMore()) {
                System.out.println("End of mib view reached");
                return;
            }
            this.print(snmpPdu2);
            while (true) {
                snmpPdu.setOID(snmpPdu2.getFirstVarBind().getName());
                snmpPdu2 = snmpSession.send(snmpPdu);
                if (!snmpPdu2.hasMore()) break;
                this.print(snmpPdu2);
            }
            System.out.println("End of mib view reached");
            snmpSession.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    @Override
    protected void moreOptions() {
        System.out.println("-w {1|2|3} which walk method to use, default is 1");
    }

    @Override
    protected void parseOptions(String[] stringArray, String string, boolean bl, boolean bl2) {
        super.parseOptions(stringArray, string, bl, bl2);
        _walkMethod = Integer.parseInt(this._parseArgs.getOptionValue('w', "1"));
    }

    @Override
    protected void printMoreOptions() {
        System.out.println("walk-method =\t\t" + _walkMethod);
    }

    @Override
    protected ParseArguments newParseArgumentsInstance(String[] stringArray) {
        return new ParseArguments(stringArray, "?ho", "uvaAXxcpmnrw");
    }
}

