/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCrypt;
import com.eg.EgDateInfo;
import com.eg.EgDbInfo;
import com.eg.EgDbaseInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.egurkha.util.DateUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Scanner;

public class dbPartition {
    EgDbaseInfo dbaseInfo = new EgDbaseInfo("manager");
    EgDbInfo dbInfo = new EgDbInfo("manager");
    EgDateInfo date = new EgDateInfo();
    private static String logFile = EgInstallInfo.getInstallDir() + "/manager/logs/dbPartition_log";
    int daysToCreatePartition = -1;
    public Connection connection = null;
    public Statement statement = null;
    public ResultSet resultset = null;
    public IniFile egDbIni;
    public String isDoubleByteEnabled;
    public String str_driver;
    public String db_servType;
    public String str_dburl;
    public String str_dbusr;
    public String str_dbpwd;
    int millis_in_days = 86400000;
    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public dbPartition() {
        String string = "eg_db.ini";
        String string2 = EgInstallInfo.getInstallDir() + "/manager/config/";
        this.egDbIni = new IniFile(string2 + string);
        this.isDoubleByteEnabled = this.egDbIni.getValue("DB_PROPERTIES", "DoubleByteEnabled");
        this.db_servType = this.egDbIni.getValue("DB_PROPERTIES", "DB_Server_Type");
        this.str_driver = this.egDbIni.getValue("DB_PROPERTIES", "sql.driver");
        this.str_dburl = this.egDbIni.getValue("DB_PROPERTIES", "sql.url");
        this.str_dbusr = this.egDbIni.getValue("DB_PROPERTIES", "sql.user");
        this.str_dbpwd = this.egDbIni.getValue("DB_PROPERTIES", "sql.password");
        this.str_dbpwd = EgCrypt.decrypt(this.str_dbpwd);
        this.daysToCreatePartition = this.dbInfo.getMeasurementCleanPeriod();
        if (this.daysToCreatePartition <= 0) {
            this.daysToCreatePartition = 42;
        }
        this.daysToCreatePartition += 10;
    }

    public String performAction(String string) {
        File file = new File(logFile);
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = null;
        List<String> list = Arrays.asList(this.dbaseInfo.getDynamicTables());
        List<String> list2 = Arrays.asList(this.dbaseInfo.getPartitionTables());
        boolean bl = list2 != null && list2.size() > 0;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("EG_UD_MEASURE", "RUM_DETAILS", "EXTERNAL_SERVICE_DETAILS", "BTM_USER_EXPERIENCE", "CTXXCXAAPPTEST_SESSIONDETAILS"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(arrayList);
        arrayList2.addAll(list);
        dbPartition.logToFile("INFO performAction tablesList -> " + arrayList2);
        if (this.dbInfo.isPartitionFlagEnabled() && bl && arrayList2 != null && arrayList2.size() > 0) {
            boolean bl2 = true;
            String string3 = null;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string4 = (String)arrayList2.get(i);
                if (string4.endsWith("_cf") || string4.endsWith("_ag") || string4.endsWith("_agx") || string4.endsWith("_ex") || list2.contains(string4)) continue;
                dbPartition.logToFile("INFO performAction started for " + string4);
                dbPartition.logToFile("INFO Max Partition date entry missing in INI for  " + string4);
                String string5 = this.isTablePartitioned(string4);
                if (string5 != null && string5.length() > 0 && !string5.equals("-")) {
                    dbPartition.logToFile("INFO " + string4 + " table is partitioned in DB. Max Partition Date is " + string5);
                    string3 = this.performAdditionalPartition(string4, string5, string);
                    if (bl2 && string3 != null && string == null) {
                        string2 = string3;
                        bl2 = false;
                        dbPartition.logToFile("INFO performAction assigning maxPartitionDate  " + string2);
                    }
                } else {
                    dbPartition.logToFile("INFO Max Partition date is empty for " + string4);
                }
                dbPartition.logToFile("INFO performAction ended for " + string4);
            }
        }
        dbPartition.logToFile("INFO performAction Returning maxPartitionDate " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String isTablePartitioned(String string) {
        String string2 = "select  MAX(prv.value) max_range_value from sys.partition_functions pf left join sys.partition_range_values prv on pf.function_id=prv.function_id where pf.name='" + string + "_pf' group by pf.name";
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = this.getCleanupConnection();
        if (connection == null) {
            dbPartition.logToFile("ERROR Failed to  get DB Connection in getMaxPartitionDate for " + string);
            return null;
        }
        String string3 = "";
        try {
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (connection != null) {
                    this.releaseCleanupConnection(connection);
                }
                String string4 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                this.releaseCleanupConnection(connection);
                resultSet = null;
                statement = null;
                return string4;
            }
            resultSet = statement.executeQuery(string2);
            dbPartition.logToFile("INFO  Query to get max partition date from db " + string2);
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString("max_range_value");
            }
        }
        catch (Exception exception) {
            String string5 = exception.toString();
            dbPartition.logToFile("ERROR  Exception when getting max partition date -  " + string5);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.releaseCleanupConnection(connection);
            resultSet = null;
            statement = null;
        }
        dbPartition.logToFile("INFO  Maximum partition date  - " + string3);
        if (string3 != null && string3.length() > 0 && !string3.equals("-")) {
            string3 = this.changeDateFormat(string3, "yyyy-MM-dd", "MM/dd/yyyy");
        }
        return string3;
    }

    private String changeDateFormat(String string, String string2, String string3) {
        String string4 = string;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = simpleDateFormat.parse(string, parsePosition);
            string4 = simpleDateFormat2.format(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string4 = string;
        }
        return string4;
    }

    public String performAdditionalPartition(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = null;
        Connection connection = this.getCleanupConnection();
        Statement statement = null;
        if (connection == null) {
            dbPartition.logToFile("ERROR Failed to  get DB Connection " + string);
            return null;
        }
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            try {
                statement.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            statement = null;
            this.releaseCleanupConnection(connection);
            bl = true;
            dbPartition.logToFile("ERROR Failed to  create jdbc Statement Object " + string);
            return null;
        }
        boolean bl2 = false;
        if (string != null && string.endsWith("_DDD")) {
            bl2 = true;
        }
        String string5 = this.sdf.format(this.date.egetRealDate());
        String string6 = string5 = string5.substring(0, string5.indexOf(" "));
        dbPartition.logToFile("INFO performAdditionalPartition dateToday -> " + string5);
        String string7 = this.dbaseInfo.getFileGroupName(string);
        String string8 = this.dbaseInfo.getFileGroupName(string + "_THRESH");
        if (string8 == null || string8.trim().length() == 0) {
            string8 = this.dbaseInfo.getDefaultFileGroupName();
            dbPartition.logToFile("INFO performAdditionalPartition - Assigned default fileGroupName since no filegroup for thresh table -> " + string8);
        }
        dbPartition.logToFile("INFO performAdditionalPartition fileGroupName -> " + string7 + " -> " + string8);
        dbPartition.logToFile("INFO performAdditionalPartition Number of partitions to be retained are -> " + this.daysToCreatePartition);
        if (string2 != null && string3 != null) {
            String string9 = DateUtil.getDateDifference((String)string2, (String)string3, (String)"days");
            dbPartition.logToFile("INFO performAdditionalPartition startDate -> " + string2 + " maxPtnDate -> " + string3 + " diff -> " + string9);
            if (string9 != null && !string9.equals("null") && !string9.equals("") && string9.trim().length() > 0) {
                this.daysToCreatePartition = Integer.parseInt(string9);
                string6 = string2;
                dbPartition.logToFile("INFO performAdditionalPartition daysToCreatePartition -> " + this.daysToCreatePartition);
            }
        }
        if (this.daysToCreatePartition != -1) {
            dbPartition.logToFile("INFO Creating additional partition for " + string);
            for (int i = 0; i < this.daysToCreatePartition; ++i) {
                String string10;
                try {
                    String string11;
                    Object object;
                    String string12 = "ALTER PARTITION SCHEME " + string + "_sch NEXT USED [" + string7 + "]";
                    dbPartition.logToFile("INFO performAdditionalPartition schemequery -> " + string12);
                    statement.execute(string12);
                    string10 = "ALTER PARTITION FUNCTION " + string + "_pf () SPLIT RANGE  (";
                    try {
                        object = this.sdf.parse(string6 + " 00:00:00");
                        ((Date)object).setTime(((Date)object).getTime() + (long)this.millis_in_days);
                        string11 = this.sdf.format((Date)object);
                        string10 = string10 + "convert(datetime,'" + string11 + "',101))";
                        string6 = string11;
                    }
                    catch (Exception exception) {
                        bl = true;
                        dbPartition.logToFile("ERROR Failed to parse partition date ");
                    }
                    dbPartition.logToFile("INFO performAdditionalPartition funcquery -> " + string10);
                    statement.execute(string10);
                    if (bl2 || EgInstallInfo.isConfigTest(string)) continue;
                    object = "ALTER PARTITION SCHEME " + string + "_thresh_sch NEXT USED [" + string8 + "]";
                    dbPartition.logToFile("INFO performAdditionalPartition threshSchemeQuery -> " + (String)object);
                    statement.execute((String)object);
                    string11 = string10;
                    string11 = dbPartition.replace(string11, string + "_pf", string + "_thresh_pf");
                    dbPartition.logToFile("INFO performAdditionalPartition threshFuncQuery -> " + string11);
                    statement.execute(string11);
                    continue;
                }
                catch (Exception exception) {
                    string10 = exception.toString();
                    dbPartition.logToFile("INFO performAdditionalPartition Exception is -> " + string10);
                    if (string10.indexOf("Duplicate range") > -1) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                    dbPartition.logToFile("ERROR Failed to do additional partition for " + string + " Exception is " + exception.toString());
                    break;
                }
            }
            dbPartition.logToFile("INFO Additional partition created till " + string6);
            if (!bl) {
                string4 = string6;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.releaseCleanupConnection(connection);
        return string4;
    }

    public Connection getCleanupConnection() {
        Connection connection = null;
        try {
            Class.forName(this.str_driver);
            connection = DriverManager.getConnection(this.str_dburl, this.str_dbusr, this.str_dbpwd);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    private void releaseCleanupConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    public static synchronized void logToFile(String string) {
        EgDateInfo egDateInfo = new EgDateInfo();
        String string2 = egDateInfo.egetDate(false);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(logFile, true));
        }
        catch (Exception exception) {
            System.out.println("Cannot open log file for monitoring ");
            return;
        }
        String string3 = new String(string2 + " " + string);
        printWriter.println(string3);
        printWriter.flush();
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPartitionNumber(String string, String string2) {
        Object object;
        String string3 = null;
        String string4 = null;
        if (string2 == null) {
            System.out.println("Please provide date to get partition number from database");
            return;
        }
        string2 = string2 + " 00:00:00";
        String string5 = "";
        try {
            object = this.sdf.parse(string2);
            ((Date)object).setTime(((Date)object).getTime() - (long)this.millis_in_days);
            string5 = this.sdf.format((Date)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = "SELECT $PARTITION.[" + string + "_pf] ('" + string5 + "') AS PartitionNumber";
        String string6 = "SELECT $PARTITION.[" + string + "_pf] ('" + string2 + "') AS PartitionNumber";
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = this.getCleanupConnection();
        if (connection == null) {
            dbPartition.logToFile("ERROR Failed to  get DB Connection in getPartitionNumber for " + string);
            return;
        }
        try {
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (connection != null) {
                    this.releaseCleanupConnection(connection);
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                this.releaseCleanupConnection(connection);
                resultSet = null;
                statement = null;
                return;
            }
            resultSet = statement.executeQuery((String)object);
            dbPartition.logToFile("INFO  Query to get partition number for previous date from db " + (String)object);
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(1);
            }
            dbPartition.logToFile("INFO  Partition number for previous date " + string5 + " is " + string3);
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSet = statement.executeQuery(string6);
            dbPartition.logToFile("INFO  Query to get partition number for input date from db " + string6);
            if (resultSet != null && resultSet.next()) {
                string4 = resultSet.getString(1);
            }
            dbPartition.logToFile("INFO  Partition number for input date " + string2 + " is " + string4);
        }
        catch (Exception exception) {
            String string7 = exception.toString();
            dbPartition.logToFile("ERROR  Exception when getting partition number -  " + string7);
            System.out.println("Exception when getting partition number -  " + string7);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.releaseCleanupConnection(connection);
            resultSet = null;
            statement = null;
        }
        System.out.println("Partition number for previous date " + string5 + " is " + string3);
        System.out.println("Partition number for given date " + string2 + " is " + string4);
    }

    public static void main(String[] stringArray) {
        System.out.println("============================================================");
        Scanner scanner = new Scanner(System.in);
        System.out.println("Type 1 -> To do additional partition for missed entries under [Partitioned_Tables] section.");
        System.out.println("Type 2 -> To check partition number for the given test and date.");
        System.out.println("============================================================");
        System.out.print("Enter the option :: ");
        String string = scanner.next();
        dbPartition dbPartition2 = new dbPartition();
        if (string.equals("2")) {
            System.out.print("Enter the TableName (Internal) :: ");
            String string2 = scanner.next();
            System.out.print("Enter the Date in the format MM/dd/yyyy :: ");
            String string3 = scanner.next();
            dbPartition2.getPartitionNumber(string2, string3);
        } else if (string.equals("1")) {
            System.out.println("Additional partition Starts !!!!!!");
            String string4 = dbPartition2.performAction(null);
            System.out.println("Additional partition Completed !!!!!!");
            System.out.println("Please check dbPartition_log file for further information");
        } else {
            System.out.println("ERROR: Please provide valid option");
        }
    }
}

