/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import com.eg.crypt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class IniTrimmer {
    private ArrayList serverTypes = null;

    public IniTrimmer() {
        this.init();
        if (this.serverTypes != null && this.serverTypes.size() > 0) {
            this.trimDiscover();
            this.trimServices();
        }
    }

    private void init() {
        this.serverTypes = new ArrayList();
        crypt crypt2 = new crypt();
        String string = EgConfigInfo.egMgrConfigDir + "eg_format.ini";
        IniFile iniFile = new IniFile(string);
        String string2 = iniFile.getValue("INFRA", "i");
        if (string2 == null || string2.length() < 1) {
            string = EgConfigInfo.egMgrConfigDir + "eg_testparam.ini";
            iniFile = new IniFile(string);
            string2 = iniFile.getValue("STRUCTURE", "s");
        }
        if (string2 == null || string2.length() < 1) {
            return;
        }
        string2 = crypt2.decrypt(string2.trim());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.serverTypes.add(stringTokenizer.nextToken());
        }
    }

    private void trimDiscover() {
        String string = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile;
        IniFile iniFile = new IniFile(string, true);
        String[] stringArray = iniFile.getSubjects();
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.equalsIgnoreCase("Site_servers") || string2.toLowerCase().endsWith("_ex") || this.serverTypes.contains(string2)) continue;
                iniFile.deleteSubject(string2);
                bl = true;
            }
            if (bl) {
                iniFile.saveFile();
            }
        }
    }

    private void trimServices() {
        String string = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egServicesConfigFile;
        IniFile iniFile = new IniFile(string, true);
        String[] stringArray = iniFile.getVariables("DISCOVERY_SPECIFICATION");
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.startsWith("#")) {
                    string2 = string2.substring(1);
                }
                if (string2.toLowerCase().endsWith("_ex") || string2.startsWith("Format:") || this.serverTypes.contains(string2)) continue;
                iniFile.deleteValue("DISCOVERY_SPECIFICATION", stringArray[i]);
                bl = true;
            }
            if (bl) {
                iniFile.saveFile();
            }
        }
    }

    private void trimSpecs() {
        String string;
        int n;
        String string2 = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egSpecsConfigFile;
        IniFile iniFile = new IniFile(string2, true);
        String[] stringArray = iniFile.getVariables("TEST_MAPPING");
        String[] stringArray2 = iniFile.getVariables("DEFAULT_TEST_MAPPING");
        boolean bl = false;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                if (string.startsWith("Format:") || string.toLowerCase().endsWith("_ex") || string.equals("Host_system") || this.serverTypes.contains(string)) continue;
                iniFile.deleteValue("TEST_MAPPING", string);
                bl = true;
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string = stringArray2[n];
                if (string.startsWith("Format:") || string.toLowerCase().endsWith("_ex") || string.equals("Host_system") || this.serverTypes.contains(string)) continue;
                iniFile.deleteValue("DEFAULT_TEST_MAPPING", string);
                bl = true;
            }
        }
        if (bl) {
            iniFile.saveFile();
        }
    }

    private void trimThreshold() {
        Object object;
        String string = EgConfigInfo.egMgrConfigDir + EgConfigInfo.egThresholdConfigFile;
        EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
        IniFile iniFile = new IniFile(string, true);
        boolean bl = false;
        List<String> list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.serverTypes.size(); ++i) {
            String string2 = (String)this.serverTypes.get(i);
            object = egSpecsInfo.getDefaultTestsForServer(string2);
            if (object == null) continue;
            list = Arrays.asList(object);
            for (int j = 0; j < list.size(); ++j) {
                String string3 = list.get(j);
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        String[] stringArray = iniFile.getVariables("DEFAULT_THRESHOLDS");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (((String)object).toLowerCase().endsWith("_ex") || arrayList.contains(object)) continue;
                iniFile.deleteValue("DEFAULT_THRESHOLDS", (String)object);
                bl = true;
            }
            if (bl) {
                iniFile.saveFile();
            }
        }
    }

    public static void main(String[] stringArray) {
        IniTrimmer iniTrimmer = new IniTrimmer();
    }
}

