/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractResultSetHandler {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;
    private boolean continueProcessingOnBatchFailure = false;
    private Object globalResultSets;
    private Map resultSetsForStatement = new TreeMap();
    private Object globalUpdateCounts;
    private Map updateCountForStatement = new TreeMap();
    private MockResultSet globalGeneratedKeys;
    private Map generatedKeysForStatement = new TreeMap();
    private Map returnsResultSetMap = new TreeMap();
    private Map throwsSQLException = new TreeMap();
    private List executedStatements = new ArrayList();
    private List returnedResultSets = new ArrayList();

    public MockResultSet createResultSet() {
        return new MockResultSet(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string) {
        return new MockResultSet(string);
    }

    public MockResultSet createResultSet(ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(String.valueOf(Math.random()));
    }

    public MockResultSet createResultSet(String string, ResultSetFactory resultSetFactory) {
        return resultSetFactory.create(string);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setExactMatch(boolean bl) {
        this.exactMatch = bl;
    }

    public void setUseRegularExpressions(boolean bl) {
        this.useRegularExpressions = bl;
    }

    public void setContinueProcessingOnBatchFailure(boolean bl) {
        this.continueProcessingOnBatchFailure = bl;
    }

    public void addExecutedStatement(String string) {
        this.executedStatements.add(string);
    }

    public void addReturnedResultSet(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return;
        }
        this.returnedResultSets.add(mockResultSet);
    }

    public void addReturnedResultSets(MockResultSet[] mockResultSetArray) {
        if (null == mockResultSetArray) {
            return;
        }
        this.returnedResultSets.add(mockResultSetArray);
    }

    public List getExecutedStatements() {
        return Collections.unmodifiableList(this.executedStatements);
    }

    public List getReturnedResultSets() {
        return Collections.unmodifiableList(this.returnedResultSets);
    }

    public void clearResultSets() {
        this.resultSetsForStatement.clear();
    }

    public void clearUpdateCounts() {
        this.updateCountForStatement.clear();
    }

    public void clearReturnsResultSet() {
        this.returnsResultSetMap.clear();
    }

    public void clearThrowsSQLException() {
        this.throwsSQLException.clear();
    }

    public void clearGeneratedKeys() {
        this.generatedKeysForStatement.clear();
    }

    public void clearGlobalResultSet() {
        this.globalResultSets = null;
    }

    public void clearGlobalGeneratedKeys() {
        this.globalGeneratedKeys = null;
    }

    public void clearGlobalUpdateCount() {
        this.globalUpdateCounts = null;
    }

    public Map getResultSetMap() {
        return Collections.unmodifiableMap(this.resultSetsForStatement);
    }

    public Map getUpdateCountMap() {
        return Collections.unmodifiableMap(this.updateCountForStatement);
    }

    public Map getGeneratedKeysMap() {
        return Collections.unmodifiableMap(this.generatedKeysForStatement);
    }

    public MockResultSet getResultSet(String string) {
        MockResultSet[] mockResultSetArray;
        Object object = this.getMatchingResultSets(string);
        if (null == object) {
            return null;
        }
        if (object instanceof MockResultSet) {
            return (MockResultSet)object;
        }
        if (object instanceof MockResultSet[] && (mockResultSetArray = (MockResultSet[])object).length > 0) {
            return mockResultSetArray[0];
        }
        return null;
    }

    public MockResultSet[] getResultSets(String string) {
        Object object = this.getMatchingResultSets(string);
        if (null == object) {
            return null;
        }
        if (object instanceof MockResultSet) {
            return new MockResultSet[]{(MockResultSet)object};
        }
        if (object instanceof MockResultSet[]) {
            return (MockResultSet[])object;
        }
        return null;
    }

    public boolean hasMultipleResultSets(String string) {
        Object object = this.getMatchingResultSets(string);
        return object instanceof MockResultSet[];
    }

    private Object getMatchingResultSets(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.resultSetsForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalResultSet() {
        if (null == this.globalResultSets) {
            return null;
        }
        if (this.globalResultSets instanceof MockResultSet) {
            return (MockResultSet)this.globalResultSets;
        }
        MockResultSet[] mockResultSetArray = this.getGlobalResultSets();
        if (null != mockResultSetArray && mockResultSetArray.length > 0) {
            return mockResultSetArray[0];
        }
        return null;
    }

    public MockResultSet[] getGlobalResultSets() {
        if (null == this.globalResultSets) {
            return null;
        }
        if (this.globalResultSets instanceof MockResultSet[]) {
            return (MockResultSet[])this.globalResultSets;
        }
        return new MockResultSet[]{(MockResultSet)this.globalResultSets};
    }

    public boolean hasMultipleGlobalResultSets() {
        return this.globalResultSets instanceof MockResultSet[];
    }

    public Integer getUpdateCount(String string) {
        Integer[] integerArray;
        Object object = this.getMatchingUpdateCounts(string);
        if (null == object) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Integer[] && (integerArray = (Integer[])object).length > 0) {
            return integerArray[0];
        }
        return null;
    }

    public Integer[] getUpdateCounts(String string) {
        Object object = this.getMatchingUpdateCounts(string);
        if (null == object) {
            return null;
        }
        if (object instanceof Integer) {
            return new Integer[]{(Integer)object};
        }
        if (object instanceof Integer[]) {
            return (Integer[])object;
        }
        return null;
    }

    public boolean hasMultipleUpdateCounts(String string) {
        Object object = this.getMatchingUpdateCounts(string);
        return object instanceof Integer[];
    }

    private Object getMatchingUpdateCounts(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.updateCountForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public int getGlobalUpdateCount() {
        if (null == this.globalUpdateCounts) {
            return 0;
        }
        if (this.globalUpdateCounts instanceof Integer) {
            return (Integer)this.globalUpdateCounts;
        }
        int[] nArray = this.getGlobalUpdateCounts();
        if (null != nArray && nArray.length > 0) {
            return nArray[0];
        }
        return 0;
    }

    public int[] getGlobalUpdateCounts() {
        if (null == this.globalUpdateCounts) {
            return null;
        }
        if (this.globalUpdateCounts instanceof int[]) {
            return (int[])this.globalUpdateCounts;
        }
        return new int[]{(Integer)this.globalUpdateCounts};
    }

    public boolean hasMultipleGlobalUpdateCounts() {
        return this.globalUpdateCounts instanceof int[];
    }

    public MockResultSet getGeneratedKeys(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.generatedKeysForStatement, string, true, true);
        if (null != list && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public MockResultSet getGlobalGeneratedKeys() {
        return this.globalGeneratedKeys;
    }

    public Boolean getReturnsResultSet(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.returnsResultSetMap, string, true, true);
        if (null != list && list.size() > 0) {
            return (Boolean)list.get(0);
        }
        return null;
    }

    public boolean getThrowsSQLException(String string) {
        return this.getSQLException(string) != null;
    }

    public SQLException getSQLException(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = sQLStatementMatcher.getMatchingObjects(this.throwsSQLException, string, true, true);
        if (null == list || list.size() == 0) {
            return null;
        }
        return (SQLException)list.get(0);
    }

    public void prepareResultSet(String string, MockResultSet mockResultSet) {
        this.resultSetsForStatement.put(string, mockResultSet);
    }

    public void prepareResultSets(String string, MockResultSet[] mockResultSetArray) {
        this.resultSetsForStatement.put(string, mockResultSetArray.clone());
    }

    public void prepareGlobalResultSet(MockResultSet mockResultSet) {
        this.globalResultSets = mockResultSet;
    }

    public void prepareGlobalResultSets(MockResultSet[] mockResultSetArray) {
        this.globalResultSets = (MockResultSet[])mockResultSetArray.clone();
    }

    public void prepareUpdateCount(String string, int n) {
        this.updateCountForStatement.put(string, new Integer(n));
    }

    public void prepareUpdateCounts(String string, int[] nArray) {
        this.updateCountForStatement.put(string, ArrayUtil.convertToObjectArray(nArray));
    }

    public void prepareGlobalUpdateCount(int n) {
        this.globalUpdateCounts = new Integer(n);
    }

    public void prepareGlobalUpdateCounts(int[] nArray) {
        this.globalUpdateCounts = (int[])nArray.clone();
    }

    public void prepareGeneratedKeys(String string, MockResultSet mockResultSet) {
        this.generatedKeysForStatement.put(string, mockResultSet);
    }

    public void prepareGlobalGeneratedKeys(MockResultSet mockResultSet) {
        this.globalGeneratedKeys = mockResultSet;
    }

    public void prepareReturnsResultSet(String string, boolean bl) {
        this.returnsResultSetMap.put(string, new Boolean(bl));
    }

    public void prepareThrowsSQLException(String string) {
        this.throwsSQLException.put(string, new SQLException("Statement " + string + " was specified to throw an exception"));
    }

    public void prepareThrowsSQLException(String string, SQLException sQLException) {
        this.throwsSQLException.put(string, sQLException);
    }

    protected boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    protected boolean getExactMatch() {
        return this.exactMatch;
    }

    protected boolean getUseRegularExpressions() {
        return this.useRegularExpressions;
    }

    public boolean getContinueProcessingOnBatchFailure() {
        return this.continueProcessingOnBatchFailure;
    }
}

