/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.utils.UnimplementedOperationException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Debug {
    private static final String MESSAGE = "Use jConnect devclasses for debugging.";
    private static final int MAX_JDB_OUTPUT = 128;
    private static boolean _printedMessage = false;
    private static boolean _debugAll = false;
    protected static String _debugClassList = null;
    private static byte[] _debugListBytes = null;
    protected static PrintStream _debugOutputStream;
    protected static PrintWriter _debugOutputWriter;
    private static Hashtable<Object, Long> _times;
    private static long _staticTO;
    private static boolean _disableAssertTrace;

    private Debug() {
    }

    public static void startTimer(Object object) {
        if (_debugAll || Debug.isDebugObject(object)) {
            if (null != object) {
                _times.put(object, new Long(System.currentTimeMillis()));
            } else {
                _staticTO = System.currentTimeMillis();
            }
        }
    }

    public static void stopTimer(Object object, String string) {
        long l = System.currentTimeMillis();
        if (_debugAll || Debug.isDebugObject(object)) {
            if (null != object) {
                Long l2 = _times.get(object);
                if (l2 == null) {
                    Debug.println(Debug.formatString(object, "No start time found for " + string));
                    return;
                }
                l -= l2.longValue();
                _times.remove(object);
            } else {
                l -= _staticTO;
            }
            Debug.println(Debug.formatString(object, string + "; elapsed time = " + l + "ms."));
        }
    }

    public static void printContextTrace(String string) {
        Debug.println("Context Trace:" + string);
    }

    public static void debug(boolean bl) throws IOException {
        Debug.debug(bl, "ALL");
    }

    public static void debug(boolean bl, String string) throws IOException {
        Debug.debug(bl, string, _debugOutputStream);
    }

    public static void debug(boolean bl, String string, PrintStream printStream) throws IOException {
        Debug.printMessage();
        if (bl) {
            if (string == null) {
                string = "ALL";
            }
            _debugClassList = string;
            _debugOutputStream = printStream;
            if (null != _debugClassList) {
                _debugListBytes = _debugClassList.getBytes();
                _debugAll = Debug.isDebugOn();
            }
        } else {
            _debugClassList = null;
            _debugListBytes = null;
            _debugOutputStream = null;
            _debugAll = false;
        }
    }

    public static PrintStream getOutputStream() {
        return _debugOutputStream;
    }

    public static void setOutputStream(PrintStream printStream) {
        _debugOutputStream = printStream;
    }

    public static PrintWriter getOutputWriter() {
        return _debugOutputWriter;
    }

    public static void setOutputWriter(PrintWriter printWriter) {
        _debugOutputWriter = printWriter;
    }

    public static void println(String string) {
        if (_debugOutputStream == null && _debugOutputWriter == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n3 = n2 + 128;
            if (n3 >= n) {
                if (_debugOutputWriter != null) {
                    _debugOutputWriter.println(string.substring(n2, n));
                } else {
                    _debugOutputStream.println(string.substring(n2, n));
                }
            } else if (_debugOutputWriter != null) {
                _debugOutputWriter.println(string.substring(n2, n));
            } else {
                _debugOutputStream.print(string.substring(n2, n3));
            }
            n2 = n3;
        }
    }

    public static void print(String string) {
        if (_debugOutputStream == null && _debugOutputWriter == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n3 = n2 + 128;
            if (n3 >= n) {
                if (_debugOutputWriter != null) {
                    _debugOutputWriter.print(string.substring(n2, n));
                } else {
                    _debugOutputStream.print(string.substring(n2, n));
                }
            } else if (_debugOutputWriter != null) {
                _debugOutputWriter.print(string.substring(n2, n));
            } else {
                _debugOutputStream.print(string.substring(n2, n3));
            }
            n2 = n3;
        }
    }

    public static void println(Object object, String string) {
        if (_debugAll || Debug.isDebugObject(object)) {
            Debug.println(Debug.formatString(object, string));
        }
    }

    public static void printStackTrace(Object object, Exception exception) {
        if (_debugAll || Debug.isDebugObject(object)) {
            Debug.println(Debug.formatString(object, exception.toString()));
            if (!_disableAssertTrace && _debugOutputStream != null) {
                exception.printStackTrace(_debugOutputStream);
            }
        }
    }

    public static void notSupported(Object object, String string) throws UnsupportedOperationException {
        String[] stringArray = new String[]{Debug.className(object) + "." + string};
        ErrorMessage.raiseRuntimeException("JZ0NS", stringArray);
    }

    public static void notImplemented(Object object, String string) throws UnimplementedOperationException {
        String[] stringArray = new String[]{Debug.className(object) + "." + string};
        ErrorMessage.raiseRuntimeException("ZZ00A", stringArray);
    }

    public static void checkObj(Object object, String string, Object object2) {
    }

    public static void asrt(Object object, boolean bl, String string) throws RuntimeException {
        if (!bl) {
            // empty if block
        }
    }

    public static void asrt(Object object, boolean bl) {
        Debug.asrt(object, bl, null);
    }

    public static void disableAssertTrace(boolean bl) {
        _disableAssertTrace = bl;
    }

    public static final void asrt(boolean bl, String string) {
        Debug.asrt(null, bl, string);
    }

    private static String className(Object object) {
        if (object != null) {
            return object.getClass().getName();
        }
        return "";
    }

    private static String formatString(Object object, String string) {
        return Debug.className(object) + "(" + Thread.currentThread() + "): " + string;
    }

    private static void printMessage() {
        if (_printedMessage) {
            return;
        }
        _printedMessage = true;
        Debug.println(MESSAGE);
    }

    private static boolean isDebugObject(Object object) {
        String string = object == null ? "STATIC" : Debug.stripPrefix(Debug.className(object));
        if (null == _debugListBytes) {
            return false;
        }
        return string != null && Debug.parseList(string);
    }

    private static boolean isDebugOn() {
        return Debug.parseList("ALL");
    }

    private static String stripPrefix(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        try {
            while (n-- > 1) {
                stringTokenizer.nextToken();
            }
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.println("parsing class name exception for: " + string);
            return null;
        }
        return string2;
    }

    private static boolean parseList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(_debugListBytes), ":");
        int n = stringTokenizer.countTokens();
        try {
            while (n-- > 0) {
                if (stringTokenizer.nextToken().compareTo(string) != 0) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.println("parsing debugClassList exception for: " + _debugClassList);
            return false;
        }
        return false;
    }

    static {
        _debugOutputWriter = null;
        _times = new Hashtable(8);
        _staticTO = 0L;
        _disableAssertTrace = false;
        _debugOutputStream = DriverManager.getLogStream();
        if (_debugOutputStream == null) {
            _debugOutputStream = System.out;
        }
    }
}

