/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;
import net.sourceforge.openforecast.models.Utils;

public class PolynomialRegressionModel
extends AbstractForecastingModel {
    private String independentVariable;
    private int order = 0;
    private double[] coefficient;

    public PolynomialRegressionModel(String independentVariable) {
        this(independentVariable, 10);
    }

    public PolynomialRegressionModel(String independentVariable, int order) {
        this.independentVariable = independentVariable;
        this.order = order;
    }

    public void init(DataSet dataSet) {
        double[][] a = new double[this.order][this.order + 1];
        int n = dataSet.size();
        int i = 0;
        while (i < this.order) {
            int j = 0;
            while (j < this.order) {
                int k = i + j;
                Iterator it = dataSet.iterator();
                while (it.hasNext()) {
                    DataPoint dp = (DataPoint)it.next();
                    double x = dp.getIndependentValue(this.independentVariable);
                    double y = dp.getDependentValue();
                    a[i][j] = a[i][j] + Math.pow(x, k);
                }
                ++j;
            }
            Iterator it = dataSet.iterator();
            while (it.hasNext()) {
                DataPoint dp = (DataPoint)it.next();
                double x = dp.getIndependentValue(this.independentVariable);
                double y = dp.getDependentValue();
                double[] dArray = a[i];
                int n2 = this.order;
                dArray[n2] = dArray[n2] + y * Math.pow(x, i);
            }
            ++i;
        }
        this.coefficient = Utils.GaussElimination(this.order, a);
        this.calculateAccuracyIndicators(dataSet);
    }

    public double forecast(DataPoint dataPoint) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double x = dataPoint.getIndependentValue(this.independentVariable);
        double forecastValue = 0.0;
        int i = 0;
        while (i < this.order) {
            forecastValue += this.coefficient[i] * Math.pow(x, i);
            ++i;
        }
        dataPoint.setDependentValue(forecastValue);
        return forecastValue;
    }

    public String getForecastType() {
        return "Single variable polynomial regression";
    }

    public String toString() {
        String description = "Single variable polynomial regression model";
        if (!this.initialized) {
            return description + " (uninitialized)";
        }
        description = description + " with an equation of: y = " + this.coefficient[0];
        int i = 1;
        while (i < this.coefficient.length) {
            if (Math.abs(this.coefficient[i]) > 0.001) {
                description = description + (this.coefficient[i] < 0.0 ? "" : "+") + this.coefficient[i] + "*" + this.independentVariable + (i > 1 ? "^" + i : "");
            }
            ++i;
        }
        return description;
    }
}

