/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;
import net.sourceforge.openforecast.models.Utils;

public class MultipleLinearRegressionModel
extends AbstractForecastingModel {
    private double intercept = 0.0;
    private Hashtable coefficient;

    public MultipleLinearRegressionModel() {
        this.coefficient = null;
    }

    public MultipleLinearRegressionModel(String[] independentVariable) {
        this.setIndependentVariables(independentVariable);
    }

    public void init(DataSet dataSet) {
        String[] varNames = dataSet.getIndependentVariables();
        if (this.coefficient == null) {
            this.setIndependentVariables(varNames);
        }
        int n = varNames.length;
        double[][] a = new double[n + 1][n + 2];
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            int row = 0;
            while (row < n + 1) {
                double rowMult = 1.0;
                if (row != 0) {
                    String rowVarName = varNames[row - 1];
                    rowMult = dp.getIndependentValue(rowVarName);
                }
                int col = 0;
                while (col < n + 2) {
                    double colMult = 1.0;
                    if (col == n + 1) {
                        colMult = dp.getDependentValue();
                    } else if (col > 0) {
                        String colVarName = varNames[col - 1];
                        colMult = dp.getIndependentValue(colVarName);
                    }
                    double[] dArray = a[row];
                    int n2 = col++;
                    dArray[n2] = dArray[n2] + rowMult * colMult;
                }
                ++row;
            }
        }
        double[] coeff = Utils.GaussElimination(a);
        this.intercept = coeff[0];
        int i = 1;
        while (i < n + 1) {
            this.coefficient.put(varNames[i - 1], new Double(coeff[i]));
            ++i;
        }
        this.calculateAccuracyIndicators(dataSet);
    }

    public void init(double intercept, Hashtable coefficients) {
        if (this.coefficient == null) {
            Enumeration keysEnum = coefficients.keys();
            String[] keys = new String[coefficients.size()];
            int k = 0;
            while (keysEnum.hasMoreElements()) {
                keys[k++] = (String)keysEnum.nextElement();
            }
            this.setIndependentVariables(keys);
        }
        this.intercept = intercept;
        Iterator it = this.coefficient.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            double coeff = ((Number)coefficients.get(name)).doubleValue();
            this.coefficient.put(name, new Double(coeff));
        }
        this.initialized = true;
    }

    public double getIntercept() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return this.intercept;
    }

    public Hashtable getCoefficients() {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        return new Hashtable(this.coefficient);
    }

    public double forecast(DataPoint dataPoint) {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double forecastValue = this.intercept;
        Iterator it = this.coefficient.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            double x = dataPoint.getIndependentValue((String)entry.getKey());
            double coeff = (Double)entry.getValue();
            forecastValue += coeff * x;
        }
        dataPoint.setDependentValue(forecastValue);
        return forecastValue;
    }

    private void setIndependentVariables(String[] independentVariable) {
        this.coefficient = new Hashtable(independentVariable.length);
        int v = 0;
        while (v < independentVariable.length) {
            this.coefficient.put(independentVariable[v], new Double(0.0));
            ++v;
        }
    }

    public String getForecastType() {
        return "Multiple variable linear regression";
    }

    public String toString() {
        String desc = "Multiple variable linear regression model with the following equation:\n  y=" + this.intercept;
        Set coeffSet = this.coefficient.entrySet();
        Iterator it = coeffSet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            double coeff = (Double)entry.getValue();
            if (coeff < -AbstractForecastingModel.TOLERANCE) {
                desc = desc + coeff + "*" + entry.getKey();
                continue;
            }
            if (!(coeff > AbstractForecastingModel.TOLERANCE)) continue;
            desc = desc + "+" + coeff + "*" + entry.getKey();
        }
        return desc;
    }
}

