/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartApplet;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.PieChart;
import com.objectplanet.chart.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class ChartDataLoader {
    private String[] parameters_range_last = new String[]{"rangestep", "range", "lowerrange", "rangeadjusteron", "currentrange", "currentlowerrange"};
    protected BarChart barChart;
    protected LineChart lineChart;
    protected PieChart pieChart;
    protected Chart theChart;
    protected String chartType;
    private boolean sampleCountSet;
    private double[] rangeStep;
    protected String labelDelimiter = ",";
    protected String valueDelimiter = ",";
    protected Hashtable targets;
    protected Hashtable labels;
    protected Hashtable labelURLs;
    protected Hashtable labelURLTargets;
    Hashtable overlayDataLoaders;

    public ChartDataLoader() {
        this.init();
    }

    public void addChartItemListener(ChartApplet chartApplet) {
    }

    public void init() {
        this.rangeStep = new double[25];
        for (int i = 0; i < 25; ++i) {
            this.rangeStep[i] = -1.0;
        }
        this.targets = new Hashtable();
        this.labels = new Hashtable();
        this.labelURLs = new Hashtable();
        this.labelURLTargets = new Hashtable();
        this.labelURLTargets.put("urltarget", "_self");
        this.overlayDataLoaders = new Hashtable();
    }

    public void reset() {
        this.labelURLs.clear();
        this.labelURLTargets.clear();
        this.labelURLTargets.put("urltarget", "_self");
        this.overlayDataLoaders.clear();
    }

    public void setChartType(String type) {
        this.chartType = type;
    }

    public String getChartType() {
        return this.chartType;
    }

    public Component setChart(Component chart) {
        this.theChart = (Chart)chart;
        if (this.chartType != null && this.chartType.equals("line")) {
            this.lineChart = (LineChart)chart;
        } else if (this.chartType != null && this.chartType.equals("pie")) {
            this.pieChart = (PieChart)chart;
        } else if (this.chartType != null && this.chartType.equals("bar")) {
            this.barChart = (BarChart)chart;
        }
        return chart;
    }

    public Chart getChart() {
        return this.theChart;
    }

    protected GenericChart createExtChart(String type) {
        return null;
    }

    public ChartDataLoader getOverlayDataLoader(String name) {
        return (ChartDataLoader)this.overlayDataLoaders.get(name);
    }

    public void setParameters(Hashtable parameters) {
        if (parameters == null) {
            return;
        }
        if (parameters.get("chart") != null) {
            this.setParameter("chart", (String)parameters.get("chart"));
        }
        if (parameters.get("overlay") != null) {
            this.setParameter("overlay", (String)parameters.get("overlay"));
        }
        if (parameters.get("overlay_seriescount") != null) {
            this.setParameter("overlay_seriesCount", (String)parameters.get("overlay_seriescount"));
        }
        if (parameters.get("overlay0") != null) {
            this.setParameter("overlay0", (String)parameters.get("overlay0"));
        }
        if (parameters.get("overlay0_seriescount") != null) {
            this.setParameter("overlay0_seriesCount", (String)parameters.get("overlay0_seriescount"));
        }
        int count = 1;
        while (parameters.get("overlay" + count) != null) {
            this.setParameter("overlay" + count, (String)parameters.get("overlay" + count));
            if (parameters.get("overlay" + count + "_seriescount") != null) {
                this.setParameter("overlay" + count + "_seriescount", (String)parameters.get("overlay" + count + "_seriescount"));
            }
            ++count;
        }
        int seriesCount = 1;
        if (parameters.containsKey("seriescount")) {
            this.setParameter("seriesCount", (String)parameters.get("seriescount"));
            seriesCount = this.theChart.getSeriesCount();
        }
        if (parameters.containsKey("chartbackground")) {
            this.setParameter("chartBackground", (String)parameters.get("chartbackground"));
        }
        if (parameters.get("valuedelimiter") != null) {
            this.setParameter("valueDelimiter", (String)parameters.get("valuedelimiter"));
            parameters.remove("valuedelimiter");
        }
        int sampleCount = 1;
        if (parameters.get("samplecount") != null) {
            try {
                String value = (String)parameters.get("samplecount");
                sampleCount = Integer.parseInt(value);
            }
            catch (Exception e) {
                System.out.println("Invalid sampleCount " + parameters.get("samplecount"));
            }
        } else if (seriesCount == 1 && parameters.get("samplevalues") != null) {
            Double[] values = ChartDataLoader.getDoubleValues((String)parameters.get("samplevalues"), this.valueDelimiter);
            sampleCount = Math.max(values != null ? values.length : 0, sampleCount);
        } else {
            for (int i = 0; i < seriesCount; ++i) {
                if (parameters.get("samplevalues_" + i) == null) continue;
                Double[] values = ChartDataLoader.getDoubleValues((String)parameters.get("samplevalues_" + i), this.valueDelimiter);
                sampleCount = Math.max(values != null ? values.length : 0, sampleCount);
            }
        }
        this.theChart.setSampleCount(sampleCount);
        String sampleCount_value = (String)parameters.get("samplecount");
        String seriesCount_value = (String)parameters.get("seriescount");
        Hashtable range_parameters = new Hashtable();
        for (int i = 0; i < this.parameters_range_last.length; ++i) {
            for (int j = 0; j < 25; ++j) {
                String param = this.parameters_range_last[i];
                if (j > 0) {
                    param = this.parameters_range_last[i] + "_" + j;
                }
                if (!parameters.containsKey(param)) continue;
                range_parameters.put(param, parameters.remove(param));
            }
        }
        if (parameters.get("labeldelimiter") != null) {
            this.setParameter("labelDelimiter", (String)parameters.get("labeldelimiter"));
            parameters.remove("labeldelimiter");
        }
        Enumeration keys = parameters.keys();
        while (keys.hasMoreElements()) {
            String param = (String)keys.nextElement();
            String value = (String)parameters.get(param);
            this.setParameter(param, value);
        }
        for (int i = 0; i < this.parameters_range_last.length; ++i) {
            for (int j = 0; j < 25; ++j) {
                String param = this.parameters_range_last[i];
                if (j > 0) {
                    param = param + "_" + j;
                }
                String value = (String)range_parameters.get(param);
                if (!this.theChart.isRangeOn(j - 1) || j == 1 && value == null) continue;
                this.setParameter(param, value);
                if (value == null) continue;
                parameters.put(param, value);
            }
        }
        if (sampleCount_value != null) {
            parameters.put("samplecount", sampleCount_value);
        }
        if (seriesCount_value != null) {
            parameters.put("seriescount", seriesCount_value);
        }
    }

    public void setParameter(String name, String value) {
        block802: {
            if (name == null) {
                return;
            }
            name = name.toLowerCase();
            if (this.theChart == null) {
                throw new IllegalStateException("theChart has not been set");
            }
            if (name.equals("overlayinsets")) {
                if (value != null && value.trim().length() > 0) {
                    Double[] values = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                    if (values != null) {
                        double top = 0.0;
                        double left = 0.0;
                        double bottom = 0.0;
                        double right = 0.0;
                        try {
                            if (values.length > 0) {
                                top = values[0];
                            }
                            if (values.length > 1) {
                                left = values[1];
                            }
                            if (values.length > 2) {
                                bottom = values[2];
                            }
                            if (values.length > 3) {
                                right = values[3];
                            }
                            this.theChart.setOverlayInsets(top, left, bottom, right);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid overlayInsets: " + value);
                        }
                    }
                } else {
                    this.theChart.setOverlayInsets(0.0, 0.0, 0.0, 0.0);
                }
            } else if (name.startsWith("overlay")) {
                int index = name.indexOf("_");
                if (index > -1) {
                    String overlay_name = name.substring(0, index).toLowerCase();
                    ChartDataLoader overlay = (ChartDataLoader)this.overlayDataLoaders.get(overlay_name);
                    if (overlay != null) {
                        String param = name.substring(index + 1);
                        overlay.setParameter(param, value);
                    }
                } else if (!this.overlayDataLoaders.containsKey(name)) {
                    if (value != null) {
                        ChartDataLoader overlayLoader = null;
                        GenericChart overlayChart = null;
                        if ((value = value.toLowerCase()) != null) {
                            if (value.equals("bar") || value.equals("line") || value.equals("pie") || value.equals("time_line") || value.equals("spline") || value.equals("plotter")) {
                                LineChart overlayLineChart = new LineChart();
                                BarChart overlayBarChart = new BarChart();
                                PieChart overlayPieChart = new PieChart();
                                if (value.equals("spline") || value.equals("time_line")) {
                                    overlayLoader = ChartApplet.createDataLoaderExt();
                                    if (overlayLoader == null) {
                                        overlayLoader = new ChartDataLoader();
                                    }
                                    overlayLoader.setChartType(value);
                                    overlayChart = (GenericChart)overlayLoader.setChart(null);
                                    overlayLineChart = (LineChart)overlayChart;
                                } else if (value.equals("plotter")) {
                                    overlayLoader = ChartApplet.createDataLoaderExt();
                                    if (overlayLoader == null) {
                                        overlayLoader = new ChartDataLoader();
                                    }
                                    overlayLoader.setChartType(value);
                                    overlayChart = (GenericChart)overlayLoader.setChart(null);
                                } else if (value.equals("line")) {
                                    overlayChart = overlayLineChart;
                                } else if (value.equals("bar")) {
                                    overlayChart = overlayBarChart;
                                } else if (value.equals("pie")) {
                                    overlayChart = overlayPieChart;
                                }
                                if (value.equals("bar") || value.equals("line") || value.equals("pie")) {
                                    overlayLoader = new ChartDataLoader();
                                    overlayLoader.setChartType(value);
                                    overlayLoader.setChart(overlayChart);
                                }
                                overlayLoader.lineChart = overlayLineChart;
                                overlayLoader.barChart = overlayBarChart;
                                overlayLoader.pieChart = overlayPieChart;
                            } else {
                                System.out.println("Invalid overlay: " + name + " " + value);
                            }
                        }
                        if (overlayLoader != null) {
                            this.overlayDataLoaders.put(name, overlayLoader);
                            this.theChart.addOverlayChart(overlayChart);
                        }
                    } else {
                        this.overlayDataLoaders.remove(name);
                    }
                }
            } else if (name.equals("width")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        int width = Integer.parseInt(value.trim());
                        this.theChart.setSize(width, this.theChart.getSize().height);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid width: " + value);
                    }
                }
            } else if (name.equals("height")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        int height = Integer.parseInt(value.trim());
                        this.theChart.setSize(this.theChart.getSize().width, height);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid height: " + value);
                    }
                }
            } else if (name.startsWith("samplevalues")) {
                try {
                    int serie = 0;
                    if (name.startsWith("samplevalues_")) {
                        serie = Integer.parseInt(name.substring(13));
                    }
                    if (value != null && value.trim().length() > 0) {
                        Double[] values = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                        if (values != null && serie >= 0 && serie < this.theChart.getSeriesCount()) {
                            int sampleCount = this.theChart.getSampleCount();
                            if (!this.sampleCountSet && values.length > sampleCount) {
                                this.theChart.setSampleCount(values.length);
                                sampleCount = values.length;
                            }
                            for (int i = 0; i < sampleCount; ++i) {
                                if (i < values.length && values[i] != null) {
                                    this.theChart.setSampleValue(serie, i, values[i]);
                                    continue;
                                }
                                ChartSample sample = this.theChart.getSample(serie, i);
                                if (sample == null) continue;
                                sample.clearValue();
                            }
                        }
                    } else if (serie >= 0 && serie < this.theChart.getSeriesCount()) {
                        this.theChart.setSampleValues(serie, null);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid " + name + " " + value);
                }
            } else if (name.equals("samplecount")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        this.theChart.setSampleCount(Math.max(0, Integer.parseInt(value.trim())));
                        this.sampleCountSet = true;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid sampleCount: " + value);
                    }
                }
            } else if (name.equals("samplecolors")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                int sample = 0;
                while (st.hasMoreTokens()) {
                    Color c;
                    String entry = st.nextToken();
                    StringTokenizer entry_st = new StringTokenizer(entry, "|");
                    if (entry_st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor(((String)entry_st.nextElement()).trim());
                        if (c != null) {
                            this.theChart.setSampleColor(sample, c);
                        } else {
                            this.theChart.setSampleColor(sample, null);
                        }
                    }
                    if (entry_st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor(((String)entry_st.nextElement()).trim());
                        if (c != null) {
                            this.theChart.setSampleColor2(sample, c);
                        } else {
                            this.theChart.setSampleColor2(sample, null);
                        }
                    }
                    ++sample;
                }
            } else if (name.equals("legendcolors")) {
                if (value != null && value.trim().length() > 0) {
                    Color[] colors = this.getColorValues(value);
                    this.theChart.setLegendColors(colors);
                } else {
                    this.theChart.setLegendColors(null);
                }
            } else if (name.equals("seriescount")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        this.theChart.setSeriesCount(Math.max(1, Integer.parseInt(value.trim())));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid seriesCount: " + value);
                    }
                } else {
                    this.theChart.setSeriesCount(1);
                }
            } else if (name.startsWith("seriesrange_")) {
                try {
                    int serie = Integer.parseInt(name.substring(12));
                    if (serie < 0 || serie >= this.theChart.getSeriesCount()) break block802;
                    if (value != null && value.length() > 0) {
                        try {
                            int range = Math.max(Integer.parseInt(value.trim()) - 1, 0);
                            this.theChart.setSeriesRange(serie, range);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid range index: " + name + " " + value);
                        }
                        break block802;
                    }
                    this.theChart.setSeriesRange(serie, 0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid series index: " + name + " " + value);
                }
            } else if (name.startsWith("rangestep")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangestep")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.rangeStep[index] = new Double(value.trim());
                        this.rangeStep[index] = Math.abs(this.rangeStep[index]);
                        this.theChart.setRelativeRange(index, 1.0, this.rangeStep[index]);
                        this.theChart.setLowerRelativeRange(index, 1.0, this.rangeStep[index]);
                        break block802;
                    }
                    this.rangeStep[index] = -1.0;
                    this.theChart.setRelativeRangeIndex(index, 1.0);
                    this.theChart.setLowerRelativeRangeIndex(index, 1.0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid rangeStep: " + value);
                    this.rangeStep[index] = -1.0;
                    this.theChart.setLowerRelativeRange(1.0);
                }
            } else if (name.equals("range") || name.startsWith("range_")) {
                int index = 0;
                if (!name.equalsIgnoreCase("range")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.theChart.setRange(index, new Double(value.trim()));
                        break block802;
                    }
                    if (this.rangeStep[index] > -1.0) {
                        this.theChart.setRelativeRange(index, 1.0, this.rangeStep[index]);
                        break block802;
                    }
                    this.theChart.setRelativeRangeIndex(index, 1.0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid range: " + value);
                    if (this.rangeStep[index] != -1.0) {
                        this.theChart.setRelativeRange(index, 1.0, this.rangeStep[index]);
                        break block802;
                    }
                    this.theChart.setRelativeRangeIndex(index, 1.0);
                }
            } else if (name.startsWith("lowerrange")) {
                int index = 0;
                if (!name.equalsIgnoreCase("lowerrange")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.theChart.setLowerRange(index, new Double(value.trim()));
                        break block802;
                    }
                    if (this.rangeStep[index] != -1.0) {
                        this.theChart.setLowerRelativeRange(index, 1.0, this.rangeStep[index]);
                        break block802;
                    }
                    this.theChart.setLowerRelativeRangeIndex(index, 1.0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid lowerRange: " + value);
                    if (this.rangeStep[index] > -1.0) {
                        this.theChart.setLowerRelativeRange(index, 1.0, this.rangeStep[index]);
                        break block802;
                    }
                    this.theChart.setLowerRelativeRangeIndex(index, 1.0);
                }
            } else if (name.equals("currentrange") || name.startsWith("currentrange_")) {
                int index = 0;
                if (!name.equalsIgnoreCase("currentrange")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.theChart.setCurrentRange(index, new Double(value.trim()));
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid range index: " + value);
                }
            } else if (name.equals("currentlowerrange") || name.startsWith("currentlowerrange_")) {
                int index = 0;
                if (!name.equalsIgnoreCase("currentlowerrange")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.theChart.setCurrentLowerRange(index, new Double(value.trim()));
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid range index: " + value);
                }
            } else if (name.startsWith("rangeinterval")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangeinterval")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.trim().length() > 0) {
                    try {
                        this.theChart.setRangeInterval(index, new Double(value.trim()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid rangeInterval: " + value);
                    }
                }
            } else if (name.startsWith("rangeon")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangeon")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setRangeOn(index, value.trim().equalsIgnoreCase("true"));
                }
            } else if (name.startsWith("rangecolor")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangecolor")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setRangeColor(index, ChartDataLoader.createColor(value));
                }
            } else if (name.startsWith("rangeposition")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangeposition")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.trim().length() > 0) {
                    if ((value = value.trim().toLowerCase()).equals("right") || value.equals("top")) {
                        this.theChart.setRangePosition(index, 1);
                    } else {
                        this.theChart.setRangePosition(index, 0);
                    }
                }
            } else if (name.startsWith("rangeadjusteron")) {
                if (value != null) {
                    int index = 0;
                    if (!name.equalsIgnoreCase("rangeadjusteron")) {
                        try {
                            index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid range index: " + name);
                        }
                    }
                    this.theChart.setRangeAdjusterOn(index, value != null && value.trim().equalsIgnoreCase("true"));
                }
            } else if (name.equals("rangeadjusterposition")) {
                if (value != null && value.length() > 0) {
                    if ((value = value.trim().toLowerCase()).equals("right") || value.equals("top")) {
                        this.theChart.setRangeAdjusterPosition(1);
                    } else {
                        this.theChart.setRangeAdjusterPosition(0);
                    }
                }
            } else if (name.equalsIgnoreCase("rangeAdjusterPosition_2")) {
                System.out.println("rangeAdjusterPosition_2 is deprecated");
            } else if (name.equals("rangeadjusted") || name.startsWith("rangeadjusted_")) {
                int index = 0;
                if (!name.equals("rangeadjusted")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.length() > 0) {
                    try {
                        this.theChart.setRangeAdjusted(index, Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        this.theChart.setRangeAdjusted(index, -1);
                    }
                }
            } else if (name.startsWith("rangedecimalcount")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangedecimalcount")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value.equalsIgnoreCase("auto")) {
                    this.theChart.setRangeDecimalCount(index, -1);
                } else {
                    try {
                        if (value != null && value.trim().length() > 0) {
                            this.theChart.setRangeDecimalCount(index, Integer.parseInt(value.trim()));
                            break block802;
                        }
                        this.theChart.setRangeDecimalCount(index, 0);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + ": " + value);
                        this.theChart.setRangeDecimalCount(index, 0);
                    }
                }
            } else if (name.equals("labeldelimiter")) {
                this.labelDelimiter = value != null && value.trim().length() > 0 || value.equals("\t") ? value : ",";
            } else if (name.equals("valuedelimiter")) {
                this.valueDelimiter = value != null && value.trim().length() > 0 || value.equals("\t") ? value : ",";
            } else if (name.equals("serieslabels")) {
                this.theChart.setSeriesLabels(this.getStringValues(ChartDataLoader.convertLineBreaks(value), this.labelDelimiter));
            } else if (name.equals("serieslabelcolors")) {
                Color[] colors = this.getColorValues(value);
                int seriesCount = this.theChart.getSeriesCount();
                for (int i = 0; i < seriesCount; ++i) {
                    if (colors != null && i < colors.length) {
                        this.theChart.setSeriesLabelColor(i, colors[i]);
                        continue;
                    }
                    this.theChart.setSeriesLabelColor(i, null);
                }
            } else if (name.equals("serieslabelson")) {
                this.theChart.setSeriesLabelsOn(value != null && value.equalsIgnoreCase("true"));
            } else if (name.equals("serieslabelstyle")) {
                this.theChart.setSeriesLabelStyle(3);
                if (!this.chartType.equals("pie")) {
                    this.theChart.setSeriesLabelStyle(1);
                }
                if (value != null && value.trim().length() > 0) {
                    if (value.trim().equalsIgnoreCase("inside")) {
                        this.theChart.setSeriesLabelStyle(0);
                    } else if (value.trim().equalsIgnoreCase("floating")) {
                        this.theChart.setSeriesLabelStyle(3);
                    } else if (value.trim().equalsIgnoreCase("outside")) {
                        this.theChart.setSeriesLabelStyle(1);
                    } else if (value.trim().equalsIgnoreCase("pointing")) {
                        this.theChart.setSeriesLabelStyle(5);
                    }
                }
            } else if (name.startsWith("serieslabelfont")) {
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setFont(name, this.createFont(value, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(name, new Font("Arial", 0, 11));
                }
            } else if (name.equals("samplelabels")) {
                this.theChart.setSampleLabels(this.getStringValues(ChartDataLoader.convertLineBreaks(value), this.labelDelimiter));
            } else if (name.equals("samplelabelson")) {
                this.theChart.setSampleLabelsOn(value != null && value.equalsIgnoreCase("true"));
            } else if (name.equals("samplelabelcolors")) {
                Color[] colors = this.getColorValues(value);
                int count = Math.max(colors != null ? colors.length : 0, this.theChart.getSampleCount());
                for (int i = 0; i < count; ++i) {
                    if (colors != null && i < colors.length) {
                        this.theChart.setSampleLabelColor(i, colors[i]);
                        continue;
                    }
                    this.theChart.setSampleLabelColor(i, null);
                }
            } else if (name.equals("samplelabelstyle")) {
                this.theChart.setSampleLabelStyle(2);
                if (this.chartType.equals("pie")) {
                    this.theChart.setSampleLabelStyle(0);
                }
                if (value != null && value.trim().equalsIgnoreCase("outside")) {
                    this.theChart.setSampleLabelStyle(1);
                } else if (value != null && value.trim().equalsIgnoreCase("pointing")) {
                    this.theChart.setSampleLabelStyle(5);
                } else if (value != null && value.trim().equalsIgnoreCase("inside")) {
                    this.theChart.setSampleLabelStyle(0);
                } else if (value != null && value.trim().equalsIgnoreCase("floating")) {
                    this.theChart.setSampleLabelStyle(3);
                } else if (value != null && value.trim().equalsIgnoreCase("below_and_floating")) {
                    this.theChart.setSampleLabelStyle(4);
                }
            } else if (name.equals("samplelabelselectioncolor")) {
                Color color;
                this.theChart.setSampleLabelSelectionColor(null);
                if (value != null && value.trim().length() > 0 && (color = ChartDataLoader.createColor(value)) != null) {
                    this.theChart.setSampleLabelSelectionColor(color);
                }
            } else if (name.equals("legendlabels")) {
                this.theChart.setLegendLabels(null);
                if (value != null && value.trim().length() > 0) {
                    String[] labels = this.getStringValues(ChartDataLoader.convertLineBreaks(value), this.labelDelimiter);
                    if (labels.length > 1) {
                        this.theChart.setLegendLabels(labels);
                    } else if (labels.length == 1 && labels[0] != null) {
                        if (labels[0].trim().equalsIgnoreCase("samplelabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSampleLabels());
                        } else if (labels[0].trim().equalsIgnoreCase("serieslabels")) {
                            this.theChart.setLegendLabels(this.theChart.getSeriesLabels());
                        } else {
                            this.theChart.setLegendLabels(labels);
                        }
                    }
                }
            } else if (name.startsWith("valuelabelson")) {
                if (name.equals("valuelabelson")) {
                    this.theChart.setValueLabelsOn(-1, value != null && value.trim().equalsIgnoreCase("true"));
                } else if (name.startsWith("valuelabelson_")) {
                    try {
                        int serie = Integer.parseInt(name.substring(14));
                        if (serie >= 0 && serie < this.theChart.getSeriesCount()) {
                            this.theChart.setValueLabelsOn(serie, value != null && value.trim().equalsIgnoreCase("true"));
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + " " + value);
                    }
                }
            } else if (name.startsWith("rangeaxislabelangle") || name.equals("sampleaxislabelangle") || name.equals("valuelabelangle") || name.equals("samplelabelangle") || name.equals("barlabelangle")) {
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.theChart.setLabelAngle(name, Integer.parseInt(value));
                        break block802;
                    }
                    this.theChart.setLabelAngle(name, 0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid " + name + ": " + value);
                }
            } else if (name.equals("valuelabelcolors")) {
                Color[] colors = this.getColorValues(value);
                int seriesCount = this.theChart.getSeriesCount();
                for (int i = 0; i < seriesCount; ++i) {
                    if (colors != null && i < colors.length) {
                        this.theChart.setValueLabelColor(i, colors[i]);
                        continue;
                    }
                    this.theChart.setValueLabelColor(i, null);
                }
            } else if (name.equals("valuelabelstyle")) {
                this.theChart.setValueLabelStyle(0);
                if (value != null && value.trim().equalsIgnoreCase("outside")) {
                    this.theChart.setValueLabelStyle(1);
                } else if (value != null && value.trim().equalsIgnoreCase("pointing")) {
                    this.theChart.setValueLabelStyle(5);
                } else if (value != null && value.trim().equalsIgnoreCase("floating")) {
                    this.theChart.setValueLabelStyle(3);
                }
            } else if (name.startsWith("valuelabelprefix") || name.startsWith("valuelabelpostfix")) {
                this.theChart.setLabel(name, ChartDataLoader.convertLineBreaks(value));
            } else if (name.startsWith("sampledecimalcount")) {
                try {
                    int serie;
                    if (name.equals("sampledecimalcount")) {
                        if (value != null && value.trim().length() > 0) {
                            if (value.equalsIgnoreCase("auto")) {
                                this.theChart.setSampleDecimalCount(-1, -1);
                            } else {
                                this.theChart.setSampleDecimalCount(-1, Integer.parseInt(value.trim()));
                            }
                        } else {
                            this.theChart.setSampleDecimalCount(-1, 0);
                        }
                        break block802;
                    }
                    if (!name.startsWith("sampledecimalcount_") || (serie = Integer.parseInt(name.substring(19))) < 0 || serie >= this.theChart.getSeriesCount()) break block802;
                    if (value != null && value.trim().length() > 0) {
                        if (value.equalsIgnoreCase("auto")) {
                            this.theChart.setSampleDecimalCount(serie, -1);
                        } else {
                            this.theChart.setSampleDecimalCount(serie, Integer.parseInt(value.trim()));
                        }
                        break block802;
                    }
                    this.theChart.setSampleDecimalCount(serie, 0);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid " + name + " " + value);
                }
            } else if (name.equalsIgnoreCase("thousandsDelimiter") || name.equalsIgnoreCase("thousandsDelimeter")) {
                this.theChart.setThousandsDelimiter(value);
                if (name.equalsIgnoreCase("thousandsDelimeter")) {
                    System.out.println("thousandsDelimeter is deprecated, use thousandsDelimiter instead");
                }
            } else if (name.equalsIgnoreCase("locale")) {
                if (value != null && value.length() > 0) {
                    String lang;
                    StringTokenizer st = new StringTokenizer(value, ", ");
                    String country = lang = st.nextToken();
                    if (st.hasMoreElements()) {
                        country = st.nextToken();
                    }
                    if (this.theChart != null) {
                        if (country.equalsIgnoreCase("eu")) {
                            this.theChart.setLocale(new Locale(lang.toUpperCase(), lang.toUpperCase(), "EURO"));
                        } else {
                            this.theChart.setLocale(new Locale(lang.toUpperCase(), country.toUpperCase()));
                        }
                    }
                } else if (this.theChart != null) {
                    this.theChart.setLocale(null);
                }
            } else if (name.equals("charttitle") || name.equals("title")) {
                this.theChart.setTitle(ChartDataLoader.convertLineBreaks(value));
                this.theChart.setTitleOn(value != null && value.length() > 0);
            } else if (name.equals("legendon")) {
                this.theChart.setLegendOn(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("legendposition")) {
                this.theChart.setLegendPosition(1);
                if (value != null && value.trim().length() > 0) {
                    if ((value = value.toLowerCase()).equals("right")) {
                        this.theChart.setLegendPosition(1);
                    } else if (value.equals("top")) {
                        this.theChart.setLegendPosition(2);
                    } else if (value.equals("bottom")) {
                        this.theChart.setLegendPosition(3);
                    } else if (value.equals("left")) {
                        this.theChart.setLegendPosition(0);
                    } else {
                        System.out.println("Invalid legendPosition: " + value);
                    }
                }
            } else if (name.equals("legendcolumns")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        int columns = Integer.parseInt(value.trim());
                        this.theChart.setLegendColumns(columns);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid legendColumns: " + value);
                    }
                }
            } else if (name.equals("legendreverseon")) {
                this.theChart.setLegendReverseOn(value != null && value.equalsIgnoreCase("true"));
            } else if (name.equals("legendboxsizeasfont")) {
                this.theChart.setLegendBoxSizeAsFont(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("3dmodeon")) {
                this.theChart.set3DModeOn(value != null && value.equalsIgnoreCase("true"));
            } else if (name.equals("3ddepth")) {
                this.theChart.set3DDepth(-1);
                if (value != null && value.trim().length() > 0) {
                    try {
                        int depth = Integer.parseInt(value.trim());
                        this.theChart.set3DDepth(depth);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid 3DDepth: " + value);
                    }
                }
            } else if (name.equals("gridoutline3don")) {
                this.theChart.setGridOutline3DOn(value != null && value.equalsIgnoreCase("true"));
            } else if (name.equals("foreground")) {
                if (value != null && value.trim().length() > 0) {
                    Color c = ChartDataLoader.createColor(value);
                    if (c != null) {
                        this.theChart.setForeground(c);
                    } else {
                        this.theChart.setForeground(Color.black);
                    }
                } else {
                    this.theChart.setForeground(Color.black);
                }
            } else if (name.equals("background")) {
                if (value != null && value.trim().length() > 0) {
                    Color c;
                    StringTokenizer st = new StringTokenizer(value.trim(), "|");
                    if (st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor((String)st.nextElement());
                        if (c != null) {
                            this.theChart.setBackground(c);
                        } else {
                            this.theChart.setBackground(new Color(231, 221, 231));
                        }
                    }
                    if (st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor((String)st.nextElement());
                        if (c != null) {
                            this.theChart.setBackground2(c);
                        } else {
                            this.theChart.setBackground2(null);
                        }
                    }
                } else {
                    this.theChart.setBackground(new Color(231, 221, 231));
                    this.theChart.setBackground2(null);
                }
            } else if (name.equals("chartforeground")) {
                if (value != null && value.trim().length() > 0) {
                    Color c = ChartDataLoader.createColor(value);
                    if (c != null) {
                        this.theChart.setChartForeground(c);
                    } else {
                        this.theChart.setChartForeground(Color.black);
                    }
                } else {
                    this.theChart.setChartForeground(Color.black);
                }
            } else if (name.equals("chartbackground")) {
                if (value != null && value.trim().length() > 0) {
                    Color c;
                    StringTokenizer st = new StringTokenizer(value.trim(), "|");
                    if (st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor((String)st.nextElement());
                        if (c != null) {
                            this.theChart.setChartBackground(c);
                        } else {
                            this.theChart.setChartBackground(Color.white);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        c = ChartDataLoader.createColor((String)st.nextElement());
                        if (c != null) {
                            this.theChart.setChartBackground2(c);
                        } else {
                            this.theChart.setChartBackground2(null);
                        }
                    }
                } else {
                    this.theChart.setChartBackground(Color.white);
                    this.theChart.setChartBackground2(null);
                }
            } else if (name.equals("alternatechartbackground")) {
                StringTokenizer st = new StringTokenizer(value.trim(), "|");
                if (st.hasMoreTokens()) {
                    String colorValue = (String)st.nextElement();
                    if (colorValue.trim().equals("brighter")) {
                        this.theChart.setAlternateChartBackground(Renderer.getBrighter(this.theChart.getChartBackground()));
                    } else if (colorValue.trim().equals("darker")) {
                        this.theChart.setAlternateChartBackground(Renderer.getDarker(this.theChart.getChartBackground()));
                    } else {
                        this.theChart.setAlternateChartBackground(ChartDataLoader.createColor(value.trim()));
                    }
                }
            } else if (name.equals("titlefont")) {
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setFont("titleFont", this.createFont(value, "Dialog", 1, 14));
                } else {
                    this.theChart.setFont("titleFont", new Font("Dialog", 1, 14));
                }
            } else if (name.equals("font")) {
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setFont(this.createFont(value, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(new Font("Arial", 0, 11));
                }
            } else if (name.endsWith("font")) {
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setFont(name, this.createFont(value, "Arial", 0, 11));
                } else {
                    this.theChart.setFont(name, null);
                }
            } else if (name.equals("graphinsets")) {
                if (value != null && value.trim().length() > 0) {
                    StringTokenizer st = new StringTokenizer(value.trim(), ",");
                    int top = -1;
                    int left = -1;
                    int bottom = -1;
                    int right = -1;
                    try {
                        if (st.hasMoreTokens()) {
                            top = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                        if (st.hasMoreTokens()) {
                            left = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                        if (st.hasMoreTokens()) {
                            bottom = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                        if (st.hasMoreTokens()) {
                            right = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                        this.theChart.setGraphInsets(top, left, bottom, right);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid graphinsets: " + value);
                    }
                } else {
                    this.theChart.setGraphInsets(-1, -1, -1, -1);
                }
            } else if (name.equals("gridadjustmenton")) {
                this.theChart.setGridAdjustmentOn(2, false);
                this.theChart.setGridAdjustmentOn(1, false);
                this.theChart.setGridAdjustmentOn(3, false);
                this.theChart.setGridAdjustmentOn(0, false);
                if (value != null && value.trim().length() > 0) {
                    if (value.trim().equalsIgnoreCase("true")) {
                        this.theChart.setGridAdjustmentOn(2, true);
                        this.theChart.setGridAdjustmentOn(1, true);
                        this.theChart.setGridAdjustmentOn(3, true);
                        this.theChart.setGridAdjustmentOn(0, true);
                    } else {
                        StringTokenizer st = new StringTokenizer(value, ",");
                        while (st.hasMoreTokens()) {
                            String edge = st.nextToken().trim();
                            if (edge.equalsIgnoreCase("top")) {
                                this.theChart.setGridAdjustmentOn(2, true);
                                continue;
                            }
                            if (edge.equalsIgnoreCase("right")) {
                                this.theChart.setGridAdjustmentOn(1, true);
                                continue;
                            }
                            if (edge.equalsIgnoreCase("bottom")) {
                                this.theChart.setGridAdjustmentOn(3, true);
                                continue;
                            }
                            if (!edge.equalsIgnoreCase("left")) continue;
                            this.theChart.setGridAdjustmentOn(0, true);
                        }
                    }
                }
            } else if (name.equals("valuelineson")) {
                this.theChart.setValueLinesOn(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("maxvaluelinecount")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        this.theChart.setMaxValueLineCount(Integer.parseInt(value.trim()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid maxValueLineCount: " + value);
                        this.theChart.setMaxValueLineCount(-1);
                    }
                } else {
                    this.theChart.setMaxValueLineCount(-1);
                }
            } else if (name.equals("defaultgridlineson")) {
                if (value != null) {
                    String[] str = this.getStringValues(value, ",");
                    if (str.length < 3) {
                        this.theChart.setDefaultGridLinesOn(str[0].trim().equalsIgnoreCase("true"));
                    } else if (str.length >= 3) {
                        double start = Double.valueOf(str[1]);
                        double step = Double.valueOf(str[2]);
                        this.theChart.setDefaultGridLinesOn(str[0].trim().equalsIgnoreCase("true"), start, step);
                    }
                }
            } else if (name.equals("defaultgridlinescolor")) {
                Color[] colors;
                this.theChart.setDefaultGridLinesColor(null);
                if (value != null && value.trim().length() > 0 && (colors = this.getColorValues(value)) != null && colors.length > 0 && colors[0] != null) {
                    this.theChart.setDefaultGridLinesColor(colors[0]);
                }
            } else if (name.equals("gridlines")) {
                Double[] lines;
                this.theChart.setGridLines(null);
                if (value != null && (lines = ChartDataLoader.getDoubleValues(value, this.valueDelimiter)) != null) {
                    double[] dLines = new double[lines.length];
                    for (int i = 0; i < lines.length; ++i) {
                        if (lines[i] == null) continue;
                        dLines[i] = lines[i];
                    }
                    this.theChart.setGridLines(dLines);
                }
            } else if (name.equals("gridlinescolor")) {
                Color[] colors;
                this.theChart.setGridLinesColor(null);
                if (value != null && value.trim().length() > 0 && (colors = this.getColorValues(value)) != null && colors.length > 0 && colors[0] != null) {
                    this.theChart.setGridLinesColor(colors[0]);
                }
            } else if (name.equals("gridlinecolors")) {
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setGridLineColors(this.getColorValues(value));
                } else {
                    this.theChart.setGridLineColors(null);
                }
            } else if (name.equals("valuelinescolor")) {
                if (value != null && value.trim().length() > 0) {
                    Color c = ChartDataLoader.createColor(value);
                    if (c != null) {
                        this.theChart.setValueLinesColor(c);
                    } else {
                        this.theChart.setValueLinesColor(Color.lightGray);
                    }
                } else {
                    this.theChart.setValueLinesColor(Color.lightGray);
                }
            } else if (name.startsWith("rangelabelsoff")) {
                int index = 0;
                if (!name.equalsIgnoreCase("rangelabelsoff")) {
                    try {
                        index = Integer.parseInt(name.substring(name.indexOf("_") + 1)) - 1;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid range index: " + name);
                    }
                }
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setRangeLabelsOn(index, !value.trim().equalsIgnoreCase("true"));
                }
            } else if (name.equals("sampleaxislabel") || name.equals("rangeaxislabel") || name.startsWith("rangeaxislabel_")) {
                this.theChart.setLabel(name, ChartDataLoader.convertLineBreaks(value));
            } else if (name.startsWith("rangelabelprefix") || name.startsWith("rangelabelpostfix")) {
                this.theChart.setLabel(name, ChartDataLoader.convertLineBreaks(value));
            } else if (name.equals("samplescrolleron")) {
                this.theChart.setSampleScrollerOn(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("zoomon")) {
                this.theChart.setZoomOn(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("sampleaxisrange")) {
                Double[] ranges;
                this.theChart.setSampleAxisRange(0.0, 100.0);
                if (value != null && value.trim().length() > 0 && (ranges = ChartDataLoader.getDoubleValues(value, this.valueDelimiter)).length >= 2) {
                    this.theChart.setSampleAxisRange(ranges[0] != null ? ranges[0] : 0.0, ranges[1] != null ? ranges[1] : 100.0);
                }
            } else if (name.equals("visiblesamples")) {
                if (value != null && value.length() > 0) {
                    int start = 0;
                    int count = -1;
                    StringTokenizer st = new StringTokenizer(value, ",");
                    try {
                        if (st.hasMoreTokens()) {
                            start = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                        if (st.hasMoreTokens()) {
                            count = Integer.parseInt(((String)st.nextElement()).trim());
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid visibleSamples: " + value);
                    }
                    this.theChart.setVisibleSamples(start, count);
                } else {
                    this.theChart.setVisibleSamples(0, -1);
                }
            } else if (name.startsWith("printasbitmap")) {
                this.theChart.setPrintAsBitmap(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (name.equals("floatingonlegendoff")) {
                this.theChart.setFloatingOnLegendOn(value == null || !value.trim().equalsIgnoreCase("true"));
            } else if (name.startsWith("targetvalueline")) {
                if (this.targets.containsKey(name)) {
                    String id = (String)this.targets.remove(name);
                    this.theChart.setTargetValueLine(id, 0.0, null, 0);
                }
                if (value != null && value.length() > 0) {
                    String s;
                    StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                    String label = null;
                    if (st.hasMoreElements()) {
                        label = ChartDataLoader.convertLineBreaks((String)st.nextElement());
                    }
                    double target = 0.0;
                    if (st.hasMoreElements()) {
                        try {
                            String s2 = (String)st.nextElement();
                            target = new Double(s2.trim());
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid targetValueLine value: " + value);
                        }
                    }
                    Color color = this.theChart.getValueLinesColor();
                    if (st.hasMoreElements() && (color = ChartDataLoader.createColor((s = (String)st.nextElement()).trim())) == null) {
                        color = this.theChart.getValueLinesColor();
                    }
                    int style = 3;
                    if (st.hasMoreElements()) {
                        String s3 = ((String)st.nextElement()).trim();
                        style = s3.equals("label") ? 1 : (s3.equals("value") ? 2 : 3);
                    }
                    int range = 0;
                    if (st.hasMoreElements()) {
                        try {
                            String s4 = (String)st.nextElement();
                            range = new Integer(s4.trim());
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid targetValueLine range: " + value);
                        }
                    }
                    if (label != null) {
                        this.targets.put(name, label);
                        this.theChart.setTargetValueLine(label, target, color, style, range);
                    }
                }
            } else if (name.equals("targetlabelsposition")) {
                if (value != null && value.trim().length() > 0) {
                    if ((value = value.toLowerCase()).equals("right") || value.equals("top")) {
                        this.theChart.setTargetLabelsPosition(1);
                    } else if (value.equals("left") || value.equals("bottom")) {
                        this.theChart.setTargetLabelsPosition(0);
                    } else {
                        this.theChart.setTargetLabelsPosition(-1);
                    }
                }
            } else if (name.startsWith("label_")) {
                if (this.labels.containsKey(name)) {
                    this.labels.remove(name);
                    this.theChart.setLabel(name, (String)null, 0, 0);
                }
                if (value != null && value.length() > 0) {
                    StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                    String label = null;
                    if (st.hasMoreElements()) {
                        label = ChartDataLoader.convertLineBreaks((String)st.nextElement());
                    }
                    int int_x = -1;
                    double double_x = -1.0;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            if (s.indexOf(46) == -1) {
                                int_x = new Integer(s.trim());
                            } else {
                                double_x = new Double(s.trim());
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    int int_y = -1;
                    double double_y = -1.0;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            if (s.indexOf(46) == -1) {
                                int_y = new Integer(s.trim());
                            } else {
                                double_y = new Double(s.trim());
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    int pointed_sample = -1;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            pointed_sample = new Integer(s.trim());
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    int pointed_serie = -1;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            pointed_serie = new Integer(s.trim());
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    if (label != null) {
                        this.labels.put(name, name);
                        if (pointed_sample > -1 && pointed_serie > -1) {
                            if (int_x != -1 && int_y != -1) {
                                this.theChart.setLabel(name, label, int_x, int_y, pointed_serie, pointed_sample);
                            } else if (double_x != -1.0 && double_y != -1.0) {
                                this.theChart.setLabel(name, label, double_x, double_y, pointed_serie, pointed_sample);
                            } else {
                                System.out.println("Invalid " + name + " value: " + value);
                            }
                        } else if (int_x != -1 && int_y != -1) {
                            this.theChart.setLabel(name, label, int_x, int_y);
                        } else if (double_x != -1.0 && double_y != -1.0) {
                            this.theChart.setLabel(name, label, double_x, double_y);
                        } else {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                }
            } else if (name.startsWith("labelposition_")) {
                if (value != null && value.length() > 0) {
                    String id = "label" + name.substring(name.indexOf("_"));
                    StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                    int int_x = -1;
                    double double_x = -1.0;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            if (s.indexOf(46) == -1) {
                                int_x = new Integer(s.trim());
                            } else {
                                double_x = new Double(s.trim());
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    int int_y = -1;
                    double double_y = -1.0;
                    if (st.hasMoreElements()) {
                        try {
                            String s = (String)st.nextElement();
                            if (s.indexOf(46) == -1) {
                                int_y = new Integer(s.trim());
                            } else {
                                double_y = new Double(s.trim());
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid " + name + " value: " + value);
                        }
                    }
                    if (int_x != -1 && int_y != -1) {
                        this.theChart.setLabelPosition(id, int_x, int_y);
                    } else if (double_x != -1.0 && double_y != -1.0) {
                        this.theChart.setLabelPosition(id, double_x, double_y);
                    } else {
                        System.out.println("Invalid " + name + " value: " + value);
                    }
                }
            } else if (name.startsWith("labelurl_")) {
                String id = "label" + name.substring(name.indexOf("_"));
                if (this.labelURLs.containsKey(id)) {
                    this.labelURLs.remove(id);
                    this.theChart.setLabelURL(id, null);
                }
                if (value != null && value.length() > 0) {
                    this.labelURLs.put(id, value);
                    this.theChart.setLabelURL(id, value);
                }
            } else if (name.startsWith("labelurltarget_")) {
                String id = "label" + name.substring(name.indexOf("_"));
                if (value != null && value.trim().length() > 0) {
                    this.labelURLTargets.put(id, value);
                } else if (name.equals("labelurltarget")) {
                    this.labelURLTargets.put("urltarget", "_self");
                } else {
                    this.labelURLTargets.remove(name);
                }
            } else if (name.startsWith("labelangle_")) {
                String id = "label" + name.substring(name.indexOf("_"));
                try {
                    int angle = Integer.parseInt(value.trim());
                    this.theChart.setLabelAngle(id, angle);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid custom label angle: " + value);
                }
            } else if (name.startsWith("labelfont_")) {
                String id = "label" + name.substring(name.indexOf("_"));
                if (value != null && value.trim().length() > 0) {
                    this.theChart.setFont(id, this.createFont(value, "Dialog", 0, 11));
                } else {
                    this.theChart.setFont(id, new Font("Dialog", 0, 11));
                }
            } else if (name.startsWith("labelcolor_")) {
                String id = "label" + name.substring(name.indexOf("_"));
                this.theChart.setLabelColor(id, ChartDataLoader.createColor(value));
            } else if (name.equalsIgnoreCase("complexLabelSeparator")) {
                this.theChart.setComplexLabelSeparator(ChartDataLoader.convertLineBreaks(value));
            } else if (name.equalsIgnoreCase("multilineLabelAlignment")) {
                if (value != null && value.trim().length() > 0) {
                    if ((value = value.toLowerCase()).equals("left")) {
                        this.theChart.setMultilineLabelAlignment(-1);
                    } else if (value.equals("center")) {
                        this.theChart.setMultilineLabelAlignment(0);
                    } else if (value.equals("right")) {
                        this.theChart.setMultilineLabelAlignment(1);
                    }
                }
            } else if (name.equalsIgnoreCase("displayVersion")) {
                if (this.theChart != null) {
                    this.theChart.displayVersionOn = value != null && value.trim().equalsIgnoreCase("true");
                }
            } else if (name.equalsIgnoreCase("antialias")) {
                this.theChart.setAntialiasingOn(value != null && value.trim().equalsIgnoreCase("true"));
            } else if (!(name.equals("data") || name.equals("datainterval") || name.startsWith("urltarget") || name.startsWith("url") || name.startsWith("exporturl") || name.startsWith("format") || name.equals("singleclickurlon") || name.equals("gridimage") || name.startsWith("legendimage_") || name.startsWith("samplehighlightimage"))) {
                if (this.chartType.equals("bar") && this.barChart != null) {
                    if (name.equals("barlabels")) {
                        if (value != null && value.length() > 0) {
                            String[] labels = this.getStringValues(ChartDataLoader.convertLineBreaks(value), this.labelDelimiter);
                            this.barChart.setBarLabels(labels);
                        } else {
                            this.barChart.setBarLabels(null);
                        }
                    } else if (name.equals("barlabelson")) {
                        this.barChart.setBarLabelsOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.equals("barlabelstyle")) {
                        System.out.println(name + " is deprecated, use sampleLabelStyle");
                        if (value != null && value.trim().equalsIgnoreCase("floating")) {
                            this.barChart.setSampleLabelStyle(3);
                        } else if (value != null && value.trim().equalsIgnoreCase("below_and_floating")) {
                            this.barChart.setSampleLabelStyle(4);
                        } else {
                            this.barChart.setSampleLabelStyle(2);
                        }
                    } else if (name.equals("barlabelcolors")) {
                        Color[] colors = this.getColorValues(value);
                        int sampleCount = this.barChart.getSampleCount();
                        for (int i = 0; i < sampleCount; ++i) {
                            if (colors != null && i < colors.length) {
                                this.barChart.setBarLabelColor(i, colors[i]);
                                continue;
                            }
                            this.barChart.setBarLabelColor(i, null);
                        }
                    } else if (name.equals("autolabelspacingon")) {
                        this.barChart.setAutoLabelSpacingOn(value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.equals("multicoloron")) {
                        this.barChart.setMultiColorOn(value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.equals("multiserieson")) {
                        this.barChart.setMultiSeriesOn(value != null && value.trim().equalsIgnoreCase("true"));
                    } else if (name.equals("baroutlineoff")) {
                        this.barChart.setBarOutlineOn(value == null || !value.trim().equalsIgnoreCase("true"));
                    } else if (name.startsWith("baroutlinecolor")) {
                        this.barChart.setBarOutlineColor(null);
                        if (value != null) {
                            this.barChart.setBarOutlineColor(ChartDataLoader.createColor(value));
                        }
                    } else if (name.equals("baralignment")) {
                        if (value != null && value.trim().equalsIgnoreCase("horizontal")) {
                            this.barChart.setBarAlignment(0);
                        } else {
                            this.barChart.setBarAlignment(1);
                        }
                    } else if (name.equals("bartype")) {
                        if (value != null) {
                            if (value.trim().equalsIgnoreCase("stacked")) {
                                this.barChart.setBarType(1);
                            } else if (value != null && value.trim().equalsIgnoreCase("behind")) {
                                this.barChart.setBarType(2);
                            } else {
                                this.barChart.setBarType(0);
                            }
                        }
                    } else if (name.equals("barshape")) {
                        if (value != null) {
                            if (value.trim().equalsIgnoreCase("cylinder")) {
                                this.barChart.setBarShape(1);
                            } else {
                                this.barChart.setBarShape(0);
                            }
                        }
                    } else if (name.equals("barwidth")) {
                        try {
                            if (value != null && value.trim().length() > 0) {
                                this.barChart.setBarWidth(new Double(value.trim()));
                                break block802;
                            }
                            this.barChart.setBarWidth(0.4);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid barWidth: " + value);
                            this.barChart.setBarWidth(0.4);
                        }
                    }
                } else if ((this.chartType.equals("line") || this.chartType.equals("time_line") || this.chartType.equals("spline")) && this.lineChart != null) {
                    if (name.equals("autolabelspacingon")) {
                        this.lineChart.setAutoLabelSpacingOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.startsWith("area")) {
                        if (value != null && value.length() > 0) {
                            int index = 0;
                            if (name.startsWith("area_")) {
                                index = Integer.parseInt(name.substring(5));
                            }
                            StringTokenizer st = new StringTokenizer(value, this.labelDelimiter);
                            int line1 = -1;
                            if (st.hasMoreElements()) {
                                try {
                                    String s = ChartDataLoader.convertLineBreaks((String)st.nextElement());
                                    line1 = new Integer(s.trim());
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Invalid area: " + value);
                                }
                            }
                            int line2 = -1;
                            if (st.hasMoreElements()) {
                                try {
                                    String s = ChartDataLoader.convertLineBreaks((String)st.nextElement());
                                    line2 = new Integer(s.trim());
                                }
                                catch (NumberFormatException e) {
                                    System.out.println("Invalid area: " + value);
                                }
                            }
                            Color color = null;
                            if (st.hasMoreElements()) {
                                String s = (String)st.nextElement();
                                color = ChartDataLoader.createColor(s.trim());
                            }
                            Color color2 = null;
                            if (st.hasMoreElements()) {
                                String s = (String)st.nextElement();
                                color2 = ChartDataLoader.createColor(s.trim());
                            }
                            this.lineChart.setArea(index, line1, line2);
                            if (color != null) {
                                this.lineChart.setAreaColor(index, color);
                            }
                            if (color2 != null) {
                                this.lineChart.setAreaColor2(index, color2);
                            } else {
                                this.lineChart.setAreaColor2(index, color);
                            }
                        }
                    } else if (name.equals("serieslineoff")) {
                        if (value != null && value.trim().equalsIgnoreCase("true")) {
                            this.lineChart.setSeriesLineOn(false);
                        } else if (value != null && value.trim().equalsIgnoreCase("false")) {
                            this.lineChart.setSeriesLineOn(true);
                        } else if (value != null && value.trim().length() > 0) {
                            this.lineChart.setSeriesLineOn(true);
                            Double[] series = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                            int seriesCount = this.lineChart.getSeriesCount();
                            for (int i = 0; i < series.length; ++i) {
                                if (series[i] == null || series[i].intValue() < 0 || series[i].intValue() >= seriesCount) continue;
                                this.lineChart.setSeriesLineOn(series[i].intValue(), false);
                            }
                        } else {
                            this.lineChart.setSeriesLineOn(true);
                        }
                    } else if (name.equals("connectedlineson")) {
                        this.lineChart.setConnectedLinesOn(-1, false);
                        if (value != null && value.trim().equalsIgnoreCase("true")) {
                            this.lineChart.setConnectedLinesOn(-1, true);
                        } else if (value != null && value.trim().equalsIgnoreCase("false")) {
                            this.lineChart.setConnectedLinesOn(-1, false);
                        } else if (value != null && value.trim().length() > 0) {
                            Double[] series = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                            int seriesCount = this.lineChart.getSeriesCount();
                            for (int i = 0; i < series.length; ++i) {
                                if (series[i] == null || series[i].intValue() < 0 || series[i].intValue() >= seriesCount) continue;
                                this.lineChart.setConnectedLinesOn(series[i].intValue(), true);
                            }
                        }
                    } else if (name.equals("linewidth")) {
                        if (value != null && value.trim().length() > 0) {
                            Double[] width = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                            if (width.length == 1 && this.lineChart.getSeriesCount() > 1 && width[0] != null) {
                                this.lineChart.setLineWidth(-1, width[0].intValue());
                            } else {
                                for (int i = 0; i < width.length; ++i) {
                                    if (width[i] == null) continue;
                                    this.lineChart.setLineWidth(i, width[i].intValue());
                                }
                            }
                        } else {
                            this.lineChart.setLineWidth(-1, 2);
                        }
                    } else if (name.equals("linestyle")) {
                        if (value != null) {
                            String[] styles = this.getStringValues(value, ",");
                            if (styles == null || styles.length == 0) {
                                return;
                            }
                            if (styles.length == 1 && this.lineChart.getSeriesCount() > 1 && styles[0] != null) {
                                if (styles[0].trim().equalsIgnoreCase("tube")) {
                                    this.lineChart.setLineStyle(-1, 1);
                                } else {
                                    this.lineChart.setLineStyle(-1, 0);
                                }
                            } else {
                                for (int i = 0; i < styles.length; ++i) {
                                    if (styles[i] != null && styles[i].trim().equalsIgnoreCase("tube")) {
                                        this.lineChart.setLineStyle(i, 1);
                                        continue;
                                    }
                                    this.lineChart.setLineStyle(i, 0);
                                }
                            }
                        }
                    } else if (name.equals("line3ddepth")) {
                        if (value != null && value.trim().length() > 0) {
                            Double[] depth = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                            if (depth.length == 1 && this.lineChart.getSeriesCount() > 1 && depth[0] != null) {
                                this.lineChart.setLine3DDepth(-1, depth[0]);
                            } else {
                                for (int i = 0; i < depth.length; ++i) {
                                    if (depth[i] == null) continue;
                                    this.lineChart.setLine3DDepth(i, depth[i]);
                                }
                            }
                        } else {
                            this.lineChart.setLine3DDepth(-1, 1.0);
                        }
                    } else if (name.equals("outlineoff")) {
                        boolean[] values = this.getBooleanValues(value);
                        int seriesCount = this.lineChart.getSeriesCount();
                        for (int i = 0; i < seriesCount; ++i) {
                            this.lineChart.setOutlineOn(i, !values[i % values.length]);
                        }
                    } else if (name.equals("linestroke")) {
                        if (value != null && value.trim().length() > 0) {
                            String[] stroke_str = this.getStringValues(value, ",");
                            if (stroke_str == null || stroke_str.length == 0) {
                                return;
                            }
                            for (int i = 0; i < stroke_str.length; ++i) {
                                String[] strokes = this.getStringValues(stroke_str[i], "|");
                                float[] values = new float[strokes.length];
                                for (int j = 0; j < strokes.length; ++j) {
                                    try {
                                        if (strokes[j] == null) continue;
                                        values[j] = Integer.parseInt(strokes[j].trim());
                                        continue;
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("Invalid stroke: " + strokes[i]);
                                    }
                                }
                                this.lineChart.setLineStroke(i, values);
                            }
                        }
                    } else if (name.equals("line3dlayout")) {
                        if (value != null) {
                            if (value != null && value.trim().equalsIgnoreCase("behind")) {
                                this.lineChart.setLine3DLayout(0);
                            } else {
                                this.lineChart.setLine3DLayout(1);
                            }
                        }
                    } else if (name.equals("stackedon")) {
                        this.lineChart.setStackedOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.equals("samplehighlighton")) {
                        boolean[] values = this.getBooleanValues(value);
                        int seriesCount = this.lineChart.getSeriesCount();
                        for (int i = 0; i < seriesCount; ++i) {
                            if (values != null && values.length > 0) {
                                this.lineChart.setSampleHighlightOn(i, values[i % values.length]);
                                continue;
                            }
                            this.lineChart.setSampleHighlightOn(i, false);
                        }
                    } else if (name.equals("samplehighlightstyle")) {
                        int[] values = this.getStyleValues(value);
                        int seriesCount = this.lineChart.getSeriesCount();
                        for (int i = 0; i < seriesCount; ++i) {
                            int size = this.lineChart.getSampleHighlightSize(i);
                            int style = 0;
                            if (values != null && values.length > 0) {
                                style = values[i % values.length];
                            }
                            this.lineChart.setSampleHighlightStyle(i, style, size);
                        }
                    } else if (name.equals("samplehighlightsize")) {
                        int seriesCount = this.lineChart.getSeriesCount();
                        Double[] sizes = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                        for (int i = 0; i < seriesCount; ++i) {
                            int style = this.lineChart.getSampleHighlightStyle(i);
                            int size = 6;
                            if (sizes != null && sizes.length > 0 && sizes[i % sizes.length] != null) {
                                size = sizes[i % sizes.length].intValue();
                            }
                            this.lineChart.setSampleHighlightStyle(i, style, size);
                        }
                    } else if (name.equalsIgnoreCase("missingvaluesinterpolated")) {
                        this.lineChart.setMissingValuesInterpolated(value != null && value.trim().equalsIgnoreCase("true"));
                    }
                } else if (this.chartType.equals("pie") && this.pieChart != null) {
                    if (name.equals("angle")) {
                        if (value != null && value.trim().length() > 0) {
                            try {
                                int angle = Integer.parseInt(value);
                                angle = Math.max(10, angle);
                                angle = Math.min(80, angle);
                                this.pieChart.setAngle(angle);
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid angle: " + value);
                                this.pieChart.setAngle(20);
                            }
                        } else {
                            this.pieChart.setAngle(20);
                        }
                    } else if (name.equals("startangle")) {
                        if (value != null && value.trim().length() > 0) {
                            Double[] angle = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                            if (angle.length == 1 && angle[0] != null) {
                                this.pieChart.setStartAngle(-1, angle[0].intValue());
                            } else {
                                for (int i = 0; i < angle.length; ++i) {
                                    if (angle[i] == null) continue;
                                    this.pieChart.setStartAngle(i, angle[i].intValue());
                                }
                            }
                        } else {
                            this.pieChart.setStartAngle(-1, 0);
                        }
                    } else if (name.equals("depth")) {
                        if (value != null && value.trim().length() > 0) {
                            try {
                                double depth = new Float(value).floatValue();
                                depth = Math.max(0.0, depth);
                                depth = Math.min(1.0, depth);
                                this.pieChart.setDepth((float)depth);
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid depth: " + value);
                                this.pieChart.setDepth(0.4f);
                            }
                        } else {
                            this.pieChart.setDepth(0.4f);
                        }
                    } else if (name.equals("percentlabelson")) {
                        this.pieChart.setPercentLabelsOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.equals("percentlabelstyle")) {
                        this.pieChart.setPercentLabelStyle(3);
                        if (value != null && value.trim().length() > 0) {
                            if (value.trim().equalsIgnoreCase("inside")) {
                                this.pieChart.setPercentLabelStyle(0);
                            } else if (value.trim().equalsIgnoreCase("outside")) {
                                this.pieChart.setPercentLabelStyle(1);
                            } else if (value.trim().equalsIgnoreCase("pointing")) {
                                this.pieChart.setPercentLabelStyle(5);
                            }
                        }
                    } else if (name.equals("pielabelson")) {
                        this.pieChart.setPieLabelsOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.startsWith("insidelabelcolor")) {
                        int pie = -1;
                        try {
                            if (name.length() > 18) {
                                pie = Integer.parseInt(name.substring(18));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid index in insideLabelColor_N parameter: " + name);
                        }
                        Color color = this.getColorValues(value)[0];
                        this.pieChart.setInsideLabelColor(pie, color);
                    } else if (name.startsWith("outsidelabelcolor")) {
                        int pie = -1;
                        try {
                            if (name.length() > 18) {
                                pie = Integer.parseInt(name.substring(18));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid index in outsideLabelColor_N parameter: " + name);
                        }
                        Color color = this.getColorValues(value)[0];
                        this.pieChart.setOutsideLabelColor(pie, color);
                    } else if (name.startsWith("pointinglabelcolor")) {
                        int pie = -1;
                        try {
                            if (name.length() > 18) {
                                pie = Integer.parseInt(name.substring(19));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid index in pointingLabelColor_N parameter: " + name);
                        }
                        Color color = this.getColorValues(value)[0];
                        this.pieChart.setPointingLabelColor(pie, color);
                    } else if (name.equals("percentdecimalcount")) {
                        if (value != null && value.trim().length() > 0) {
                            try {
                                this.pieChart.setPercentDecimalCount(Integer.parseInt(value));
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid percentDecimalCount: " + value);
                                this.pieChart.setPercentDecimalCount(0);
                            }
                        } else {
                            this.pieChart.setPercentDecimalCount(0);
                        }
                    } else if (name.equals("sliceseperatoron")) {
                        this.pieChart.setSliceSeperatorOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.equals("gradientsampleson")) {
                        this.pieChart.setGradientSamplesOn(value != null && value.equalsIgnoreCase("true"));
                    } else if (name.equals("sliceseperatorcolor")) {
                        if (value != null && value.length() > 0) {
                            this.pieChart.setSliceSeperatorColor(ChartDataLoader.createColor(value));
                        } else {
                            this.pieChart.setSliceSeperatorColor(null);
                        }
                    } else if (name.equals("selectionstyle")) {
                        int style = 0;
                        if (value != null) {
                            if (value.equals("circle")) {
                                style = 1;
                            } else if (value.equals("detached")) {
                                style = 2;
                            }
                        }
                        this.pieChart.setSelectionStyle(style);
                    } else if (name.equals("detacheddistance")) {
                        this.pieChart.setDetachedDistance(0.1);
                        if (value != null && value.length() > 0) {
                            try {
                                double distance = new Double(value);
                                this.pieChart.setDetachedDistance(Math.max(0.0, distance));
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Invalid detachDistance: " + value);
                            }
                        }
                    } else if (name.startsWith("detachedslices")) {
                        int pie = name.equals("detachedslices") ? 0 : -1;
                        try {
                            if (name.length() > 15) {
                                pie = Integer.parseInt(name.substring(15));
                            }
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid index in detachedSlices_N parameter: " + name);
                        }
                        Double[] detached = ChartDataLoader.getDoubleValues(value, this.valueDelimiter);
                        int seriesCount = this.pieChart.getSeriesCount();
                        int sampleCount = this.pieChart.getSampleCount();
                        if (seriesCount == 1) {
                            for (int i = 0; i < sampleCount; ++i) {
                                this.pieChart.setDetachedSlice(0, i, 0.0);
                            }
                            if (detached != null) {
                                double distance = this.pieChart.getDetachedDistance();
                                for (int i = 0; detached != null && i < detached.length; ++i) {
                                    int slice = detached[i].intValue();
                                    if (slice >= sampleCount) continue;
                                    this.pieChart.setDetachedSlice(0, slice, distance);
                                }
                            }
                        } else if (pie < sampleCount) {
                            for (int i = 0; i < seriesCount; ++i) {
                                this.pieChart.setDetachedSlice(i, pie, 0.0);
                            }
                            if (detached != null) {
                                double distance = this.pieChart.getDetachedDistance();
                                for (int i = 0; detached != null && i < detached.length; ++i) {
                                    int slice = detached[i].intValue();
                                    if (slice >= seriesCount) continue;
                                    this.pieChart.setDetachedSlice(slice, pie, distance);
                                }
                            }
                        }
                    } else if (name.equals("pierotationon")) {
                        this.pieChart.setPieRotationOn(value != null && value.equalsIgnoreCase("true"));
                    }
                }
            }
        }
    }

    protected void setImage(String name, Image image) {
        block17: {
            if (image != null) {
                this.theChart.addImage(name, image);
            }
            if (name.equalsIgnoreCase("gridimage")) {
                if (image != null) {
                    this.theChart.setGridImage("gridimage");
                } else {
                    this.theChart.setGridImage(null);
                }
            } else if (name.startsWith("legendimage_")) {
                try {
                    int index = Integer.parseInt(name.substring(name.indexOf("_") + 1));
                    if (image != null) {
                        this.theChart.setLegendImage(index, name);
                        break block17;
                    }
                    this.theChart.setLegendImage(index, null);
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid legend index: " + name);
                }
            } else if (name.startsWith("samplehighlightimage")) {
                try {
                    if (name.equals("samplehighlightimage")) {
                        this.lineChart.setSampleHighlightImage(-1, -1, name);
                    } else if (name.indexOf(95, 21) == -1) {
                        int serie = Integer.parseInt(name.substring(21));
                        this.lineChart.setSampleHighlightImage(serie, -1, name);
                    } else {
                        int serie = Integer.parseInt(name.substring(21, name.indexOf(95, 21)));
                        int sample = Integer.parseInt(name.substring(name.indexOf(95, 21) + 1));
                        this.lineChart.setSampleHighlightImage(serie, sample, name);
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid index in insideLableColor_N parameter: " + name);
                }
            }
        }
    }

    protected boolean[] getBooleanValues(String string) {
        boolean[] values = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, ",");
            values = new boolean[st.countTokens()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = st.nextToken().trim().equalsIgnoreCase("true");
            }
        }
        return values;
    }

    protected int[] getStyleValues(String string) {
        int[] values = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, ",");
            values = new int[st.countTokens()];
            for (int i = 0; i < values.length; ++i) {
                String style = st.nextToken().trim().toLowerCase();
                if (style.equals("circle")) {
                    values[i] = 0;
                    continue;
                }
                if (style.equals("circle_opaque")) {
                    values[i] = 1;
                    continue;
                }
                if (style.equals("circle_filled")) {
                    values[i] = 2;
                    continue;
                }
                if (style.equals("square")) {
                    values[i] = 3;
                    continue;
                }
                if (style.equals("square_opaque")) {
                    values[i] = 4;
                    continue;
                }
                if (style.equals("square_filled")) {
                    values[i] = 5;
                    continue;
                }
                if (style.equals("diamond")) {
                    values[i] = 6;
                    continue;
                }
                if (style.equals("diamond_opaque")) {
                    values[i] = 7;
                    continue;
                }
                if (style.equals("diamond_filled")) {
                    values[i] = 8;
                    continue;
                }
                values[i] = 0;
                System.out.println("Invalid sampleHighlightStyle: " + style);
            }
        }
        return values;
    }

    protected String[] getStringValues(String string) {
        return this.getStringValues(string, this.labelDelimiter);
    }

    protected String[] getStringValues(String string, String delimiter) {
        return Chart.getStringValues(string, delimiter);
    }

    protected Color[] getColorValues(String string) {
        Color[] colors = null;
        String[] labels = Chart.getStringValues(string, ",");
        if (labels != null) {
            colors = new Color[labels.length];
            for (int i = 0; i < colors.length; ++i) {
                if (labels[i] == null) continue;
                colors[i] = ChartDataLoader.createColor(labels[i].trim());
            }
        }
        return colors;
    }

    static int getFontType(String type) {
        if ((type = type.toLowerCase().trim()).equals("bold")) {
            return 1;
        }
        if (type.equals("italic")) {
            return 2;
        }
        if (type.equals("bolditalic") || type.equals("italicbold")) {
            return 3;
        }
        return 0;
    }

    public Font createFont(String value, String name, int type, int size) {
        StringTokenizer st = new StringTokenizer(value, ",");
        String fontFace = name;
        int fontSize = Math.max(0, size);
        int fontType = type;
        if (st.hasMoreTokens()) {
            fontFace = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            fontType = ChartDataLoader.getFontType(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            try {
                fontSize = Integer.parseInt(st.nextToken().trim());
            }
            catch (NumberFormatException e) {
                fontSize = 12;
            }
        }
        return new Font(fontFace, fontType, fontSize);
    }

    public static Color createColor(String color) {
        boolean is_java2;
        if (color == null || color.length() == 0) {
            return null;
        }
        boolean bl = is_java2 = !System.getProperty("java.version").startsWith("1.1");
        if (color.indexOf(",") >= 0) {
            StringTokenizer st = new StringTokenizer(color, ", ");
            try {
                int r = Integer.parseInt(st.nextToken());
                int g = Integer.parseInt(st.nextToken());
                int b = Integer.parseInt(st.nextToken());
                if (is_java2 && st.hasMoreTokens()) {
                    return new Color(r, g, b, Integer.parseInt(st.nextToken()));
                }
                return new Color(r, g, b);
            }
            catch (Exception e) {
                System.out.println("Invalid RGB color: " + color);
            }
        } else if (color.startsWith("#")) {
            try {
                int r = Integer.parseInt(color.substring(1, 3), 16);
                int g = Integer.parseInt(color.substring(3, 5), 16);
                int b = Integer.parseInt(color.substring(5, 7), 16);
                if (is_java2 && color.length() >= 9) {
                    return new Color(r, g, b, Integer.parseInt(color.substring(7, 9), 16));
                }
                return new Color(r, g, b);
            }
            catch (Exception e) {
                System.out.println("Invalid hex color: " + color);
            }
        } else {
            if ((color = color.toLowerCase()).equals("black")) {
                return Color.black;
            }
            if (color.equals("blue")) {
                return Color.blue;
            }
            if (color.equals("cyan")) {
                return Color.cyan;
            }
            if (color.equals("darkgray")) {
                return Color.darkGray;
            }
            if (color.equals("gray")) {
                return Color.gray;
            }
            if (color.equals("green")) {
                return Color.green;
            }
            if (color.equals("lightgray")) {
                return Color.lightGray;
            }
            if (color.equals("magenta")) {
                return Color.magenta;
            }
            if (color.equals("orange")) {
                return Color.orange;
            }
            if (color.equals("pink")) {
                return Color.pink;
            }
            if (color.equals("red")) {
                return Color.red;
            }
            if (color.equals("white")) {
                return Color.white;
            }
            if (color.equals("yellow")) {
                return Color.yellow;
            }
            if (!color.equals("x")) {
                System.out.println("Invalid color name: " + color);
            }
        }
        return null;
    }

    public String createArrayString(int[] array) {
        if (array == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(100);
        for (int i = 0; i < array.length; ++i) {
            buffer.append(array[i]);
            if (i >= array.length - 1) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    protected static String convertLineBreaks(String label) {
        if (label == null) {
            return null;
        }
        char[] original = label.toCharArray();
        char[] replaced = new char[original.length];
        int j = 0;
        for (int i = 0; i < original.length; ++i) {
            if (i < original.length - 1 && original[i] == '\\' && original[i + 1] == 'n') {
                replaced[j++] = 10;
                ++i;
                continue;
            }
            if (i < original.length - 5 && original[i] == '\\' && original[i + 1] == 'u') {
                try {
                    replaced[j++] = (char)Integer.parseInt(label.substring(i + 2, i + 6), 16);
                    i += 5;
                }
                catch (NumberFormatException e) {
                    replaced[j++] = original[i];
                }
                continue;
            }
            replaced[j++] = original[i];
        }
        return new String(replaced, 0, j);
    }

    protected static Double[] getDoubleValues(String string) {
        return ChartDataLoader.getDoubleValues(string, ",");
    }

    protected static Double[] getDoubleValues(String string, String delimiter) {
        Double[] values = null;
        String[] labels = Chart.getStringValues(string, delimiter);
        if (labels != null) {
            values = new Double[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] == null) continue;
                try {
                    values[i] = new Double(labels[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    values[i] = new Double(Double.NaN);
                }
            }
        }
        return values;
    }
}

