$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
Try
{
              Add-PsSnapin Citrix.Broker.Admin.*
}
catch
{
              write-host "Unable to load the snapin"
              exit 1
}

$groupName = $args[0]
$mode = $args[1]
Try
{
    $DesktopGroup = Get-BrokerDesktopGroup -Name $groupName
}
Catch
{
              Write-host "Unable to determine delivery group status - possibly insufficient administrative privileges"
              exit 1
}

if($mode -eq "enable")
{
              $isMaintenance = $true
}
else
{
              $isMaintenance = $false
}

if($DesktopGroup -ne $null -and $DesktopGroup.InMaintenanceMode -eq "True" -and $isMaintenance)
{
	Write-host "$groupName is already in Maintenance Mode"
	exit 1
}
             
If ($DesktopGroup -ne $null)
{
              $DesktopGroup | Set-BrokerDesktopGroup -InMaintenanceMode $isMaintenance
              if($isMaintenance)
              {
                             Write-Host "$groupName is in Maintenance Mode"
              }
              else
              {
                             Write-Host "$groupName is no longer in Maintenance Mode"
              }
}
else
{
Write-host "Could not find delivery group $groupName "
                exit 1
}
