$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
$VMs = @()
Try
{
Add-PSSnapin Citrix.Broker.Admin.* | Out-Null
}
Catch
{
Write-Host "Unable to load Citrix Snapin.
               Exit 1
}
$VMs = Get-BrokerDesktop -InMaintenanceMode $true
If ($VMs)
{
Write-Host "Machines In Maintenance Mode:"
               ForEach ($vm in $VMs)
{
                              $vm.MachineName
               }
}
Else
{
Write-Host "There are no machines in maintenance mode!"
}
