$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

<# 
.SYNOPSIS
    Enable XenApp Logon to the selected server. 
#>

$ErrorActionPreference = "Stop"
$computer = $env:COMPUTERNAME
Try
{
    Add-PsSnapin Citrix.XenApp.Commands
}
Catch
{
    Write-Error "Unable to load the snapin"
    Exit 1
}

Try
{
    Enable-XAServerLogOn -ServerName $computer
}
Catch
{
    Write-Error "Error in executing Enable-XAServerLogon Cmdlet"
    Exit 1
}
Write-Host "Logins enabled on $computer" 
