﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
Import-Module $egEncryPath -WarningAction SilentlyContinue
clear

function Write-Log(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true)]
        [String]$LogEntry
    )
    Process
    {
        Try{
            $logPath=$egurkhaPath+'\Webhooks\logs'
            if(!(Test-Path -Path $logPath)){
                $null=New-Item -ItemType directory -Path $logPath
            }
            $logFilePath=$logPath+'\Webhook_prerequisites.log'

            $logFilePath1=$logFilePath.Replace(".log","1.log")
	        [string]$date = Get-Date -Format G
            ( "[" + $date + "] - " + $LogEntry ) | Out-File -FilePath $logFilePath -Append
            if ([System.IO.File]::Exists($logFilePath) -and (Get-Item $logFilePath).length -gt 2mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($logFilePath1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $logFilePath1 
                } 
                Rename-Item $logFilePath $logFilePath1 
            }
        }Catch{
            $ErrorMessage=([string]$_.Exception)+($_.ScriptStackTrace)
            Write-Host ('Exception occurred while write log - '+$ErrorMessage) -ForegroundColor Red
        }
    }
}

function Get-INIContent(){
    [CmdletBinding()]
    Param (
    [Parameter(Mandatory=$true, Position=1)]
    [String]$subject, 
    [Parameter(Mandatory=$true, Position=2)]
    [String]$searchText
    )
    Process
    {
        Try{
            #$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
            $iniPath=$egurkhaPath+'\agent\config\eg_webhooks.ini'
            $iniContent=get-content -Path $iniPath
            $totalLines = $iniContent.Length
            if($searchText){
                for($i=0;$i -lt $iniContent.Length;$i++ ){
                    if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                        $i++
                        while($true){
                            if($i -ge $totalLines){
                                return $null
                            }elseif($iniContent[$i] -match $searchText){
                                $iniArr=$iniContent[$i].Split('=')
                                if($searchText -eq $iniArr[0]){
                                    return $iniContent[$i].Substring($iniContent[$i].IndexOf('=')+1)
                                }
                            }
                            $i++  
                        }
                    }
                }       
            }else{
                Write-Host "Search entry is missing in eg_webhook.ini - $searchText"
                Write-Log -LogEntry "Search entry is missing in eg_webhook.ini - $searchText"
            }
        }Catch{
            $ErrorMessage=([string]$_.Exception)+($_.ScriptStackTrace)
            Write-Host ('Exception occurred while read eg_webhooks.ini - '+$ErrorMessage) -ForegroundColor Red
            Write-Log -LogEntry ('Exception occurred while read eg_webhooks.ini - '+$ErrorMessage)            
        }
    }
}

function Proceed-Download(){
    [CmdletBinding()]
    Param( 
        [Parameter(Mandatory=$true)]
        [String]$DownloadURL,
        [Parameter(Mandatory=$true)]
        [String]$username,
        [Parameter(Mandatory=$true)]
        [String]$password
    )
    Process
    {
        Try{
            $downloadPath = $egurkhaPath+'\Webhooks\lib'
            if(!(Test-Path -Path $downloadPath)){
                $null=New-Item -ItemType directory -Path $downloadPath
            }

            $downloadFileName=$DownloadURL.Substring($DownloadURL.LastIndexOf('/')+1)
            $downloadFilePath=$downloadPath+'\'+$downloadFileName
            $isPresent=Test-Path $downloadFilePath -PathType Leaf
            if(!$isPresent){
                Write-Host ('Download Location - '+$downloadPath) 
                Write-Log -LogEntry ('Download Location - '+$downloadPath) 
                Write-Host ($downloadFileName+' - download started...') -ForegroundColor Green
                Write-Log -LogEntry ($downloadFileName+' - download started...')

                $secPassword = ConvertTo-SecureString $password -AsPlainText -Force
                $credential = New-Object System.Management.Automation.PSCredential ($username, $secPassword)

                Invoke-WebRequest -Uri $DownloadURL -OutFile $downloadFilePath -Credential $credential

                Write-Host ($downloadFileName+' - download completed!') -ForegroundColor Green
                Write-Log -LogEntry ($downloadFileName+' - download completed!')
            }
        }Catch{
            $ErrorMessage=([string]$_.Exception)+($_.ScriptStackTrace)
            Write-Log ('Exception occurred while download file - '+$ErrorMessage) 
            Write-Host ('Exception occurred while download file - '+$ErrorMessage) -ForegroundColor Red            
        }
    }      
}

$stTim1=Get-Date
Write-Log -LogEntry "******************************************** Webhook ********************************************"
Write-Log -LogEntry "Webhook jar download process started at $stTim1"

$downloadURL = Get-INIContent -subject "Download_eGWebhook" -searchText "Download_eGWebhook_Jar"
$username = Get-INIContent -subject "Download_eGWebhook" -searchText "username"
$password = Get-INIContent -subject "Download_eGWebhook" -searchText "password"

if($downloadURL){
    
    $keyFile=$egurkhaPath+'\Webhooks\config\kloc.dat'
    if([System.IO.File]::Exists($keyFile)){
        $key=Get-Content -Path $keyFile

        if($username){
            $username = Unprotect-Value -ProtectdValue $username -Key $key

            if($password){    
                $password = Unprotect-Value -ProtectdValue $password -Key $key

                Proceed-Download -DownloadURL $downloadURL -username $username -password $password
                exit 1
            }else{
                Write-Host ('Password is empty/null - '+$password) -ForegroundColor Red
                Write-Log -LogEntry ('Password is empty/null - '+$password)                
            }
        }else{
            Write-Host ('Username is empty/null - '+$username) -ForegroundColor Red
            Write-Log -LogEntry ('Username is empty/null - '+$username)            
        }
    }else{
        Write-Host ('Encryption key file is not found at - '+$keyFile) -ForegroundColor Red
        Write-Log -LogEntry ('Encryption key file is not found at - '+$keyFile)        
    }
}else{
    Write-Host ('Download url is empty/null - '+$downloadURL) -ForegroundColor Red
    Write-Log -LogEntry ('Download url is empty/null - '+$downloadURL)    
}

$edTim1=Get-Date
Write-Log -LogEntry "Webhook jar download process ended at $edTim1"
Write-Log -LogEntry '************************************************************************************************'