$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
$hostserver = $env:computername
$mailboxes = Get-MailboxDatabase -Server $hostserver -status | Select Server, StorageGroupName, Mounted, Name, @{Name="Size (GB)";Expression={$objitem = (Get-MailboxDatabase $_.Identity); $path = "`\`\" + $objitem.server + "`\" + $objItem.EdbFilePath.DriveName.Remove(1).ToString() + "$"+ $objItem.EdbFilePath.PathName.Remove(0,2); $size = ((Get-ChildItem $path).length)/1048576KB; [math]::round($size, 2)}}, @{Name="No. Of Mailboxs";expression={(Get-Mailbox -Database $_.Identity  | Measure-Object).Count}}

foreach( $mb in $mailboxes)
{
	Write-Host $mb

}
